# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ExternalClusterArgs', 'ExternalCluster']

@pulumi.input_type
class ExternalClusterArgs:
    def __init__(__self__, *,
                 external_cluster_id: pulumi.Input[builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 external_connector_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a ExternalCluster resource.
        :param pulumi.Input[builtins.str] external_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] external_connector_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external connector.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "external_cluster_id", external_cluster_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if external_connector_id is not None:
            pulumi.set(__self__, "external_connector_id", external_connector_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="externalClusterId")
    def external_cluster_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external cluster.
        """
        return pulumi.get(self, "external_cluster_id")

    @external_cluster_id.setter
    def external_cluster_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "external_cluster_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="externalConnectorId")
    def external_connector_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external connector.
        """
        return pulumi.get(self, "external_connector_id")

    @external_connector_id.setter
    def external_connector_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_connector_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _ExternalClusterState:
    def __init__(__self__, *,
                 additional_details: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 component_name: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 external_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 external_connector_id: Optional[pulumi.Input[builtins.str]] = None,
                 external_db_system_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 grid_home: Optional[pulumi.Input[builtins.str]] = None,
                 is_flex_cluster: Optional[pulumi.Input[builtins.bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 network_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalClusterNetworkConfigurationArgs']]]] = None,
                 ocr_file_location: Optional[pulumi.Input[builtins.str]] = None,
                 scan_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalClusterScanConfigurationArgs']]]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 vip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalClusterVipConfigurationArgs']]]] = None):
        """
        Input properties used for looking up and filtering ExternalCluster resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_details: The additional details of the external cluster defined in `{"key": "value"}` format. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[builtins.str] component_name: The name of the external cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: The user-friendly name for the external cluster. The name does not have to be unique.
        :param pulumi.Input[builtins.str] external_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external cluster.
        :param pulumi.Input[builtins.str] external_connector_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external connector.
        :param pulumi.Input[builtins.str] external_db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB system that the cluster is a part of.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] grid_home: The directory in which Oracle Grid Infrastructure is installed.
        :param pulumi.Input[builtins.bool] is_flex_cluster: Indicates whether the cluster is Oracle Flex Cluster or not.
        :param pulumi.Input[builtins.str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[Sequence[pulumi.Input['ExternalClusterNetworkConfigurationArgs']]] network_configurations: The list of network address configurations of the external cluster.
        :param pulumi.Input[builtins.str] ocr_file_location: The location of the Oracle Cluster Registry (OCR).
        :param pulumi.Input[Sequence[pulumi.Input['ExternalClusterScanConfigurationArgs']]] scan_configurations: The list of Single Client Access Name (SCAN) configurations of the external cluster.
        :param pulumi.Input[builtins.str] state: The current lifecycle state of the external cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The date and time the external cluster was created.
        :param pulumi.Input[builtins.str] time_updated: The date and time the external cluster was last updated.
        :param pulumi.Input[builtins.str] version: The cluster version.
        :param pulumi.Input[Sequence[pulumi.Input['ExternalClusterVipConfigurationArgs']]] vip_configurations: The list of Virtual IP (VIP) configurations of the external cluster.
        """
        if additional_details is not None:
            pulumi.set(__self__, "additional_details", additional_details)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if component_name is not None:
            pulumi.set(__self__, "component_name", component_name)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if external_cluster_id is not None:
            pulumi.set(__self__, "external_cluster_id", external_cluster_id)
        if external_connector_id is not None:
            pulumi.set(__self__, "external_connector_id", external_connector_id)
        if external_db_system_id is not None:
            pulumi.set(__self__, "external_db_system_id", external_db_system_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if grid_home is not None:
            pulumi.set(__self__, "grid_home", grid_home)
        if is_flex_cluster is not None:
            pulumi.set(__self__, "is_flex_cluster", is_flex_cluster)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if network_configurations is not None:
            pulumi.set(__self__, "network_configurations", network_configurations)
        if ocr_file_location is not None:
            pulumi.set(__self__, "ocr_file_location", ocr_file_location)
        if scan_configurations is not None:
            pulumi.set(__self__, "scan_configurations", scan_configurations)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vip_configurations is not None:
            pulumi.set(__self__, "vip_configurations", vip_configurations)

    @property
    @pulumi.getter(name="additionalDetails")
    def additional_details(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The additional details of the external cluster defined in `{"key": "value"}` format. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "additional_details")

    @additional_details.setter
    def additional_details(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "additional_details", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="componentName")
    def component_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the external cluster.
        """
        return pulumi.get(self, "component_name")

    @component_name.setter
    def component_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "component_name", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user-friendly name for the external cluster. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="externalClusterId")
    def external_cluster_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external cluster.
        """
        return pulumi.get(self, "external_cluster_id")

    @external_cluster_id.setter
    def external_cluster_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_cluster_id", value)

    @property
    @pulumi.getter(name="externalConnectorId")
    def external_connector_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external connector.
        """
        return pulumi.get(self, "external_connector_id")

    @external_connector_id.setter
    def external_connector_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_connector_id", value)

    @property
    @pulumi.getter(name="externalDbSystemId")
    def external_db_system_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB system that the cluster is a part of.
        """
        return pulumi.get(self, "external_db_system_id")

    @external_db_system_id.setter
    def external_db_system_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_db_system_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="gridHome")
    def grid_home(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The directory in which Oracle Grid Infrastructure is installed.
        """
        return pulumi.get(self, "grid_home")

    @grid_home.setter
    def grid_home(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "grid_home", value)

    @property
    @pulumi.getter(name="isFlexCluster")
    def is_flex_cluster(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether the cluster is Oracle Flex Cluster or not.
        """
        return pulumi.get(self, "is_flex_cluster")

    @is_flex_cluster.setter
    def is_flex_cluster(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_flex_cluster", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="networkConfigurations")
    def network_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExternalClusterNetworkConfigurationArgs']]]]:
        """
        The list of network address configurations of the external cluster.
        """
        return pulumi.get(self, "network_configurations")

    @network_configurations.setter
    def network_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalClusterNetworkConfigurationArgs']]]]):
        pulumi.set(self, "network_configurations", value)

    @property
    @pulumi.getter(name="ocrFileLocation")
    def ocr_file_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the Oracle Cluster Registry (OCR).
        """
        return pulumi.get(self, "ocr_file_location")

    @ocr_file_location.setter
    def ocr_file_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ocr_file_location", value)

    @property
    @pulumi.getter(name="scanConfigurations")
    def scan_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExternalClusterScanConfigurationArgs']]]]:
        """
        The list of Single Client Access Name (SCAN) configurations of the external cluster.
        """
        return pulumi.get(self, "scan_configurations")

    @scan_configurations.setter
    def scan_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalClusterScanConfigurationArgs']]]]):
        pulumi.set(self, "scan_configurations", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current lifecycle state of the external cluster.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the external cluster was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the external cluster was last updated.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The cluster version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="vipConfigurations")
    def vip_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExternalClusterVipConfigurationArgs']]]]:
        """
        The list of Virtual IP (VIP) configurations of the external cluster.
        """
        return pulumi.get(self, "vip_configurations")

    @vip_configurations.setter
    def vip_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalClusterVipConfigurationArgs']]]]):
        pulumi.set(self, "vip_configurations", value)


@pulumi.type_token("oci:DatabaseManagement/externalCluster:ExternalCluster")
class ExternalCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 external_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 external_connector_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        This resource provides the External Cluster resource in Oracle Cloud Infrastructure Database Management service.

        Updates the external cluster specified by `externalClusterId`.

        ## Import

        ExternalClusters can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DatabaseManagement/externalCluster:ExternalCluster test_external_cluster "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] external_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external cluster.
        :param pulumi.Input[builtins.str] external_connector_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external connector.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExternalClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the External Cluster resource in Oracle Cloud Infrastructure Database Management service.

        Updates the external cluster specified by `externalClusterId`.

        ## Import

        ExternalClusters can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DatabaseManagement/externalCluster:ExternalCluster test_external_cluster "id"
        ```

        :param str resource_name: The name of the resource.
        :param ExternalClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExternalClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 external_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 external_connector_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExternalClusterArgs.__new__(ExternalClusterArgs)

            __props__.__dict__["defined_tags"] = defined_tags
            if external_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'external_cluster_id'")
            __props__.__dict__["external_cluster_id"] = external_cluster_id
            __props__.__dict__["external_connector_id"] = external_connector_id
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["additional_details"] = None
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["component_name"] = None
            __props__.__dict__["display_name"] = None
            __props__.__dict__["external_db_system_id"] = None
            __props__.__dict__["grid_home"] = None
            __props__.__dict__["is_flex_cluster"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["network_configurations"] = None
            __props__.__dict__["ocr_file_location"] = None
            __props__.__dict__["scan_configurations"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["version"] = None
            __props__.__dict__["vip_configurations"] = None
        super(ExternalCluster, __self__).__init__(
            'oci:DatabaseManagement/externalCluster:ExternalCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_details: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            component_name: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            external_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
            external_connector_id: Optional[pulumi.Input[builtins.str]] = None,
            external_db_system_id: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            grid_home: Optional[pulumi.Input[builtins.str]] = None,
            is_flex_cluster: Optional[pulumi.Input[builtins.bool]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            network_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExternalClusterNetworkConfigurationArgs', 'ExternalClusterNetworkConfigurationArgsDict']]]]] = None,
            ocr_file_location: Optional[pulumi.Input[builtins.str]] = None,
            scan_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExternalClusterScanConfigurationArgs', 'ExternalClusterScanConfigurationArgsDict']]]]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None,
            version: Optional[pulumi.Input[builtins.str]] = None,
            vip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExternalClusterVipConfigurationArgs', 'ExternalClusterVipConfigurationArgsDict']]]]] = None) -> 'ExternalCluster':
        """
        Get an existing ExternalCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_details: The additional details of the external cluster defined in `{"key": "value"}` format. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[builtins.str] component_name: The name of the external cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: The user-friendly name for the external cluster. The name does not have to be unique.
        :param pulumi.Input[builtins.str] external_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external cluster.
        :param pulumi.Input[builtins.str] external_connector_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external connector.
        :param pulumi.Input[builtins.str] external_db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB system that the cluster is a part of.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] grid_home: The directory in which Oracle Grid Infrastructure is installed.
        :param pulumi.Input[builtins.bool] is_flex_cluster: Indicates whether the cluster is Oracle Flex Cluster or not.
        :param pulumi.Input[builtins.str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExternalClusterNetworkConfigurationArgs', 'ExternalClusterNetworkConfigurationArgsDict']]]] network_configurations: The list of network address configurations of the external cluster.
        :param pulumi.Input[builtins.str] ocr_file_location: The location of the Oracle Cluster Registry (OCR).
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExternalClusterScanConfigurationArgs', 'ExternalClusterScanConfigurationArgsDict']]]] scan_configurations: The list of Single Client Access Name (SCAN) configurations of the external cluster.
        :param pulumi.Input[builtins.str] state: The current lifecycle state of the external cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The date and time the external cluster was created.
        :param pulumi.Input[builtins.str] time_updated: The date and time the external cluster was last updated.
        :param pulumi.Input[builtins.str] version: The cluster version.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExternalClusterVipConfigurationArgs', 'ExternalClusterVipConfigurationArgsDict']]]] vip_configurations: The list of Virtual IP (VIP) configurations of the external cluster.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExternalClusterState.__new__(_ExternalClusterState)

        __props__.__dict__["additional_details"] = additional_details
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["component_name"] = component_name
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["external_cluster_id"] = external_cluster_id
        __props__.__dict__["external_connector_id"] = external_connector_id
        __props__.__dict__["external_db_system_id"] = external_db_system_id
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["grid_home"] = grid_home
        __props__.__dict__["is_flex_cluster"] = is_flex_cluster
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["network_configurations"] = network_configurations
        __props__.__dict__["ocr_file_location"] = ocr_file_location
        __props__.__dict__["scan_configurations"] = scan_configurations
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["version"] = version
        __props__.__dict__["vip_configurations"] = vip_configurations
        return ExternalCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalDetails")
    def additional_details(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The additional details of the external cluster defined in `{"key": "value"}` format. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "additional_details")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="componentName")
    def component_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the external cluster.
        """
        return pulumi.get(self, "component_name")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The user-friendly name for the external cluster. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="externalClusterId")
    def external_cluster_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external cluster.
        """
        return pulumi.get(self, "external_cluster_id")

    @property
    @pulumi.getter(name="externalConnectorId")
    def external_connector_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external connector.
        """
        return pulumi.get(self, "external_connector_id")

    @property
    @pulumi.getter(name="externalDbSystemId")
    def external_db_system_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB system that the cluster is a part of.
        """
        return pulumi.get(self, "external_db_system_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="gridHome")
    def grid_home(self) -> pulumi.Output[builtins.str]:
        """
        The directory in which Oracle Grid Infrastructure is installed.
        """
        return pulumi.get(self, "grid_home")

    @property
    @pulumi.getter(name="isFlexCluster")
    def is_flex_cluster(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates whether the cluster is Oracle Flex Cluster or not.
        """
        return pulumi.get(self, "is_flex_cluster")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="networkConfigurations")
    def network_configurations(self) -> pulumi.Output[Sequence['outputs.ExternalClusterNetworkConfiguration']]:
        """
        The list of network address configurations of the external cluster.
        """
        return pulumi.get(self, "network_configurations")

    @property
    @pulumi.getter(name="ocrFileLocation")
    def ocr_file_location(self) -> pulumi.Output[builtins.str]:
        """
        The location of the Oracle Cluster Registry (OCR).
        """
        return pulumi.get(self, "ocr_file_location")

    @property
    @pulumi.getter(name="scanConfigurations")
    def scan_configurations(self) -> pulumi.Output[Sequence['outputs.ExternalClusterScanConfiguration']]:
        """
        The list of Single Client Access Name (SCAN) configurations of the external cluster.
        """
        return pulumi.get(self, "scan_configurations")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current lifecycle state of the external cluster.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the external cluster was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the external cluster was last updated.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.str]:
        """
        The cluster version.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="vipConfigurations")
    def vip_configurations(self) -> pulumi.Output[Sequence['outputs.ExternalClusterVipConfiguration']]:
        """
        The list of Virtual IP (VIP) configurations of the external cluster.
        """
        return pulumi.get(self, "vip_configurations")

