# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApplicationArgs', 'Application']

@pulumi.input_type
class ApplicationArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 driver_shape: pulumi.Input[builtins.str],
                 executor_shape: pulumi.Input[builtins.str],
                 language: pulumi.Input[builtins.str],
                 num_executors: pulumi.Input[builtins.int],
                 spark_version: pulumi.Input[builtins.str],
                 application_log_config: Optional[pulumi.Input['ApplicationApplicationLogConfigArgs']] = None,
                 archive_uri: Optional[pulumi.Input[builtins.str]] = None,
                 arguments: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 class_name: Optional[pulumi.Input[builtins.str]] = None,
                 configuration: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 driver_shape_config: Optional[pulumi.Input['ApplicationDriverShapeConfigArgs']] = None,
                 execute: Optional[pulumi.Input[builtins.str]] = None,
                 executor_shape_config: Optional[pulumi.Input['ApplicationExecutorShapeConfigArgs']] = None,
                 file_uri: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 idle_timeout_in_minutes: Optional[pulumi.Input[builtins.str]] = None,
                 logs_bucket_uri: Optional[pulumi.Input[builtins.str]] = None,
                 max_duration_in_minutes: Optional[pulumi.Input[builtins.str]] = None,
                 metastore_id: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationParameterArgs']]]] = None,
                 pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 private_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 terminate_runs_on_deletion: Optional[pulumi.Input[builtins.bool]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 warehouse_bucket_uri: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Application resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of a compartment.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. It does not have to be unique. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] driver_shape: (Updatable) The VM shape for the driver. Sets the driver cores and memory.
        :param pulumi.Input[builtins.str] executor_shape: (Updatable) The VM shape for the executors. Sets the executor cores and memory.
        :param pulumi.Input[builtins.str] language: (Updatable) The Spark language.
        :param pulumi.Input[builtins.int] num_executors: (Updatable) The number of executor VMs requested.
        :param pulumi.Input[builtins.str] spark_version: (Updatable) The Spark version utilized to run the application.
        :param pulumi.Input['ApplicationApplicationLogConfigArgs'] application_log_config: (Updatable) Logging details of Application logs for Data Flow Run.
        :param pulumi.Input[builtins.str] archive_uri: (Updatable) A comma separated list of one or more archive files as Oracle Cloud Infrastructure URIs. For example, ``oci://path/to/a.zip,oci://path/to/b.zip``. An Oracle Cloud Infrastructure URI of an archive.zip file containing custom dependencies that may be used to support the execution of a Python, Java, or Scala application. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] arguments: (Updatable) The arguments passed to the running application as command line arguments.  An argument is either a plain text or a placeholder. Placeholders are replaced using values from the parameters map.  Each placeholder specified must be represented in the parameters map else the request (POST or PUT) will fail with a HTTP 400 status code.  Placeholders are specified as `Service Api Spec`, where `name` is the name of the parameter. Example:  `[ "--input", "${input_file}", "--name", "John Doe" ]` If "input_file" has a value of "mydata.xml", then the value above will be translated to `--input mydata.xml --name "John Doe"`
        :param pulumi.Input[builtins.str] class_name: (Updatable) The class for the application.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] configuration: (Updatable) The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A user-friendly description. Avoid entering confidential information.
        :param pulumi.Input['ApplicationDriverShapeConfigArgs'] driver_shape_config: (Updatable) This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param pulumi.Input[builtins.str] execute: (Updatable) The input used for spark-submit command. For more details see https://spark.apache.org/docs/latest/submitting-applications.html#launching-applications-with-spark-submit. Supported options include ``--class``, ``--file``, ``--jars``, ``--conf``, ``--py-files``, and main application file with arguments. Example: ``--jars oci://path/to/a.jar,oci://path/to/b.jar --files oci://path/to/a.json,oci://path/to/b.csv --py-files oci://path/to/a.py,oci://path/to/b.py --conf spark.sql.crossJoin.enabled=true --class org.apache.spark.examples.SparkPi oci://path/to/main.jar 10`` Note: If execute is specified together with applicationId, className, configuration, fileUri, language, arguments, parameters during application create/update, or run create/submit, Data Flow service will use derived information from execute input only.
        :param pulumi.Input['ApplicationExecutorShapeConfigArgs'] executor_shape_config: (Updatable) This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param pulumi.Input[builtins.str] file_uri: (Updatable) An Oracle Cloud Infrastructure URI of the file containing the application to execute. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] idle_timeout_in_minutes: (Updatable) The timeout value in minutes used to manage Runs. A Run would be stopped after inactivity for this amount of time period. Note: This parameter is currently only applicable for Runs of type `SESSION`. Default value is 2880 minutes (2 days)
        :param pulumi.Input[builtins.str] logs_bucket_uri: (Updatable) An Oracle Cloud Infrastructure URI of the bucket where the Spark job logs are to be uploaded. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        :param pulumi.Input[builtins.str] max_duration_in_minutes: (Updatable) The maximum duration in minutes for which an Application should run. Data Flow Run would be terminated once it reaches this duration from the time it transitions to `IN_PROGRESS` state.
        :param pulumi.Input[builtins.str] metastore_id: (Updatable) The OCID of Oracle Cloud Infrastructure Hive Metastore.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationParameterArgs']]] parameters: (Updatable) An array of name/value pairs used to fill placeholders found in properties like `Application.arguments`.  The name must be a string of one or more word characters (a-z, A-Z, 0-9, _).  The value can be a string of 0 or more characters of any kind. Example:  [ { name: "iterations", value: "10"}, { name: "input_file", value: "mydata.xml" }, { name: "variable_x", value: "${x}"} ]
        :param pulumi.Input[builtins.str] pool_id: (Updatable) The OCID of a pool. Unique Id to indentify a dataflow pool resource.
        :param pulumi.Input[builtins.str] private_endpoint_id: (Updatable) The OCID of a private endpoint.
        :param pulumi.Input[builtins.bool] terminate_runs_on_deletion: A boolean flag which indicates whether related non-terminal Run(s) for the Application should be terminated along with Application deletion or not.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] type: The Spark application processing type.
        :param pulumi.Input[builtins.str] warehouse_bucket_uri: (Updatable) An Oracle Cloud Infrastructure URI of the bucket to be used as default warehouse directory for BATCH SQL runs. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "driver_shape", driver_shape)
        pulumi.set(__self__, "executor_shape", executor_shape)
        pulumi.set(__self__, "language", language)
        pulumi.set(__self__, "num_executors", num_executors)
        pulumi.set(__self__, "spark_version", spark_version)
        if application_log_config is not None:
            pulumi.set(__self__, "application_log_config", application_log_config)
        if archive_uri is not None:
            pulumi.set(__self__, "archive_uri", archive_uri)
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if class_name is not None:
            pulumi.set(__self__, "class_name", class_name)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if driver_shape_config is not None:
            pulumi.set(__self__, "driver_shape_config", driver_shape_config)
        if execute is not None:
            pulumi.set(__self__, "execute", execute)
        if executor_shape_config is not None:
            pulumi.set(__self__, "executor_shape_config", executor_shape_config)
        if file_uri is not None:
            pulumi.set(__self__, "file_uri", file_uri)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if logs_bucket_uri is not None:
            pulumi.set(__self__, "logs_bucket_uri", logs_bucket_uri)
        if max_duration_in_minutes is not None:
            pulumi.set(__self__, "max_duration_in_minutes", max_duration_in_minutes)
        if metastore_id is not None:
            pulumi.set(__self__, "metastore_id", metastore_id)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if pool_id is not None:
            pulumi.set(__self__, "pool_id", pool_id)
        if private_endpoint_id is not None:
            pulumi.set(__self__, "private_endpoint_id", private_endpoint_id)
        if terminate_runs_on_deletion is not None:
            pulumi.set(__self__, "terminate_runs_on_deletion", terminate_runs_on_deletion)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if warehouse_bucket_uri is not None:
            pulumi.set(__self__, "warehouse_bucket_uri", warehouse_bucket_uri)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The OCID of a compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) A user-friendly name. It does not have to be unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="driverShape")
    def driver_shape(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The VM shape for the driver. Sets the driver cores and memory.
        """
        return pulumi.get(self, "driver_shape")

    @driver_shape.setter
    def driver_shape(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "driver_shape", value)

    @property
    @pulumi.getter(name="executorShape")
    def executor_shape(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The VM shape for the executors. Sets the executor cores and memory.
        """
        return pulumi.get(self, "executor_shape")

    @executor_shape.setter
    def executor_shape(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "executor_shape", value)

    @property
    @pulumi.getter
    def language(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The Spark language.
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "language", value)

    @property
    @pulumi.getter(name="numExecutors")
    def num_executors(self) -> pulumi.Input[builtins.int]:
        """
        (Updatable) The number of executor VMs requested.
        """
        return pulumi.get(self, "num_executors")

    @num_executors.setter
    def num_executors(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "num_executors", value)

    @property
    @pulumi.getter(name="sparkVersion")
    def spark_version(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The Spark version utilized to run the application.
        """
        return pulumi.get(self, "spark_version")

    @spark_version.setter
    def spark_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "spark_version", value)

    @property
    @pulumi.getter(name="applicationLogConfig")
    def application_log_config(self) -> Optional[pulumi.Input['ApplicationApplicationLogConfigArgs']]:
        """
        (Updatable) Logging details of Application logs for Data Flow Run.
        """
        return pulumi.get(self, "application_log_config")

    @application_log_config.setter
    def application_log_config(self, value: Optional[pulumi.Input['ApplicationApplicationLogConfigArgs']]):
        pulumi.set(self, "application_log_config", value)

    @property
    @pulumi.getter(name="archiveUri")
    def archive_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A comma separated list of one or more archive files as Oracle Cloud Infrastructure URIs. For example, ``oci://path/to/a.zip,oci://path/to/b.zip``. An Oracle Cloud Infrastructure URI of an archive.zip file containing custom dependencies that may be used to support the execution of a Python, Java, or Scala application. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "archive_uri")

    @archive_uri.setter
    def archive_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "archive_uri", value)

    @property
    @pulumi.getter
    def arguments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) The arguments passed to the running application as command line arguments.  An argument is either a plain text or a placeholder. Placeholders are replaced using values from the parameters map.  Each placeholder specified must be represented in the parameters map else the request (POST or PUT) will fail with a HTTP 400 status code.  Placeholders are specified as `Service Api Spec`, where `name` is the name of the parameter. Example:  `[ "--input", "${input_file}", "--name", "John Doe" ]` If "input_file" has a value of "mydata.xml", then the value above will be translated to `--input mydata.xml --name "John Doe"`
        """
        return pulumi.get(self, "arguments")

    @arguments.setter
    def arguments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "arguments", value)

    @property
    @pulumi.getter(name="className")
    def class_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The class for the application.
        """
        return pulumi.get(self, "class_name")

    @class_name.setter
    def class_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "class_name", value)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly description. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="driverShapeConfig")
    def driver_shape_config(self) -> Optional[pulumi.Input['ApplicationDriverShapeConfigArgs']]:
        """
        (Updatable) This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "driver_shape_config")

    @driver_shape_config.setter
    def driver_shape_config(self, value: Optional[pulumi.Input['ApplicationDriverShapeConfigArgs']]):
        pulumi.set(self, "driver_shape_config", value)

    @property
    @pulumi.getter
    def execute(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The input used for spark-submit command. For more details see https://spark.apache.org/docs/latest/submitting-applications.html#launching-applications-with-spark-submit. Supported options include ``--class``, ``--file``, ``--jars``, ``--conf``, ``--py-files``, and main application file with arguments. Example: ``--jars oci://path/to/a.jar,oci://path/to/b.jar --files oci://path/to/a.json,oci://path/to/b.csv --py-files oci://path/to/a.py,oci://path/to/b.py --conf spark.sql.crossJoin.enabled=true --class org.apache.spark.examples.SparkPi oci://path/to/main.jar 10`` Note: If execute is specified together with applicationId, className, configuration, fileUri, language, arguments, parameters during application create/update, or run create/submit, Data Flow service will use derived information from execute input only.
        """
        return pulumi.get(self, "execute")

    @execute.setter
    def execute(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "execute", value)

    @property
    @pulumi.getter(name="executorShapeConfig")
    def executor_shape_config(self) -> Optional[pulumi.Input['ApplicationExecutorShapeConfigArgs']]:
        """
        (Updatable) This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "executor_shape_config")

    @executor_shape_config.setter
    def executor_shape_config(self, value: Optional[pulumi.Input['ApplicationExecutorShapeConfigArgs']]):
        pulumi.set(self, "executor_shape_config", value)

    @property
    @pulumi.getter(name="fileUri")
    def file_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) An Oracle Cloud Infrastructure URI of the file containing the application to execute. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "file_uri")

    @file_uri.setter
    def file_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "file_uri", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The timeout value in minutes used to manage Runs. A Run would be stopped after inactivity for this amount of time period. Note: This parameter is currently only applicable for Runs of type `SESSION`. Default value is 2880 minutes (2 days)
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @idle_timeout_in_minutes.setter
    def idle_timeout_in_minutes(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "idle_timeout_in_minutes", value)

    @property
    @pulumi.getter(name="logsBucketUri")
    def logs_bucket_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) An Oracle Cloud Infrastructure URI of the bucket where the Spark job logs are to be uploaded. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "logs_bucket_uri")

    @logs_bucket_uri.setter
    def logs_bucket_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "logs_bucket_uri", value)

    @property
    @pulumi.getter(name="maxDurationInMinutes")
    def max_duration_in_minutes(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The maximum duration in minutes for which an Application should run. Data Flow Run would be terminated once it reaches this duration from the time it transitions to `IN_PROGRESS` state.
        """
        return pulumi.get(self, "max_duration_in_minutes")

    @max_duration_in_minutes.setter
    def max_duration_in_minutes(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "max_duration_in_minutes", value)

    @property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of Oracle Cloud Infrastructure Hive Metastore.
        """
        return pulumi.get(self, "metastore_id")

    @metastore_id.setter
    def metastore_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "metastore_id", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationParameterArgs']]]]:
        """
        (Updatable) An array of name/value pairs used to fill placeholders found in properties like `Application.arguments`.  The name must be a string of one or more word characters (a-z, A-Z, 0-9, _).  The value can be a string of 0 or more characters of any kind. Example:  [ { name: "iterations", value: "10"}, { name: "input_file", value: "mydata.xml" }, { name: "variable_x", value: "${x}"} ]
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of a pool. Unique Id to indentify a dataflow pool resource.
        """
        return pulumi.get(self, "pool_id")

    @pool_id.setter
    def pool_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pool_id", value)

    @property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of a private endpoint.
        """
        return pulumi.get(self, "private_endpoint_id")

    @private_endpoint_id.setter
    def private_endpoint_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_endpoint_id", value)

    @property
    @pulumi.getter(name="terminateRunsOnDeletion")
    def terminate_runs_on_deletion(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A boolean flag which indicates whether related non-terminal Run(s) for the Application should be terminated along with Application deletion or not.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "terminate_runs_on_deletion")

    @terminate_runs_on_deletion.setter
    def terminate_runs_on_deletion(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "terminate_runs_on_deletion", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Spark application processing type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="warehouseBucketUri")
    def warehouse_bucket_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) An Oracle Cloud Infrastructure URI of the bucket to be used as default warehouse directory for BATCH SQL runs. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "warehouse_bucket_uri")

    @warehouse_bucket_uri.setter
    def warehouse_bucket_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "warehouse_bucket_uri", value)


@pulumi.input_type
class _ApplicationState:
    def __init__(__self__, *,
                 application_log_config: Optional[pulumi.Input['ApplicationApplicationLogConfigArgs']] = None,
                 archive_uri: Optional[pulumi.Input[builtins.str]] = None,
                 arguments: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 class_name: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 configuration: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 driver_shape: Optional[pulumi.Input[builtins.str]] = None,
                 driver_shape_config: Optional[pulumi.Input['ApplicationDriverShapeConfigArgs']] = None,
                 execute: Optional[pulumi.Input[builtins.str]] = None,
                 executor_shape: Optional[pulumi.Input[builtins.str]] = None,
                 executor_shape_config: Optional[pulumi.Input['ApplicationExecutorShapeConfigArgs']] = None,
                 file_uri: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 idle_timeout_in_minutes: Optional[pulumi.Input[builtins.str]] = None,
                 language: Optional[pulumi.Input[builtins.str]] = None,
                 logs_bucket_uri: Optional[pulumi.Input[builtins.str]] = None,
                 max_duration_in_minutes: Optional[pulumi.Input[builtins.str]] = None,
                 metastore_id: Optional[pulumi.Input[builtins.str]] = None,
                 num_executors: Optional[pulumi.Input[builtins.int]] = None,
                 owner_principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 owner_user_name: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationParameterArgs']]]] = None,
                 pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 private_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 spark_version: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 terminate_runs_on_deletion: Optional[pulumi.Input[builtins.bool]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 warehouse_bucket_uri: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Application resources.
        :param pulumi.Input['ApplicationApplicationLogConfigArgs'] application_log_config: (Updatable) Logging details of Application logs for Data Flow Run.
        :param pulumi.Input[builtins.str] archive_uri: (Updatable) A comma separated list of one or more archive files as Oracle Cloud Infrastructure URIs. For example, ``oci://path/to/a.zip,oci://path/to/b.zip``. An Oracle Cloud Infrastructure URI of an archive.zip file containing custom dependencies that may be used to support the execution of a Python, Java, or Scala application. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] arguments: (Updatable) The arguments passed to the running application as command line arguments.  An argument is either a plain text or a placeholder. Placeholders are replaced using values from the parameters map.  Each placeholder specified must be represented in the parameters map else the request (POST or PUT) will fail with a HTTP 400 status code.  Placeholders are specified as `Service Api Spec`, where `name` is the name of the parameter. Example:  `[ "--input", "${input_file}", "--name", "John Doe" ]` If "input_file" has a value of "mydata.xml", then the value above will be translated to `--input mydata.xml --name "John Doe"`
        :param pulumi.Input[builtins.str] class_name: (Updatable) The class for the application.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of a compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] configuration: (Updatable) The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A user-friendly description. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. It does not have to be unique. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] driver_shape: (Updatable) The VM shape for the driver. Sets the driver cores and memory.
        :param pulumi.Input['ApplicationDriverShapeConfigArgs'] driver_shape_config: (Updatable) This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param pulumi.Input[builtins.str] execute: (Updatable) The input used for spark-submit command. For more details see https://spark.apache.org/docs/latest/submitting-applications.html#launching-applications-with-spark-submit. Supported options include ``--class``, ``--file``, ``--jars``, ``--conf``, ``--py-files``, and main application file with arguments. Example: ``--jars oci://path/to/a.jar,oci://path/to/b.jar --files oci://path/to/a.json,oci://path/to/b.csv --py-files oci://path/to/a.py,oci://path/to/b.py --conf spark.sql.crossJoin.enabled=true --class org.apache.spark.examples.SparkPi oci://path/to/main.jar 10`` Note: If execute is specified together with applicationId, className, configuration, fileUri, language, arguments, parameters during application create/update, or run create/submit, Data Flow service will use derived information from execute input only.
        :param pulumi.Input[builtins.str] executor_shape: (Updatable) The VM shape for the executors. Sets the executor cores and memory.
        :param pulumi.Input['ApplicationExecutorShapeConfigArgs'] executor_shape_config: (Updatable) This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param pulumi.Input[builtins.str] file_uri: (Updatable) An Oracle Cloud Infrastructure URI of the file containing the application to execute. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] idle_timeout_in_minutes: (Updatable) The timeout value in minutes used to manage Runs. A Run would be stopped after inactivity for this amount of time period. Note: This parameter is currently only applicable for Runs of type `SESSION`. Default value is 2880 minutes (2 days)
        :param pulumi.Input[builtins.str] language: (Updatable) The Spark language.
        :param pulumi.Input[builtins.str] logs_bucket_uri: (Updatable) An Oracle Cloud Infrastructure URI of the bucket where the Spark job logs are to be uploaded. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        :param pulumi.Input[builtins.str] max_duration_in_minutes: (Updatable) The maximum duration in minutes for which an Application should run. Data Flow Run would be terminated once it reaches this duration from the time it transitions to `IN_PROGRESS` state.
        :param pulumi.Input[builtins.str] metastore_id: (Updatable) The OCID of Oracle Cloud Infrastructure Hive Metastore.
        :param pulumi.Input[builtins.int] num_executors: (Updatable) The number of executor VMs requested.
        :param pulumi.Input[builtins.str] owner_principal_id: The OCID of the user who created the resource.
        :param pulumi.Input[builtins.str] owner_user_name: The username of the user who created the resource.  If the username of the owner does not exist, `null` will be returned and the caller should refer to the ownerPrincipalId value instead.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationParameterArgs']]] parameters: (Updatable) An array of name/value pairs used to fill placeholders found in properties like `Application.arguments`.  The name must be a string of one or more word characters (a-z, A-Z, 0-9, _).  The value can be a string of 0 or more characters of any kind. Example:  [ { name: "iterations", value: "10"}, { name: "input_file", value: "mydata.xml" }, { name: "variable_x", value: "${x}"} ]
        :param pulumi.Input[builtins.str] pool_id: (Updatable) The OCID of a pool. Unique Id to indentify a dataflow pool resource.
        :param pulumi.Input[builtins.str] private_endpoint_id: (Updatable) The OCID of a private endpoint.
        :param pulumi.Input[builtins.str] spark_version: (Updatable) The Spark version utilized to run the application.
        :param pulumi.Input[builtins.str] state: The current state of this application.
        :param pulumi.Input[builtins.bool] terminate_runs_on_deletion: A boolean flag which indicates whether related non-terminal Run(s) for the Application should be terminated along with Application deletion or not.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] time_created: The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        :param pulumi.Input[builtins.str] time_updated: The date and time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        :param pulumi.Input[builtins.str] type: The Spark application processing type.
        :param pulumi.Input[builtins.str] warehouse_bucket_uri: (Updatable) An Oracle Cloud Infrastructure URI of the bucket to be used as default warehouse directory for BATCH SQL runs. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        if application_log_config is not None:
            pulumi.set(__self__, "application_log_config", application_log_config)
        if archive_uri is not None:
            pulumi.set(__self__, "archive_uri", archive_uri)
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if class_name is not None:
            pulumi.set(__self__, "class_name", class_name)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if driver_shape is not None:
            pulumi.set(__self__, "driver_shape", driver_shape)
        if driver_shape_config is not None:
            pulumi.set(__self__, "driver_shape_config", driver_shape_config)
        if execute is not None:
            pulumi.set(__self__, "execute", execute)
        if executor_shape is not None:
            pulumi.set(__self__, "executor_shape", executor_shape)
        if executor_shape_config is not None:
            pulumi.set(__self__, "executor_shape_config", executor_shape_config)
        if file_uri is not None:
            pulumi.set(__self__, "file_uri", file_uri)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if logs_bucket_uri is not None:
            pulumi.set(__self__, "logs_bucket_uri", logs_bucket_uri)
        if max_duration_in_minutes is not None:
            pulumi.set(__self__, "max_duration_in_minutes", max_duration_in_minutes)
        if metastore_id is not None:
            pulumi.set(__self__, "metastore_id", metastore_id)
        if num_executors is not None:
            pulumi.set(__self__, "num_executors", num_executors)
        if owner_principal_id is not None:
            pulumi.set(__self__, "owner_principal_id", owner_principal_id)
        if owner_user_name is not None:
            pulumi.set(__self__, "owner_user_name", owner_user_name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if pool_id is not None:
            pulumi.set(__self__, "pool_id", pool_id)
        if private_endpoint_id is not None:
            pulumi.set(__self__, "private_endpoint_id", private_endpoint_id)
        if spark_version is not None:
            pulumi.set(__self__, "spark_version", spark_version)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if terminate_runs_on_deletion is not None:
            pulumi.set(__self__, "terminate_runs_on_deletion", terminate_runs_on_deletion)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if warehouse_bucket_uri is not None:
            pulumi.set(__self__, "warehouse_bucket_uri", warehouse_bucket_uri)

    @property
    @pulumi.getter(name="applicationLogConfig")
    def application_log_config(self) -> Optional[pulumi.Input['ApplicationApplicationLogConfigArgs']]:
        """
        (Updatable) Logging details of Application logs for Data Flow Run.
        """
        return pulumi.get(self, "application_log_config")

    @application_log_config.setter
    def application_log_config(self, value: Optional[pulumi.Input['ApplicationApplicationLogConfigArgs']]):
        pulumi.set(self, "application_log_config", value)

    @property
    @pulumi.getter(name="archiveUri")
    def archive_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A comma separated list of one or more archive files as Oracle Cloud Infrastructure URIs. For example, ``oci://path/to/a.zip,oci://path/to/b.zip``. An Oracle Cloud Infrastructure URI of an archive.zip file containing custom dependencies that may be used to support the execution of a Python, Java, or Scala application. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "archive_uri")

    @archive_uri.setter
    def archive_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "archive_uri", value)

    @property
    @pulumi.getter
    def arguments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) The arguments passed to the running application as command line arguments.  An argument is either a plain text or a placeholder. Placeholders are replaced using values from the parameters map.  Each placeholder specified must be represented in the parameters map else the request (POST or PUT) will fail with a HTTP 400 status code.  Placeholders are specified as `Service Api Spec`, where `name` is the name of the parameter. Example:  `[ "--input", "${input_file}", "--name", "John Doe" ]` If "input_file" has a value of "mydata.xml", then the value above will be translated to `--input mydata.xml --name "John Doe"`
        """
        return pulumi.get(self, "arguments")

    @arguments.setter
    def arguments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "arguments", value)

    @property
    @pulumi.getter(name="className")
    def class_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The class for the application.
        """
        return pulumi.get(self, "class_name")

    @class_name.setter
    def class_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "class_name", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of a compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly description. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name. It does not have to be unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="driverShape")
    def driver_shape(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The VM shape for the driver. Sets the driver cores and memory.
        """
        return pulumi.get(self, "driver_shape")

    @driver_shape.setter
    def driver_shape(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "driver_shape", value)

    @property
    @pulumi.getter(name="driverShapeConfig")
    def driver_shape_config(self) -> Optional[pulumi.Input['ApplicationDriverShapeConfigArgs']]:
        """
        (Updatable) This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "driver_shape_config")

    @driver_shape_config.setter
    def driver_shape_config(self, value: Optional[pulumi.Input['ApplicationDriverShapeConfigArgs']]):
        pulumi.set(self, "driver_shape_config", value)

    @property
    @pulumi.getter
    def execute(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The input used for spark-submit command. For more details see https://spark.apache.org/docs/latest/submitting-applications.html#launching-applications-with-spark-submit. Supported options include ``--class``, ``--file``, ``--jars``, ``--conf``, ``--py-files``, and main application file with arguments. Example: ``--jars oci://path/to/a.jar,oci://path/to/b.jar --files oci://path/to/a.json,oci://path/to/b.csv --py-files oci://path/to/a.py,oci://path/to/b.py --conf spark.sql.crossJoin.enabled=true --class org.apache.spark.examples.SparkPi oci://path/to/main.jar 10`` Note: If execute is specified together with applicationId, className, configuration, fileUri, language, arguments, parameters during application create/update, or run create/submit, Data Flow service will use derived information from execute input only.
        """
        return pulumi.get(self, "execute")

    @execute.setter
    def execute(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "execute", value)

    @property
    @pulumi.getter(name="executorShape")
    def executor_shape(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The VM shape for the executors. Sets the executor cores and memory.
        """
        return pulumi.get(self, "executor_shape")

    @executor_shape.setter
    def executor_shape(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "executor_shape", value)

    @property
    @pulumi.getter(name="executorShapeConfig")
    def executor_shape_config(self) -> Optional[pulumi.Input['ApplicationExecutorShapeConfigArgs']]:
        """
        (Updatable) This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "executor_shape_config")

    @executor_shape_config.setter
    def executor_shape_config(self, value: Optional[pulumi.Input['ApplicationExecutorShapeConfigArgs']]):
        pulumi.set(self, "executor_shape_config", value)

    @property
    @pulumi.getter(name="fileUri")
    def file_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) An Oracle Cloud Infrastructure URI of the file containing the application to execute. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "file_uri")

    @file_uri.setter
    def file_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "file_uri", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The timeout value in minutes used to manage Runs. A Run would be stopped after inactivity for this amount of time period. Note: This parameter is currently only applicable for Runs of type `SESSION`. Default value is 2880 minutes (2 days)
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @idle_timeout_in_minutes.setter
    def idle_timeout_in_minutes(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "idle_timeout_in_minutes", value)

    @property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The Spark language.
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "language", value)

    @property
    @pulumi.getter(name="logsBucketUri")
    def logs_bucket_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) An Oracle Cloud Infrastructure URI of the bucket where the Spark job logs are to be uploaded. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "logs_bucket_uri")

    @logs_bucket_uri.setter
    def logs_bucket_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "logs_bucket_uri", value)

    @property
    @pulumi.getter(name="maxDurationInMinutes")
    def max_duration_in_minutes(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The maximum duration in minutes for which an Application should run. Data Flow Run would be terminated once it reaches this duration from the time it transitions to `IN_PROGRESS` state.
        """
        return pulumi.get(self, "max_duration_in_minutes")

    @max_duration_in_minutes.setter
    def max_duration_in_minutes(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "max_duration_in_minutes", value)

    @property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of Oracle Cloud Infrastructure Hive Metastore.
        """
        return pulumi.get(self, "metastore_id")

    @metastore_id.setter
    def metastore_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "metastore_id", value)

    @property
    @pulumi.getter(name="numExecutors")
    def num_executors(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The number of executor VMs requested.
        """
        return pulumi.get(self, "num_executors")

    @num_executors.setter
    def num_executors(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "num_executors", value)

    @property
    @pulumi.getter(name="ownerPrincipalId")
    def owner_principal_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the user who created the resource.
        """
        return pulumi.get(self, "owner_principal_id")

    @owner_principal_id.setter
    def owner_principal_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "owner_principal_id", value)

    @property
    @pulumi.getter(name="ownerUserName")
    def owner_user_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The username of the user who created the resource.  If the username of the owner does not exist, `null` will be returned and the caller should refer to the ownerPrincipalId value instead.
        """
        return pulumi.get(self, "owner_user_name")

    @owner_user_name.setter
    def owner_user_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "owner_user_name", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationParameterArgs']]]]:
        """
        (Updatable) An array of name/value pairs used to fill placeholders found in properties like `Application.arguments`.  The name must be a string of one or more word characters (a-z, A-Z, 0-9, _).  The value can be a string of 0 or more characters of any kind. Example:  [ { name: "iterations", value: "10"}, { name: "input_file", value: "mydata.xml" }, { name: "variable_x", value: "${x}"} ]
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of a pool. Unique Id to indentify a dataflow pool resource.
        """
        return pulumi.get(self, "pool_id")

    @pool_id.setter
    def pool_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pool_id", value)

    @property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of a private endpoint.
        """
        return pulumi.get(self, "private_endpoint_id")

    @private_endpoint_id.setter
    def private_endpoint_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_endpoint_id", value)

    @property
    @pulumi.getter(name="sparkVersion")
    def spark_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The Spark version utilized to run the application.
        """
        return pulumi.get(self, "spark_version")

    @spark_version.setter
    def spark_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "spark_version", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of this application.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="terminateRunsOnDeletion")
    def terminate_runs_on_deletion(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A boolean flag which indicates whether related non-terminal Run(s) for the Application should be terminated along with Application deletion or not.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "terminate_runs_on_deletion")

    @terminate_runs_on_deletion.setter
    def terminate_runs_on_deletion(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "terminate_runs_on_deletion", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Spark application processing type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="warehouseBucketUri")
    def warehouse_bucket_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) An Oracle Cloud Infrastructure URI of the bucket to be used as default warehouse directory for BATCH SQL runs. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "warehouse_bucket_uri")

    @warehouse_bucket_uri.setter
    def warehouse_bucket_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "warehouse_bucket_uri", value)


@pulumi.type_token("oci:DataFlow/application:Application")
class Application(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_log_config: Optional[pulumi.Input[Union['ApplicationApplicationLogConfigArgs', 'ApplicationApplicationLogConfigArgsDict']]] = None,
                 archive_uri: Optional[pulumi.Input[builtins.str]] = None,
                 arguments: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 class_name: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 configuration: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 driver_shape: Optional[pulumi.Input[builtins.str]] = None,
                 driver_shape_config: Optional[pulumi.Input[Union['ApplicationDriverShapeConfigArgs', 'ApplicationDriverShapeConfigArgsDict']]] = None,
                 execute: Optional[pulumi.Input[builtins.str]] = None,
                 executor_shape: Optional[pulumi.Input[builtins.str]] = None,
                 executor_shape_config: Optional[pulumi.Input[Union['ApplicationExecutorShapeConfigArgs', 'ApplicationExecutorShapeConfigArgsDict']]] = None,
                 file_uri: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 idle_timeout_in_minutes: Optional[pulumi.Input[builtins.str]] = None,
                 language: Optional[pulumi.Input[builtins.str]] = None,
                 logs_bucket_uri: Optional[pulumi.Input[builtins.str]] = None,
                 max_duration_in_minutes: Optional[pulumi.Input[builtins.str]] = None,
                 metastore_id: Optional[pulumi.Input[builtins.str]] = None,
                 num_executors: Optional[pulumi.Input[builtins.int]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationParameterArgs', 'ApplicationParameterArgsDict']]]]] = None,
                 pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 private_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 spark_version: Optional[pulumi.Input[builtins.str]] = None,
                 terminate_runs_on_deletion: Optional[pulumi.Input[builtins.bool]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 warehouse_bucket_uri: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Application resource in Oracle Cloud Infrastructure Data Flow service.

        Creates an application.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_application = oci.data_flow.Application("test_application",
            compartment_id=compartment_id,
            display_name=application_display_name,
            driver_shape=application_driver_shape,
            executor_shape=application_executor_shape,
            language=application_language,
            num_executors=application_num_executors,
            spark_version=application_spark_version,
            application_log_config={
                "log_group_id": test_log_group["id"],
                "log_id": test_log["id"],
            },
            archive_uri=application_archive_uri,
            arguments=application_arguments,
            class_name=application_class_name,
            configuration=application_configuration,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=application_description,
            driver_shape_config={
                "memory_in_gbs": application_driver_shape_config_memory_in_gbs,
                "ocpus": application_driver_shape_config_ocpus,
            },
            execute=application_execute,
            executor_shape_config={
                "memory_in_gbs": application_executor_shape_config_memory_in_gbs,
                "ocpus": application_executor_shape_config_ocpus,
            },
            file_uri=application_file_uri,
            freeform_tags={
                "Department": "Finance",
            },
            idle_timeout_in_minutes=application_idle_timeout_in_minutes,
            logs_bucket_uri=application_logs_bucket_uri,
            max_duration_in_minutes=application_max_duration_in_minutes,
            metastore_id=metastore_id,
            parameters=[{
                "name": application_parameters_name,
                "value": application_parameters_value,
            }],
            pool_id=test_pool["id"],
            private_endpoint_id=test_private_endpoint["id"],
            type=application_type,
            warehouse_bucket_uri=application_warehouse_bucket_uri,
            terminate_runs_on_deletion=True)
        ```

        ## Import

        Applications can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataFlow/application:Application test_application "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ApplicationApplicationLogConfigArgs', 'ApplicationApplicationLogConfigArgsDict']] application_log_config: (Updatable) Logging details of Application logs for Data Flow Run.
        :param pulumi.Input[builtins.str] archive_uri: (Updatable) A comma separated list of one or more archive files as Oracle Cloud Infrastructure URIs. For example, ``oci://path/to/a.zip,oci://path/to/b.zip``. An Oracle Cloud Infrastructure URI of an archive.zip file containing custom dependencies that may be used to support the execution of a Python, Java, or Scala application. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] arguments: (Updatable) The arguments passed to the running application as command line arguments.  An argument is either a plain text or a placeholder. Placeholders are replaced using values from the parameters map.  Each placeholder specified must be represented in the parameters map else the request (POST or PUT) will fail with a HTTP 400 status code.  Placeholders are specified as `Service Api Spec`, where `name` is the name of the parameter. Example:  `[ "--input", "${input_file}", "--name", "John Doe" ]` If "input_file" has a value of "mydata.xml", then the value above will be translated to `--input mydata.xml --name "John Doe"`
        :param pulumi.Input[builtins.str] class_name: (Updatable) The class for the application.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of a compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] configuration: (Updatable) The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A user-friendly description. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. It does not have to be unique. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] driver_shape: (Updatable) The VM shape for the driver. Sets the driver cores and memory.
        :param pulumi.Input[Union['ApplicationDriverShapeConfigArgs', 'ApplicationDriverShapeConfigArgsDict']] driver_shape_config: (Updatable) This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param pulumi.Input[builtins.str] execute: (Updatable) The input used for spark-submit command. For more details see https://spark.apache.org/docs/latest/submitting-applications.html#launching-applications-with-spark-submit. Supported options include ``--class``, ``--file``, ``--jars``, ``--conf``, ``--py-files``, and main application file with arguments. Example: ``--jars oci://path/to/a.jar,oci://path/to/b.jar --files oci://path/to/a.json,oci://path/to/b.csv --py-files oci://path/to/a.py,oci://path/to/b.py --conf spark.sql.crossJoin.enabled=true --class org.apache.spark.examples.SparkPi oci://path/to/main.jar 10`` Note: If execute is specified together with applicationId, className, configuration, fileUri, language, arguments, parameters during application create/update, or run create/submit, Data Flow service will use derived information from execute input only.
        :param pulumi.Input[builtins.str] executor_shape: (Updatable) The VM shape for the executors. Sets the executor cores and memory.
        :param pulumi.Input[Union['ApplicationExecutorShapeConfigArgs', 'ApplicationExecutorShapeConfigArgsDict']] executor_shape_config: (Updatable) This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param pulumi.Input[builtins.str] file_uri: (Updatable) An Oracle Cloud Infrastructure URI of the file containing the application to execute. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] idle_timeout_in_minutes: (Updatable) The timeout value in minutes used to manage Runs. A Run would be stopped after inactivity for this amount of time period. Note: This parameter is currently only applicable for Runs of type `SESSION`. Default value is 2880 minutes (2 days)
        :param pulumi.Input[builtins.str] language: (Updatable) The Spark language.
        :param pulumi.Input[builtins.str] logs_bucket_uri: (Updatable) An Oracle Cloud Infrastructure URI of the bucket where the Spark job logs are to be uploaded. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        :param pulumi.Input[builtins.str] max_duration_in_minutes: (Updatable) The maximum duration in minutes for which an Application should run. Data Flow Run would be terminated once it reaches this duration from the time it transitions to `IN_PROGRESS` state.
        :param pulumi.Input[builtins.str] metastore_id: (Updatable) The OCID of Oracle Cloud Infrastructure Hive Metastore.
        :param pulumi.Input[builtins.int] num_executors: (Updatable) The number of executor VMs requested.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationParameterArgs', 'ApplicationParameterArgsDict']]]] parameters: (Updatable) An array of name/value pairs used to fill placeholders found in properties like `Application.arguments`.  The name must be a string of one or more word characters (a-z, A-Z, 0-9, _).  The value can be a string of 0 or more characters of any kind. Example:  [ { name: "iterations", value: "10"}, { name: "input_file", value: "mydata.xml" }, { name: "variable_x", value: "${x}"} ]
        :param pulumi.Input[builtins.str] pool_id: (Updatable) The OCID of a pool. Unique Id to indentify a dataflow pool resource.
        :param pulumi.Input[builtins.str] private_endpoint_id: (Updatable) The OCID of a private endpoint.
        :param pulumi.Input[builtins.str] spark_version: (Updatable) The Spark version utilized to run the application.
        :param pulumi.Input[builtins.bool] terminate_runs_on_deletion: A boolean flag which indicates whether related non-terminal Run(s) for the Application should be terminated along with Application deletion or not.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] type: The Spark application processing type.
        :param pulumi.Input[builtins.str] warehouse_bucket_uri: (Updatable) An Oracle Cloud Infrastructure URI of the bucket to be used as default warehouse directory for BATCH SQL runs. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplicationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Application resource in Oracle Cloud Infrastructure Data Flow service.

        Creates an application.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_application = oci.data_flow.Application("test_application",
            compartment_id=compartment_id,
            display_name=application_display_name,
            driver_shape=application_driver_shape,
            executor_shape=application_executor_shape,
            language=application_language,
            num_executors=application_num_executors,
            spark_version=application_spark_version,
            application_log_config={
                "log_group_id": test_log_group["id"],
                "log_id": test_log["id"],
            },
            archive_uri=application_archive_uri,
            arguments=application_arguments,
            class_name=application_class_name,
            configuration=application_configuration,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=application_description,
            driver_shape_config={
                "memory_in_gbs": application_driver_shape_config_memory_in_gbs,
                "ocpus": application_driver_shape_config_ocpus,
            },
            execute=application_execute,
            executor_shape_config={
                "memory_in_gbs": application_executor_shape_config_memory_in_gbs,
                "ocpus": application_executor_shape_config_ocpus,
            },
            file_uri=application_file_uri,
            freeform_tags={
                "Department": "Finance",
            },
            idle_timeout_in_minutes=application_idle_timeout_in_minutes,
            logs_bucket_uri=application_logs_bucket_uri,
            max_duration_in_minutes=application_max_duration_in_minutes,
            metastore_id=metastore_id,
            parameters=[{
                "name": application_parameters_name,
                "value": application_parameters_value,
            }],
            pool_id=test_pool["id"],
            private_endpoint_id=test_private_endpoint["id"],
            type=application_type,
            warehouse_bucket_uri=application_warehouse_bucket_uri,
            terminate_runs_on_deletion=True)
        ```

        ## Import

        Applications can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataFlow/application:Application test_application "id"
        ```

        :param str resource_name: The name of the resource.
        :param ApplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_log_config: Optional[pulumi.Input[Union['ApplicationApplicationLogConfigArgs', 'ApplicationApplicationLogConfigArgsDict']]] = None,
                 archive_uri: Optional[pulumi.Input[builtins.str]] = None,
                 arguments: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 class_name: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 configuration: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 driver_shape: Optional[pulumi.Input[builtins.str]] = None,
                 driver_shape_config: Optional[pulumi.Input[Union['ApplicationDriverShapeConfigArgs', 'ApplicationDriverShapeConfigArgsDict']]] = None,
                 execute: Optional[pulumi.Input[builtins.str]] = None,
                 executor_shape: Optional[pulumi.Input[builtins.str]] = None,
                 executor_shape_config: Optional[pulumi.Input[Union['ApplicationExecutorShapeConfigArgs', 'ApplicationExecutorShapeConfigArgsDict']]] = None,
                 file_uri: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 idle_timeout_in_minutes: Optional[pulumi.Input[builtins.str]] = None,
                 language: Optional[pulumi.Input[builtins.str]] = None,
                 logs_bucket_uri: Optional[pulumi.Input[builtins.str]] = None,
                 max_duration_in_minutes: Optional[pulumi.Input[builtins.str]] = None,
                 metastore_id: Optional[pulumi.Input[builtins.str]] = None,
                 num_executors: Optional[pulumi.Input[builtins.int]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationParameterArgs', 'ApplicationParameterArgsDict']]]]] = None,
                 pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 private_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 spark_version: Optional[pulumi.Input[builtins.str]] = None,
                 terminate_runs_on_deletion: Optional[pulumi.Input[builtins.bool]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 warehouse_bucket_uri: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplicationArgs.__new__(ApplicationArgs)

            __props__.__dict__["application_log_config"] = application_log_config
            __props__.__dict__["archive_uri"] = archive_uri
            __props__.__dict__["arguments"] = arguments
            __props__.__dict__["class_name"] = class_name
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["configuration"] = configuration
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if driver_shape is None and not opts.urn:
                raise TypeError("Missing required property 'driver_shape'")
            __props__.__dict__["driver_shape"] = driver_shape
            __props__.__dict__["driver_shape_config"] = driver_shape_config
            __props__.__dict__["execute"] = execute
            if executor_shape is None and not opts.urn:
                raise TypeError("Missing required property 'executor_shape'")
            __props__.__dict__["executor_shape"] = executor_shape
            __props__.__dict__["executor_shape_config"] = executor_shape_config
            __props__.__dict__["file_uri"] = file_uri
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["idle_timeout_in_minutes"] = idle_timeout_in_minutes
            if language is None and not opts.urn:
                raise TypeError("Missing required property 'language'")
            __props__.__dict__["language"] = language
            __props__.__dict__["logs_bucket_uri"] = logs_bucket_uri
            __props__.__dict__["max_duration_in_minutes"] = max_duration_in_minutes
            __props__.__dict__["metastore_id"] = metastore_id
            if num_executors is None and not opts.urn:
                raise TypeError("Missing required property 'num_executors'")
            __props__.__dict__["num_executors"] = num_executors
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["pool_id"] = pool_id
            __props__.__dict__["private_endpoint_id"] = private_endpoint_id
            if spark_version is None and not opts.urn:
                raise TypeError("Missing required property 'spark_version'")
            __props__.__dict__["spark_version"] = spark_version
            __props__.__dict__["terminate_runs_on_deletion"] = terminate_runs_on_deletion
            __props__.__dict__["type"] = type
            __props__.__dict__["warehouse_bucket_uri"] = warehouse_bucket_uri
            __props__.__dict__["owner_principal_id"] = None
            __props__.__dict__["owner_user_name"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(Application, __self__).__init__(
            'oci:DataFlow/application:Application',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_log_config: Optional[pulumi.Input[Union['ApplicationApplicationLogConfigArgs', 'ApplicationApplicationLogConfigArgsDict']]] = None,
            archive_uri: Optional[pulumi.Input[builtins.str]] = None,
            arguments: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            class_name: Optional[pulumi.Input[builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            configuration: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            driver_shape: Optional[pulumi.Input[builtins.str]] = None,
            driver_shape_config: Optional[pulumi.Input[Union['ApplicationDriverShapeConfigArgs', 'ApplicationDriverShapeConfigArgsDict']]] = None,
            execute: Optional[pulumi.Input[builtins.str]] = None,
            executor_shape: Optional[pulumi.Input[builtins.str]] = None,
            executor_shape_config: Optional[pulumi.Input[Union['ApplicationExecutorShapeConfigArgs', 'ApplicationExecutorShapeConfigArgsDict']]] = None,
            file_uri: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            idle_timeout_in_minutes: Optional[pulumi.Input[builtins.str]] = None,
            language: Optional[pulumi.Input[builtins.str]] = None,
            logs_bucket_uri: Optional[pulumi.Input[builtins.str]] = None,
            max_duration_in_minutes: Optional[pulumi.Input[builtins.str]] = None,
            metastore_id: Optional[pulumi.Input[builtins.str]] = None,
            num_executors: Optional[pulumi.Input[builtins.int]] = None,
            owner_principal_id: Optional[pulumi.Input[builtins.str]] = None,
            owner_user_name: Optional[pulumi.Input[builtins.str]] = None,
            parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationParameterArgs', 'ApplicationParameterArgsDict']]]]] = None,
            pool_id: Optional[pulumi.Input[builtins.str]] = None,
            private_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
            spark_version: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            terminate_runs_on_deletion: Optional[pulumi.Input[builtins.bool]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            warehouse_bucket_uri: Optional[pulumi.Input[builtins.str]] = None) -> 'Application':
        """
        Get an existing Application resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ApplicationApplicationLogConfigArgs', 'ApplicationApplicationLogConfigArgsDict']] application_log_config: (Updatable) Logging details of Application logs for Data Flow Run.
        :param pulumi.Input[builtins.str] archive_uri: (Updatable) A comma separated list of one or more archive files as Oracle Cloud Infrastructure URIs. For example, ``oci://path/to/a.zip,oci://path/to/b.zip``. An Oracle Cloud Infrastructure URI of an archive.zip file containing custom dependencies that may be used to support the execution of a Python, Java, or Scala application. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] arguments: (Updatable) The arguments passed to the running application as command line arguments.  An argument is either a plain text or a placeholder. Placeholders are replaced using values from the parameters map.  Each placeholder specified must be represented in the parameters map else the request (POST or PUT) will fail with a HTTP 400 status code.  Placeholders are specified as `Service Api Spec`, where `name` is the name of the parameter. Example:  `[ "--input", "${input_file}", "--name", "John Doe" ]` If "input_file" has a value of "mydata.xml", then the value above will be translated to `--input mydata.xml --name "John Doe"`
        :param pulumi.Input[builtins.str] class_name: (Updatable) The class for the application.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of a compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] configuration: (Updatable) The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A user-friendly description. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. It does not have to be unique. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] driver_shape: (Updatable) The VM shape for the driver. Sets the driver cores and memory.
        :param pulumi.Input[Union['ApplicationDriverShapeConfigArgs', 'ApplicationDriverShapeConfigArgsDict']] driver_shape_config: (Updatable) This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param pulumi.Input[builtins.str] execute: (Updatable) The input used for spark-submit command. For more details see https://spark.apache.org/docs/latest/submitting-applications.html#launching-applications-with-spark-submit. Supported options include ``--class``, ``--file``, ``--jars``, ``--conf``, ``--py-files``, and main application file with arguments. Example: ``--jars oci://path/to/a.jar,oci://path/to/b.jar --files oci://path/to/a.json,oci://path/to/b.csv --py-files oci://path/to/a.py,oci://path/to/b.py --conf spark.sql.crossJoin.enabled=true --class org.apache.spark.examples.SparkPi oci://path/to/main.jar 10`` Note: If execute is specified together with applicationId, className, configuration, fileUri, language, arguments, parameters during application create/update, or run create/submit, Data Flow service will use derived information from execute input only.
        :param pulumi.Input[builtins.str] executor_shape: (Updatable) The VM shape for the executors. Sets the executor cores and memory.
        :param pulumi.Input[Union['ApplicationExecutorShapeConfigArgs', 'ApplicationExecutorShapeConfigArgsDict']] executor_shape_config: (Updatable) This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param pulumi.Input[builtins.str] file_uri: (Updatable) An Oracle Cloud Infrastructure URI of the file containing the application to execute. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] idle_timeout_in_minutes: (Updatable) The timeout value in minutes used to manage Runs. A Run would be stopped after inactivity for this amount of time period. Note: This parameter is currently only applicable for Runs of type `SESSION`. Default value is 2880 minutes (2 days)
        :param pulumi.Input[builtins.str] language: (Updatable) The Spark language.
        :param pulumi.Input[builtins.str] logs_bucket_uri: (Updatable) An Oracle Cloud Infrastructure URI of the bucket where the Spark job logs are to be uploaded. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        :param pulumi.Input[builtins.str] max_duration_in_minutes: (Updatable) The maximum duration in minutes for which an Application should run. Data Flow Run would be terminated once it reaches this duration from the time it transitions to `IN_PROGRESS` state.
        :param pulumi.Input[builtins.str] metastore_id: (Updatable) The OCID of Oracle Cloud Infrastructure Hive Metastore.
        :param pulumi.Input[builtins.int] num_executors: (Updatable) The number of executor VMs requested.
        :param pulumi.Input[builtins.str] owner_principal_id: The OCID of the user who created the resource.
        :param pulumi.Input[builtins.str] owner_user_name: The username of the user who created the resource.  If the username of the owner does not exist, `null` will be returned and the caller should refer to the ownerPrincipalId value instead.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationParameterArgs', 'ApplicationParameterArgsDict']]]] parameters: (Updatable) An array of name/value pairs used to fill placeholders found in properties like `Application.arguments`.  The name must be a string of one or more word characters (a-z, A-Z, 0-9, _).  The value can be a string of 0 or more characters of any kind. Example:  [ { name: "iterations", value: "10"}, { name: "input_file", value: "mydata.xml" }, { name: "variable_x", value: "${x}"} ]
        :param pulumi.Input[builtins.str] pool_id: (Updatable) The OCID of a pool. Unique Id to indentify a dataflow pool resource.
        :param pulumi.Input[builtins.str] private_endpoint_id: (Updatable) The OCID of a private endpoint.
        :param pulumi.Input[builtins.str] spark_version: (Updatable) The Spark version utilized to run the application.
        :param pulumi.Input[builtins.str] state: The current state of this application.
        :param pulumi.Input[builtins.bool] terminate_runs_on_deletion: A boolean flag which indicates whether related non-terminal Run(s) for the Application should be terminated along with Application deletion or not.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] time_created: The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        :param pulumi.Input[builtins.str] time_updated: The date and time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        :param pulumi.Input[builtins.str] type: The Spark application processing type.
        :param pulumi.Input[builtins.str] warehouse_bucket_uri: (Updatable) An Oracle Cloud Infrastructure URI of the bucket to be used as default warehouse directory for BATCH SQL runs. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplicationState.__new__(_ApplicationState)

        __props__.__dict__["application_log_config"] = application_log_config
        __props__.__dict__["archive_uri"] = archive_uri
        __props__.__dict__["arguments"] = arguments
        __props__.__dict__["class_name"] = class_name
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["configuration"] = configuration
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["driver_shape"] = driver_shape
        __props__.__dict__["driver_shape_config"] = driver_shape_config
        __props__.__dict__["execute"] = execute
        __props__.__dict__["executor_shape"] = executor_shape
        __props__.__dict__["executor_shape_config"] = executor_shape_config
        __props__.__dict__["file_uri"] = file_uri
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["idle_timeout_in_minutes"] = idle_timeout_in_minutes
        __props__.__dict__["language"] = language
        __props__.__dict__["logs_bucket_uri"] = logs_bucket_uri
        __props__.__dict__["max_duration_in_minutes"] = max_duration_in_minutes
        __props__.__dict__["metastore_id"] = metastore_id
        __props__.__dict__["num_executors"] = num_executors
        __props__.__dict__["owner_principal_id"] = owner_principal_id
        __props__.__dict__["owner_user_name"] = owner_user_name
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["pool_id"] = pool_id
        __props__.__dict__["private_endpoint_id"] = private_endpoint_id
        __props__.__dict__["spark_version"] = spark_version
        __props__.__dict__["state"] = state
        __props__.__dict__["terminate_runs_on_deletion"] = terminate_runs_on_deletion
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["type"] = type
        __props__.__dict__["warehouse_bucket_uri"] = warehouse_bucket_uri
        return Application(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationLogConfig")
    def application_log_config(self) -> pulumi.Output['outputs.ApplicationApplicationLogConfig']:
        """
        (Updatable) Logging details of Application logs for Data Flow Run.
        """
        return pulumi.get(self, "application_log_config")

    @property
    @pulumi.getter(name="archiveUri")
    def archive_uri(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Updatable) A comma separated list of one or more archive files as Oracle Cloud Infrastructure URIs. For example, ``oci://path/to/a.zip,oci://path/to/b.zip``. An Oracle Cloud Infrastructure URI of an archive.zip file containing custom dependencies that may be used to support the execution of a Python, Java, or Scala application. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "archive_uri")

    @property
    @pulumi.getter
    def arguments(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        (Updatable) The arguments passed to the running application as command line arguments.  An argument is either a plain text or a placeholder. Placeholders are replaced using values from the parameters map.  Each placeholder specified must be represented in the parameters map else the request (POST or PUT) will fail with a HTTP 400 status code.  Placeholders are specified as `Service Api Spec`, where `name` is the name of the parameter. Example:  `[ "--input", "${input_file}", "--name", "John Doe" ]` If "input_file" has a value of "mydata.xml", then the value above will be translated to `--input mydata.xml --name "John Doe"`
        """
        return pulumi.get(self, "arguments")

    @property
    @pulumi.getter(name="className")
    def class_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Updatable) The class for the application.
        """
        return pulumi.get(self, "class_name")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The OCID of a compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A user-friendly description. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A user-friendly name. It does not have to be unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="driverShape")
    def driver_shape(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The VM shape for the driver. Sets the driver cores and memory.
        """
        return pulumi.get(self, "driver_shape")

    @property
    @pulumi.getter(name="driverShapeConfig")
    def driver_shape_config(self) -> pulumi.Output['outputs.ApplicationDriverShapeConfig']:
        """
        (Updatable) This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "driver_shape_config")

    @property
    @pulumi.getter
    def execute(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The input used for spark-submit command. For more details see https://spark.apache.org/docs/latest/submitting-applications.html#launching-applications-with-spark-submit. Supported options include ``--class``, ``--file``, ``--jars``, ``--conf``, ``--py-files``, and main application file with arguments. Example: ``--jars oci://path/to/a.jar,oci://path/to/b.jar --files oci://path/to/a.json,oci://path/to/b.csv --py-files oci://path/to/a.py,oci://path/to/b.py --conf spark.sql.crossJoin.enabled=true --class org.apache.spark.examples.SparkPi oci://path/to/main.jar 10`` Note: If execute is specified together with applicationId, className, configuration, fileUri, language, arguments, parameters during application create/update, or run create/submit, Data Flow service will use derived information from execute input only.
        """
        return pulumi.get(self, "execute")

    @property
    @pulumi.getter(name="executorShape")
    def executor_shape(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The VM shape for the executors. Sets the executor cores and memory.
        """
        return pulumi.get(self, "executor_shape")

    @property
    @pulumi.getter(name="executorShapeConfig")
    def executor_shape_config(self) -> pulumi.Output['outputs.ApplicationExecutorShapeConfig']:
        """
        (Updatable) This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "executor_shape_config")

    @property
    @pulumi.getter(name="fileUri")
    def file_uri(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) An Oracle Cloud Infrastructure URI of the file containing the application to execute. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "file_uri")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The timeout value in minutes used to manage Runs. A Run would be stopped after inactivity for this amount of time period. Note: This parameter is currently only applicable for Runs of type `SESSION`. Default value is 2880 minutes (2 days)
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @property
    @pulumi.getter
    def language(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The Spark language.
        """
        return pulumi.get(self, "language")

    @property
    @pulumi.getter(name="logsBucketUri")
    def logs_bucket_uri(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) An Oracle Cloud Infrastructure URI of the bucket where the Spark job logs are to be uploaded. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "logs_bucket_uri")

    @property
    @pulumi.getter(name="maxDurationInMinutes")
    def max_duration_in_minutes(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The maximum duration in minutes for which an Application should run. Data Flow Run would be terminated once it reaches this duration from the time it transitions to `IN_PROGRESS` state.
        """
        return pulumi.get(self, "max_duration_in_minutes")

    @property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The OCID of Oracle Cloud Infrastructure Hive Metastore.
        """
        return pulumi.get(self, "metastore_id")

    @property
    @pulumi.getter(name="numExecutors")
    def num_executors(self) -> pulumi.Output[builtins.int]:
        """
        (Updatable) The number of executor VMs requested.
        """
        return pulumi.get(self, "num_executors")

    @property
    @pulumi.getter(name="ownerPrincipalId")
    def owner_principal_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the user who created the resource.
        """
        return pulumi.get(self, "owner_principal_id")

    @property
    @pulumi.getter(name="ownerUserName")
    def owner_user_name(self) -> pulumi.Output[builtins.str]:
        """
        The username of the user who created the resource.  If the username of the owner does not exist, `null` will be returned and the caller should refer to the ownerPrincipalId value instead.
        """
        return pulumi.get(self, "owner_user_name")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Sequence['outputs.ApplicationParameter']]:
        """
        (Updatable) An array of name/value pairs used to fill placeholders found in properties like `Application.arguments`.  The name must be a string of one or more word characters (a-z, A-Z, 0-9, _).  The value can be a string of 0 or more characters of any kind. Example:  [ { name: "iterations", value: "10"}, { name: "input_file", value: "mydata.xml" }, { name: "variable_x", value: "${x}"} ]
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The OCID of a pool. Unique Id to indentify a dataflow pool resource.
        """
        return pulumi.get(self, "pool_id")

    @property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The OCID of a private endpoint.
        """
        return pulumi.get(self, "private_endpoint_id")

    @property
    @pulumi.getter(name="sparkVersion")
    def spark_version(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The Spark version utilized to run the application.
        """
        return pulumi.get(self, "spark_version")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of this application.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="terminateRunsOnDeletion")
    def terminate_runs_on_deletion(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        A boolean flag which indicates whether related non-terminal Run(s) for the Application should be terminated along with Application deletion or not.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "terminate_runs_on_deletion")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        The Spark application processing type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="warehouseBucketUri")
    def warehouse_bucket_uri(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) An Oracle Cloud Infrastructure URI of the bucket to be used as default warehouse directory for BATCH SQL runs. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "warehouse_bucket_uri")

