# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AuditProfileManagementArgs', 'AuditProfileManagement']

@pulumi.input_type
class AuditProfileManagementArgs:
    def __init__(__self__, *,
                 change_retention_trigger: Optional[pulumi.Input[builtins.bool]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_override_global_retention_setting: Optional[pulumi.Input[builtins.bool]] = None,
                 is_paid_usage_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 offline_months: Optional[pulumi.Input[builtins.int]] = None,
                 online_months: Optional[pulumi.Input[builtins.int]] = None,
                 target_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AuditProfileManagement resource.
        :param pulumi.Input[builtins.bool] change_retention_trigger: (Updatable) An optional property when set to true triggers Change Retention.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment that contains the audit.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) The description of the audit profile.
        :param pulumi.Input[builtins.str] display_name: (Updatable) The display name of the audit profile. The name does not have to be unique, and it's updatable.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_override_global_retention_setting: Indicates whether audit retention settings like online and offline months is set at the target level overriding the global audit retention settings.
        :param pulumi.Input[builtins.bool] is_paid_usage_enabled: (Updatable) Indicates if you want to continue collecting audit records beyond the free limit of one million audit records per month per target database, potentially incurring additional charges. The default value is inherited from the global settings.  You can change at the global level or at the target level.
        :param pulumi.Input[builtins.int] offline_months: Indicates the number of months the audit records will be stored offline in the Data Safe audit archive. Minimum: 0; Maximum: 72 months. If you have a requirement to store the audit data even longer in archive, please contact the Oracle Support.
        :param pulumi.Input[builtins.int] online_months: Indicates the number of months the audit records will be stored online in Oracle Data Safe audit repository for immediate reporting and analysis.  Minimum: 1; Maximum:12 months
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] target_id: The OCID of the target.
        """
        if change_retention_trigger is not None:
            pulumi.set(__self__, "change_retention_trigger", change_retention_trigger)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_override_global_retention_setting is not None:
            pulumi.set(__self__, "is_override_global_retention_setting", is_override_global_retention_setting)
        if is_paid_usage_enabled is not None:
            pulumi.set(__self__, "is_paid_usage_enabled", is_paid_usage_enabled)
        if offline_months is not None:
            pulumi.set(__self__, "offline_months", offline_months)
        if online_months is not None:
            pulumi.set(__self__, "online_months", online_months)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)

    @property
    @pulumi.getter(name="changeRetentionTrigger")
    def change_retention_trigger(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) An optional property when set to true triggers Change Retention.
        """
        return pulumi.get(self, "change_retention_trigger")

    @change_retention_trigger.setter
    def change_retention_trigger(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "change_retention_trigger", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the compartment that contains the audit.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The description of the audit profile.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The display name of the audit profile. The name does not have to be unique, and it's updatable.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isOverrideGlobalRetentionSetting")
    def is_override_global_retention_setting(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether audit retention settings like online and offline months is set at the target level overriding the global audit retention settings.
        """
        return pulumi.get(self, "is_override_global_retention_setting")

    @is_override_global_retention_setting.setter
    def is_override_global_retention_setting(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_override_global_retention_setting", value)

    @property
    @pulumi.getter(name="isPaidUsageEnabled")
    def is_paid_usage_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Indicates if you want to continue collecting audit records beyond the free limit of one million audit records per month per target database, potentially incurring additional charges. The default value is inherited from the global settings.  You can change at the global level or at the target level.
        """
        return pulumi.get(self, "is_paid_usage_enabled")

    @is_paid_usage_enabled.setter
    def is_paid_usage_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_paid_usage_enabled", value)

    @property
    @pulumi.getter(name="offlineMonths")
    def offline_months(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Indicates the number of months the audit records will be stored offline in the Data Safe audit archive. Minimum: 0; Maximum: 72 months. If you have a requirement to store the audit data even longer in archive, please contact the Oracle Support.
        """
        return pulumi.get(self, "offline_months")

    @offline_months.setter
    def offline_months(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "offline_months", value)

    @property
    @pulumi.getter(name="onlineMonths")
    def online_months(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Indicates the number of months the audit records will be stored online in Oracle Data Safe audit repository for immediate reporting and analysis.  Minimum: 1; Maximum:12 months

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "online_months")

    @online_months.setter
    def online_months(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "online_months", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the target.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_id", value)


@pulumi.input_type
class _AuditProfileManagementState:
    def __init__(__self__, *,
                 audit_collected_volume: Optional[pulumi.Input[builtins.str]] = None,
                 change_retention_trigger: Optional[pulumi.Input[builtins.bool]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_override_global_retention_setting: Optional[pulumi.Input[builtins.bool]] = None,
                 is_paid_usage_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 offline_months: Optional[pulumi.Input[builtins.int]] = None,
                 online_months: Optional[pulumi.Input[builtins.int]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 target_id: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AuditProfileManagement resources.
        :param pulumi.Input[builtins.str] audit_collected_volume: Indicates number of audit records collected by Data Safe in the current calendar month.  Audit records for the Data Safe service account are excluded and are not counted towards your monthly free limit.
        :param pulumi.Input[builtins.bool] change_retention_trigger: (Updatable) An optional property when set to true triggers Change Retention.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment that contains the audit.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) The description of the audit profile.
        :param pulumi.Input[builtins.str] display_name: (Updatable) The display name of the audit profile. The name does not have to be unique, and it's updatable.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_override_global_retention_setting: Indicates whether audit retention settings like online and offline months is set at the target level overriding the global audit retention settings.
        :param pulumi.Input[builtins.bool] is_paid_usage_enabled: (Updatable) Indicates if you want to continue collecting audit records beyond the free limit of one million audit records per month per target database, potentially incurring additional charges. The default value is inherited from the global settings.  You can change at the global level or at the target level.
        :param pulumi.Input[builtins.str] lifecycle_details: Details about the current state of the audit profile in Data Safe.
        :param pulumi.Input[builtins.int] offline_months: Indicates the number of months the audit records will be stored offline in the Data Safe audit archive. Minimum: 0; Maximum: 72 months. If you have a requirement to store the audit data even longer in archive, please contact the Oracle Support.
        :param pulumi.Input[builtins.int] online_months: Indicates the number of months the audit records will be stored online in Oracle Data Safe audit repository for immediate reporting and analysis.  Minimum: 1; Maximum:12 months
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] state: The current state of the audit profile.
        :param pulumi.Input[builtins.str] target_id: The OCID of the target.
        :param pulumi.Input[builtins.str] time_created: The date and time the audit profile was created, in the format defined by RFC3339.
        :param pulumi.Input[builtins.str] time_updated: The date and time the audit profile was updated, in the format defined by RFC3339.
        """
        if audit_collected_volume is not None:
            pulumi.set(__self__, "audit_collected_volume", audit_collected_volume)
        if change_retention_trigger is not None:
            pulumi.set(__self__, "change_retention_trigger", change_retention_trigger)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_override_global_retention_setting is not None:
            pulumi.set(__self__, "is_override_global_retention_setting", is_override_global_retention_setting)
        if is_paid_usage_enabled is not None:
            pulumi.set(__self__, "is_paid_usage_enabled", is_paid_usage_enabled)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if offline_months is not None:
            pulumi.set(__self__, "offline_months", offline_months)
        if online_months is not None:
            pulumi.set(__self__, "online_months", online_months)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="auditCollectedVolume")
    def audit_collected_volume(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates number of audit records collected by Data Safe in the current calendar month.  Audit records for the Data Safe service account are excluded and are not counted towards your monthly free limit.
        """
        return pulumi.get(self, "audit_collected_volume")

    @audit_collected_volume.setter
    def audit_collected_volume(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "audit_collected_volume", value)

    @property
    @pulumi.getter(name="changeRetentionTrigger")
    def change_retention_trigger(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) An optional property when set to true triggers Change Retention.
        """
        return pulumi.get(self, "change_retention_trigger")

    @change_retention_trigger.setter
    def change_retention_trigger(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "change_retention_trigger", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the compartment that contains the audit.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The description of the audit profile.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The display name of the audit profile. The name does not have to be unique, and it's updatable.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isOverrideGlobalRetentionSetting")
    def is_override_global_retention_setting(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether audit retention settings like online and offline months is set at the target level overriding the global audit retention settings.
        """
        return pulumi.get(self, "is_override_global_retention_setting")

    @is_override_global_retention_setting.setter
    def is_override_global_retention_setting(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_override_global_retention_setting", value)

    @property
    @pulumi.getter(name="isPaidUsageEnabled")
    def is_paid_usage_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Indicates if you want to continue collecting audit records beyond the free limit of one million audit records per month per target database, potentially incurring additional charges. The default value is inherited from the global settings.  You can change at the global level or at the target level.
        """
        return pulumi.get(self, "is_paid_usage_enabled")

    @is_paid_usage_enabled.setter
    def is_paid_usage_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_paid_usage_enabled", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Details about the current state of the audit profile in Data Safe.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="offlineMonths")
    def offline_months(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Indicates the number of months the audit records will be stored offline in the Data Safe audit archive. Minimum: 0; Maximum: 72 months. If you have a requirement to store the audit data even longer in archive, please contact the Oracle Support.
        """
        return pulumi.get(self, "offline_months")

    @offline_months.setter
    def offline_months(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "offline_months", value)

    @property
    @pulumi.getter(name="onlineMonths")
    def online_months(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Indicates the number of months the audit records will be stored online in Oracle Data Safe audit repository for immediate reporting and analysis.  Minimum: 1; Maximum:12 months

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "online_months")

    @online_months.setter
    def online_months(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "online_months", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the audit profile.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the target.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the audit profile was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the audit profile was updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:DataSafe/auditProfileManagement:AuditProfileManagement")
class AuditProfileManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 change_retention_trigger: Optional[pulumi.Input[builtins.bool]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_override_global_retention_setting: Optional[pulumi.Input[builtins.bool]] = None,
                 is_paid_usage_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 offline_months: Optional[pulumi.Input[builtins.int]] = None,
                 online_months: Optional[pulumi.Input[builtins.int]] = None,
                 target_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Audit Profile Management resource in Oracle Cloud Infrastructure Data Safe service.

        Updates one or more attributes of the specified audit profile.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_audit_profile_management = oci.data_safe.AuditProfileManagement("test_audit_profile_management",
            compartment_id=compartment_id,
            target_id=test_target_database["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=audit_profile_management_description,
            display_name=audit_profile_management_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            is_paid_usage_enabled=audit_profile_management_is_paid_usage_enabled,
            change_retention_trigger=True,
            offline_months=10,
            online_months=7)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] change_retention_trigger: (Updatable) An optional property when set to true triggers Change Retention.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment that contains the audit.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) The description of the audit profile.
        :param pulumi.Input[builtins.str] display_name: (Updatable) The display name of the audit profile. The name does not have to be unique, and it's updatable.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_override_global_retention_setting: Indicates whether audit retention settings like online and offline months is set at the target level overriding the global audit retention settings.
        :param pulumi.Input[builtins.bool] is_paid_usage_enabled: (Updatable) Indicates if you want to continue collecting audit records beyond the free limit of one million audit records per month per target database, potentially incurring additional charges. The default value is inherited from the global settings.  You can change at the global level or at the target level.
        :param pulumi.Input[builtins.int] offline_months: Indicates the number of months the audit records will be stored offline in the Data Safe audit archive. Minimum: 0; Maximum: 72 months. If you have a requirement to store the audit data even longer in archive, please contact the Oracle Support.
        :param pulumi.Input[builtins.int] online_months: Indicates the number of months the audit records will be stored online in Oracle Data Safe audit repository for immediate reporting and analysis.  Minimum: 1; Maximum:12 months
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] target_id: The OCID of the target.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AuditProfileManagementArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Audit Profile Management resource in Oracle Cloud Infrastructure Data Safe service.

        Updates one or more attributes of the specified audit profile.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_audit_profile_management = oci.data_safe.AuditProfileManagement("test_audit_profile_management",
            compartment_id=compartment_id,
            target_id=test_target_database["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=audit_profile_management_description,
            display_name=audit_profile_management_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            is_paid_usage_enabled=audit_profile_management_is_paid_usage_enabled,
            change_retention_trigger=True,
            offline_months=10,
            online_months=7)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param AuditProfileManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuditProfileManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 change_retention_trigger: Optional[pulumi.Input[builtins.bool]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_override_global_retention_setting: Optional[pulumi.Input[builtins.bool]] = None,
                 is_paid_usage_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 offline_months: Optional[pulumi.Input[builtins.int]] = None,
                 online_months: Optional[pulumi.Input[builtins.int]] = None,
                 target_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuditProfileManagementArgs.__new__(AuditProfileManagementArgs)

            __props__.__dict__["change_retention_trigger"] = change_retention_trigger
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_override_global_retention_setting"] = is_override_global_retention_setting
            __props__.__dict__["is_paid_usage_enabled"] = is_paid_usage_enabled
            __props__.__dict__["offline_months"] = offline_months
            __props__.__dict__["online_months"] = online_months
            __props__.__dict__["target_id"] = target_id
            __props__.__dict__["audit_collected_volume"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(AuditProfileManagement, __self__).__init__(
            'oci:DataSafe/auditProfileManagement:AuditProfileManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            audit_collected_volume: Optional[pulumi.Input[builtins.str]] = None,
            change_retention_trigger: Optional[pulumi.Input[builtins.bool]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            is_override_global_retention_setting: Optional[pulumi.Input[builtins.bool]] = None,
            is_paid_usage_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            offline_months: Optional[pulumi.Input[builtins.int]] = None,
            online_months: Optional[pulumi.Input[builtins.int]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            target_id: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None) -> 'AuditProfileManagement':
        """
        Get an existing AuditProfileManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] audit_collected_volume: Indicates number of audit records collected by Data Safe in the current calendar month.  Audit records for the Data Safe service account are excluded and are not counted towards your monthly free limit.
        :param pulumi.Input[builtins.bool] change_retention_trigger: (Updatable) An optional property when set to true triggers Change Retention.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment that contains the audit.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) The description of the audit profile.
        :param pulumi.Input[builtins.str] display_name: (Updatable) The display name of the audit profile. The name does not have to be unique, and it's updatable.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_override_global_retention_setting: Indicates whether audit retention settings like online and offline months is set at the target level overriding the global audit retention settings.
        :param pulumi.Input[builtins.bool] is_paid_usage_enabled: (Updatable) Indicates if you want to continue collecting audit records beyond the free limit of one million audit records per month per target database, potentially incurring additional charges. The default value is inherited from the global settings.  You can change at the global level or at the target level.
        :param pulumi.Input[builtins.str] lifecycle_details: Details about the current state of the audit profile in Data Safe.
        :param pulumi.Input[builtins.int] offline_months: Indicates the number of months the audit records will be stored offline in the Data Safe audit archive. Minimum: 0; Maximum: 72 months. If you have a requirement to store the audit data even longer in archive, please contact the Oracle Support.
        :param pulumi.Input[builtins.int] online_months: Indicates the number of months the audit records will be stored online in Oracle Data Safe audit repository for immediate reporting and analysis.  Minimum: 1; Maximum:12 months
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] state: The current state of the audit profile.
        :param pulumi.Input[builtins.str] target_id: The OCID of the target.
        :param pulumi.Input[builtins.str] time_created: The date and time the audit profile was created, in the format defined by RFC3339.
        :param pulumi.Input[builtins.str] time_updated: The date and time the audit profile was updated, in the format defined by RFC3339.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuditProfileManagementState.__new__(_AuditProfileManagementState)

        __props__.__dict__["audit_collected_volume"] = audit_collected_volume
        __props__.__dict__["change_retention_trigger"] = change_retention_trigger
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_override_global_retention_setting"] = is_override_global_retention_setting
        __props__.__dict__["is_paid_usage_enabled"] = is_paid_usage_enabled
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["offline_months"] = offline_months
        __props__.__dict__["online_months"] = online_months
        __props__.__dict__["state"] = state
        __props__.__dict__["target_id"] = target_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return AuditProfileManagement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="auditCollectedVolume")
    def audit_collected_volume(self) -> pulumi.Output[builtins.str]:
        """
        Indicates number of audit records collected by Data Safe in the current calendar month.  Audit records for the Data Safe service account are excluded and are not counted towards your monthly free limit.
        """
        return pulumi.get(self, "audit_collected_volume")

    @property
    @pulumi.getter(name="changeRetentionTrigger")
    def change_retention_trigger(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        (Updatable) An optional property when set to true triggers Change Retention.
        """
        return pulumi.get(self, "change_retention_trigger")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The OCID of the compartment that contains the audit.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The description of the audit profile.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The display name of the audit profile. The name does not have to be unique, and it's updatable.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isOverrideGlobalRetentionSetting")
    def is_override_global_retention_setting(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Indicates whether audit retention settings like online and offline months is set at the target level overriding the global audit retention settings.
        """
        return pulumi.get(self, "is_override_global_retention_setting")

    @property
    @pulumi.getter(name="isPaidUsageEnabled")
    def is_paid_usage_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        (Updatable) Indicates if you want to continue collecting audit records beyond the free limit of one million audit records per month per target database, potentially incurring additional charges. The default value is inherited from the global settings.  You can change at the global level or at the target level.
        """
        return pulumi.get(self, "is_paid_usage_enabled")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        Details about the current state of the audit profile in Data Safe.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="offlineMonths")
    def offline_months(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Indicates the number of months the audit records will be stored offline in the Data Safe audit archive. Minimum: 0; Maximum: 72 months. If you have a requirement to store the audit data even longer in archive, please contact the Oracle Support.
        """
        return pulumi.get(self, "offline_months")

    @property
    @pulumi.getter(name="onlineMonths")
    def online_months(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Indicates the number of months the audit records will be stored online in Oracle Data Safe audit repository for immediate reporting and analysis.  Minimum: 1; Maximum:12 months

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "online_months")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the audit profile.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The OCID of the target.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the audit profile was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the audit profile was updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

