# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSensitiveDataModelResult',
    'AwaitableGetSensitiveDataModelResult',
    'get_sensitive_data_model',
    'get_sensitive_data_model_output',
]

@pulumi.output_type
class GetSensitiveDataModelResult:
    """
    A collection of values returned by getSensitiveDataModel.
    """
    def __init__(__self__, app_suite_name=None, compartment_id=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, is_app_defined_relation_discovery_enabled=None, is_include_all_schemas=None, is_include_all_sensitive_types=None, is_sample_data_collection_enabled=None, schemas_for_discoveries=None, sensitive_data_model_id=None, sensitive_type_group_ids_for_discoveries=None, sensitive_type_ids_for_discoveries=None, state=None, system_tags=None, tables_for_discoveries=None, target_id=None, time_created=None, time_updated=None):
        if app_suite_name and not isinstance(app_suite_name, str):
            raise TypeError("Expected argument 'app_suite_name' to be a str")
        pulumi.set(__self__, "app_suite_name", app_suite_name)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_app_defined_relation_discovery_enabled and not isinstance(is_app_defined_relation_discovery_enabled, bool):
            raise TypeError("Expected argument 'is_app_defined_relation_discovery_enabled' to be a bool")
        pulumi.set(__self__, "is_app_defined_relation_discovery_enabled", is_app_defined_relation_discovery_enabled)
        if is_include_all_schemas and not isinstance(is_include_all_schemas, bool):
            raise TypeError("Expected argument 'is_include_all_schemas' to be a bool")
        pulumi.set(__self__, "is_include_all_schemas", is_include_all_schemas)
        if is_include_all_sensitive_types and not isinstance(is_include_all_sensitive_types, bool):
            raise TypeError("Expected argument 'is_include_all_sensitive_types' to be a bool")
        pulumi.set(__self__, "is_include_all_sensitive_types", is_include_all_sensitive_types)
        if is_sample_data_collection_enabled and not isinstance(is_sample_data_collection_enabled, bool):
            raise TypeError("Expected argument 'is_sample_data_collection_enabled' to be a bool")
        pulumi.set(__self__, "is_sample_data_collection_enabled", is_sample_data_collection_enabled)
        if schemas_for_discoveries and not isinstance(schemas_for_discoveries, list):
            raise TypeError("Expected argument 'schemas_for_discoveries' to be a list")
        pulumi.set(__self__, "schemas_for_discoveries", schemas_for_discoveries)
        if sensitive_data_model_id and not isinstance(sensitive_data_model_id, str):
            raise TypeError("Expected argument 'sensitive_data_model_id' to be a str")
        pulumi.set(__self__, "sensitive_data_model_id", sensitive_data_model_id)
        if sensitive_type_group_ids_for_discoveries and not isinstance(sensitive_type_group_ids_for_discoveries, list):
            raise TypeError("Expected argument 'sensitive_type_group_ids_for_discoveries' to be a list")
        pulumi.set(__self__, "sensitive_type_group_ids_for_discoveries", sensitive_type_group_ids_for_discoveries)
        if sensitive_type_ids_for_discoveries and not isinstance(sensitive_type_ids_for_discoveries, list):
            raise TypeError("Expected argument 'sensitive_type_ids_for_discoveries' to be a list")
        pulumi.set(__self__, "sensitive_type_ids_for_discoveries", sensitive_type_ids_for_discoveries)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if tables_for_discoveries and not isinstance(tables_for_discoveries, list):
            raise TypeError("Expected argument 'tables_for_discoveries' to be a list")
        pulumi.set(__self__, "tables_for_discoveries", tables_for_discoveries)
        if target_id and not isinstance(target_id, str):
            raise TypeError("Expected argument 'target_id' to be a str")
        pulumi.set(__self__, "target_id", target_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="appSuiteName")
    def app_suite_name(self) -> builtins.str:
        """
        The application suite name identifying a collection of applications. The default value is GENERIC. It's useful only if maintaining a sensitive data model for a suite of applications.
        """
        return pulumi.get(self, "app_suite_name")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment that contains the sensitive data model.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the sensitive data model.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The display name of the sensitive data model.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the sensitive data model.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAppDefinedRelationDiscoveryEnabled")
    def is_app_defined_relation_discovery_enabled(self) -> builtins.bool:
        """
        Indicates if data discovery jobs should identify potential application-level (non-dictionary) referential relationships between columns. Note that data discovery automatically identifies and adds database-level (dictionary-defined) relationships. This option helps identify application-level relationships that are not defined in the database dictionary, which in turn, helps identify additional sensitive columns and preserve referential integrity during data masking. It's disabled by default and should be used only if there is a need to identify application-level relationships.
        """
        return pulumi.get(self, "is_app_defined_relation_discovery_enabled")

    @property
    @pulumi.getter(name="isIncludeAllSchemas")
    def is_include_all_schemas(self) -> builtins.bool:
        """
        Indicates if all the schemas in the associated target database should be scanned by data discovery jobs. If it is set to true, sensitive data is discovered in all schemas (except for schemas maintained by Oracle).
        """
        return pulumi.get(self, "is_include_all_schemas")

    @property
    @pulumi.getter(name="isIncludeAllSensitiveTypes")
    def is_include_all_sensitive_types(self) -> builtins.bool:
        """
        Indicates if all the existing sensitive types should be used by data discovery jobs.If it's set to true, the sensitiveTypeIdsForDiscovery attribute is ignored and all sensitive types are used for data discovery.
        """
        return pulumi.get(self, "is_include_all_sensitive_types")

    @property
    @pulumi.getter(name="isSampleDataCollectionEnabled")
    def is_sample_data_collection_enabled(self) -> builtins.bool:
        """
        Indicates if data discovery jobs should collect and store sample data values for the discovered columns. Sample data helps review the discovered columns and ensure that they actually contain sensitive data. As it collects original data from the target database, it's disabled by default and should be used only if it's acceptable to store sample data in Data Safe's repository in Oracle Cloud. Note that sample data values are not collected for columns with the following data types: LONG, LOB, RAW, XMLTYPE and BFILE.
        """
        return pulumi.get(self, "is_sample_data_collection_enabled")

    @property
    @pulumi.getter(name="schemasForDiscoveries")
    def schemas_for_discoveries(self) -> Sequence[builtins.str]:
        """
        The schemas to be scanned by data discovery jobs.
        """
        return pulumi.get(self, "schemas_for_discoveries")

    @property
    @pulumi.getter(name="sensitiveDataModelId")
    def sensitive_data_model_id(self) -> builtins.str:
        return pulumi.get(self, "sensitive_data_model_id")

    @property
    @pulumi.getter(name="sensitiveTypeGroupIdsForDiscoveries")
    def sensitive_type_group_ids_for_discoveries(self) -> Sequence[builtins.str]:
        """
        The OCIDs of the sensitive type groups to be used by data discovery jobs.
        """
        return pulumi.get(self, "sensitive_type_group_ids_for_discoveries")

    @property
    @pulumi.getter(name="sensitiveTypeIdsForDiscoveries")
    def sensitive_type_ids_for_discoveries(self) -> Sequence[builtins.str]:
        """
        The OCIDs of the sensitive types to be used by data discovery jobs.
        """
        return pulumi.get(self, "sensitive_type_ids_for_discoveries")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the sensitive data model.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="tablesForDiscoveries")
    def tables_for_discoveries(self) -> Sequence['outputs.GetSensitiveDataModelTablesForDiscoveryResult']:
        """
        The data discovery jobs will scan the tables specified here, including both schemas and tables. For instance, the input could be in the format: [{schemaName: "HR", tableName: ["T1", "T2"]}, {schemaName:  "OE", tableName : ["T3", "T4"]}].
        """
        return pulumi.get(self, "tables_for_discoveries")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> builtins.str:
        """
        The OCID of the reference target database associated with the sensitive data model. All operations such as performing data discovery and adding columns manually are done in the context of the associated target database.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the sensitive data model was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the sensitive data model was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetSensitiveDataModelResult(GetSensitiveDataModelResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSensitiveDataModelResult(
            app_suite_name=self.app_suite_name,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_app_defined_relation_discovery_enabled=self.is_app_defined_relation_discovery_enabled,
            is_include_all_schemas=self.is_include_all_schemas,
            is_include_all_sensitive_types=self.is_include_all_sensitive_types,
            is_sample_data_collection_enabled=self.is_sample_data_collection_enabled,
            schemas_for_discoveries=self.schemas_for_discoveries,
            sensitive_data_model_id=self.sensitive_data_model_id,
            sensitive_type_group_ids_for_discoveries=self.sensitive_type_group_ids_for_discoveries,
            sensitive_type_ids_for_discoveries=self.sensitive_type_ids_for_discoveries,
            state=self.state,
            system_tags=self.system_tags,
            tables_for_discoveries=self.tables_for_discoveries,
            target_id=self.target_id,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_sensitive_data_model(sensitive_data_model_id: Optional[builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSensitiveDataModelResult:
    """
    This data source provides details about a specific Sensitive Data Model resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of the specified sensitive data model.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sensitive_data_model = oci.DataSafe.get_sensitive_data_model(sensitive_data_model_id=test_sensitive_data_model_oci_data_safe_sensitive_data_model["id"])
    ```


    :param builtins.str sensitive_data_model_id: The OCID of the sensitive data model.
    """
    __args__ = dict()
    __args__['sensitiveDataModelId'] = sensitive_data_model_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getSensitiveDataModel:getSensitiveDataModel', __args__, opts=opts, typ=GetSensitiveDataModelResult).value

    return AwaitableGetSensitiveDataModelResult(
        app_suite_name=pulumi.get(__ret__, 'app_suite_name'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_app_defined_relation_discovery_enabled=pulumi.get(__ret__, 'is_app_defined_relation_discovery_enabled'),
        is_include_all_schemas=pulumi.get(__ret__, 'is_include_all_schemas'),
        is_include_all_sensitive_types=pulumi.get(__ret__, 'is_include_all_sensitive_types'),
        is_sample_data_collection_enabled=pulumi.get(__ret__, 'is_sample_data_collection_enabled'),
        schemas_for_discoveries=pulumi.get(__ret__, 'schemas_for_discoveries'),
        sensitive_data_model_id=pulumi.get(__ret__, 'sensitive_data_model_id'),
        sensitive_type_group_ids_for_discoveries=pulumi.get(__ret__, 'sensitive_type_group_ids_for_discoveries'),
        sensitive_type_ids_for_discoveries=pulumi.get(__ret__, 'sensitive_type_ids_for_discoveries'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        tables_for_discoveries=pulumi.get(__ret__, 'tables_for_discoveries'),
        target_id=pulumi.get(__ret__, 'target_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_sensitive_data_model_output(sensitive_data_model_id: Optional[pulumi.Input[builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSensitiveDataModelResult]:
    """
    This data source provides details about a specific Sensitive Data Model resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of the specified sensitive data model.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sensitive_data_model = oci.DataSafe.get_sensitive_data_model(sensitive_data_model_id=test_sensitive_data_model_oci_data_safe_sensitive_data_model["id"])
    ```


    :param builtins.str sensitive_data_model_id: The OCID of the sensitive data model.
    """
    __args__ = dict()
    __args__['sensitiveDataModelId'] = sensitive_data_model_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getSensitiveDataModel:getSensitiveDataModel', __args__, opts=opts, typ=GetSensitiveDataModelResult)
    return __ret__.apply(lambda __response__: GetSensitiveDataModelResult(
        app_suite_name=pulumi.get(__response__, 'app_suite_name'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_app_defined_relation_discovery_enabled=pulumi.get(__response__, 'is_app_defined_relation_discovery_enabled'),
        is_include_all_schemas=pulumi.get(__response__, 'is_include_all_schemas'),
        is_include_all_sensitive_types=pulumi.get(__response__, 'is_include_all_sensitive_types'),
        is_sample_data_collection_enabled=pulumi.get(__response__, 'is_sample_data_collection_enabled'),
        schemas_for_discoveries=pulumi.get(__response__, 'schemas_for_discoveries'),
        sensitive_data_model_id=pulumi.get(__response__, 'sensitive_data_model_id'),
        sensitive_type_group_ids_for_discoveries=pulumi.get(__response__, 'sensitive_type_group_ids_for_discoveries'),
        sensitive_type_ids_for_discoveries=pulumi.get(__response__, 'sensitive_type_ids_for_discoveries'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        tables_for_discoveries=pulumi.get(__response__, 'tables_for_discoveries'),
        target_id=pulumi.get(__response__, 'target_id'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
