# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSensitiveDataModelReferentialRelationResult',
    'AwaitableGetSensitiveDataModelReferentialRelationResult',
    'get_sensitive_data_model_referential_relation',
    'get_sensitive_data_model_referential_relation_output',
]

@pulumi.output_type
class GetSensitiveDataModelReferentialRelationResult:
    """
    A collection of values returned by getSensitiveDataModelReferentialRelation.
    """
    def __init__(__self__, children=None, id=None, is_sensitive=None, key=None, parents=None, relation_type=None, sensitive_data_model_id=None, state=None):
        if children and not isinstance(children, list):
            raise TypeError("Expected argument 'children' to be a list")
        pulumi.set(__self__, "children", children)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_sensitive and not isinstance(is_sensitive, bool):
            raise TypeError("Expected argument 'is_sensitive' to be a bool")
        pulumi.set(__self__, "is_sensitive", is_sensitive)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if parents and not isinstance(parents, list):
            raise TypeError("Expected argument 'parents' to be a list")
        pulumi.set(__self__, "parents", parents)
        if relation_type and not isinstance(relation_type, str):
            raise TypeError("Expected argument 'relation_type' to be a str")
        pulumi.set(__self__, "relation_type", relation_type)
        if sensitive_data_model_id and not isinstance(sensitive_data_model_id, str):
            raise TypeError("Expected argument 'sensitive_data_model_id' to be a str")
        pulumi.set(__self__, "sensitive_data_model_id", sensitive_data_model_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def children(self) -> Sequence['outputs.GetSensitiveDataModelReferentialRelationChildResult']:
        """
        columnsInfo object has details of column group with schema details.
        """
        return pulumi.get(self, "children")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isSensitive")
    def is_sensitive(self) -> builtins.bool:
        """
        Determines if the columns present in the referential relation is present in the sensitive data model
        """
        return pulumi.get(self, "is_sensitive")

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The unique key that identifies the referential relation. It's numeric and unique within a sensitive data model.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def parents(self) -> Sequence['outputs.GetSensitiveDataModelReferentialRelationParentResult']:
        """
        columnsInfo object has details of column group with schema details.
        """
        return pulumi.get(self, "parents")

    @property
    @pulumi.getter(name="relationType")
    def relation_type(self) -> builtins.str:
        """
        The type of referential relationship the sensitive column has with its parent. NONE indicates that the sensitive column does not have a parent. DB_DEFINED indicates that the relationship is defined in the database dictionary. APP_DEFINED indicates that the relationship is defined at the application level and not in the database dictionary.
        """
        return pulumi.get(self, "relation_type")

    @property
    @pulumi.getter(name="sensitiveDataModelId")
    def sensitive_data_model_id(self) -> builtins.str:
        """
        The OCID of the sensitive data model that contains the sensitive column.
        """
        return pulumi.get(self, "sensitive_data_model_id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the referential relation.
        """
        return pulumi.get(self, "state")


class AwaitableGetSensitiveDataModelReferentialRelationResult(GetSensitiveDataModelReferentialRelationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSensitiveDataModelReferentialRelationResult(
            children=self.children,
            id=self.id,
            is_sensitive=self.is_sensitive,
            key=self.key,
            parents=self.parents,
            relation_type=self.relation_type,
            sensitive_data_model_id=self.sensitive_data_model_id,
            state=self.state)


def get_sensitive_data_model_referential_relation(key: Optional[builtins.str] = None,
                                                  sensitive_data_model_id: Optional[builtins.str] = None,
                                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSensitiveDataModelReferentialRelationResult:
    """
    This data source provides details about a specific Sensitive Data Model Referential Relation resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of the specified referential relation.


    :param builtins.str key: The unique key that identifies the referential relation. It's numeric and unique within a sensitive data model.
    :param builtins.str sensitive_data_model_id: The OCID of the sensitive data model.
    """
    __args__ = dict()
    __args__['key'] = key
    __args__['sensitiveDataModelId'] = sensitive_data_model_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getSensitiveDataModelReferentialRelation:getSensitiveDataModelReferentialRelation', __args__, opts=opts, typ=GetSensitiveDataModelReferentialRelationResult).value

    return AwaitableGetSensitiveDataModelReferentialRelationResult(
        children=pulumi.get(__ret__, 'children'),
        id=pulumi.get(__ret__, 'id'),
        is_sensitive=pulumi.get(__ret__, 'is_sensitive'),
        key=pulumi.get(__ret__, 'key'),
        parents=pulumi.get(__ret__, 'parents'),
        relation_type=pulumi.get(__ret__, 'relation_type'),
        sensitive_data_model_id=pulumi.get(__ret__, 'sensitive_data_model_id'),
        state=pulumi.get(__ret__, 'state'))
def get_sensitive_data_model_referential_relation_output(key: Optional[pulumi.Input[builtins.str]] = None,
                                                         sensitive_data_model_id: Optional[pulumi.Input[builtins.str]] = None,
                                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSensitiveDataModelReferentialRelationResult]:
    """
    This data source provides details about a specific Sensitive Data Model Referential Relation resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of the specified referential relation.


    :param builtins.str key: The unique key that identifies the referential relation. It's numeric and unique within a sensitive data model.
    :param builtins.str sensitive_data_model_id: The OCID of the sensitive data model.
    """
    __args__ = dict()
    __args__['key'] = key
    __args__['sensitiveDataModelId'] = sensitive_data_model_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getSensitiveDataModelReferentialRelation:getSensitiveDataModelReferentialRelation', __args__, opts=opts, typ=GetSensitiveDataModelReferentialRelationResult)
    return __ret__.apply(lambda __response__: GetSensitiveDataModelReferentialRelationResult(
        children=pulumi.get(__response__, 'children'),
        id=pulumi.get(__response__, 'id'),
        is_sensitive=pulumi.get(__response__, 'is_sensitive'),
        key=pulumi.get(__response__, 'key'),
        parents=pulumi.get(__response__, 'parents'),
        relation_type=pulumi.get(__response__, 'relation_type'),
        sensitive_data_model_id=pulumi.get(__response__, 'sensitive_data_model_id'),
        state=pulumi.get(__response__, 'state')))
