# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSqlFirewallPolicyAnalyticsResult',
    'AwaitableGetSqlFirewallPolicyAnalyticsResult',
    'get_sql_firewall_policy_analytics',
    'get_sql_firewall_policy_analytics_output',
]

@pulumi.output_type
class GetSqlFirewallPolicyAnalyticsResult:
    """
    A collection of values returned by getSqlFirewallPolicyAnalytics.
    """
    def __init__(__self__, access_level=None, compartment_id=None, compartment_id_in_subtree=None, filters=None, group_bies=None, id=None, security_policy_id=None, sql_firewall_policy_analytics_collections=None, state=None, time_ended=None, time_started=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if group_bies and not isinstance(group_bies, list):
            raise TypeError("Expected argument 'group_bies' to be a list")
        pulumi.set(__self__, "group_bies", group_bies)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if security_policy_id and not isinstance(security_policy_id, str):
            raise TypeError("Expected argument 'security_policy_id' to be a str")
        pulumi.set(__self__, "security_policy_id", security_policy_id)
        if sql_firewall_policy_analytics_collections and not isinstance(sql_firewall_policy_analytics_collections, list):
            raise TypeError("Expected argument 'sql_firewall_policy_analytics_collections' to be a list")
        pulumi.set(__self__, "sql_firewall_policy_analytics_collections", sql_firewall_policy_analytics_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_ended and not isinstance(time_ended, str):
            raise TypeError("Expected argument 'time_ended' to be a str")
        pulumi.set(__self__, "time_ended", time_ended)
        if time_started and not isinstance(time_started, str):
            raise TypeError("Expected argument 'time_started' to be a str")
        pulumi.set(__self__, "time_started", time_started)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[builtins.str]:
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSqlFirewallPolicyAnalyticsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "group_bies")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> Optional[builtins.str]:
        """
        The OCID of the security policy corresponding to the SQL Firewall policy.
        """
        return pulumi.get(self, "security_policy_id")

    @property
    @pulumi.getter(name="sqlFirewallPolicyAnalyticsCollections")
    def sql_firewall_policy_analytics_collections(self) -> Sequence['outputs.GetSqlFirewallPolicyAnalyticsSqlFirewallPolicyAnalyticsCollectionResult']:
        """
        The list of sql_firewall_policy_analytics_collection.
        """
        return pulumi.get(self, "sql_firewall_policy_analytics_collections")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the SQL Firewall policy.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> Optional[builtins.str]:
        return pulumi.get(self, "time_ended")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> Optional[builtins.str]:
        return pulumi.get(self, "time_started")


class AwaitableGetSqlFirewallPolicyAnalyticsResult(GetSqlFirewallPolicyAnalyticsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSqlFirewallPolicyAnalyticsResult(
            access_level=self.access_level,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            filters=self.filters,
            group_bies=self.group_bies,
            id=self.id,
            security_policy_id=self.security_policy_id,
            sql_firewall_policy_analytics_collections=self.sql_firewall_policy_analytics_collections,
            state=self.state,
            time_ended=self.time_ended,
            time_started=self.time_started)


def get_sql_firewall_policy_analytics(access_level: Optional[builtins.str] = None,
                                      compartment_id: Optional[builtins.str] = None,
                                      compartment_id_in_subtree: Optional[builtins.bool] = None,
                                      filters: Optional[Sequence[Union['GetSqlFirewallPolicyAnalyticsFilterArgs', 'GetSqlFirewallPolicyAnalyticsFilterArgsDict']]] = None,
                                      group_bies: Optional[Sequence[builtins.str]] = None,
                                      security_policy_id: Optional[builtins.str] = None,
                                      state: Optional[builtins.str] = None,
                                      time_ended: Optional[builtins.str] = None,
                                      time_started: Optional[builtins.str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSqlFirewallPolicyAnalyticsResult:
    """
    This data source provides the list of Sql Firewall Policy Analytics in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of aggregated SQL Firewall policy details.

    The parameter `accessLevel` specifies whether to return only those compartments for which the
    requestor has INSPECT permissions on at least one resource directly
    or indirectly (ACCESSIBLE) (the resource can be in a subcompartment) or to return Not Authorized if
    principal doesn't have access to even one of the child compartments. This is valid only when
    `compartmentIdInSubtree` is set to `true`.

    The parameter `compartmentIdInSubtree` applies when you perform SummarizedSqlFirewallPolicyInfo on the specified
    `compartmentId` and when it is set to true, the entire hierarchy of compartments can be returned.
    To get a full list of all compartments and subcompartments in the tenancy (root compartment),
    set the parameter `compartmentIdInSubtree` to true and `accessLevel` to ACCESSIBLE.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sql_firewall_policy_analytics = oci.DataSafe.get_sql_firewall_policy_analytics(compartment_id=compartment_id,
        access_level=sql_firewall_policy_analytic_access_level,
        compartment_id_in_subtree=sql_firewall_policy_analytic_compartment_id_in_subtree,
        group_bies=sql_firewall_policy_analytic_group_by,
        security_policy_id=test_security_policy["id"],
        state=sql_firewall_policy_analytic_state,
        time_ended=sql_firewall_policy_analytic_time_ended,
        time_started=sql_firewall_policy_analytic_time_started)
    ```


    :param builtins.str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param builtins.str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param Sequence[builtins.str] group_bies: The group by parameter to summarize SQL Firewall policy aggregation.
    :param builtins.str security_policy_id: An optional filter to return only resources that match the specified OCID of the security policy resource.
    :param builtins.str state: The current state of the SQL Firewall policy.
    :param builtins.str time_ended: An optional filter to return the summary of the SQL Firewall policies created before the date-time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
    :param builtins.str time_started: An optional filter to return the summary of the SQL Firewall policies created after the date-time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['groupBies'] = group_bies
    __args__['securityPolicyId'] = security_policy_id
    __args__['state'] = state
    __args__['timeEnded'] = time_ended
    __args__['timeStarted'] = time_started
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getSqlFirewallPolicyAnalytics:getSqlFirewallPolicyAnalytics', __args__, opts=opts, typ=GetSqlFirewallPolicyAnalyticsResult).value

    return AwaitableGetSqlFirewallPolicyAnalyticsResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__ret__, 'filters'),
        group_bies=pulumi.get(__ret__, 'group_bies'),
        id=pulumi.get(__ret__, 'id'),
        security_policy_id=pulumi.get(__ret__, 'security_policy_id'),
        sql_firewall_policy_analytics_collections=pulumi.get(__ret__, 'sql_firewall_policy_analytics_collections'),
        state=pulumi.get(__ret__, 'state'),
        time_ended=pulumi.get(__ret__, 'time_ended'),
        time_started=pulumi.get(__ret__, 'time_started'))
def get_sql_firewall_policy_analytics_output(access_level: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                             compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                             compartment_id_in_subtree: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSqlFirewallPolicyAnalyticsFilterArgs', 'GetSqlFirewallPolicyAnalyticsFilterArgsDict']]]]] = None,
                                             group_bies: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                             security_policy_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                             state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                             time_ended: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                             time_started: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSqlFirewallPolicyAnalyticsResult]:
    """
    This data source provides the list of Sql Firewall Policy Analytics in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of aggregated SQL Firewall policy details.

    The parameter `accessLevel` specifies whether to return only those compartments for which the
    requestor has INSPECT permissions on at least one resource directly
    or indirectly (ACCESSIBLE) (the resource can be in a subcompartment) or to return Not Authorized if
    principal doesn't have access to even one of the child compartments. This is valid only when
    `compartmentIdInSubtree` is set to `true`.

    The parameter `compartmentIdInSubtree` applies when you perform SummarizedSqlFirewallPolicyInfo on the specified
    `compartmentId` and when it is set to true, the entire hierarchy of compartments can be returned.
    To get a full list of all compartments and subcompartments in the tenancy (root compartment),
    set the parameter `compartmentIdInSubtree` to true and `accessLevel` to ACCESSIBLE.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sql_firewall_policy_analytics = oci.DataSafe.get_sql_firewall_policy_analytics(compartment_id=compartment_id,
        access_level=sql_firewall_policy_analytic_access_level,
        compartment_id_in_subtree=sql_firewall_policy_analytic_compartment_id_in_subtree,
        group_bies=sql_firewall_policy_analytic_group_by,
        security_policy_id=test_security_policy["id"],
        state=sql_firewall_policy_analytic_state,
        time_ended=sql_firewall_policy_analytic_time_ended,
        time_started=sql_firewall_policy_analytic_time_started)
    ```


    :param builtins.str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param builtins.str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param Sequence[builtins.str] group_bies: The group by parameter to summarize SQL Firewall policy aggregation.
    :param builtins.str security_policy_id: An optional filter to return only resources that match the specified OCID of the security policy resource.
    :param builtins.str state: The current state of the SQL Firewall policy.
    :param builtins.str time_ended: An optional filter to return the summary of the SQL Firewall policies created before the date-time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
    :param builtins.str time_started: An optional filter to return the summary of the SQL Firewall policies created after the date-time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['groupBies'] = group_bies
    __args__['securityPolicyId'] = security_policy_id
    __args__['state'] = state
    __args__['timeEnded'] = time_ended
    __args__['timeStarted'] = time_started
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getSqlFirewallPolicyAnalytics:getSqlFirewallPolicyAnalytics', __args__, opts=opts, typ=GetSqlFirewallPolicyAnalyticsResult)
    return __ret__.apply(lambda __response__: GetSqlFirewallPolicyAnalyticsResult(
        access_level=pulumi.get(__response__, 'access_level'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__response__, 'filters'),
        group_bies=pulumi.get(__response__, 'group_bies'),
        id=pulumi.get(__response__, 'id'),
        security_policy_id=pulumi.get(__response__, 'security_policy_id'),
        sql_firewall_policy_analytics_collections=pulumi.get(__response__, 'sql_firewall_policy_analytics_collections'),
        state=pulumi.get(__response__, 'state'),
        time_ended=pulumi.get(__response__, 'time_ended'),
        time_started=pulumi.get(__response__, 'time_started')))
