# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetServiceProviderResult',
    'AwaitableGetServiceProviderResult',
    'get_service_provider',
    'get_service_provider_output',
]

@pulumi.output_type
class GetServiceProviderResult:
    """
    A collection of values returned by getServiceProvider.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, description=None, freeform_tags=None, id=None, lifecycle_state_details=None, name=None, service_provider_id=None, service_provider_type=None, service_types=None, state=None, supported_resource_types=None, system_tags=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_state_details and not isinstance(lifecycle_state_details, str):
            raise TypeError("Expected argument 'lifecycle_state_details' to be a str")
        pulumi.set(__self__, "lifecycle_state_details", lifecycle_state_details)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if service_provider_id and not isinstance(service_provider_id, str):
            raise TypeError("Expected argument 'service_provider_id' to be a str")
        pulumi.set(__self__, "service_provider_id", service_provider_id)
        if service_provider_type and not isinstance(service_provider_type, str):
            raise TypeError("Expected argument 'service_provider_type' to be a str")
        pulumi.set(__self__, "service_provider_type", service_provider_type)
        if service_types and not isinstance(service_types, list):
            raise TypeError("Expected argument 'service_types' to be a list")
        pulumi.set(__self__, "service_types", service_types)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if supported_resource_types and not isinstance(supported_resource_types, list):
            raise TypeError("Expected argument 'supported_resource_types' to be a list")
        pulumi.set(__self__, "supported_resource_types", supported_resource_types)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment that contains the Delegation Control.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the Service Provider.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> builtins.str:
        """
        Description of the current lifecycle state in more detail.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Unique name of the Service Provider.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceProviderId")
    def service_provider_id(self) -> builtins.str:
        return pulumi.get(self, "service_provider_id")

    @property
    @pulumi.getter(name="serviceProviderType")
    def service_provider_type(self) -> builtins.str:
        """
        Service Provider type.
        """
        return pulumi.get(self, "service_provider_type")

    @property
    @pulumi.getter(name="serviceTypes")
    def service_types(self) -> Sequence[builtins.str]:
        """
        Types of services offered by this provider.
        """
        return pulumi.get(self, "service_types")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current lifecycle state of the Service Provider.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="supportedResourceTypes")
    def supported_resource_types(self) -> Sequence[builtins.str]:
        """
        Resource types for which this provider will provide service. Default to all if not specified.
        """
        return pulumi.get(self, "supported_resource_types")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        Time when the Service Provider was created expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        Time when the Service Provider was last modified expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetServiceProviderResult(GetServiceProviderResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceProviderResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_state_details=self.lifecycle_state_details,
            name=self.name,
            service_provider_id=self.service_provider_id,
            service_provider_type=self.service_provider_type,
            service_types=self.service_types,
            state=self.state,
            supported_resource_types=self.supported_resource_types,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_service_provider(service_provider_id: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceProviderResult:
    """
    This data source provides details about a specific Service Provider resource in Oracle Cloud Infrastructure Delegate Access Control service.

    Gets a ServiceProvider by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_service_provider = oci.DelegateAccessControl.get_service_provider(service_provider_id=test_service_provider_oci_delegate_access_control_service_provider["id"])
    ```


    :param builtins.str service_provider_id: unique Service Provider identifier
    """
    __args__ = dict()
    __args__['serviceProviderId'] = service_provider_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DelegateAccessControl/getServiceProvider:getServiceProvider', __args__, opts=opts, typ=GetServiceProviderResult).value

    return AwaitableGetServiceProviderResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_state_details=pulumi.get(__ret__, 'lifecycle_state_details'),
        name=pulumi.get(__ret__, 'name'),
        service_provider_id=pulumi.get(__ret__, 'service_provider_id'),
        service_provider_type=pulumi.get(__ret__, 'service_provider_type'),
        service_types=pulumi.get(__ret__, 'service_types'),
        state=pulumi.get(__ret__, 'state'),
        supported_resource_types=pulumi.get(__ret__, 'supported_resource_types'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_service_provider_output(service_provider_id: Optional[pulumi.Input[builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServiceProviderResult]:
    """
    This data source provides details about a specific Service Provider resource in Oracle Cloud Infrastructure Delegate Access Control service.

    Gets a ServiceProvider by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_service_provider = oci.DelegateAccessControl.get_service_provider(service_provider_id=test_service_provider_oci_delegate_access_control_service_provider["id"])
    ```


    :param builtins.str service_provider_id: unique Service Provider identifier
    """
    __args__ = dict()
    __args__['serviceProviderId'] = service_provider_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DelegateAccessControl/getServiceProvider:getServiceProvider', __args__, opts=opts, typ=GetServiceProviderResult)
    return __ret__.apply(lambda __response__: GetServiceProviderResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_state_details=pulumi.get(__response__, 'lifecycle_state_details'),
        name=pulumi.get(__response__, 'name'),
        service_provider_id=pulumi.get(__response__, 'service_provider_id'),
        service_provider_type=pulumi.get(__response__, 'service_provider_type'),
        service_types=pulumi.get(__response__, 'service_types'),
        state=pulumi.get(__response__, 'state'),
        supported_resource_types=pulumi.get(__response__, 'supported_resource_types'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
