# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetServiceProviderActionResult',
    'AwaitableGetServiceProviderActionResult',
    'get_service_provider_action',
    'get_service_provider_action_output',
]

@pulumi.output_type
class GetServiceProviderActionResult:
    """
    A collection of values returned by getServiceProviderAction.
    """
    def __init__(__self__, component=None, customer_display_name=None, description=None, id=None, name=None, properties=None, resource_type=None, service_provider_action_id=None, service_provider_service_types=None, state=None):
        if component and not isinstance(component, str):
            raise TypeError("Expected argument 'component' to be a str")
        pulumi.set(__self__, "component", component)
        if customer_display_name and not isinstance(customer_display_name, str):
            raise TypeError("Expected argument 'customer_display_name' to be a str")
        pulumi.set(__self__, "customer_display_name", customer_display_name)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if properties and not isinstance(properties, list):
            raise TypeError("Expected argument 'properties' to be a list")
        pulumi.set(__self__, "properties", properties)
        if resource_type and not isinstance(resource_type, str):
            raise TypeError("Expected argument 'resource_type' to be a str")
        pulumi.set(__self__, "resource_type", resource_type)
        if service_provider_action_id and not isinstance(service_provider_action_id, str):
            raise TypeError("Expected argument 'service_provider_action_id' to be a str")
        pulumi.set(__self__, "service_provider_action_id", service_provider_action_id)
        if service_provider_service_types and not isinstance(service_provider_service_types, list):
            raise TypeError("Expected argument 'service_provider_service_types' to be a list")
        pulumi.set(__self__, "service_provider_service_types", service_provider_service_types)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def component(self) -> builtins.str:
        """
        Name of the infrastructure layer associated with the Service Provider Action.
        """
        return pulumi.get(self, "component")

    @property
    @pulumi.getter(name="customerDisplayName")
    def customer_display_name(self) -> builtins.str:
        """
        Display Name of the Service Provider Action.
        """
        return pulumi.get(self, "customer_display_name")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the Service Provider Action in terms of associated risk profile, and characteristics of the operating system commands made available to the support operator under this Service Provider Action.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the property
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> Sequence['outputs.GetServiceProviderActionPropertyResult']:
        """
        Fine grained properties associated with the Delegation Control.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> builtins.str:
        """
        resourceType for which the ServiceProviderAction is applicable
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="serviceProviderActionId")
    def service_provider_action_id(self) -> builtins.str:
        return pulumi.get(self, "service_provider_action_id")

    @property
    @pulumi.getter(name="serviceProviderServiceTypes")
    def service_provider_service_types(self) -> Sequence[builtins.str]:
        """
        List of Service Provider Service Types that this Service Provider Action is applicable to.
        """
        return pulumi.get(self, "service_provider_service_types")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current lifecycle state of the Service Provider Action.
        """
        return pulumi.get(self, "state")


class AwaitableGetServiceProviderActionResult(GetServiceProviderActionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceProviderActionResult(
            component=self.component,
            customer_display_name=self.customer_display_name,
            description=self.description,
            id=self.id,
            name=self.name,
            properties=self.properties,
            resource_type=self.resource_type,
            service_provider_action_id=self.service_provider_action_id,
            service_provider_service_types=self.service_provider_service_types,
            state=self.state)


def get_service_provider_action(service_provider_action_id: Optional[builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceProviderActionResult:
    """
    This data source provides details about a specific Service Provider Action resource in Oracle Cloud Infrastructure Delegate Access Control service.

    Gets the Service Provider Action associated with the specified Service Provider Action ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_service_provider_action = oci.DelegateAccessControl.get_service_provider_action(service_provider_action_id=test_service_provider_action_oci_delegate_access_control_service_provider_action["id"])
    ```


    :param builtins.str service_provider_action_id: Unique Oracle supplied identifier associated with the Service Provider Action.
    """
    __args__ = dict()
    __args__['serviceProviderActionId'] = service_provider_action_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DelegateAccessControl/getServiceProviderAction:getServiceProviderAction', __args__, opts=opts, typ=GetServiceProviderActionResult).value

    return AwaitableGetServiceProviderActionResult(
        component=pulumi.get(__ret__, 'component'),
        customer_display_name=pulumi.get(__ret__, 'customer_display_name'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        properties=pulumi.get(__ret__, 'properties'),
        resource_type=pulumi.get(__ret__, 'resource_type'),
        service_provider_action_id=pulumi.get(__ret__, 'service_provider_action_id'),
        service_provider_service_types=pulumi.get(__ret__, 'service_provider_service_types'),
        state=pulumi.get(__ret__, 'state'))
def get_service_provider_action_output(service_provider_action_id: Optional[pulumi.Input[builtins.str]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServiceProviderActionResult]:
    """
    This data source provides details about a specific Service Provider Action resource in Oracle Cloud Infrastructure Delegate Access Control service.

    Gets the Service Provider Action associated with the specified Service Provider Action ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_service_provider_action = oci.DelegateAccessControl.get_service_provider_action(service_provider_action_id=test_service_provider_action_oci_delegate_access_control_service_provider_action["id"])
    ```


    :param builtins.str service_provider_action_id: Unique Oracle supplied identifier associated with the Service Provider Action.
    """
    __args__ = dict()
    __args__['serviceProviderActionId'] = service_provider_action_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DelegateAccessControl/getServiceProviderAction:getServiceProviderAction', __args__, opts=opts, typ=GetServiceProviderActionResult)
    return __ret__.apply(lambda __response__: GetServiceProviderActionResult(
        component=pulumi.get(__response__, 'component'),
        customer_display_name=pulumi.get(__response__, 'customer_display_name'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        properties=pulumi.get(__response__, 'properties'),
        resource_type=pulumi.get(__response__, 'resource_type'),
        service_provider_action_id=pulumi.get(__response__, 'service_provider_action_id'),
        service_provider_service_types=pulumi.get(__response__, 'service_provider_service_types'),
        state=pulumi.get(__response__, 'state')))
