# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetProjectRepositorySettingResult',
    'AwaitableGetProjectRepositorySettingResult',
    'get_project_repository_setting',
    'get_project_repository_setting_output',
]

@pulumi.output_type
class GetProjectRepositorySettingResult:
    """
    A collection of values returned by getProjectRepositorySetting.
    """
    def __init__(__self__, approval_rules=None, id=None, merge_settings=None, project_id=None):
        if approval_rules and not isinstance(approval_rules, list):
            raise TypeError("Expected argument 'approval_rules' to be a list")
        pulumi.set(__self__, "approval_rules", approval_rules)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if merge_settings and not isinstance(merge_settings, list):
            raise TypeError("Expected argument 'merge_settings' to be a list")
        pulumi.set(__self__, "merge_settings", merge_settings)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="approvalRules")
    def approval_rules(self) -> Sequence['outputs.GetProjectRepositorySettingApprovalRuleResult']:
        """
        List of approval rules which must be statisfied before pull requests which match the rules can be merged
        """
        return pulumi.get(self, "approval_rules")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="mergeSettings")
    def merge_settings(self) -> Sequence['outputs.GetProjectRepositorySettingMergeSettingResult']:
        """
        Enabled and disabled merge strategies for a project or repository, also contains a default strategy.
        """
        return pulumi.get(self, "merge_settings")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        return pulumi.get(self, "project_id")


class AwaitableGetProjectRepositorySettingResult(GetProjectRepositorySettingResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectRepositorySettingResult(
            approval_rules=self.approval_rules,
            id=self.id,
            merge_settings=self.merge_settings,
            project_id=self.project_id)


def get_project_repository_setting(project_id: Optional[builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectRepositorySettingResult:
    """
    This data source provides details about a specific Project Repository Setting resource in Oracle Cloud Infrastructure Devops service.

    Retrieves a project's repository settings details.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_project_repository_setting = oci.DevOps.get_project_repository_setting(project_id=test_project["id"])
    ```


    :param builtins.str project_id: Unique project identifier.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DevOps/getProjectRepositorySetting:getProjectRepositorySetting', __args__, opts=opts, typ=GetProjectRepositorySettingResult).value

    return AwaitableGetProjectRepositorySettingResult(
        approval_rules=pulumi.get(__ret__, 'approval_rules'),
        id=pulumi.get(__ret__, 'id'),
        merge_settings=pulumi.get(__ret__, 'merge_settings'),
        project_id=pulumi.get(__ret__, 'project_id'))
def get_project_repository_setting_output(project_id: Optional[pulumi.Input[builtins.str]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProjectRepositorySettingResult]:
    """
    This data source provides details about a specific Project Repository Setting resource in Oracle Cloud Infrastructure Devops service.

    Retrieves a project's repository settings details.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_project_repository_setting = oci.DevOps.get_project_repository_setting(project_id=test_project["id"])
    ```


    :param builtins.str project_id: Unique project identifier.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DevOps/getProjectRepositorySetting:getProjectRepositorySetting', __args__, opts=opts, typ=GetProjectRepositorySettingResult)
    return __ret__.apply(lambda __response__: GetProjectRepositorySettingResult(
        approval_rules=pulumi.get(__response__, 'approval_rules'),
        id=pulumi.get(__response__, 'id'),
        merge_settings=pulumi.get(__response__, 'merge_settings'),
        project_id=pulumi.get(__response__, 'project_id')))
