# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RepositorySettingArgs', 'RepositorySetting']

@pulumi.input_type
class RepositorySettingArgs:
    def __init__(__self__, *,
                 repository_id: pulumi.Input[builtins.str],
                 approval_rules: Optional[pulumi.Input['RepositorySettingApprovalRulesArgs']] = None,
                 merge_checks: Optional[pulumi.Input['RepositorySettingMergeChecksArgs']] = None,
                 merge_settings: Optional[pulumi.Input['RepositorySettingMergeSettingsArgs']] = None):
        """
        The set of arguments for constructing a RepositorySetting resource.
        :param pulumi.Input[builtins.str] repository_id: Unique repository identifier.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input['RepositorySettingApprovalRulesArgs'] approval_rules: (Updatable) List of approval rules which must be statisfied before pull requests which match the rules can be merged
        :param pulumi.Input['RepositorySettingMergeChecksArgs'] merge_checks: (Updatable) Criteria which must be satisfied to merge a pull request.
        :param pulumi.Input['RepositorySettingMergeSettingsArgs'] merge_settings: (Updatable) Enabled and disabled merge strategies for a project or repository, also contains a default strategy.
        """
        pulumi.set(__self__, "repository_id", repository_id)
        if approval_rules is not None:
            pulumi.set(__self__, "approval_rules", approval_rules)
        if merge_checks is not None:
            pulumi.set(__self__, "merge_checks", merge_checks)
        if merge_settings is not None:
            pulumi.set(__self__, "merge_settings", merge_settings)

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Input[builtins.str]:
        """
        Unique repository identifier.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "repository_id")

    @repository_id.setter
    def repository_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "repository_id", value)

    @property
    @pulumi.getter(name="approvalRules")
    def approval_rules(self) -> Optional[pulumi.Input['RepositorySettingApprovalRulesArgs']]:
        """
        (Updatable) List of approval rules which must be statisfied before pull requests which match the rules can be merged
        """
        return pulumi.get(self, "approval_rules")

    @approval_rules.setter
    def approval_rules(self, value: Optional[pulumi.Input['RepositorySettingApprovalRulesArgs']]):
        pulumi.set(self, "approval_rules", value)

    @property
    @pulumi.getter(name="mergeChecks")
    def merge_checks(self) -> Optional[pulumi.Input['RepositorySettingMergeChecksArgs']]:
        """
        (Updatable) Criteria which must be satisfied to merge a pull request.
        """
        return pulumi.get(self, "merge_checks")

    @merge_checks.setter
    def merge_checks(self, value: Optional[pulumi.Input['RepositorySettingMergeChecksArgs']]):
        pulumi.set(self, "merge_checks", value)

    @property
    @pulumi.getter(name="mergeSettings")
    def merge_settings(self) -> Optional[pulumi.Input['RepositorySettingMergeSettingsArgs']]:
        """
        (Updatable) Enabled and disabled merge strategies for a project or repository, also contains a default strategy.
        """
        return pulumi.get(self, "merge_settings")

    @merge_settings.setter
    def merge_settings(self, value: Optional[pulumi.Input['RepositorySettingMergeSettingsArgs']]):
        pulumi.set(self, "merge_settings", value)


@pulumi.input_type
class _RepositorySettingState:
    def __init__(__self__, *,
                 approval_rules: Optional[pulumi.Input['RepositorySettingApprovalRulesArgs']] = None,
                 merge_checks: Optional[pulumi.Input['RepositorySettingMergeChecksArgs']] = None,
                 merge_settings: Optional[pulumi.Input['RepositorySettingMergeSettingsArgs']] = None,
                 repository_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering RepositorySetting resources.
        :param pulumi.Input['RepositorySettingApprovalRulesArgs'] approval_rules: (Updatable) List of approval rules which must be statisfied before pull requests which match the rules can be merged
        :param pulumi.Input['RepositorySettingMergeChecksArgs'] merge_checks: (Updatable) Criteria which must be satisfied to merge a pull request.
        :param pulumi.Input['RepositorySettingMergeSettingsArgs'] merge_settings: (Updatable) Enabled and disabled merge strategies for a project or repository, also contains a default strategy.
        :param pulumi.Input[builtins.str] repository_id: Unique repository identifier.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if approval_rules is not None:
            pulumi.set(__self__, "approval_rules", approval_rules)
        if merge_checks is not None:
            pulumi.set(__self__, "merge_checks", merge_checks)
        if merge_settings is not None:
            pulumi.set(__self__, "merge_settings", merge_settings)
        if repository_id is not None:
            pulumi.set(__self__, "repository_id", repository_id)

    @property
    @pulumi.getter(name="approvalRules")
    def approval_rules(self) -> Optional[pulumi.Input['RepositorySettingApprovalRulesArgs']]:
        """
        (Updatable) List of approval rules which must be statisfied before pull requests which match the rules can be merged
        """
        return pulumi.get(self, "approval_rules")

    @approval_rules.setter
    def approval_rules(self, value: Optional[pulumi.Input['RepositorySettingApprovalRulesArgs']]):
        pulumi.set(self, "approval_rules", value)

    @property
    @pulumi.getter(name="mergeChecks")
    def merge_checks(self) -> Optional[pulumi.Input['RepositorySettingMergeChecksArgs']]:
        """
        (Updatable) Criteria which must be satisfied to merge a pull request.
        """
        return pulumi.get(self, "merge_checks")

    @merge_checks.setter
    def merge_checks(self, value: Optional[pulumi.Input['RepositorySettingMergeChecksArgs']]):
        pulumi.set(self, "merge_checks", value)

    @property
    @pulumi.getter(name="mergeSettings")
    def merge_settings(self) -> Optional[pulumi.Input['RepositorySettingMergeSettingsArgs']]:
        """
        (Updatable) Enabled and disabled merge strategies for a project or repository, also contains a default strategy.
        """
        return pulumi.get(self, "merge_settings")

    @merge_settings.setter
    def merge_settings(self, value: Optional[pulumi.Input['RepositorySettingMergeSettingsArgs']]):
        pulumi.set(self, "merge_settings", value)

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique repository identifier.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "repository_id")

    @repository_id.setter
    def repository_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "repository_id", value)


@pulumi.type_token("oci:DevOps/repositorySetting:RepositorySetting")
class RepositorySetting(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 approval_rules: Optional[pulumi.Input[Union['RepositorySettingApprovalRulesArgs', 'RepositorySettingApprovalRulesArgsDict']]] = None,
                 merge_checks: Optional[pulumi.Input[Union['RepositorySettingMergeChecksArgs', 'RepositorySettingMergeChecksArgsDict']]] = None,
                 merge_settings: Optional[pulumi.Input[Union['RepositorySettingMergeSettingsArgs', 'RepositorySettingMergeSettingsArgsDict']]] = None,
                 repository_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Repository Setting resource in Oracle Cloud Infrastructure Devops service.

        Updates the settings for a repository.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_repository_setting = oci.dev_ops.RepositorySetting("test_repository_setting",
            repository_id=test_repository["id"],
            approval_rules={
                "items": [{
                    "min_approvals_count": repository_setting_approval_rules_items_min_approvals_count,
                    "name": repository_setting_approval_rules_items_name,
                    "destination_branch": repository_setting_approval_rules_items_destination_branch,
                    "reviewers": [{
                        "principal_id": test_principal["id"],
                    }],
                }],
            },
            merge_checks={
                "last_build_succeeded": repository_setting_merge_checks_last_build_succeeded,
            },
            merge_settings={
                "allowed_merge_strategies": repository_setting_merge_settings_allowed_merge_strategies,
                "default_merge_strategy": repository_setting_merge_settings_default_merge_strategy,
            })
        ```

        ## Import

        RepositorySettings can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DevOps/repositorySetting:RepositorySetting test_repository_setting "repositories/{repositoryId}/repositorySettings"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RepositorySettingApprovalRulesArgs', 'RepositorySettingApprovalRulesArgsDict']] approval_rules: (Updatable) List of approval rules which must be statisfied before pull requests which match the rules can be merged
        :param pulumi.Input[Union['RepositorySettingMergeChecksArgs', 'RepositorySettingMergeChecksArgsDict']] merge_checks: (Updatable) Criteria which must be satisfied to merge a pull request.
        :param pulumi.Input[Union['RepositorySettingMergeSettingsArgs', 'RepositorySettingMergeSettingsArgsDict']] merge_settings: (Updatable) Enabled and disabled merge strategies for a project or repository, also contains a default strategy.
        :param pulumi.Input[builtins.str] repository_id: Unique repository identifier.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RepositorySettingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Repository Setting resource in Oracle Cloud Infrastructure Devops service.

        Updates the settings for a repository.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_repository_setting = oci.dev_ops.RepositorySetting("test_repository_setting",
            repository_id=test_repository["id"],
            approval_rules={
                "items": [{
                    "min_approvals_count": repository_setting_approval_rules_items_min_approvals_count,
                    "name": repository_setting_approval_rules_items_name,
                    "destination_branch": repository_setting_approval_rules_items_destination_branch,
                    "reviewers": [{
                        "principal_id": test_principal["id"],
                    }],
                }],
            },
            merge_checks={
                "last_build_succeeded": repository_setting_merge_checks_last_build_succeeded,
            },
            merge_settings={
                "allowed_merge_strategies": repository_setting_merge_settings_allowed_merge_strategies,
                "default_merge_strategy": repository_setting_merge_settings_default_merge_strategy,
            })
        ```

        ## Import

        RepositorySettings can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DevOps/repositorySetting:RepositorySetting test_repository_setting "repositories/{repositoryId}/repositorySettings"
        ```

        :param str resource_name: The name of the resource.
        :param RepositorySettingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RepositorySettingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 approval_rules: Optional[pulumi.Input[Union['RepositorySettingApprovalRulesArgs', 'RepositorySettingApprovalRulesArgsDict']]] = None,
                 merge_checks: Optional[pulumi.Input[Union['RepositorySettingMergeChecksArgs', 'RepositorySettingMergeChecksArgsDict']]] = None,
                 merge_settings: Optional[pulumi.Input[Union['RepositorySettingMergeSettingsArgs', 'RepositorySettingMergeSettingsArgsDict']]] = None,
                 repository_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RepositorySettingArgs.__new__(RepositorySettingArgs)

            __props__.__dict__["approval_rules"] = approval_rules
            __props__.__dict__["merge_checks"] = merge_checks
            __props__.__dict__["merge_settings"] = merge_settings
            if repository_id is None and not opts.urn:
                raise TypeError("Missing required property 'repository_id'")
            __props__.__dict__["repository_id"] = repository_id
        super(RepositorySetting, __self__).__init__(
            'oci:DevOps/repositorySetting:RepositorySetting',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            approval_rules: Optional[pulumi.Input[Union['RepositorySettingApprovalRulesArgs', 'RepositorySettingApprovalRulesArgsDict']]] = None,
            merge_checks: Optional[pulumi.Input[Union['RepositorySettingMergeChecksArgs', 'RepositorySettingMergeChecksArgsDict']]] = None,
            merge_settings: Optional[pulumi.Input[Union['RepositorySettingMergeSettingsArgs', 'RepositorySettingMergeSettingsArgsDict']]] = None,
            repository_id: Optional[pulumi.Input[builtins.str]] = None) -> 'RepositorySetting':
        """
        Get an existing RepositorySetting resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RepositorySettingApprovalRulesArgs', 'RepositorySettingApprovalRulesArgsDict']] approval_rules: (Updatable) List of approval rules which must be statisfied before pull requests which match the rules can be merged
        :param pulumi.Input[Union['RepositorySettingMergeChecksArgs', 'RepositorySettingMergeChecksArgsDict']] merge_checks: (Updatable) Criteria which must be satisfied to merge a pull request.
        :param pulumi.Input[Union['RepositorySettingMergeSettingsArgs', 'RepositorySettingMergeSettingsArgsDict']] merge_settings: (Updatable) Enabled and disabled merge strategies for a project or repository, also contains a default strategy.
        :param pulumi.Input[builtins.str] repository_id: Unique repository identifier.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RepositorySettingState.__new__(_RepositorySettingState)

        __props__.__dict__["approval_rules"] = approval_rules
        __props__.__dict__["merge_checks"] = merge_checks
        __props__.__dict__["merge_settings"] = merge_settings
        __props__.__dict__["repository_id"] = repository_id
        return RepositorySetting(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="approvalRules")
    def approval_rules(self) -> pulumi.Output['outputs.RepositorySettingApprovalRules']:
        """
        (Updatable) List of approval rules which must be statisfied before pull requests which match the rules can be merged
        """
        return pulumi.get(self, "approval_rules")

    @property
    @pulumi.getter(name="mergeChecks")
    def merge_checks(self) -> pulumi.Output['outputs.RepositorySettingMergeChecks']:
        """
        (Updatable) Criteria which must be satisfied to merge a pull request.
        """
        return pulumi.get(self, "merge_checks")

    @property
    @pulumi.getter(name="mergeSettings")
    def merge_settings(self) -> pulumi.Output['outputs.RepositorySettingMergeSettings']:
        """
        (Updatable) Enabled and disabled merge strategies for a project or repository, also contains a default strategy.
        """
        return pulumi.get(self, "merge_settings")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Output[builtins.str]:
        """
        Unique repository identifier.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "repository_id")

