# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDeploymentEnvironmentsResult',
    'AwaitableGetDeploymentEnvironmentsResult',
    'get_deployment_environments',
    'get_deployment_environments_output',
]

@pulumi.output_type
class GetDeploymentEnvironmentsResult:
    """
    A collection of values returned by getDeploymentEnvironments.
    """
    def __init__(__self__, compartment_id=None, deployment_environment_collections=None, filters=None, id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if deployment_environment_collections and not isinstance(deployment_environment_collections, list):
            raise TypeError("Expected argument 'deployment_environment_collections' to be a list")
        pulumi.set(__self__, "deployment_environment_collections", deployment_environment_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="deploymentEnvironmentCollections")
    def deployment_environment_collections(self) -> Sequence['outputs.GetDeploymentEnvironmentsDeploymentEnvironmentCollectionResult']:
        """
        The list of deployment_environment_collection.
        """
        return pulumi.get(self, "deployment_environment_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDeploymentEnvironmentsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetDeploymentEnvironmentsResult(GetDeploymentEnvironmentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDeploymentEnvironmentsResult(
            compartment_id=self.compartment_id,
            deployment_environment_collections=self.deployment_environment_collections,
            filters=self.filters,
            id=self.id)


def get_deployment_environments(compartment_id: Optional[builtins.str] = None,
                                filters: Optional[Sequence[Union['GetDeploymentEnvironmentsFilterArgs', 'GetDeploymentEnvironmentsFilterArgsDict']]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDeploymentEnvironmentsResult:
    """
    This data source provides the list of Deployment Environments in Oracle Cloud Infrastructure Golden Gate service.

    Returns an array of DeploymentEnvironmentDescriptor

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_deployment_environments = oci.GoldenGate.get_deployment_environments(compartment_id=compartment_id)
    ```


    :param builtins.str compartment_id: The OCID of the compartment that contains the work request. Work requests should be scoped  to the same compartment as the resource the work request affects. If the work request concerns  multiple resources, and those resources are not in the same compartment, it is up to the service team  to pick the primary resource whose compartment should be used.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:GoldenGate/getDeploymentEnvironments:getDeploymentEnvironments', __args__, opts=opts, typ=GetDeploymentEnvironmentsResult).value

    return AwaitableGetDeploymentEnvironmentsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        deployment_environment_collections=pulumi.get(__ret__, 'deployment_environment_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))
def get_deployment_environments_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                       filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDeploymentEnvironmentsFilterArgs', 'GetDeploymentEnvironmentsFilterArgsDict']]]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDeploymentEnvironmentsResult]:
    """
    This data source provides the list of Deployment Environments in Oracle Cloud Infrastructure Golden Gate service.

    Returns an array of DeploymentEnvironmentDescriptor

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_deployment_environments = oci.GoldenGate.get_deployment_environments(compartment_id=compartment_id)
    ```


    :param builtins.str compartment_id: The OCID of the compartment that contains the work request. Work requests should be scoped  to the same compartment as the resource the work request affects. If the work request concerns  multiple resources, and those resources are not in the same compartment, it is up to the service team  to pick the primary resource whose compartment should be used.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:GoldenGate/getDeploymentEnvironments:getDeploymentEnvironments', __args__, opts=opts, typ=GetDeploymentEnvironmentsResult)
    return __ret__.apply(lambda __response__: GetDeploymentEnvironmentsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        deployment_environment_collections=pulumi.get(__response__, 'deployment_environment_collections'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id')))
