# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetPipelineResult',
    'AwaitableGetPipelineResult',
    'get_pipeline',
    'get_pipeline_output',
]

@pulumi.output_type
class GetPipelineResult:
    """
    A collection of values returned by getPipeline.
    """
    def __init__(__self__, compartment_id=None, cpu_core_count=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, is_auto_scaling_enabled=None, license_model=None, lifecycle_details=None, lifecycle_sub_state=None, locks=None, mapping_rules=None, pipeline_diagnostic_datas=None, pipeline_id=None, process_options=None, recipe_type=None, source_connection_details=None, state=None, system_tags=None, target_connection_details=None, time_created=None, time_last_recorded=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if cpu_core_count and not isinstance(cpu_core_count, int):
            raise TypeError("Expected argument 'cpu_core_count' to be a int")
        pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_auto_scaling_enabled and not isinstance(is_auto_scaling_enabled, bool):
            raise TypeError("Expected argument 'is_auto_scaling_enabled' to be a bool")
        pulumi.set(__self__, "is_auto_scaling_enabled", is_auto_scaling_enabled)
        if license_model and not isinstance(license_model, str):
            raise TypeError("Expected argument 'license_model' to be a str")
        pulumi.set(__self__, "license_model", license_model)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if lifecycle_sub_state and not isinstance(lifecycle_sub_state, str):
            raise TypeError("Expected argument 'lifecycle_sub_state' to be a str")
        pulumi.set(__self__, "lifecycle_sub_state", lifecycle_sub_state)
        if locks and not isinstance(locks, list):
            raise TypeError("Expected argument 'locks' to be a list")
        pulumi.set(__self__, "locks", locks)
        if mapping_rules and not isinstance(mapping_rules, list):
            raise TypeError("Expected argument 'mapping_rules' to be a list")
        pulumi.set(__self__, "mapping_rules", mapping_rules)
        if pipeline_diagnostic_datas and not isinstance(pipeline_diagnostic_datas, list):
            raise TypeError("Expected argument 'pipeline_diagnostic_datas' to be a list")
        pulumi.set(__self__, "pipeline_diagnostic_datas", pipeline_diagnostic_datas)
        if pipeline_id and not isinstance(pipeline_id, str):
            raise TypeError("Expected argument 'pipeline_id' to be a str")
        pulumi.set(__self__, "pipeline_id", pipeline_id)
        if process_options and not isinstance(process_options, list):
            raise TypeError("Expected argument 'process_options' to be a list")
        pulumi.set(__self__, "process_options", process_options)
        if recipe_type and not isinstance(recipe_type, str):
            raise TypeError("Expected argument 'recipe_type' to be a str")
        pulumi.set(__self__, "recipe_type", recipe_type)
        if source_connection_details and not isinstance(source_connection_details, list):
            raise TypeError("Expected argument 'source_connection_details' to be a list")
        pulumi.set(__self__, "source_connection_details", source_connection_details)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if target_connection_details and not isinstance(target_connection_details, list):
            raise TypeError("Expected argument 'target_connection_details' to be a list")
        pulumi.set(__self__, "target_connection_details", target_connection_details)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_last_recorded and not isinstance(time_last_recorded, str):
            raise TypeError("Expected argument 'time_last_recorded' to be a str")
        pulumi.set(__self__, "time_last_recorded", time_last_recorded)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment being referenced.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> builtins.int:
        """
        The Minimum number of OCPUs to be made available for this Deployment.
        """
        return pulumi.get(self, "cpu_core_count")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Tags defined for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Metadata about this specific object.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        An object's Display Name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        A simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the pipeline. This option applies when retrieving a pipeline.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAutoScalingEnabled")
    def is_auto_scaling_enabled(self) -> builtins.bool:
        """
        Indicates if auto scaling is enabled for the Deployment's CPU core count.
        """
        return pulumi.get(self, "is_auto_scaling_enabled")

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> builtins.str:
        """
        The Oracle license model that applies to a Deployment.
        """
        return pulumi.get(self, "license_model")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        Describes the object's current state in detail. For example, it can be used to provide actionable information for a resource in a Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="lifecycleSubState")
    def lifecycle_sub_state(self) -> builtins.str:
        """
        Possible lifecycle substates when retrieving a pipeline.
        """
        return pulumi.get(self, "lifecycle_sub_state")

    @property
    @pulumi.getter
    def locks(self) -> Sequence['outputs.GetPipelineLockResult']:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @property
    @pulumi.getter(name="mappingRules")
    def mapping_rules(self) -> Sequence['outputs.GetPipelineMappingRuleResult']:
        """
        Mapping for source/target schema/tables for the pipeline data replication.
        """
        return pulumi.get(self, "mapping_rules")

    @property
    @pulumi.getter(name="pipelineDiagnosticDatas")
    def pipeline_diagnostic_datas(self) -> Sequence['outputs.GetPipelinePipelineDiagnosticDataResult']:
        """
        Information regarding the pipeline diagnostic collection
        """
        return pulumi.get(self, "pipeline_diagnostic_datas")

    @property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> builtins.str:
        return pulumi.get(self, "pipeline_id")

    @property
    @pulumi.getter(name="processOptions")
    def process_options(self) -> Sequence['outputs.GetPipelineProcessOptionResult']:
        """
        Required pipeline options to configure the replication process (Extract or Replicat).
        """
        return pulumi.get(self, "process_options")

    @property
    @pulumi.getter(name="recipeType")
    def recipe_type(self) -> builtins.str:
        """
        The type of the recipe
        """
        return pulumi.get(self, "recipe_type")

    @property
    @pulumi.getter(name="sourceConnectionDetails")
    def source_connection_details(self) -> Sequence['outputs.GetPipelineSourceConnectionDetailResult']:
        """
        The source connection details for creating a pipeline.
        """
        return pulumi.get(self, "source_connection_details")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        Lifecycle state of the pipeline.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle Cloud Infrastructure services. Each key is predefined and scoped to namespaces.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetConnectionDetails")
    def target_connection_details(self) -> Sequence['outputs.GetPipelineTargetConnectionDetailResult']:
        """
        The target connection details for creating a pipeline.
        """
        return pulumi.get(self, "target_connection_details")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the resource was created. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastRecorded")
    def time_last_recorded(self) -> builtins.str:
        """
        When the resource was last updated. This option applies when retrieving a pipeline. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2024-07-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_last_recorded")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time the resource was last updated. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetPipelineResult(GetPipelineResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPipelineResult(
            compartment_id=self.compartment_id,
            cpu_core_count=self.cpu_core_count,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_auto_scaling_enabled=self.is_auto_scaling_enabled,
            license_model=self.license_model,
            lifecycle_details=self.lifecycle_details,
            lifecycle_sub_state=self.lifecycle_sub_state,
            locks=self.locks,
            mapping_rules=self.mapping_rules,
            pipeline_diagnostic_datas=self.pipeline_diagnostic_datas,
            pipeline_id=self.pipeline_id,
            process_options=self.process_options,
            recipe_type=self.recipe_type,
            source_connection_details=self.source_connection_details,
            state=self.state,
            system_tags=self.system_tags,
            target_connection_details=self.target_connection_details,
            time_created=self.time_created,
            time_last_recorded=self.time_last_recorded,
            time_updated=self.time_updated)


def get_pipeline(pipeline_id: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPipelineResult:
    """
    This data source provides details about a specific Pipeline resource in Oracle Cloud Infrastructure Golden Gate service.

    Retrieves a Pipeline details.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_pipeline = oci.GoldenGate.get_pipeline(pipeline_id=test_pipeline_oci_golden_gate_pipeline["id"])
    ```


    :param builtins.str pipeline_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the pipeline created.
    """
    __args__ = dict()
    __args__['pipelineId'] = pipeline_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:GoldenGate/getPipeline:getPipeline', __args__, opts=opts, typ=GetPipelineResult).value

    return AwaitableGetPipelineResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        cpu_core_count=pulumi.get(__ret__, 'cpu_core_count'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_auto_scaling_enabled=pulumi.get(__ret__, 'is_auto_scaling_enabled'),
        license_model=pulumi.get(__ret__, 'license_model'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        lifecycle_sub_state=pulumi.get(__ret__, 'lifecycle_sub_state'),
        locks=pulumi.get(__ret__, 'locks'),
        mapping_rules=pulumi.get(__ret__, 'mapping_rules'),
        pipeline_diagnostic_datas=pulumi.get(__ret__, 'pipeline_diagnostic_datas'),
        pipeline_id=pulumi.get(__ret__, 'pipeline_id'),
        process_options=pulumi.get(__ret__, 'process_options'),
        recipe_type=pulumi.get(__ret__, 'recipe_type'),
        source_connection_details=pulumi.get(__ret__, 'source_connection_details'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        target_connection_details=pulumi.get(__ret__, 'target_connection_details'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_last_recorded=pulumi.get(__ret__, 'time_last_recorded'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_pipeline_output(pipeline_id: Optional[pulumi.Input[builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPipelineResult]:
    """
    This data source provides details about a specific Pipeline resource in Oracle Cloud Infrastructure Golden Gate service.

    Retrieves a Pipeline details.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_pipeline = oci.GoldenGate.get_pipeline(pipeline_id=test_pipeline_oci_golden_gate_pipeline["id"])
    ```


    :param builtins.str pipeline_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the pipeline created.
    """
    __args__ = dict()
    __args__['pipelineId'] = pipeline_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:GoldenGate/getPipeline:getPipeline', __args__, opts=opts, typ=GetPipelineResult)
    return __ret__.apply(lambda __response__: GetPipelineResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        cpu_core_count=pulumi.get(__response__, 'cpu_core_count'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_auto_scaling_enabled=pulumi.get(__response__, 'is_auto_scaling_enabled'),
        license_model=pulumi.get(__response__, 'license_model'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        lifecycle_sub_state=pulumi.get(__response__, 'lifecycle_sub_state'),
        locks=pulumi.get(__response__, 'locks'),
        mapping_rules=pulumi.get(__response__, 'mapping_rules'),
        pipeline_diagnostic_datas=pulumi.get(__response__, 'pipeline_diagnostic_datas'),
        pipeline_id=pulumi.get(__response__, 'pipeline_id'),
        process_options=pulumi.get(__response__, 'process_options'),
        recipe_type=pulumi.get(__response__, 'recipe_type'),
        source_connection_details=pulumi.get(__response__, 'source_connection_details'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        target_connection_details=pulumi.get(__response__, 'target_connection_details'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_last_recorded=pulumi.get(__response__, 'time_last_recorded'),
        time_updated=pulumi.get(__response__, 'time_updated')))
