# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainsNetworkPerimeterArgs', 'DomainsNetworkPerimeter']

@pulumi.input_type
class DomainsNetworkPerimeterArgs:
    def __init__(__self__, *,
                 idcs_endpoint: pulumi.Input[builtins.str],
                 ip_addresses: pulumi.Input[Sequence[pulumi.Input['DomainsNetworkPerimeterIpAddressArgs']]],
                 schemas: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 attributes: Optional[pulumi.Input[builtins.str]] = None,
                 authorization: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 external_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 ocid: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsNetworkPerimeterTagArgs']]]] = None):
        """
        The set of arguments for constructing a DomainsNetworkPerimeter resource.
        :param pulumi.Input[builtins.str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input['DomainsNetworkPerimeterIpAddressArgs']]] ip_addresses: (Updatable) IPAddresses or Ranges assigned to the NetworkPerimeter
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[builtins.str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[builtins.str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[builtins.str] description: (Updatable) NetworkPerimeter Description
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value.  The value of the externalId attribute is always issued be the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] name: (Updatable) NetworkPerimeter name
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: always
               * type: string
               * uniqueness: server
        :param pulumi.Input[builtins.str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[builtins.str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input['DomainsNetworkPerimeterTagArgs']]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        """
        pulumi.set(__self__, "idcs_endpoint", idcs_endpoint)
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        pulumi.set(__self__, "schemas", schemas)
        if attribute_sets is not None:
            pulumi.set(__self__, "attribute_sets", attribute_sets)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ocid is not None:
            pulumi.set(__self__, "ocid", ocid)
        if resource_type_schema_version is not None:
            pulumi.set(__self__, "resource_type_schema_version", resource_type_schema_version)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> pulumi.Input[builtins.str]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @idcs_endpoint.setter
    def idcs_endpoint(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "idcs_endpoint", value)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> pulumi.Input[Sequence[pulumi.Input['DomainsNetworkPerimeterIpAddressArgs']]]:
        """
        (Updatable) IPAddresses or Ranges assigned to the NetworkPerimeter

        **SCIM++ Properties:**
        * idcsCompositeKey: [value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: pulumi.Input[Sequence[pulumi.Input['DomainsNetworkPerimeterIpAddressArgs']]]):
        pulumi.set(self, "ip_addresses", value)

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @attribute_sets.setter
    def attribute_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "attribute_sets", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) NetworkPerimeter Description

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value.  The value of the externalId attribute is always issued be the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) NetworkPerimeter name

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: always
        * type: string
        * uniqueness: server
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ocid", value)

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @resource_type_schema_version.setter
    def resource_type_schema_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_type_schema_version", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsNetworkPerimeterTagArgs']]]]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsNetworkPerimeterTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _DomainsNetworkPerimeterState:
    def __init__(__self__, *,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 attributes: Optional[pulumi.Input[builtins.str]] = None,
                 authorization: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_ocid: Optional[pulumi.Input[builtins.str]] = None,
                 delete_in_progress: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain_ocid: Optional[pulumi.Input[builtins.str]] = None,
                 external_id: Optional[pulumi.Input[builtins.str]] = None,
                 idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsNetworkPerimeterIdcsCreatedByArgs']]]] = None,
                 idcs_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsNetworkPerimeterIdcsLastModifiedByArgs']]]] = None,
                 idcs_last_upgraded_in_release: Optional[pulumi.Input[builtins.str]] = None,
                 idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsNetworkPerimeterIpAddressArgs']]]] = None,
                 metas: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsNetworkPerimeterMetaArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 ocid: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[builtins.str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsNetworkPerimeterTagArgs']]]] = None,
                 tenancy_ocid: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering DomainsNetworkPerimeter resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[builtins.str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[builtins.str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[builtins.str] compartment_ocid: (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] delete_in_progress: (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.str] description: (Updatable) NetworkPerimeter Description
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] domain_ocid: (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value.  The value of the externalId attribute is always issued be the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsNetworkPerimeterIdcsCreatedByArgs']]] idcs_created_bies: (Updatable) The User or App who created the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[builtins.str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input['DomainsNetworkPerimeterIdcsLastModifiedByArgs']]] idcs_last_modified_bies: (Updatable) The User or App who modified the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[builtins.str] idcs_last_upgraded_in_release: (Updatable) The release number when the resource was upgraded.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] idcs_prevented_operations: (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsNetworkPerimeterIpAddressArgs']]] ip_addresses: (Updatable) IPAddresses or Ranges assigned to the NetworkPerimeter
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsNetworkPerimeterMetaArgs']]] metas: (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
               * type: complex
        :param pulumi.Input[builtins.str] name: (Updatable) NetworkPerimeter name
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: always
               * type: string
               * uniqueness: server
        :param pulumi.Input[builtins.str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[builtins.str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsNetworkPerimeterTagArgs']]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[builtins.str] tenancy_ocid: (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if attribute_sets is not None:
            pulumi.set(__self__, "attribute_sets", attribute_sets)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if compartment_ocid is not None:
            pulumi.set(__self__, "compartment_ocid", compartment_ocid)
        if delete_in_progress is not None:
            pulumi.set(__self__, "delete_in_progress", delete_in_progress)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_ocid is not None:
            pulumi.set(__self__, "domain_ocid", domain_ocid)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if idcs_created_bies is not None:
            pulumi.set(__self__, "idcs_created_bies", idcs_created_bies)
        if idcs_endpoint is not None:
            pulumi.set(__self__, "idcs_endpoint", idcs_endpoint)
        if idcs_last_modified_bies is not None:
            pulumi.set(__self__, "idcs_last_modified_bies", idcs_last_modified_bies)
        if idcs_last_upgraded_in_release is not None:
            pulumi.set(__self__, "idcs_last_upgraded_in_release", idcs_last_upgraded_in_release)
        if idcs_prevented_operations is not None:
            pulumi.set(__self__, "idcs_prevented_operations", idcs_prevented_operations)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)
        if metas is not None:
            pulumi.set(__self__, "metas", metas)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ocid is not None:
            pulumi.set(__self__, "ocid", ocid)
        if resource_type_schema_version is not None:
            pulumi.set(__self__, "resource_type_schema_version", resource_type_schema_version)
        if schemas is not None:
            pulumi.set(__self__, "schemas", schemas)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenancy_ocid is not None:
            pulumi.set(__self__, "tenancy_ocid", tenancy_ocid)

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @attribute_sets.setter
    def attribute_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "attribute_sets", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "compartment_ocid")

    @compartment_ocid.setter
    def compartment_ocid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_ocid", value)

    @property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "delete_in_progress")

    @delete_in_progress.setter
    def delete_in_progress(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "delete_in_progress", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) NetworkPerimeter Description

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "domain_ocid")

    @domain_ocid.setter
    def domain_ocid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_ocid", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value.  The value of the externalId attribute is always issued be the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsNetworkPerimeterIdcsCreatedByArgs']]]]:
        """
        (Updatable) The User or App who created the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_created_bies")

    @idcs_created_bies.setter
    def idcs_created_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsNetworkPerimeterIdcsCreatedByArgs']]]]):
        pulumi.set(self, "idcs_created_bies", value)

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @idcs_endpoint.setter
    def idcs_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "idcs_endpoint", value)

    @property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsNetworkPerimeterIdcsLastModifiedByArgs']]]]:
        """
        (Updatable) The User or App who modified the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @idcs_last_modified_bies.setter
    def idcs_last_modified_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsNetworkPerimeterIdcsLastModifiedByArgs']]]]):
        pulumi.set(self, "idcs_last_modified_bies", value)

    @property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The release number when the resource was upgraded.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @idcs_last_upgraded_in_release.setter
    def idcs_last_upgraded_in_release(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "idcs_last_upgraded_in_release", value)

    @property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @idcs_prevented_operations.setter
    def idcs_prevented_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "idcs_prevented_operations", value)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsNetworkPerimeterIpAddressArgs']]]]:
        """
        (Updatable) IPAddresses or Ranges assigned to the NetworkPerimeter

        **SCIM++ Properties:**
        * idcsCompositeKey: [value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsNetworkPerimeterIpAddressArgs']]]]):
        pulumi.set(self, "ip_addresses", value)

    @property
    @pulumi.getter
    def metas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsNetworkPerimeterMetaArgs']]]]:
        """
        (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
        * type: complex
        """
        return pulumi.get(self, "metas")

    @metas.setter
    def metas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsNetworkPerimeterMetaArgs']]]]):
        pulumi.set(self, "metas", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) NetworkPerimeter name

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: always
        * type: string
        * uniqueness: server
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ocid", value)

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @resource_type_schema_version.setter
    def resource_type_schema_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_type_schema_version", value)

    @property
    @pulumi.getter
    def schemas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsNetworkPerimeterTagArgs']]]]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsNetworkPerimeterTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "tenancy_ocid")

    @tenancy_ocid.setter
    def tenancy_ocid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenancy_ocid", value)


@pulumi.type_token("oci:Identity/domainsNetworkPerimeter:DomainsNetworkPerimeter")
class DomainsNetworkPerimeter(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 attributes: Optional[pulumi.Input[builtins.str]] = None,
                 authorization: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 external_id: Optional[pulumi.Input[builtins.str]] = None,
                 idcs_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsNetworkPerimeterIpAddressArgs', 'DomainsNetworkPerimeterIpAddressArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 ocid: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[builtins.str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsNetworkPerimeterTagArgs', 'DomainsNetworkPerimeterTagArgsDict']]]]] = None,
                 __props__=None):
        """
        This resource provides the Network Perimeter resource in Oracle Cloud Infrastructure Identity Domains service.

        Create a NetworkPerimeter

        ## Import

        NetworkPerimeters can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Identity/domainsNetworkPerimeter:DomainsNetworkPerimeter test_network_perimeter "idcsEndpoint/{idcsEndpoint}/networkPerimeters/{networkPerimeterId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[builtins.str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[builtins.str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[builtins.str] description: (Updatable) NetworkPerimeter Description
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value.  The value of the externalId attribute is always issued be the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsNetworkPerimeterIpAddressArgs', 'DomainsNetworkPerimeterIpAddressArgsDict']]]] ip_addresses: (Updatable) IPAddresses or Ranges assigned to the NetworkPerimeter
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[builtins.str] name: (Updatable) NetworkPerimeter name
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: always
               * type: string
               * uniqueness: server
        :param pulumi.Input[builtins.str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[builtins.str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsNetworkPerimeterTagArgs', 'DomainsNetworkPerimeterTagArgsDict']]]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainsNetworkPerimeterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Network Perimeter resource in Oracle Cloud Infrastructure Identity Domains service.

        Create a NetworkPerimeter

        ## Import

        NetworkPerimeters can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Identity/domainsNetworkPerimeter:DomainsNetworkPerimeter test_network_perimeter "idcsEndpoint/{idcsEndpoint}/networkPerimeters/{networkPerimeterId}"
        ```

        :param str resource_name: The name of the resource.
        :param DomainsNetworkPerimeterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainsNetworkPerimeterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 attributes: Optional[pulumi.Input[builtins.str]] = None,
                 authorization: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 external_id: Optional[pulumi.Input[builtins.str]] = None,
                 idcs_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsNetworkPerimeterIpAddressArgs', 'DomainsNetworkPerimeterIpAddressArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 ocid: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[builtins.str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsNetworkPerimeterTagArgs', 'DomainsNetworkPerimeterTagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainsNetworkPerimeterArgs.__new__(DomainsNetworkPerimeterArgs)

            __props__.__dict__["attribute_sets"] = attribute_sets
            __props__.__dict__["attributes"] = attributes
            __props__.__dict__["authorization"] = authorization
            __props__.__dict__["description"] = description
            __props__.__dict__["external_id"] = external_id
            if idcs_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'idcs_endpoint'")
            __props__.__dict__["idcs_endpoint"] = idcs_endpoint
            if ip_addresses is None and not opts.urn:
                raise TypeError("Missing required property 'ip_addresses'")
            __props__.__dict__["ip_addresses"] = ip_addresses
            __props__.__dict__["name"] = name
            __props__.__dict__["ocid"] = ocid
            __props__.__dict__["resource_type_schema_version"] = resource_type_schema_version
            if schemas is None and not opts.urn:
                raise TypeError("Missing required property 'schemas'")
            __props__.__dict__["schemas"] = schemas
            __props__.__dict__["tags"] = tags
            __props__.__dict__["compartment_ocid"] = None
            __props__.__dict__["delete_in_progress"] = None
            __props__.__dict__["domain_ocid"] = None
            __props__.__dict__["idcs_created_bies"] = None
            __props__.__dict__["idcs_last_modified_bies"] = None
            __props__.__dict__["idcs_last_upgraded_in_release"] = None
            __props__.__dict__["idcs_prevented_operations"] = None
            __props__.__dict__["metas"] = None
            __props__.__dict__["tenancy_ocid"] = None
        super(DomainsNetworkPerimeter, __self__).__init__(
            'oci:Identity/domainsNetworkPerimeter:DomainsNetworkPerimeter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            attributes: Optional[pulumi.Input[builtins.str]] = None,
            authorization: Optional[pulumi.Input[builtins.str]] = None,
            compartment_ocid: Optional[pulumi.Input[builtins.str]] = None,
            delete_in_progress: Optional[pulumi.Input[builtins.bool]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            domain_ocid: Optional[pulumi.Input[builtins.str]] = None,
            external_id: Optional[pulumi.Input[builtins.str]] = None,
            idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsNetworkPerimeterIdcsCreatedByArgs', 'DomainsNetworkPerimeterIdcsCreatedByArgsDict']]]]] = None,
            idcs_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsNetworkPerimeterIdcsLastModifiedByArgs', 'DomainsNetworkPerimeterIdcsLastModifiedByArgsDict']]]]] = None,
            idcs_last_upgraded_in_release: Optional[pulumi.Input[builtins.str]] = None,
            idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsNetworkPerimeterIpAddressArgs', 'DomainsNetworkPerimeterIpAddressArgsDict']]]]] = None,
            metas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsNetworkPerimeterMetaArgs', 'DomainsNetworkPerimeterMetaArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            ocid: Optional[pulumi.Input[builtins.str]] = None,
            resource_type_schema_version: Optional[pulumi.Input[builtins.str]] = None,
            schemas: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsNetworkPerimeterTagArgs', 'DomainsNetworkPerimeterTagArgsDict']]]]] = None,
            tenancy_ocid: Optional[pulumi.Input[builtins.str]] = None) -> 'DomainsNetworkPerimeter':
        """
        Get an existing DomainsNetworkPerimeter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[builtins.str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[builtins.str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[builtins.str] compartment_ocid: (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] delete_in_progress: (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.str] description: (Updatable) NetworkPerimeter Description
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] domain_ocid: (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value.  The value of the externalId attribute is always issued be the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsNetworkPerimeterIdcsCreatedByArgs', 'DomainsNetworkPerimeterIdcsCreatedByArgsDict']]]] idcs_created_bies: (Updatable) The User or App who created the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[builtins.str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsNetworkPerimeterIdcsLastModifiedByArgs', 'DomainsNetworkPerimeterIdcsLastModifiedByArgsDict']]]] idcs_last_modified_bies: (Updatable) The User or App who modified the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[builtins.str] idcs_last_upgraded_in_release: (Updatable) The release number when the resource was upgraded.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] idcs_prevented_operations: (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsNetworkPerimeterIpAddressArgs', 'DomainsNetworkPerimeterIpAddressArgsDict']]]] ip_addresses: (Updatable) IPAddresses or Ranges assigned to the NetworkPerimeter
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsNetworkPerimeterMetaArgs', 'DomainsNetworkPerimeterMetaArgsDict']]]] metas: (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
               * type: complex
        :param pulumi.Input[builtins.str] name: (Updatable) NetworkPerimeter name
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: always
               * type: string
               * uniqueness: server
        :param pulumi.Input[builtins.str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[builtins.str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsNetworkPerimeterTagArgs', 'DomainsNetworkPerimeterTagArgsDict']]]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[builtins.str] tenancy_ocid: (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainsNetworkPerimeterState.__new__(_DomainsNetworkPerimeterState)

        __props__.__dict__["attribute_sets"] = attribute_sets
        __props__.__dict__["attributes"] = attributes
        __props__.__dict__["authorization"] = authorization
        __props__.__dict__["compartment_ocid"] = compartment_ocid
        __props__.__dict__["delete_in_progress"] = delete_in_progress
        __props__.__dict__["description"] = description
        __props__.__dict__["domain_ocid"] = domain_ocid
        __props__.__dict__["external_id"] = external_id
        __props__.__dict__["idcs_created_bies"] = idcs_created_bies
        __props__.__dict__["idcs_endpoint"] = idcs_endpoint
        __props__.__dict__["idcs_last_modified_bies"] = idcs_last_modified_bies
        __props__.__dict__["idcs_last_upgraded_in_release"] = idcs_last_upgraded_in_release
        __props__.__dict__["idcs_prevented_operations"] = idcs_prevented_operations
        __props__.__dict__["ip_addresses"] = ip_addresses
        __props__.__dict__["metas"] = metas
        __props__.__dict__["name"] = name
        __props__.__dict__["ocid"] = ocid
        __props__.__dict__["resource_type_schema_version"] = resource_type_schema_version
        __props__.__dict__["schemas"] = schemas
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenancy_ocid"] = tenancy_ocid
        return DomainsNetworkPerimeter(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @property
    @pulumi.getter
    def attributes(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def authorization(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "compartment_ocid")

    @property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "delete_in_progress")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) NetworkPerimeter Description

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "domain_ocid")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value.  The value of the externalId attribute is always issued be the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> pulumi.Output[Sequence['outputs.DomainsNetworkPerimeterIdcsCreatedBy']]:
        """
        (Updatable) The User or App who created the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_created_bies")

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> pulumi.Output[Sequence['outputs.DomainsNetworkPerimeterIdcsLastModifiedBy']]:
        """
        (Updatable) The User or App who modified the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The release number when the resource was upgraded.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> pulumi.Output[Sequence['outputs.DomainsNetworkPerimeterIpAddress']]:
        """
        (Updatable) IPAddresses or Ranges assigned to the NetworkPerimeter

        **SCIM++ Properties:**
        * idcsCompositeKey: [value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter
    def metas(self) -> pulumi.Output[Sequence['outputs.DomainsNetworkPerimeterMeta']]:
        """
        (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
        * type: complex
        """
        return pulumi.get(self, "metas")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) NetworkPerimeter name

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: always
        * type: string
        * uniqueness: server
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def ocid(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.DomainsNetworkPerimeterTag']]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "tenancy_ocid")

