# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetRegionSubscriptionsResult',
    'AwaitableGetRegionSubscriptionsResult',
    'get_region_subscriptions',
    'get_region_subscriptions_output',
]

@pulumi.output_type
class GetRegionSubscriptionsResult:
    """
    A collection of values returned by getRegionSubscriptions.
    """
    def __init__(__self__, filters=None, id=None, region_subscriptions=None, tenancy_id=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region_subscriptions and not isinstance(region_subscriptions, list):
            raise TypeError("Expected argument 'region_subscriptions' to be a list")
        pulumi.set(__self__, "region_subscriptions", region_subscriptions)
        if tenancy_id and not isinstance(tenancy_id, str):
            raise TypeError("Expected argument 'tenancy_id' to be a str")
        pulumi.set(__self__, "tenancy_id", tenancy_id)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetRegionSubscriptionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="regionSubscriptions")
    def region_subscriptions(self) -> Sequence['outputs.GetRegionSubscriptionsRegionSubscriptionResult']:
        """
        The list of region_subscriptions.
        """
        return pulumi.get(self, "region_subscriptions")

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> builtins.str:
        return pulumi.get(self, "tenancy_id")


class AwaitableGetRegionSubscriptionsResult(GetRegionSubscriptionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRegionSubscriptionsResult(
            filters=self.filters,
            id=self.id,
            region_subscriptions=self.region_subscriptions,
            tenancy_id=self.tenancy_id)


def get_region_subscriptions(filters: Optional[Sequence[Union['GetRegionSubscriptionsFilterArgs', 'GetRegionSubscriptionsFilterArgsDict']]] = None,
                             tenancy_id: Optional[builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRegionSubscriptionsResult:
    """
    This data source provides the list of Region Subscriptions in Oracle Cloud Infrastructure Identity service.

    Lists the region subscriptions for the specified tenancy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_region_subscriptions = oci.Identity.get_region_subscriptions(tenancy_id=test_tenancy["id"])
    ```


    :param builtins.str tenancy_id: The OCID of the tenancy.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['tenancyId'] = tenancy_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Identity/getRegionSubscriptions:getRegionSubscriptions', __args__, opts=opts, typ=GetRegionSubscriptionsResult).value

    return AwaitableGetRegionSubscriptionsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        region_subscriptions=pulumi.get(__ret__, 'region_subscriptions'),
        tenancy_id=pulumi.get(__ret__, 'tenancy_id'))
def get_region_subscriptions_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetRegionSubscriptionsFilterArgs', 'GetRegionSubscriptionsFilterArgsDict']]]]] = None,
                                    tenancy_id: Optional[pulumi.Input[builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRegionSubscriptionsResult]:
    """
    This data source provides the list of Region Subscriptions in Oracle Cloud Infrastructure Identity service.

    Lists the region subscriptions for the specified tenancy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_region_subscriptions = oci.Identity.get_region_subscriptions(tenancy_id=test_tenancy["id"])
    ```


    :param builtins.str tenancy_id: The OCID of the tenancy.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['tenancyId'] = tenancy_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Identity/getRegionSubscriptions:getRegionSubscriptions', __args__, opts=opts, typ=GetRegionSubscriptionsResult)
    return __ret__.apply(lambda __response__: GetRegionSubscriptionsResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        region_subscriptions=pulumi.get(__response__, 'region_subscriptions'),
        tenancy_id=pulumi.get(__response__, 'tenancy_id')))
