# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFleetDrsFilesResult',
    'AwaitableGetFleetDrsFilesResult',
    'get_fleet_drs_files',
    'get_fleet_drs_files_output',
]

@pulumi.output_type
class GetFleetDrsFilesResult:
    """
    A collection of values returned by getFleetDrsFiles.
    """
    def __init__(__self__, drs_file_collections=None, filters=None, fleet_id=None, id=None):
        if drs_file_collections and not isinstance(drs_file_collections, list):
            raise TypeError("Expected argument 'drs_file_collections' to be a list")
        pulumi.set(__self__, "drs_file_collections", drs_file_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="drsFileCollections")
    def drs_file_collections(self) -> Sequence['outputs.GetFleetDrsFilesDrsFileCollectionResult']:
        """
        The list of drs_file_collection.
        """
        return pulumi.get(self, "drs_file_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetFleetDrsFilesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> builtins.str:
        return pulumi.get(self, "fleet_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetFleetDrsFilesResult(GetFleetDrsFilesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFleetDrsFilesResult(
            drs_file_collections=self.drs_file_collections,
            filters=self.filters,
            fleet_id=self.fleet_id,
            id=self.id)


def get_fleet_drs_files(filters: Optional[Sequence[Union['GetFleetDrsFilesFilterArgs', 'GetFleetDrsFilesFilterArgsDict']]] = None,
                        fleet_id: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFleetDrsFilesResult:
    """
    This data source provides the list of Fleet Drs Files in Oracle Cloud Infrastructure Jms service.

    List the details about the created DRS files in the Fleet.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_drs_files = oci.Jms.get_fleet_drs_files(fleet_id=test_fleet["id"])
    ```


    :param builtins.str fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getFleetDrsFiles:getFleetDrsFiles', __args__, opts=opts, typ=GetFleetDrsFilesResult).value

    return AwaitableGetFleetDrsFilesResult(
        drs_file_collections=pulumi.get(__ret__, 'drs_file_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        id=pulumi.get(__ret__, 'id'))
def get_fleet_drs_files_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetFleetDrsFilesFilterArgs', 'GetFleetDrsFilesFilterArgsDict']]]]] = None,
                               fleet_id: Optional[pulumi.Input[builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFleetDrsFilesResult]:
    """
    This data source provides the list of Fleet Drs Files in Oracle Cloud Infrastructure Jms service.

    List the details about the created DRS files in the Fleet.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_drs_files = oci.Jms.get_fleet_drs_files(fleet_id=test_fleet["id"])
    ```


    :param builtins.str fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Jms/getFleetDrsFiles:getFleetDrsFiles', __args__, opts=opts, typ=GetFleetDrsFilesResult)
    return __ret__.apply(lambda __response__: GetFleetDrsFilesResult(
        drs_file_collections=pulumi.get(__response__, 'drs_file_collections'),
        filters=pulumi.get(__response__, 'filters'),
        fleet_id=pulumi.get(__response__, 'fleet_id'),
        id=pulumi.get(__response__, 'id')))
