# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetJavaDownloadsJavaLicenseResult',
    'AwaitableGetJavaDownloadsJavaLicenseResult',
    'get_java_downloads_java_license',
    'get_java_downloads_java_license_output',
]

@pulumi.output_type
class GetJavaDownloadsJavaLicenseResult:
    """
    A collection of values returned by getJavaDownloadsJavaLicense.
    """
    def __init__(__self__, display_name=None, id=None, license_type=None, license_url=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if license_type and not isinstance(license_type, str):
            raise TypeError("Expected argument 'license_type' to be a str")
        pulumi.set(__self__, "license_type", license_type)
        if license_url and not isinstance(license_url, str):
            raise TypeError("Expected argument 'license_url' to be a str")
        pulumi.set(__self__, "license_url", license_url)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        Commonly used name for the license type.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> builtins.str:
        """
        License Type
        """
        return pulumi.get(self, "license_type")

    @property
    @pulumi.getter(name="licenseUrl")
    def license_url(self) -> builtins.str:
        """
        Publicly accessible license URL containing the detailed terms and conditions.
        """
        return pulumi.get(self, "license_url")


class AwaitableGetJavaDownloadsJavaLicenseResult(GetJavaDownloadsJavaLicenseResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetJavaDownloadsJavaLicenseResult(
            display_name=self.display_name,
            id=self.id,
            license_type=self.license_type,
            license_url=self.license_url)


def get_java_downloads_java_license(license_type: Optional[builtins.str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetJavaDownloadsJavaLicenseResult:
    """
    This data source provides details about a specific Java License resource in Oracle Cloud Infrastructure Jms Java Downloads service.

    Return details of the specified Java license type.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_java_license = oci.Jms.get_java_downloads_java_license(license_type=java_license_license_type)
    ```


    :param builtins.str license_type: Unique Java license type.
    """
    __args__ = dict()
    __args__['licenseType'] = license_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getJavaDownloadsJavaLicense:getJavaDownloadsJavaLicense', __args__, opts=opts, typ=GetJavaDownloadsJavaLicenseResult).value

    return AwaitableGetJavaDownloadsJavaLicenseResult(
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        license_type=pulumi.get(__ret__, 'license_type'),
        license_url=pulumi.get(__ret__, 'license_url'))
def get_java_downloads_java_license_output(license_type: Optional[pulumi.Input[builtins.str]] = None,
                                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetJavaDownloadsJavaLicenseResult]:
    """
    This data source provides details about a specific Java License resource in Oracle Cloud Infrastructure Jms Java Downloads service.

    Return details of the specified Java license type.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_java_license = oci.Jms.get_java_downloads_java_license(license_type=java_license_license_type)
    ```


    :param builtins.str license_type: Unique Java license type.
    """
    __args__ = dict()
    __args__['licenseType'] = license_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Jms/getJavaDownloadsJavaLicense:getJavaDownloadsJavaLicense', __args__, opts=opts, typ=GetJavaDownloadsJavaLicenseResult)
    return __ret__.apply(lambda __response__: GetJavaDownloadsJavaLicenseResult(
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        license_type=pulumi.get(__response__, 'license_type'),
        license_url=pulumi.get(__response__, 'license_url')))
