# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetTopUtilizedResourcesResult',
    'AwaitableGetTopUtilizedResourcesResult',
    'get_top_utilized_resources',
    'get_top_utilized_resources_output',
]

@pulumi.output_type
class GetTopUtilizedResourcesResult:
    """
    A collection of values returned by getTopUtilizedResources.
    """
    def __init__(__self__, compartment_id=None, id=None, is_compartment_id_in_subtree=None, items=None, resource_unit_type=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_compartment_id_in_subtree and not isinstance(is_compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'is_compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "is_compartment_id_in_subtree", is_compartment_id_in_subtree)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if resource_unit_type and not isinstance(resource_unit_type, str):
            raise TypeError("Expected argument 'resource_unit_type' to be a str")
        pulumi.set(__self__, "resource_unit_type", resource_unit_type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isCompartmentIdInSubtree")
    def is_compartment_id_in_subtree(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "is_compartment_id_in_subtree")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetTopUtilizedResourcesItemResult']:
        """
        The top utilized resource summary collection.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="resourceUnitType")
    def resource_unit_type(self) -> Optional[builtins.str]:
        return pulumi.get(self, "resource_unit_type")


class AwaitableGetTopUtilizedResourcesResult(GetTopUtilizedResourcesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTopUtilizedResourcesResult(
            compartment_id=self.compartment_id,
            id=self.id,
            is_compartment_id_in_subtree=self.is_compartment_id_in_subtree,
            items=self.items,
            resource_unit_type=self.resource_unit_type)


def get_top_utilized_resources(compartment_id: Optional[builtins.str] = None,
                               is_compartment_id_in_subtree: Optional[builtins.bool] = None,
                               resource_unit_type: Optional[builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTopUtilizedResourcesResult:
    """
    This data source provides the list of Top Utilized Resources in Oracle Cloud Infrastructure License Manager service.

    Retrieves the top utilized resources for a given compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_top_utilized_resources = oci.LicenseManager.get_top_utilized_resources(compartment_id=compartment_id,
        is_compartment_id_in_subtree=top_utilized_resource_is_compartment_id_in_subtree,
        resource_unit_type=top_utilized_resource_resource_unit_type)
    ```


    :param builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) used for the license record, product license, and configuration.
    :param builtins.bool is_compartment_id_in_subtree: Indicates if the given compartment is the root compartment.
    :param builtins.str resource_unit_type: A filter to return only resources whose unit matches the given resource unit.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['isCompartmentIdInSubtree'] = is_compartment_id_in_subtree
    __args__['resourceUnitType'] = resource_unit_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LicenseManager/getTopUtilizedResources:getTopUtilizedResources', __args__, opts=opts, typ=GetTopUtilizedResourcesResult).value

    return AwaitableGetTopUtilizedResourcesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        id=pulumi.get(__ret__, 'id'),
        is_compartment_id_in_subtree=pulumi.get(__ret__, 'is_compartment_id_in_subtree'),
        items=pulumi.get(__ret__, 'items'),
        resource_unit_type=pulumi.get(__ret__, 'resource_unit_type'))
def get_top_utilized_resources_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                      is_compartment_id_in_subtree: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                      resource_unit_type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTopUtilizedResourcesResult]:
    """
    This data source provides the list of Top Utilized Resources in Oracle Cloud Infrastructure License Manager service.

    Retrieves the top utilized resources for a given compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_top_utilized_resources = oci.LicenseManager.get_top_utilized_resources(compartment_id=compartment_id,
        is_compartment_id_in_subtree=top_utilized_resource_is_compartment_id_in_subtree,
        resource_unit_type=top_utilized_resource_resource_unit_type)
    ```


    :param builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) used for the license record, product license, and configuration.
    :param builtins.bool is_compartment_id_in_subtree: Indicates if the given compartment is the root compartment.
    :param builtins.str resource_unit_type: A filter to return only resources whose unit matches the given resource unit.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['isCompartmentIdInSubtree'] = is_compartment_id_in_subtree
    __args__['resourceUnitType'] = resource_unit_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:LicenseManager/getTopUtilizedResources:getTopUtilizedResources', __args__, opts=opts, typ=GetTopUtilizedResourcesResult)
    return __ret__.apply(lambda __response__: GetTopUtilizedResourcesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        id=pulumi.get(__response__, 'id'),
        is_compartment_id_in_subtree=pulumi.get(__response__, 'is_compartment_id_in_subtree'),
        items=pulumi.get(__response__, 'items'),
        resource_unit_type=pulumi.get(__response__, 'resource_unit_type')))
