# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetListenerRulesResult',
    'AwaitableGetListenerRulesResult',
    'get_listener_rules',
    'get_listener_rules_output',
]

@pulumi.output_type
class GetListenerRulesResult:
    """
    A collection of values returned by getListenerRules.
    """
    def __init__(__self__, filters=None, id=None, listener_name=None, listener_rules=None, load_balancer_id=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if listener_name and not isinstance(listener_name, str):
            raise TypeError("Expected argument 'listener_name' to be a str")
        pulumi.set(__self__, "listener_name", listener_name)
        if listener_rules and not isinstance(listener_rules, list):
            raise TypeError("Expected argument 'listener_rules' to be a list")
        pulumi.set(__self__, "listener_rules", listener_rules)
        if load_balancer_id and not isinstance(load_balancer_id, str):
            raise TypeError("Expected argument 'load_balancer_id' to be a str")
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetListenerRulesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="listenerName")
    def listener_name(self) -> builtins.str:
        return pulumi.get(self, "listener_name")

    @property
    @pulumi.getter(name="listenerRules")
    def listener_rules(self) -> Sequence['outputs.GetListenerRulesListenerRuleResult']:
        """
        The list of listener_rules.
        """
        return pulumi.get(self, "listener_rules")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> builtins.str:
        return pulumi.get(self, "load_balancer_id")


class AwaitableGetListenerRulesResult(GetListenerRulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetListenerRulesResult(
            filters=self.filters,
            id=self.id,
            listener_name=self.listener_name,
            listener_rules=self.listener_rules,
            load_balancer_id=self.load_balancer_id)


def get_listener_rules(filters: Optional[Sequence[Union['GetListenerRulesFilterArgs', 'GetListenerRulesFilterArgsDict']]] = None,
                       listener_name: Optional[builtins.str] = None,
                       load_balancer_id: Optional[builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetListenerRulesResult:
    """
    This data source provides the list of Listener Rules in Oracle Cloud Infrastructure Load Balancer service.

    Lists all of the rules from all of the rule sets associated with the specified listener. The response organizes
    the rules in the following order:

    *  Access control rules
    *  Allow method rules
    *  Request header rules
    *  Response header rules

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_listener_rules = oci.LoadBalancer.get_listener_rules(listener_name=test_listener["name"],
        load_balancer_id=test_load_balancer["id"])
    ```


    :param builtins.str listener_name: The name of the listener the rules are associated with. Example: `example_listener`
    :param builtins.str load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer associated with the listener.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['listenerName'] = listener_name
    __args__['loadBalancerId'] = load_balancer_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LoadBalancer/getListenerRules:getListenerRules', __args__, opts=opts, typ=GetListenerRulesResult).value

    return AwaitableGetListenerRulesResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        listener_name=pulumi.get(__ret__, 'listener_name'),
        listener_rules=pulumi.get(__ret__, 'listener_rules'),
        load_balancer_id=pulumi.get(__ret__, 'load_balancer_id'))
def get_listener_rules_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetListenerRulesFilterArgs', 'GetListenerRulesFilterArgsDict']]]]] = None,
                              listener_name: Optional[pulumi.Input[builtins.str]] = None,
                              load_balancer_id: Optional[pulumi.Input[builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetListenerRulesResult]:
    """
    This data source provides the list of Listener Rules in Oracle Cloud Infrastructure Load Balancer service.

    Lists all of the rules from all of the rule sets associated with the specified listener. The response organizes
    the rules in the following order:

    *  Access control rules
    *  Allow method rules
    *  Request header rules
    *  Response header rules

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_listener_rules = oci.LoadBalancer.get_listener_rules(listener_name=test_listener["name"],
        load_balancer_id=test_load_balancer["id"])
    ```


    :param builtins.str listener_name: The name of the listener the rules are associated with. Example: `example_listener`
    :param builtins.str load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer associated with the listener.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['listenerName'] = listener_name
    __args__['loadBalancerId'] = load_balancer_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:LoadBalancer/getListenerRules:getListenerRules', __args__, opts=opts, typ=GetListenerRulesResult)
    return __ret__.apply(lambda __response__: GetListenerRulesResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        listener_name=pulumi.get(__response__, 'listener_name'),
        listener_rules=pulumi.get(__response__, 'listener_rules'),
        load_balancer_id=pulumi.get(__response__, 'load_balancer_id')))
