# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetLogAnalyticsEntityTopologyResult',
    'AwaitableGetLogAnalyticsEntityTopologyResult',
    'get_log_analytics_entity_topology',
    'get_log_analytics_entity_topology_output',
]

@pulumi.output_type
class GetLogAnalyticsEntityTopologyResult:
    """
    A collection of values returned by getLogAnalyticsEntityTopology.
    """
    def __init__(__self__, context=None, filters=None, id=None, items=None, log_analytics_entity_id=None, metadata_equals=None, namespace=None, state=None):
        if context and not isinstance(context, str):
            raise TypeError("Expected argument 'context' to be a str")
        pulumi.set(__self__, "context", context)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if log_analytics_entity_id and not isinstance(log_analytics_entity_id, str):
            raise TypeError("Expected argument 'log_analytics_entity_id' to be a str")
        pulumi.set(__self__, "log_analytics_entity_id", log_analytics_entity_id)
        if metadata_equals and not isinstance(metadata_equals, list):
            raise TypeError("Expected argument 'metadata_equals' to be a list")
        pulumi.set(__self__, "metadata_equals", metadata_equals)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def context(self) -> Optional[builtins.str]:
        return pulumi.get(self, "context")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetLogAnalyticsEntityTopologyFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetLogAnalyticsEntityTopologyItemResult']:
        """
        An array of entity metadata.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="logAnalyticsEntityId")
    def log_analytics_entity_id(self) -> builtins.str:
        return pulumi.get(self, "log_analytics_entity_id")

    @property
    @pulumi.getter(name="metadataEquals")
    def metadata_equals(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "metadata_equals")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the log analytics entity.
        """
        return pulumi.get(self, "state")


class AwaitableGetLogAnalyticsEntityTopologyResult(GetLogAnalyticsEntityTopologyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLogAnalyticsEntityTopologyResult(
            context=self.context,
            filters=self.filters,
            id=self.id,
            items=self.items,
            log_analytics_entity_id=self.log_analytics_entity_id,
            metadata_equals=self.metadata_equals,
            namespace=self.namespace,
            state=self.state)


def get_log_analytics_entity_topology(context: Optional[builtins.str] = None,
                                      filters: Optional[Sequence[Union['GetLogAnalyticsEntityTopologyFilterArgs', 'GetLogAnalyticsEntityTopologyFilterArgsDict']]] = None,
                                      log_analytics_entity_id: Optional[builtins.str] = None,
                                      metadata_equals: Optional[Sequence[builtins.str]] = None,
                                      namespace: Optional[builtins.str] = None,
                                      state: Optional[builtins.str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLogAnalyticsEntityTopologyResult:
    """
    This data source provides details about a specific Log Analytics Entity Topology resource in Oracle Cloud Infrastructure Log Analytics service.

    Return a log analytics entity topology collection that contains a set of log analytics entities and a set of relationships between those, for the input source entity.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_log_analytics_entity_topology = oci.LogAnalytics.get_log_analytics_entity_topology(log_analytics_entity_id=test_log_analytics_entity["id"],
        namespace=log_analytics_entity_topology_namespace,
        context=log_analytics_entity_topology_context,
        metadata_equals=log_analytics_entity_topology_metadata_equals,
        state=log_analytics_entity_topology_state)
    ```


    :param builtins.str context: A filter to return log analytics entity toplogy whose context matches the specified string.
    :param builtins.str log_analytics_entity_id: The log analytics entity OCID.
    :param Sequence[builtins.str] metadata_equals: A filter to return only log analytics entities whose metadata name, value and type matches the specified string. Each item in the array has the format "{name}:{value}:{type}".  All inputs are case-insensitive.
    :param builtins.str namespace: The Logging Analytics namespace used for the request.
    :param builtins.str state: A filter to return only those log analytics entities with the specified lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['context'] = context
    __args__['filters'] = filters
    __args__['logAnalyticsEntityId'] = log_analytics_entity_id
    __args__['metadataEquals'] = metadata_equals
    __args__['namespace'] = namespace
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LogAnalytics/getLogAnalyticsEntityTopology:getLogAnalyticsEntityTopology', __args__, opts=opts, typ=GetLogAnalyticsEntityTopologyResult).value

    return AwaitableGetLogAnalyticsEntityTopologyResult(
        context=pulumi.get(__ret__, 'context'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        log_analytics_entity_id=pulumi.get(__ret__, 'log_analytics_entity_id'),
        metadata_equals=pulumi.get(__ret__, 'metadata_equals'),
        namespace=pulumi.get(__ret__, 'namespace'),
        state=pulumi.get(__ret__, 'state'))
def get_log_analytics_entity_topology_output(context: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetLogAnalyticsEntityTopologyFilterArgs', 'GetLogAnalyticsEntityTopologyFilterArgsDict']]]]] = None,
                                             log_analytics_entity_id: Optional[pulumi.Input[builtins.str]] = None,
                                             metadata_equals: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                             namespace: Optional[pulumi.Input[builtins.str]] = None,
                                             state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLogAnalyticsEntityTopologyResult]:
    """
    This data source provides details about a specific Log Analytics Entity Topology resource in Oracle Cloud Infrastructure Log Analytics service.

    Return a log analytics entity topology collection that contains a set of log analytics entities and a set of relationships between those, for the input source entity.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_log_analytics_entity_topology = oci.LogAnalytics.get_log_analytics_entity_topology(log_analytics_entity_id=test_log_analytics_entity["id"],
        namespace=log_analytics_entity_topology_namespace,
        context=log_analytics_entity_topology_context,
        metadata_equals=log_analytics_entity_topology_metadata_equals,
        state=log_analytics_entity_topology_state)
    ```


    :param builtins.str context: A filter to return log analytics entity toplogy whose context matches the specified string.
    :param builtins.str log_analytics_entity_id: The log analytics entity OCID.
    :param Sequence[builtins.str] metadata_equals: A filter to return only log analytics entities whose metadata name, value and type matches the specified string. Each item in the array has the format "{name}:{value}:{type}".  All inputs are case-insensitive.
    :param builtins.str namespace: The Logging Analytics namespace used for the request.
    :param builtins.str state: A filter to return only those log analytics entities with the specified lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['context'] = context
    __args__['filters'] = filters
    __args__['logAnalyticsEntityId'] = log_analytics_entity_id
    __args__['metadataEquals'] = metadata_equals
    __args__['namespace'] = namespace
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:LogAnalytics/getLogAnalyticsEntityTopology:getLogAnalyticsEntityTopology', __args__, opts=opts, typ=GetLogAnalyticsEntityTopologyResult)
    return __ret__.apply(lambda __response__: GetLogAnalyticsEntityTopologyResult(
        context=pulumi.get(__response__, 'context'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        items=pulumi.get(__response__, 'items'),
        log_analytics_entity_id=pulumi.get(__response__, 'log_analytics_entity_id'),
        metadata_equals=pulumi.get(__response__, 'metadata_equals'),
        namespace=pulumi.get(__response__, 'namespace'),
        state=pulumi.get(__response__, 'state')))
