# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCategoriesResult',
    'AwaitableGetCategoriesResult',
    'get_categories',
    'get_categories_output',
]

@pulumi.output_type
class GetCategoriesResult:
    """
    A collection of values returned by getCategories.
    """
    def __init__(__self__, categories=None, compartment_id=None, filters=None, id=None):
        if categories and not isinstance(categories, list):
            raise TypeError("Expected argument 'categories' to be a list")
        pulumi.set(__self__, "categories", categories)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def categories(self) -> Sequence['outputs.GetCategoriesCategoryResult']:
        """
        The list of categories.
        """
        return pulumi.get(self, "categories")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetCategoriesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetCategoriesResult(GetCategoriesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCategoriesResult(
            categories=self.categories,
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id)


def get_categories(compartment_id: Optional[builtins.str] = None,
                   filters: Optional[Sequence[Union['GetCategoriesFilterArgs', 'GetCategoriesFilterArgsDict']]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCategoriesResult:
    """
    This data source provides the list of Categories in Oracle Cloud Infrastructure Marketplace service.

    Gets the list of all the categories for listings published to Oracle Cloud Infrastructure Marketplace. Categories apply
    to the software product provided by the listing.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_categories = oci.Marketplace.get_categories(compartment_id=compartment_id)
    ```


    :param builtins.str compartment_id: The unique identifier for the compartment.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Marketplace/getCategories:getCategories', __args__, opts=opts, typ=GetCategoriesResult).value

    return AwaitableGetCategoriesResult(
        categories=pulumi.get(__ret__, 'categories'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))
def get_categories_output(compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          filters: Optional[pulumi.Input[Optional[Sequence[Union['GetCategoriesFilterArgs', 'GetCategoriesFilterArgsDict']]]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCategoriesResult]:
    """
    This data source provides the list of Categories in Oracle Cloud Infrastructure Marketplace service.

    Gets the list of all the categories for listings published to Oracle Cloud Infrastructure Marketplace. Categories apply
    to the software product provided by the listing.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_categories = oci.Marketplace.get_categories(compartment_id=compartment_id)
    ```


    :param builtins.str compartment_id: The unique identifier for the compartment.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Marketplace/getCategories:getCategories', __args__, opts=opts, typ=GetCategoriesResult)
    return __ret__.apply(lambda __response__: GetCategoriesResult(
        categories=pulumi.get(__response__, 'categories'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id')))
