# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AlarmOverride',
    'AlarmSuppression',
    'AlarmSuppressionAlarmSuppressionTarget',
    'AlarmSuppressionSuppressionCondition',
    'GetAlarmHistoryCollectionEntryResult',
    'GetAlarmOverrideResult',
    'GetAlarmStatusesAlarmStatusResult',
    'GetAlarmStatusesAlarmStatusSuppressionResult',
    'GetAlarmStatusesFilterResult',
    'GetAlarmSuppressionResult',
    'GetAlarmSuppressionAlarmSuppressionTargetResult',
    'GetAlarmSuppressionSuppressionConditionResult',
    'GetAlarmSuppressionsAlarmSuppressionCollectionResult',
    'GetAlarmSuppressionsAlarmSuppressionCollectionItemResult',
    'GetAlarmSuppressionsAlarmSuppressionCollectionItemAlarmSuppressionTargetResult',
    'GetAlarmSuppressionsAlarmSuppressionCollectionItemSuppressionConditionResult',
    'GetAlarmSuppressionsFilterResult',
    'GetAlarmsAlarmResult',
    'GetAlarmsAlarmOverrideResult',
    'GetAlarmsAlarmSuppressionResult',
    'GetAlarmsFilterResult',
    'GetMetricDataFilterResult',
    'GetMetricDataMetricDataResult',
    'GetMetricDataMetricDataAggregatedDatapointResult',
    'GetMetricsFilterResult',
    'GetMetricsMetricResult',
]

@pulumi.output_type
class AlarmOverride(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pendingDuration":
            suggest = "pending_duration"
        elif key == "ruleName":
            suggest = "rule_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlarmOverride. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlarmOverride.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlarmOverride.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 body: Optional[builtins.str] = None,
                 pending_duration: Optional[builtins.str] = None,
                 query: Optional[builtins.str] = None,
                 rule_name: Optional[builtins.str] = None,
                 severity: Optional[builtins.str] = None):
        """
        :param builtins.str body: (Updatable) The human-readable content of the delivered alarm notification. Optionally include [dynamic variables](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/update-alarm-dynamic-variables.htm). Oracle recommends providing guidance to operators for resolving the alarm condition. Consider adding links to standard runbook practices. Avoid entering confidential information.  Example: `High CPU usage alert. Follow runbook instructions for resolution.`
        :param builtins.str pending_duration: (Updatable) The period of time that the condition defined in the alarm must persist before the alarm state changes from "OK" to "FIRING". For example, a value of 5 minutes means that the alarm must persist in breaching the condition for five minutes before the alarm updates its state to "FIRING".
               
               The duration is specified as a string in ISO 8601 format (`PT10M` for ten minutes or `PT1H` for one hour). Minimum: PT1M. Maximum: PT1H. Default: PT1M.
               
               Under the default value of PT1M, the first evaluation that breaches the alarm updates the state to "FIRING".
               
               The alarm updates its status to "OK" when the breaching condition has been clear for the most recent minute.
               
               Example: `PT5M`
        :param builtins.str query: (Updatable) The Monitoring Query Language (MQL) expression to evaluate for the alarm. The Alarms feature of the Monitoring service interprets results for each returned time series as Boolean values, where zero represents false and a non-zero value represents true. A true value means that the trigger rule condition has been met. The query must specify a metric, statistic, interval, and trigger rule (threshold or absence). Supported values for interval depend on the specified time range. More interval values are supported for smaller time ranges. You can optionally specify dimensions and grouping functions. Also, you can customize the  [absence detection period](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/create-edit-alarm-query-absence-detection-period.htm). Supported grouping functions: `grouping()`, `groupBy()`. For information about writing MQL expressions, see [Editing the MQL Expression for a Query](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/query-metric-mql.htm). For details about MQL, see [Monitoring Query Language (MQL) Reference](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Reference/mql.htm). For available dimensions, review the metric definition for the supported service. See [Supported Services](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#SupportedServices).
               
               Example of threshold alarm:
               
               -----
               
               CpuUtilization[1m]{availabilityDomain="cumS:PHX-AD-1"}.groupBy(availabilityDomain).percentile(0.9) > 85
               
               -----
               
               Example of absence alarm:
               
               -----
               
               CpuUtilization[1m]{availabilityDomain="cumS:PHX-AD-1"}.absent()
               
               ----- Example of absence alarm with custom absence detection period of 20 hours:
               
               ----- CpuUtilization[1m]{availabilityDomain="cumS:PHX-AD-1"}.absent(20h) -----
        :param builtins.str rule_name: (Updatable) A user-friendly description for this alarm override. Must be unique across all `ruleName` values for the alarm.
        :param builtins.str severity: (Updatable) The perceived severity of the alarm with regard to the affected system.  Example: `CRITICAL`
        """
        if body is not None:
            pulumi.set(__self__, "body", body)
        if pending_duration is not None:
            pulumi.set(__self__, "pending_duration", pending_duration)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)

    @property
    @pulumi.getter
    def body(self) -> Optional[builtins.str]:
        """
        (Updatable) The human-readable content of the delivered alarm notification. Optionally include [dynamic variables](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/update-alarm-dynamic-variables.htm). Oracle recommends providing guidance to operators for resolving the alarm condition. Consider adding links to standard runbook practices. Avoid entering confidential information.  Example: `High CPU usage alert. Follow runbook instructions for resolution.`
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter(name="pendingDuration")
    def pending_duration(self) -> Optional[builtins.str]:
        """
        (Updatable) The period of time that the condition defined in the alarm must persist before the alarm state changes from "OK" to "FIRING". For example, a value of 5 minutes means that the alarm must persist in breaching the condition for five minutes before the alarm updates its state to "FIRING".

        The duration is specified as a string in ISO 8601 format (`PT10M` for ten minutes or `PT1H` for one hour). Minimum: PT1M. Maximum: PT1H. Default: PT1M.

        Under the default value of PT1M, the first evaluation that breaches the alarm updates the state to "FIRING".

        The alarm updates its status to "OK" when the breaching condition has been clear for the most recent minute.

        Example: `PT5M`
        """
        return pulumi.get(self, "pending_duration")

    @property
    @pulumi.getter
    def query(self) -> Optional[builtins.str]:
        """
        (Updatable) The Monitoring Query Language (MQL) expression to evaluate for the alarm. The Alarms feature of the Monitoring service interprets results for each returned time series as Boolean values, where zero represents false and a non-zero value represents true. A true value means that the trigger rule condition has been met. The query must specify a metric, statistic, interval, and trigger rule (threshold or absence). Supported values for interval depend on the specified time range. More interval values are supported for smaller time ranges. You can optionally specify dimensions and grouping functions. Also, you can customize the  [absence detection period](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/create-edit-alarm-query-absence-detection-period.htm). Supported grouping functions: `grouping()`, `groupBy()`. For information about writing MQL expressions, see [Editing the MQL Expression for a Query](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/query-metric-mql.htm). For details about MQL, see [Monitoring Query Language (MQL) Reference](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Reference/mql.htm). For available dimensions, review the metric definition for the supported service. See [Supported Services](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#SupportedServices).

        Example of threshold alarm:

        -----

        CpuUtilization[1m]{availabilityDomain="cumS:PHX-AD-1"}.groupBy(availabilityDomain).percentile(0.9) > 85

        -----

        Example of absence alarm:

        -----

        CpuUtilization[1m]{availabilityDomain="cumS:PHX-AD-1"}.absent()

        ----- Example of absence alarm with custom absence detection period of 20 hours:

        ----- CpuUtilization[1m]{availabilityDomain="cumS:PHX-AD-1"}.absent(20h) -----
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[builtins.str]:
        """
        (Updatable) A user-friendly description for this alarm override. Must be unique across all `ruleName` values for the alarm.
        """
        return pulumi.get(self, "rule_name")

    @property
    @pulumi.getter
    def severity(self) -> Optional[builtins.str]:
        """
        (Updatable) The perceived severity of the alarm with regard to the affected system.  Example: `CRITICAL`
        """
        return pulumi.get(self, "severity")


@pulumi.output_type
class AlarmSuppression(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeSuppressFrom":
            suggest = "time_suppress_from"
        elif key == "timeSuppressUntil":
            suggest = "time_suppress_until"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlarmSuppression. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlarmSuppression.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlarmSuppression.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 time_suppress_from: builtins.str,
                 time_suppress_until: builtins.str,
                 description: Optional[builtins.str] = None):
        """
        :param builtins.str time_suppress_from: (Updatable) The start date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T01:02:29.600Z`
        :param builtins.str time_suppress_until: (Updatable) The end date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T02:02:29.600Z` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param builtins.str description: (Updatable) Human-readable reason for suppressing alarm notifications. It does not have to be unique, and it's changeable. Avoid entering confidential information.
               
               Oracle recommends including tracking information for the event or associated work, such as a ticket number.
               
               Example: `Planned outage due to change IT-1234.`
        """
        pulumi.set(__self__, "time_suppress_from", time_suppress_from)
        pulumi.set(__self__, "time_suppress_until", time_suppress_until)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="timeSuppressFrom")
    def time_suppress_from(self) -> builtins.str:
        """
        (Updatable) The start date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T01:02:29.600Z`
        """
        return pulumi.get(self, "time_suppress_from")

    @property
    @pulumi.getter(name="timeSuppressUntil")
    def time_suppress_until(self) -> builtins.str:
        """
        (Updatable) The end date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T02:02:29.600Z` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_suppress_until")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        (Updatable) Human-readable reason for suppressing alarm notifications. It does not have to be unique, and it's changeable. Avoid entering confidential information.

        Oracle recommends including tracking information for the event or associated work, such as a ticket number.

        Example: `Planned outage due to change IT-1234.`
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class AlarmSuppressionAlarmSuppressionTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetType":
            suggest = "target_type"
        elif key == "alarmId":
            suggest = "alarm_id"
        elif key == "compartmentId":
            suggest = "compartment_id"
        elif key == "compartmentIdInSubtree":
            suggest = "compartment_id_in_subtree"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlarmSuppressionAlarmSuppressionTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlarmSuppressionAlarmSuppressionTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlarmSuppressionAlarmSuppressionTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_type: builtins.str,
                 alarm_id: Optional[builtins.str] = None,
                 compartment_id: Optional[builtins.str] = None,
                 compartment_id_in_subtree: Optional[builtins.bool] = None):
        """
        :param builtins.str target_type: The type of the alarm suppression target.
        :param builtins.str alarm_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the alarm that is the target of the alarm suppression.
        :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment or tenancy that is the  target of the alarm suppression. Example: `ocid1.compartment.oc1..exampleuniqueID`
        :param builtins.bool compartment_id_in_subtree: When true, the alarm suppression targets all alarms under all compartments and subcompartments of  the tenancy specified. The parameter can only be set to true when compartmentId is the tenancy OCID  (the tenancy is the root compartment). When false, the alarm suppression targets only the alarms under the specified compartment.
        """
        pulumi.set(__self__, "target_type", target_type)
        if alarm_id is not None:
            pulumi.set(__self__, "alarm_id", alarm_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree is not None:
            pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> builtins.str:
        """
        The type of the alarm suppression target.
        """
        return pulumi.get(self, "target_type")

    @property
    @pulumi.getter(name="alarmId")
    def alarm_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the alarm that is the target of the alarm suppression.
        """
        return pulumi.get(self, "alarm_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment or tenancy that is the  target of the alarm suppression. Example: `ocid1.compartment.oc1..exampleuniqueID`
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[builtins.bool]:
        """
        When true, the alarm suppression targets all alarms under all compartments and subcompartments of  the tenancy specified. The parameter can only be set to true when compartmentId is the tenancy OCID  (the tenancy is the root compartment). When false, the alarm suppression targets only the alarms under the specified compartment.
        """
        return pulumi.get(self, "compartment_id_in_subtree")


@pulumi.output_type
class AlarmSuppressionSuppressionCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conditionType":
            suggest = "condition_type"
        elif key == "suppressionDuration":
            suggest = "suppression_duration"
        elif key == "suppressionRecurrence":
            suggest = "suppression_recurrence"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlarmSuppressionSuppressionCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlarmSuppressionSuppressionCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlarmSuppressionSuppressionCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 condition_type: builtins.str,
                 suppression_duration: builtins.str,
                 suppression_recurrence: builtins.str):
        """
        :param builtins.str condition_type: Type of suppression condition.
        :param builtins.str suppression_duration: Duration of the recurring suppression. Specified as a string in ISO 8601 format. Minimum: `PT1M` (1 minute). Maximum: `PT24H` (24 hours).
        :param builtins.str suppression_recurrence: Frequency and start time of the recurring suppression. The format follows [the iCalendar specification (RFC 5545, section 3.3.10)](https://datatracker.ietf.org/doc/html/rfc5545#section-3.3.10). Supported rule parts:
               * `FREQ`: Frequency of the recurring suppression: `WEEKLY` or `DAILY` only.
               * `BYDAY`: Comma separated days. Use with weekly suppressions only. Supported values: `MO`, `TU`, `WE`, `TH`, `FR`, `SA` ,`SU`.
               * `BYHOUR`, `BYMINUTE`, `BYSECOND`: Start time in UTC, after `timeSuppressFrom` value. Default is 00:00:00 UTC after `timeSuppressFrom`.
        """
        pulumi.set(__self__, "condition_type", condition_type)
        pulumi.set(__self__, "suppression_duration", suppression_duration)
        pulumi.set(__self__, "suppression_recurrence", suppression_recurrence)

    @property
    @pulumi.getter(name="conditionType")
    def condition_type(self) -> builtins.str:
        """
        Type of suppression condition.
        """
        return pulumi.get(self, "condition_type")

    @property
    @pulumi.getter(name="suppressionDuration")
    def suppression_duration(self) -> builtins.str:
        """
        Duration of the recurring suppression. Specified as a string in ISO 8601 format. Minimum: `PT1M` (1 minute). Maximum: `PT24H` (24 hours).
        """
        return pulumi.get(self, "suppression_duration")

    @property
    @pulumi.getter(name="suppressionRecurrence")
    def suppression_recurrence(self) -> builtins.str:
        """
        Frequency and start time of the recurring suppression. The format follows [the iCalendar specification (RFC 5545, section 3.3.10)](https://datatracker.ietf.org/doc/html/rfc5545#section-3.3.10). Supported rule parts:
        * `FREQ`: Frequency of the recurring suppression: `WEEKLY` or `DAILY` only.
        * `BYDAY`: Comma separated days. Use with weekly suppressions only. Supported values: `MO`, `TU`, `WE`, `TH`, `FR`, `SA` ,`SU`.
        * `BYHOUR`, `BYMINUTE`, `BYSECOND`: Start time in UTC, after `timeSuppressFrom` value. Default is 00:00:00 UTC after `timeSuppressFrom`.
        """
        return pulumi.get(self, "suppression_recurrence")


@pulumi.output_type
class GetAlarmHistoryCollectionEntryResult(dict):
    def __init__(__self__, *,
                 alarm_summary: builtins.str,
                 summary: builtins.str,
                 timestamp: builtins.str,
                 timestamp_triggered: builtins.str):
        """
        :param builtins.str alarm_summary: Customizable alarm summary (`alarmSummary` [alarm message parameter](https://docs.cloud.oracle.com/iaas/Content/Monitoring/alarm-message-format.htm)). Optionally include [dynamic variables](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/update-alarm-dynamic-variables.htm). The alarm summary appears within the body of the alarm message and in responses to  [ListAlarmStatus](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/AlarmStatusSummary/ListAlarmsStatus)  [GetAlarmHistory](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/AlarmHistoryCollection/GetAlarmHistory) and [RetrieveDimensionStates](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/AlarmDimensionStatesCollection/RetrieveDimensionStates).
        :param builtins.str summary: Description for this alarm history entry.
        :param builtins.str timestamp: Timestamp for this alarm history entry. Format defined by RFC3339.  Example: `2023-02-01T01:02:29.600Z`
        :param builtins.str timestamp_triggered: Timestamp for the transition of the alarm state. For example, the time when the alarm transitioned from OK to Firing. Available for state transition entries only. Note: A three-minute lag for this value accounts for any late-arriving metrics.  Example: `2023-02-01T0:59:00.789Z`
        """
        pulumi.set(__self__, "alarm_summary", alarm_summary)
        pulumi.set(__self__, "summary", summary)
        pulumi.set(__self__, "timestamp", timestamp)
        pulumi.set(__self__, "timestamp_triggered", timestamp_triggered)

    @property
    @pulumi.getter(name="alarmSummary")
    def alarm_summary(self) -> builtins.str:
        """
        Customizable alarm summary (`alarmSummary` [alarm message parameter](https://docs.cloud.oracle.com/iaas/Content/Monitoring/alarm-message-format.htm)). Optionally include [dynamic variables](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/update-alarm-dynamic-variables.htm). The alarm summary appears within the body of the alarm message and in responses to  [ListAlarmStatus](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/AlarmStatusSummary/ListAlarmsStatus)  [GetAlarmHistory](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/AlarmHistoryCollection/GetAlarmHistory) and [RetrieveDimensionStates](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/AlarmDimensionStatesCollection/RetrieveDimensionStates).
        """
        return pulumi.get(self, "alarm_summary")

    @property
    @pulumi.getter
    def summary(self) -> builtins.str:
        """
        Description for this alarm history entry.
        """
        return pulumi.get(self, "summary")

    @property
    @pulumi.getter
    def timestamp(self) -> builtins.str:
        """
        Timestamp for this alarm history entry. Format defined by RFC3339.  Example: `2023-02-01T01:02:29.600Z`
        """
        return pulumi.get(self, "timestamp")

    @property
    @pulumi.getter(name="timestampTriggered")
    def timestamp_triggered(self) -> builtins.str:
        """
        Timestamp for the transition of the alarm state. For example, the time when the alarm transitioned from OK to Firing. Available for state transition entries only. Note: A three-minute lag for this value accounts for any late-arriving metrics.  Example: `2023-02-01T0:59:00.789Z`
        """
        return pulumi.get(self, "timestamp_triggered")


@pulumi.output_type
class GetAlarmOverrideResult(dict):
    def __init__(__self__, *,
                 body: builtins.str,
                 pending_duration: builtins.str,
                 query: builtins.str,
                 rule_name: builtins.str,
                 severity: builtins.str):
        """
        :param builtins.str body: The human-readable content of the delivered alarm notification. Optionally include [dynamic variables](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/update-alarm-dynamic-variables.htm). Oracle recommends providing guidance to operators for resolving the alarm condition. Consider adding links to standard runbook practices. Avoid entering confidential information.  Example: `High CPU usage alert. Follow runbook instructions for resolution.`
        :param builtins.str pending_duration: The period of time that the condition defined in the alarm must persist before the alarm state changes from "OK" to "FIRING". For example, a value of 5 minutes means that the alarm must persist in breaching the condition for five minutes before the alarm updates its state to "FIRING".
        :param builtins.str query: The Monitoring Query Language (MQL) expression to evaluate for the alarm. The Alarms feature of the Monitoring service interprets results for each returned time series as Boolean values, where zero represents false and a non-zero value represents true. A true value means that the trigger rule condition has been met. The query must specify a metric, statistic, interval, and trigger rule (threshold or absence). Supported values for interval depend on the specified time range. More interval values are supported for smaller time ranges. You can optionally specify dimensions and grouping functions. Also, you can customize the  [absence detection period](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/create-edit-alarm-query-absence-detection-period.htm). Supported grouping functions: `grouping()`, `groupBy()`. For information about writing MQL expressions, see [Editing the MQL Expression for a Query](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/query-metric-mql.htm). For details about MQL, see [Monitoring Query Language (MQL) Reference](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Reference/mql.htm). For available dimensions, review the metric definition for the supported service. See [Supported Services](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#SupportedServices).
        :param builtins.str rule_name: Identifier of the alarm's base values for alarm evaluation, for use when the alarm contains overrides.  Default value is `BASE`. For information about alarm overrides, see [AlarmOverride](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/AlarmOverride).
        :param builtins.str severity: The perceived type of response required when the alarm is in the "FIRING" state.  Example: `CRITICAL`
        """
        pulumi.set(__self__, "body", body)
        pulumi.set(__self__, "pending_duration", pending_duration)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "rule_name", rule_name)
        pulumi.set(__self__, "severity", severity)

    @property
    @pulumi.getter
    def body(self) -> builtins.str:
        """
        The human-readable content of the delivered alarm notification. Optionally include [dynamic variables](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/update-alarm-dynamic-variables.htm). Oracle recommends providing guidance to operators for resolving the alarm condition. Consider adding links to standard runbook practices. Avoid entering confidential information.  Example: `High CPU usage alert. Follow runbook instructions for resolution.`
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter(name="pendingDuration")
    def pending_duration(self) -> builtins.str:
        """
        The period of time that the condition defined in the alarm must persist before the alarm state changes from "OK" to "FIRING". For example, a value of 5 minutes means that the alarm must persist in breaching the condition for five minutes before the alarm updates its state to "FIRING".
        """
        return pulumi.get(self, "pending_duration")

    @property
    @pulumi.getter
    def query(self) -> builtins.str:
        """
        The Monitoring Query Language (MQL) expression to evaluate for the alarm. The Alarms feature of the Monitoring service interprets results for each returned time series as Boolean values, where zero represents false and a non-zero value represents true. A true value means that the trigger rule condition has been met. The query must specify a metric, statistic, interval, and trigger rule (threshold or absence). Supported values for interval depend on the specified time range. More interval values are supported for smaller time ranges. You can optionally specify dimensions and grouping functions. Also, you can customize the  [absence detection period](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/create-edit-alarm-query-absence-detection-period.htm). Supported grouping functions: `grouping()`, `groupBy()`. For information about writing MQL expressions, see [Editing the MQL Expression for a Query](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/query-metric-mql.htm). For details about MQL, see [Monitoring Query Language (MQL) Reference](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Reference/mql.htm). For available dimensions, review the metric definition for the supported service. See [Supported Services](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#SupportedServices).
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> builtins.str:
        """
        Identifier of the alarm's base values for alarm evaluation, for use when the alarm contains overrides.  Default value is `BASE`. For information about alarm overrides, see [AlarmOverride](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/AlarmOverride).
        """
        return pulumi.get(self, "rule_name")

    @property
    @pulumi.getter
    def severity(self) -> builtins.str:
        """
        The perceived type of response required when the alarm is in the "FIRING" state.  Example: `CRITICAL`
        """
        return pulumi.get(self, "severity")


@pulumi.output_type
class GetAlarmStatusesAlarmStatusResult(dict):
    def __init__(__self__, *,
                 alarm_summary: builtins.str,
                 display_name: builtins.str,
                 id: builtins.str,
                 rule_name: builtins.str,
                 severity: builtins.str,
                 status: builtins.str,
                 suppressions: Sequence['outputs.GetAlarmStatusesAlarmStatusSuppressionResult'],
                 timestamp_triggered: builtins.str):
        """
        :param builtins.str alarm_summary: Customizable alarm summary (`alarmSummary` [alarm message parameter](https://docs.cloud.oracle.com/iaas/Content/Monitoring/alarm-message-format.htm)). Optionally include [dynamic variables](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/update-alarm-dynamic-variables.htm). The alarm summary appears within the body of the alarm message and in responses to  [ListAlarmStatus](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/AlarmStatusSummary/ListAlarmsStatus)  [GetAlarmHistory](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/AlarmHistoryCollection/GetAlarmHistory) and [RetrieveDimensionStates](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/AlarmDimensionStatesCollection/RetrieveDimensionStates).
        :param builtins.str display_name: A filter to return only resources that match the given display name exactly. Use this filter to list an alarm by name. Alternatively, when you know the alarm OCID, use the GetAlarm operation.
        :param builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the alarm.
        :param builtins.str rule_name: Identifier of the alarm's base values for alarm evaluation, for use when the alarm contains overrides.  Default value is `BASE`. For information about alarm overrides, see [AlarmOverride](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/AlarmOverride).
        :param builtins.str severity: The perceived type of response required when the alarm is in the "FIRING" state.  Example: `CRITICAL`
        :param builtins.str status: The status of the metric stream to use for alarm filtering. For example, set `StatusQueryParam` to "FIRING" to filter results to metric streams of the alarm with that status. Default behaviour is to return alarms irrespective of metric streams' status.  Example: `FIRING`
        :param Sequence['GetAlarmStatusesAlarmStatusSuppressionArgs'] suppressions: The configuration details for suppressing an alarm.
        :param builtins.str timestamp_triggered: Timestamp for the transition of the alarm state. For example, the time when the alarm transitioned from OK to Firing. Note: A three-minute lag for this value accounts for any late-arriving metrics.  Example: `2023-02-01T01:02:29.600Z`
        """
        pulumi.set(__self__, "alarm_summary", alarm_summary)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "rule_name", rule_name)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "suppressions", suppressions)
        pulumi.set(__self__, "timestamp_triggered", timestamp_triggered)

    @property
    @pulumi.getter(name="alarmSummary")
    def alarm_summary(self) -> builtins.str:
        """
        Customizable alarm summary (`alarmSummary` [alarm message parameter](https://docs.cloud.oracle.com/iaas/Content/Monitoring/alarm-message-format.htm)). Optionally include [dynamic variables](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/update-alarm-dynamic-variables.htm). The alarm summary appears within the body of the alarm message and in responses to  [ListAlarmStatus](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/AlarmStatusSummary/ListAlarmsStatus)  [GetAlarmHistory](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/AlarmHistoryCollection/GetAlarmHistory) and [RetrieveDimensionStates](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/AlarmDimensionStatesCollection/RetrieveDimensionStates).
        """
        return pulumi.get(self, "alarm_summary")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the given display name exactly. Use this filter to list an alarm by name. Alternatively, when you know the alarm OCID, use the GetAlarm operation.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the alarm.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> builtins.str:
        """
        Identifier of the alarm's base values for alarm evaluation, for use when the alarm contains overrides.  Default value is `BASE`. For information about alarm overrides, see [AlarmOverride](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/AlarmOverride).
        """
        return pulumi.get(self, "rule_name")

    @property
    @pulumi.getter
    def severity(self) -> builtins.str:
        """
        The perceived type of response required when the alarm is in the "FIRING" state.  Example: `CRITICAL`
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        The status of the metric stream to use for alarm filtering. For example, set `StatusQueryParam` to "FIRING" to filter results to metric streams of the alarm with that status. Default behaviour is to return alarms irrespective of metric streams' status.  Example: `FIRING`
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def suppressions(self) -> Sequence['outputs.GetAlarmStatusesAlarmStatusSuppressionResult']:
        """
        The configuration details for suppressing an alarm.
        """
        return pulumi.get(self, "suppressions")

    @property
    @pulumi.getter(name="timestampTriggered")
    def timestamp_triggered(self) -> builtins.str:
        """
        Timestamp for the transition of the alarm state. For example, the time when the alarm transitioned from OK to Firing. Note: A three-minute lag for this value accounts for any late-arriving metrics.  Example: `2023-02-01T01:02:29.600Z`
        """
        return pulumi.get(self, "timestamp_triggered")


@pulumi.output_type
class GetAlarmStatusesAlarmStatusSuppressionResult(dict):
    def __init__(__self__, *,
                 description: builtins.str,
                 time_suppress_from: builtins.str,
                 time_suppress_until: builtins.str):
        """
        :param builtins.str description: Human-readable reason for suppressing alarm notifications. It does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param builtins.str time_suppress_from: The start date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T01:02:29.600Z`
        :param builtins.str time_suppress_until: The end date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T02:02:29.600Z`
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "time_suppress_from", time_suppress_from)
        pulumi.set(__self__, "time_suppress_until", time_suppress_until)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Human-readable reason for suppressing alarm notifications. It does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="timeSuppressFrom")
    def time_suppress_from(self) -> builtins.str:
        """
        The start date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T01:02:29.600Z`
        """
        return pulumi.get(self, "time_suppress_from")

    @property
    @pulumi.getter(name="timeSuppressUntil")
    def time_suppress_until(self) -> builtins.str:
        """
        The end date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T02:02:29.600Z`
        """
        return pulumi.get(self, "time_suppress_until")


@pulumi.output_type
class GetAlarmStatusesFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetAlarmSuppressionResult(dict):
    def __init__(__self__, *,
                 description: builtins.str,
                 time_suppress_from: builtins.str,
                 time_suppress_until: builtins.str):
        """
        :param builtins.str description: Human-readable reason for suppressing alarm notifications. It does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param builtins.str time_suppress_from: The start date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T01:02:29.600Z`
        :param builtins.str time_suppress_until: The end date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T02:02:29.600Z`
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "time_suppress_from", time_suppress_from)
        pulumi.set(__self__, "time_suppress_until", time_suppress_until)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Human-readable reason for suppressing alarm notifications. It does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="timeSuppressFrom")
    def time_suppress_from(self) -> builtins.str:
        """
        The start date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T01:02:29.600Z`
        """
        return pulumi.get(self, "time_suppress_from")

    @property
    @pulumi.getter(name="timeSuppressUntil")
    def time_suppress_until(self) -> builtins.str:
        """
        The end date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T02:02:29.600Z`
        """
        return pulumi.get(self, "time_suppress_until")


@pulumi.output_type
class GetAlarmSuppressionAlarmSuppressionTargetResult(dict):
    def __init__(__self__, *,
                 alarm_id: builtins.str,
                 compartment_id: builtins.str,
                 compartment_id_in_subtree: builtins.bool,
                 target_type: builtins.str):
        """
        :param builtins.str alarm_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the alarm that is the target of the alarm suppression.
        :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the alarm suppression.
        :param builtins.bool compartment_id_in_subtree: When true, the alarm suppression targets all alarms under all compartments and subcompartments of  the tenancy specified. The parameter can only be set to true when compartmentId is the tenancy OCID  (the tenancy is the root compartment). When false, the alarm suppression targets only the alarms under the specified compartment.
        :param builtins.str target_type: The type of the alarm suppression target.
        """
        pulumi.set(__self__, "alarm_id", alarm_id)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        pulumi.set(__self__, "target_type", target_type)

    @property
    @pulumi.getter(name="alarmId")
    def alarm_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the alarm that is the target of the alarm suppression.
        """
        return pulumi.get(self, "alarm_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the alarm suppression.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> builtins.bool:
        """
        When true, the alarm suppression targets all alarms under all compartments and subcompartments of  the tenancy specified. The parameter can only be set to true when compartmentId is the tenancy OCID  (the tenancy is the root compartment). When false, the alarm suppression targets only the alarms under the specified compartment.
        """
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> builtins.str:
        """
        The type of the alarm suppression target.
        """
        return pulumi.get(self, "target_type")


@pulumi.output_type
class GetAlarmSuppressionSuppressionConditionResult(dict):
    def __init__(__self__, *,
                 condition_type: builtins.str,
                 suppression_duration: builtins.str,
                 suppression_recurrence: builtins.str):
        """
        :param builtins.str condition_type: Type of suppression condition.
        :param builtins.str suppression_duration: Duration of the recurring suppression. Specified as a string in ISO 8601 format. Minimum: `PT1M` (1 minute). Maximum: `PT24H` (24 hours).
        :param builtins.str suppression_recurrence: Frequency and start time of the recurring suppression. The format follows [the iCalendar specification (RFC 5545, section 3.3.10)](https://datatracker.ietf.org/doc/html/rfc5545#section-3.3.10). Supported rule parts:
               * `FREQ`: Frequency of the recurring suppression: `WEEKLY` or `DAILY` only.
               * `BYDAY`: Comma separated days. Use with weekly suppressions only. Supported values: `MO`, `TU`, `WE`, `TH`, `FR`, `SA` ,`SU`.
               * `BYHOUR`, `BYMINUTE`, `BYSECOND`: Start time in UTC, after `timeSuppressFrom` value. Default is 00:00:00 UTC after `timeSuppressFrom`.
        """
        pulumi.set(__self__, "condition_type", condition_type)
        pulumi.set(__self__, "suppression_duration", suppression_duration)
        pulumi.set(__self__, "suppression_recurrence", suppression_recurrence)

    @property
    @pulumi.getter(name="conditionType")
    def condition_type(self) -> builtins.str:
        """
        Type of suppression condition.
        """
        return pulumi.get(self, "condition_type")

    @property
    @pulumi.getter(name="suppressionDuration")
    def suppression_duration(self) -> builtins.str:
        """
        Duration of the recurring suppression. Specified as a string in ISO 8601 format. Minimum: `PT1M` (1 minute). Maximum: `PT24H` (24 hours).
        """
        return pulumi.get(self, "suppression_duration")

    @property
    @pulumi.getter(name="suppressionRecurrence")
    def suppression_recurrence(self) -> builtins.str:
        """
        Frequency and start time of the recurring suppression. The format follows [the iCalendar specification (RFC 5545, section 3.3.10)](https://datatracker.ietf.org/doc/html/rfc5545#section-3.3.10). Supported rule parts:
        * `FREQ`: Frequency of the recurring suppression: `WEEKLY` or `DAILY` only.
        * `BYDAY`: Comma separated days. Use with weekly suppressions only. Supported values: `MO`, `TU`, `WE`, `TH`, `FR`, `SA` ,`SU`.
        * `BYHOUR`, `BYMINUTE`, `BYSECOND`: Start time in UTC, after `timeSuppressFrom` value. Default is 00:00:00 UTC after `timeSuppressFrom`.
        """
        return pulumi.get(self, "suppression_recurrence")


@pulumi.output_type
class GetAlarmSuppressionsAlarmSuppressionCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetAlarmSuppressionsAlarmSuppressionCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetAlarmSuppressionsAlarmSuppressionCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetAlarmSuppressionsAlarmSuppressionCollectionItemResult(dict):
    def __init__(__self__, *,
                 alarm_suppression_targets: Sequence['outputs.GetAlarmSuppressionsAlarmSuppressionCollectionItemAlarmSuppressionTargetResult'],
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 description: builtins.str,
                 dimensions: Mapping[str, builtins.str],
                 display_name: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 level: builtins.str,
                 state: builtins.str,
                 suppression_conditions: Sequence['outputs.GetAlarmSuppressionsAlarmSuppressionCollectionItemSuppressionConditionResult'],
                 time_created: builtins.str,
                 time_suppress_from: builtins.str,
                 time_suppress_until: builtins.str,
                 time_updated: builtins.str):
        """
        :param Sequence['GetAlarmSuppressionsAlarmSuppressionCollectionItemAlarmSuppressionTargetArgs'] alarm_suppression_targets: The target of the alarm suppression.
        :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment for searching.  Use the tenancy OCID to search in the root compartment.
               
               If targetType is not specified, searches all suppressions defined under the compartment.  If targetType is `COMPARTMENT`, searches suppressions in the specified compartment only.
               
               Example: `ocid1.compartment.oc1..exampleuniqueID`
        :param Mapping[str, builtins.str] defined_tags: Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"Operations.CostCenter": "42"}`
        :param builtins.str description: Human-readable reason for this alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param Mapping[str, builtins.str] dimensions: Configured dimension filter for suppressing alarm state entries that include the set of specified dimension key-value pairs.  Example: `{"resourceId": "instance.region1.phx.exampleuniqueID"}`
        :param builtins.str display_name: A filter to return only resources that match the given display name exactly. Use this filter to list an alarm suppression by name. Alternatively, when you know the alarm suppression OCID, use the GetAlarmSuppression operation.
        :param Mapping[str, builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        :param builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the alarm suppression.
        :param builtins.str level: The level of this alarm suppression. `ALARM` indicates a suppression of the entire alarm, regardless of dimension. `DIMENSION` indicates a suppression configured for specified dimensions.
        :param builtins.str state: A filter to return only resources that match the given lifecycle state exactly. When not specified, only resources in the ACTIVE lifecycle state are listed.
        :param Sequence['GetAlarmSuppressionsAlarmSuppressionCollectionItemSuppressionConditionArgs'] suppression_conditions: Array of all preconditions for alarm suppression. Example: `[{ conditionType: "RECURRENCE", suppressionRecurrence: "FRQ=DAILY;BYHOUR=10", suppressionDuration: "PT1H" }]`
        :param builtins.str time_created: The date and time the alarm suppression was created. Format defined by RFC3339.  Example: `2018-02-01T01:02:29.600Z`
        :param builtins.str time_suppress_from: The start date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2018-02-01T01:02:29.600Z`
        :param builtins.str time_suppress_until: The end date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2018-02-01T02:02:29.600Z`
        :param builtins.str time_updated: The date and time the alarm suppression was last updated (deleted). Format defined by RFC3339.  Example: `2018-02-03T01:02:29.600Z`
        """
        pulumi.set(__self__, "alarm_suppression_targets", alarm_suppression_targets)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "dimensions", dimensions)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "level", level)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "suppression_conditions", suppression_conditions)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_suppress_from", time_suppress_from)
        pulumi.set(__self__, "time_suppress_until", time_suppress_until)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="alarmSuppressionTargets")
    def alarm_suppression_targets(self) -> Sequence['outputs.GetAlarmSuppressionsAlarmSuppressionCollectionItemAlarmSuppressionTargetResult']:
        """
        The target of the alarm suppression.
        """
        return pulumi.get(self, "alarm_suppression_targets")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment for searching.  Use the tenancy OCID to search in the root compartment.

        If targetType is not specified, searches all suppressions defined under the compartment.  If targetType is `COMPARTMENT`, searches suppressions in the specified compartment only.

        Example: `ocid1.compartment.oc1..exampleuniqueID`
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Human-readable reason for this alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def dimensions(self) -> Mapping[str, builtins.str]:
        """
        Configured dimension filter for suppressing alarm state entries that include the set of specified dimension key-value pairs.  Example: `{"resourceId": "instance.region1.phx.exampleuniqueID"}`
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the given display name exactly. Use this filter to list an alarm suppression by name. Alternatively, when you know the alarm suppression OCID, use the GetAlarmSuppression operation.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the alarm suppression.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def level(self) -> builtins.str:
        """
        The level of this alarm suppression. `ALARM` indicates a suppression of the entire alarm, regardless of dimension. `DIMENSION` indicates a suppression configured for specified dimensions.
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        A filter to return only resources that match the given lifecycle state exactly. When not specified, only resources in the ACTIVE lifecycle state are listed.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="suppressionConditions")
    def suppression_conditions(self) -> Sequence['outputs.GetAlarmSuppressionsAlarmSuppressionCollectionItemSuppressionConditionResult']:
        """
        Array of all preconditions for alarm suppression. Example: `[{ conditionType: "RECURRENCE", suppressionRecurrence: "FRQ=DAILY;BYHOUR=10", suppressionDuration: "PT1H" }]`
        """
        return pulumi.get(self, "suppression_conditions")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the alarm suppression was created. Format defined by RFC3339.  Example: `2018-02-01T01:02:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeSuppressFrom")
    def time_suppress_from(self) -> builtins.str:
        """
        The start date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2018-02-01T01:02:29.600Z`
        """
        return pulumi.get(self, "time_suppress_from")

    @property
    @pulumi.getter(name="timeSuppressUntil")
    def time_suppress_until(self) -> builtins.str:
        """
        The end date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2018-02-01T02:02:29.600Z`
        """
        return pulumi.get(self, "time_suppress_until")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the alarm suppression was last updated (deleted). Format defined by RFC3339.  Example: `2018-02-03T01:02:29.600Z`
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetAlarmSuppressionsAlarmSuppressionCollectionItemAlarmSuppressionTargetResult(dict):
    def __init__(__self__, *,
                 alarm_id: builtins.str,
                 compartment_id: builtins.str,
                 compartment_id_in_subtree: builtins.bool,
                 target_type: builtins.str):
        """
        :param builtins.str alarm_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the alarm that is the target of the alarm suppression.
        :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment for searching.  Use the tenancy OCID to search in the root compartment.
               
               If targetType is not specified, searches all suppressions defined under the compartment.  If targetType is `COMPARTMENT`, searches suppressions in the specified compartment only.
               
               Example: `ocid1.compartment.oc1..exampleuniqueID`
        :param builtins.bool compartment_id_in_subtree: When true, returns resources from all compartments and subcompartments. The parameter can only be set to true when compartmentId is the tenancy OCID (the tenancy is the root compartment). A true value requires the user to have tenancy-level permissions. If this requirement is not met, then the call is rejected. When false, returns resources from only the compartment specified in compartmentId. Default is false.
        :param builtins.str target_type: The target type to use when listing alarm suppressions.     `ALARM` lists all suppression records for the specified alarm. `COMPARTMENT` lists all suppression records for the specified compartment or tenancy.
        """
        pulumi.set(__self__, "alarm_id", alarm_id)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        pulumi.set(__self__, "target_type", target_type)

    @property
    @pulumi.getter(name="alarmId")
    def alarm_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the alarm that is the target of the alarm suppression.
        """
        return pulumi.get(self, "alarm_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment for searching.  Use the tenancy OCID to search in the root compartment.

        If targetType is not specified, searches all suppressions defined under the compartment.  If targetType is `COMPARTMENT`, searches suppressions in the specified compartment only.

        Example: `ocid1.compartment.oc1..exampleuniqueID`
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> builtins.bool:
        """
        When true, returns resources from all compartments and subcompartments. The parameter can only be set to true when compartmentId is the tenancy OCID (the tenancy is the root compartment). A true value requires the user to have tenancy-level permissions. If this requirement is not met, then the call is rejected. When false, returns resources from only the compartment specified in compartmentId. Default is false.
        """
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> builtins.str:
        """
        The target type to use when listing alarm suppressions.     `ALARM` lists all suppression records for the specified alarm. `COMPARTMENT` lists all suppression records for the specified compartment or tenancy.
        """
        return pulumi.get(self, "target_type")


@pulumi.output_type
class GetAlarmSuppressionsAlarmSuppressionCollectionItemSuppressionConditionResult(dict):
    def __init__(__self__, *,
                 condition_type: builtins.str,
                 suppression_duration: builtins.str,
                 suppression_recurrence: builtins.str):
        """
        :param builtins.str condition_type: Type of suppression condition.
        :param builtins.str suppression_duration: Duration of the recurring suppression. Specified as a string in ISO 8601 format. Minimum: `PT1M` (1 minute). Maximum: `PT24H` (24 hours).
        :param builtins.str suppression_recurrence: Frequency and start time of the recurring suppression. The format follows [the iCalendar specification (RFC 5545, section 3.3.10)](https://datatracker.ietf.org/doc/html/rfc5545#section-3.3.10). Supported rule parts:
               * `FREQ`: Frequency of the recurring suppression: `WEEKLY` or `DAILY` only.
               * `BYDAY`: Comma separated days. Use with weekly suppressions only. Supported values: `MO`, `TU`, `WE`, `TH`, `FR`, `SA` ,`SU`.
               * `BYHOUR`, `BYMINUTE`, `BYSECOND`: Start time in UTC, after `timeSuppressFrom` value. Default is 00:00:00 UTC after `timeSuppressFrom`.
        """
        pulumi.set(__self__, "condition_type", condition_type)
        pulumi.set(__self__, "suppression_duration", suppression_duration)
        pulumi.set(__self__, "suppression_recurrence", suppression_recurrence)

    @property
    @pulumi.getter(name="conditionType")
    def condition_type(self) -> builtins.str:
        """
        Type of suppression condition.
        """
        return pulumi.get(self, "condition_type")

    @property
    @pulumi.getter(name="suppressionDuration")
    def suppression_duration(self) -> builtins.str:
        """
        Duration of the recurring suppression. Specified as a string in ISO 8601 format. Minimum: `PT1M` (1 minute). Maximum: `PT24H` (24 hours).
        """
        return pulumi.get(self, "suppression_duration")

    @property
    @pulumi.getter(name="suppressionRecurrence")
    def suppression_recurrence(self) -> builtins.str:
        """
        Frequency and start time of the recurring suppression. The format follows [the iCalendar specification (RFC 5545, section 3.3.10)](https://datatracker.ietf.org/doc/html/rfc5545#section-3.3.10). Supported rule parts:
        * `FREQ`: Frequency of the recurring suppression: `WEEKLY` or `DAILY` only.
        * `BYDAY`: Comma separated days. Use with weekly suppressions only. Supported values: `MO`, `TU`, `WE`, `TH`, `FR`, `SA` ,`SU`.
        * `BYHOUR`, `BYMINUTE`, `BYSECOND`: Start time in UTC, after `timeSuppressFrom` value. Default is 00:00:00 UTC after `timeSuppressFrom`.
        """
        return pulumi.get(self, "suppression_recurrence")


@pulumi.output_type
class GetAlarmSuppressionsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetAlarmsAlarmResult(dict):
    def __init__(__self__, *,
                 alarm_summary: builtins.str,
                 body: builtins.str,
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 destinations: Sequence[builtins.str],
                 display_name: builtins.str,
                 evaluation_slack_duration: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 is_enabled: builtins.bool,
                 is_notifications_per_metric_dimension_enabled: builtins.bool,
                 message_format: builtins.str,
                 metric_compartment_id: builtins.str,
                 metric_compartment_id_in_subtree: builtins.bool,
                 namespace: builtins.str,
                 notification_title: builtins.str,
                 notification_version: builtins.str,
                 overrides: Sequence['outputs.GetAlarmsAlarmOverrideResult'],
                 pending_duration: builtins.str,
                 query: builtins.str,
                 repeat_notification_duration: builtins.str,
                 resolution: builtins.str,
                 resource_group: builtins.str,
                 rule_name: builtins.str,
                 severity: builtins.str,
                 state: builtins.str,
                 suppressions: Sequence['outputs.GetAlarmsAlarmSuppressionResult'],
                 time_created: builtins.str,
                 time_updated: builtins.str):
        """
        :param builtins.str alarm_summary: Customizable alarm summary (`alarmSummary` [alarm message parameter](https://docs.cloud.oracle.com/iaas/Content/Monitoring/alarm-message-format.htm)). Optionally include [dynamic variables](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/update-alarm-dynamic-variables.htm). The alarm summary appears within the body of the alarm message and in responses to  [ListAlarmStatus](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/AlarmStatusSummary/ListAlarmsStatus)  [GetAlarmHistory](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/AlarmHistoryCollection/GetAlarmHistory) and [RetrieveDimensionStates](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/AlarmDimensionStatesCollection/RetrieveDimensionStates).
        :param builtins.str body: The human-readable content of the delivered alarm notification. Optionally include [dynamic variables](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/update-alarm-dynamic-variables.htm). Oracle recommends providing guidance to operators for resolving the alarm condition. Consider adding links to standard runbook practices. Avoid entering confidential information.  Example: `High CPU usage alert. Follow runbook instructions for resolution.`
        :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the resources monitored by the metric that you are searching for. Use tenancyId to search in the root compartment.  Example: `ocid1.compartment.oc1..exampleuniqueID`
        :param Mapping[str, builtins.str] defined_tags: Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"Operations.CostCenter": "42"}`
        :param Sequence[builtins.str] destinations: A list of destinations for alarm notifications. Each destination is represented by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a related resource, such as a [topic](https://docs.cloud.oracle.com/iaas/api/#/en/notification/latest/NotificationTopic). Supported destination services: Notifications, Streaming. Limit: One destination per supported destination service.
        :param builtins.str display_name: A filter to return only resources that match the given display name exactly. Use this filter to list an alarm by name. Alternatively, when you know the alarm OCID, use the GetAlarm operation.
        :param builtins.str evaluation_slack_duration: Customizable slack period to wait for metric ingestion before evaluating the alarm. Specify a string in ISO 8601 format (`PT10M` for ten minutes or `PT1H` for one hour). Minimum: PT3M. Maximum: PT2H. Default: PT3M. For more information about the slack period, see [About the Internal Reset Period](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#reset).
        :param Mapping[str, builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        :param builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the alarm.
        :param builtins.bool is_enabled: Whether the alarm is enabled.  Example: `true`
        :param builtins.bool is_notifications_per_metric_dimension_enabled: Whether the alarm sends a separate message for each metric stream. See [Creating an Alarm That Splits Messages by Metric Stream](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/create-alarm-split.htm). Example: `true`
        :param builtins.str message_format: The format to use for alarm notifications. The formats are:
               * `RAW` - Raw JSON blob. Default value. When the `destinations` attribute specifies `Streaming`, all alarm notifications use this format.
               * `PRETTY_JSON`: JSON with new lines and indents. Available when the `destinations` attribute specifies `Notifications` only.
               * `ONS_OPTIMIZED`: Simplified, user-friendly layout. Available when the `destinations` attribute specifies `Notifications` only. Applies to Email subscription types only.
        :param builtins.str metric_compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the metric being evaluated by the alarm.
        :param builtins.bool metric_compartment_id_in_subtree: When true, the alarm evaluates metrics from all compartments and subcompartments. The parameter can only be set to true when metricCompartmentId is the tenancy OCID (the tenancy is the root compartment). A true value requires the user to have tenancy-level permissions. If this requirement is not met, then the call is rejected. When false, the alarm evaluates metrics from only the compartment specified in metricCompartmentId. Default is false.  Example: `true`
        :param builtins.str namespace: The source service or application emitting the metric that is evaluated by the alarm.  Example: `oci_computeagent`
        :param builtins.str notification_title: Customizable notification title (`title` [alarm message parameter](https://docs.cloud.oracle.com/iaas/Content/Monitoring/alarm-message-format.htm)). Optionally include [dynamic variables](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/update-alarm-dynamic-variables.htm). The notification title appears as the subject line in a formatted email message and as the title in a Slack message.
        :param builtins.str notification_version: The version of the alarm notification to be delivered. Allowed value: `1.X` The value must start with a number (up to four digits), followed by a period and an uppercase X.
        :param Sequence['GetAlarmsAlarmOverrideArgs'] overrides: A set of overrides that control evaluations of the alarm.
        :param builtins.str pending_duration: The period of time that the condition defined in the alarm must persist before the alarm state changes from "OK" to "FIRING". For example, a value of 5 minutes means that the alarm must persist in breaching the condition for five minutes before the alarm updates its state to "FIRING".
        :param builtins.str query: The Monitoring Query Language (MQL) expression to evaluate for the alarm. The Alarms feature of the Monitoring service interprets results for each returned time series as Boolean values, where zero represents false and a non-zero value represents true. A true value means that the trigger rule condition has been met. The query must specify a metric, statistic, interval, and trigger rule (threshold or absence). Supported values for interval depend on the specified time range. More interval values are supported for smaller time ranges. You can optionally specify dimensions and grouping functions. Also, you can customize the  [absence detection period](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/create-edit-alarm-query-absence-detection-period.htm). Supported grouping functions: `grouping()`, `groupBy()`. For information about writing MQL expressions, see [Editing the MQL Expression for a Query](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/query-metric-mql.htm). For details about MQL, see [Monitoring Query Language (MQL) Reference](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Reference/mql.htm). For available dimensions, review the metric definition for the supported service. See [Supported Services](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#SupportedServices).
        :param builtins.str repeat_notification_duration: The frequency for re-submitting alarm notifications, if the alarm keeps firing without interruption. Format defined by ISO 8601. For example, `PT4H` indicates four hours. Minimum: PT1M. Maximum: P30D.
        :param builtins.str resolution: The time between calculated aggregation windows for the alarm. Supported value: `1m`
        :param builtins.str resource_group: Resource group that you want to match. A null value returns only metric data that has no resource groups. The specified resource group must exist in the definition of the posted metric. Only one resource group can be applied per metric. A valid resourceGroup value starts with an alphabetical character and includes only alphanumeric characters, periods (.), underscores (_), hyphens (-), and dollar signs ($).  Example: `frontend-fleet`
        :param builtins.str rule_name: Identifier of the alarm's base values for alarm evaluation, for use when the alarm contains overrides.  Default value is `BASE`. For information about alarm overrides, see [AlarmOverride](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/AlarmOverride).
        :param builtins.str severity: The perceived type of response required when the alarm is in the "FIRING" state.  Example: `CRITICAL`
        :param builtins.str state: A filter to return only alarms that match the given lifecycle state exactly. When not specified, only alarms in the ACTIVE lifecycle state are listed.
        :param Sequence['GetAlarmsAlarmSuppressionArgs'] suppressions: The configuration details for suppressing an alarm.
        :param builtins.str time_created: The date and time the alarm was created. Format defined by RFC3339.  Example: `2023-02-01T01:02:29.600Z`
        :param builtins.str time_updated: The date and time the alarm was last updated. Format defined by RFC3339.  Example: `2023-02-03T01:02:29.600Z`
        """
        pulumi.set(__self__, "alarm_summary", alarm_summary)
        pulumi.set(__self__, "body", body)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "destinations", destinations)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "evaluation_slack_duration", evaluation_slack_duration)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "is_notifications_per_metric_dimension_enabled", is_notifications_per_metric_dimension_enabled)
        pulumi.set(__self__, "message_format", message_format)
        pulumi.set(__self__, "metric_compartment_id", metric_compartment_id)
        pulumi.set(__self__, "metric_compartment_id_in_subtree", metric_compartment_id_in_subtree)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "notification_title", notification_title)
        pulumi.set(__self__, "notification_version", notification_version)
        pulumi.set(__self__, "overrides", overrides)
        pulumi.set(__self__, "pending_duration", pending_duration)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "repeat_notification_duration", repeat_notification_duration)
        pulumi.set(__self__, "resolution", resolution)
        pulumi.set(__self__, "resource_group", resource_group)
        pulumi.set(__self__, "rule_name", rule_name)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "suppressions", suppressions)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="alarmSummary")
    def alarm_summary(self) -> builtins.str:
        """
        Customizable alarm summary (`alarmSummary` [alarm message parameter](https://docs.cloud.oracle.com/iaas/Content/Monitoring/alarm-message-format.htm)). Optionally include [dynamic variables](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/update-alarm-dynamic-variables.htm). The alarm summary appears within the body of the alarm message and in responses to  [ListAlarmStatus](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/AlarmStatusSummary/ListAlarmsStatus)  [GetAlarmHistory](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/AlarmHistoryCollection/GetAlarmHistory) and [RetrieveDimensionStates](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/AlarmDimensionStatesCollection/RetrieveDimensionStates).
        """
        return pulumi.get(self, "alarm_summary")

    @property
    @pulumi.getter
    def body(self) -> builtins.str:
        """
        The human-readable content of the delivered alarm notification. Optionally include [dynamic variables](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/update-alarm-dynamic-variables.htm). Oracle recommends providing guidance to operators for resolving the alarm condition. Consider adding links to standard runbook practices. Avoid entering confidential information.  Example: `High CPU usage alert. Follow runbook instructions for resolution.`
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the resources monitored by the metric that you are searching for. Use tenancyId to search in the root compartment.  Example: `ocid1.compartment.oc1..exampleuniqueID`
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def destinations(self) -> Sequence[builtins.str]:
        """
        A list of destinations for alarm notifications. Each destination is represented by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a related resource, such as a [topic](https://docs.cloud.oracle.com/iaas/api/#/en/notification/latest/NotificationTopic). Supported destination services: Notifications, Streaming. Limit: One destination per supported destination service.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the given display name exactly. Use this filter to list an alarm by name. Alternatively, when you know the alarm OCID, use the GetAlarm operation.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="evaluationSlackDuration")
    def evaluation_slack_duration(self) -> builtins.str:
        """
        Customizable slack period to wait for metric ingestion before evaluating the alarm. Specify a string in ISO 8601 format (`PT10M` for ten minutes or `PT1H` for one hour). Minimum: PT3M. Maximum: PT2H. Default: PT3M. For more information about the slack period, see [About the Internal Reset Period](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#reset).
        """
        return pulumi.get(self, "evaluation_slack_duration")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the alarm.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> builtins.bool:
        """
        Whether the alarm is enabled.  Example: `true`
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="isNotificationsPerMetricDimensionEnabled")
    def is_notifications_per_metric_dimension_enabled(self) -> builtins.bool:
        """
        Whether the alarm sends a separate message for each metric stream. See [Creating an Alarm That Splits Messages by Metric Stream](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/create-alarm-split.htm). Example: `true`
        """
        return pulumi.get(self, "is_notifications_per_metric_dimension_enabled")

    @property
    @pulumi.getter(name="messageFormat")
    def message_format(self) -> builtins.str:
        """
        The format to use for alarm notifications. The formats are:
        * `RAW` - Raw JSON blob. Default value. When the `destinations` attribute specifies `Streaming`, all alarm notifications use this format.
        * `PRETTY_JSON`: JSON with new lines and indents. Available when the `destinations` attribute specifies `Notifications` only.
        * `ONS_OPTIMIZED`: Simplified, user-friendly layout. Available when the `destinations` attribute specifies `Notifications` only. Applies to Email subscription types only.
        """
        return pulumi.get(self, "message_format")

    @property
    @pulumi.getter(name="metricCompartmentId")
    def metric_compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the metric being evaluated by the alarm.
        """
        return pulumi.get(self, "metric_compartment_id")

    @property
    @pulumi.getter(name="metricCompartmentIdInSubtree")
    def metric_compartment_id_in_subtree(self) -> builtins.bool:
        """
        When true, the alarm evaluates metrics from all compartments and subcompartments. The parameter can only be set to true when metricCompartmentId is the tenancy OCID (the tenancy is the root compartment). A true value requires the user to have tenancy-level permissions. If this requirement is not met, then the call is rejected. When false, the alarm evaluates metrics from only the compartment specified in metricCompartmentId. Default is false.  Example: `true`
        """
        return pulumi.get(self, "metric_compartment_id_in_subtree")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        The source service or application emitting the metric that is evaluated by the alarm.  Example: `oci_computeagent`
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="notificationTitle")
    def notification_title(self) -> builtins.str:
        """
        Customizable notification title (`title` [alarm message parameter](https://docs.cloud.oracle.com/iaas/Content/Monitoring/alarm-message-format.htm)). Optionally include [dynamic variables](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/update-alarm-dynamic-variables.htm). The notification title appears as the subject line in a formatted email message and as the title in a Slack message.
        """
        return pulumi.get(self, "notification_title")

    @property
    @pulumi.getter(name="notificationVersion")
    def notification_version(self) -> builtins.str:
        """
        The version of the alarm notification to be delivered. Allowed value: `1.X` The value must start with a number (up to four digits), followed by a period and an uppercase X.
        """
        return pulumi.get(self, "notification_version")

    @property
    @pulumi.getter
    def overrides(self) -> Sequence['outputs.GetAlarmsAlarmOverrideResult']:
        """
        A set of overrides that control evaluations of the alarm.
        """
        return pulumi.get(self, "overrides")

    @property
    @pulumi.getter(name="pendingDuration")
    def pending_duration(self) -> builtins.str:
        """
        The period of time that the condition defined in the alarm must persist before the alarm state changes from "OK" to "FIRING". For example, a value of 5 minutes means that the alarm must persist in breaching the condition for five minutes before the alarm updates its state to "FIRING".
        """
        return pulumi.get(self, "pending_duration")

    @property
    @pulumi.getter
    def query(self) -> builtins.str:
        """
        The Monitoring Query Language (MQL) expression to evaluate for the alarm. The Alarms feature of the Monitoring service interprets results for each returned time series as Boolean values, where zero represents false and a non-zero value represents true. A true value means that the trigger rule condition has been met. The query must specify a metric, statistic, interval, and trigger rule (threshold or absence). Supported values for interval depend on the specified time range. More interval values are supported for smaller time ranges. You can optionally specify dimensions and grouping functions. Also, you can customize the  [absence detection period](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/create-edit-alarm-query-absence-detection-period.htm). Supported grouping functions: `grouping()`, `groupBy()`. For information about writing MQL expressions, see [Editing the MQL Expression for a Query](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/query-metric-mql.htm). For details about MQL, see [Monitoring Query Language (MQL) Reference](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Reference/mql.htm). For available dimensions, review the metric definition for the supported service. See [Supported Services](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#SupportedServices).
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="repeatNotificationDuration")
    def repeat_notification_duration(self) -> builtins.str:
        """
        The frequency for re-submitting alarm notifications, if the alarm keeps firing without interruption. Format defined by ISO 8601. For example, `PT4H` indicates four hours. Minimum: PT1M. Maximum: P30D.
        """
        return pulumi.get(self, "repeat_notification_duration")

    @property
    @pulumi.getter
    def resolution(self) -> builtins.str:
        """
        The time between calculated aggregation windows for the alarm. Supported value: `1m`
        """
        return pulumi.get(self, "resolution")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> builtins.str:
        """
        Resource group that you want to match. A null value returns only metric data that has no resource groups. The specified resource group must exist in the definition of the posted metric. Only one resource group can be applied per metric. A valid resourceGroup value starts with an alphabetical character and includes only alphanumeric characters, periods (.), underscores (_), hyphens (-), and dollar signs ($).  Example: `frontend-fleet`
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> builtins.str:
        """
        Identifier of the alarm's base values for alarm evaluation, for use when the alarm contains overrides.  Default value is `BASE`. For information about alarm overrides, see [AlarmOverride](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/AlarmOverride).
        """
        return pulumi.get(self, "rule_name")

    @property
    @pulumi.getter
    def severity(self) -> builtins.str:
        """
        The perceived type of response required when the alarm is in the "FIRING" state.  Example: `CRITICAL`
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        A filter to return only alarms that match the given lifecycle state exactly. When not specified, only alarms in the ACTIVE lifecycle state are listed.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def suppressions(self) -> Sequence['outputs.GetAlarmsAlarmSuppressionResult']:
        """
        The configuration details for suppressing an alarm.
        """
        return pulumi.get(self, "suppressions")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the alarm was created. Format defined by RFC3339.  Example: `2023-02-01T01:02:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the alarm was last updated. Format defined by RFC3339.  Example: `2023-02-03T01:02:29.600Z`
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetAlarmsAlarmOverrideResult(dict):
    def __init__(__self__, *,
                 body: builtins.str,
                 pending_duration: builtins.str,
                 query: builtins.str,
                 rule_name: builtins.str,
                 severity: builtins.str):
        """
        :param builtins.str body: The human-readable content of the delivered alarm notification. Optionally include [dynamic variables](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/update-alarm-dynamic-variables.htm). Oracle recommends providing guidance to operators for resolving the alarm condition. Consider adding links to standard runbook practices. Avoid entering confidential information.  Example: `High CPU usage alert. Follow runbook instructions for resolution.`
        :param builtins.str pending_duration: The period of time that the condition defined in the alarm must persist before the alarm state changes from "OK" to "FIRING". For example, a value of 5 minutes means that the alarm must persist in breaching the condition for five minutes before the alarm updates its state to "FIRING".
        :param builtins.str query: The Monitoring Query Language (MQL) expression to evaluate for the alarm. The Alarms feature of the Monitoring service interprets results for each returned time series as Boolean values, where zero represents false and a non-zero value represents true. A true value means that the trigger rule condition has been met. The query must specify a metric, statistic, interval, and trigger rule (threshold or absence). Supported values for interval depend on the specified time range. More interval values are supported for smaller time ranges. You can optionally specify dimensions and grouping functions. Also, you can customize the  [absence detection period](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/create-edit-alarm-query-absence-detection-period.htm). Supported grouping functions: `grouping()`, `groupBy()`. For information about writing MQL expressions, see [Editing the MQL Expression for a Query](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/query-metric-mql.htm). For details about MQL, see [Monitoring Query Language (MQL) Reference](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Reference/mql.htm). For available dimensions, review the metric definition for the supported service. See [Supported Services](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#SupportedServices).
        :param builtins.str rule_name: Identifier of the alarm's base values for alarm evaluation, for use when the alarm contains overrides.  Default value is `BASE`. For information about alarm overrides, see [AlarmOverride](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/AlarmOverride).
        :param builtins.str severity: The perceived type of response required when the alarm is in the "FIRING" state.  Example: `CRITICAL`
        """
        pulumi.set(__self__, "body", body)
        pulumi.set(__self__, "pending_duration", pending_duration)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "rule_name", rule_name)
        pulumi.set(__self__, "severity", severity)

    @property
    @pulumi.getter
    def body(self) -> builtins.str:
        """
        The human-readable content of the delivered alarm notification. Optionally include [dynamic variables](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/update-alarm-dynamic-variables.htm). Oracle recommends providing guidance to operators for resolving the alarm condition. Consider adding links to standard runbook practices. Avoid entering confidential information.  Example: `High CPU usage alert. Follow runbook instructions for resolution.`
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter(name="pendingDuration")
    def pending_duration(self) -> builtins.str:
        """
        The period of time that the condition defined in the alarm must persist before the alarm state changes from "OK" to "FIRING". For example, a value of 5 minutes means that the alarm must persist in breaching the condition for five minutes before the alarm updates its state to "FIRING".
        """
        return pulumi.get(self, "pending_duration")

    @property
    @pulumi.getter
    def query(self) -> builtins.str:
        """
        The Monitoring Query Language (MQL) expression to evaluate for the alarm. The Alarms feature of the Monitoring service interprets results for each returned time series as Boolean values, where zero represents false and a non-zero value represents true. A true value means that the trigger rule condition has been met. The query must specify a metric, statistic, interval, and trigger rule (threshold or absence). Supported values for interval depend on the specified time range. More interval values are supported for smaller time ranges. You can optionally specify dimensions and grouping functions. Also, you can customize the  [absence detection period](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/create-edit-alarm-query-absence-detection-period.htm). Supported grouping functions: `grouping()`, `groupBy()`. For information about writing MQL expressions, see [Editing the MQL Expression for a Query](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/query-metric-mql.htm). For details about MQL, see [Monitoring Query Language (MQL) Reference](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Reference/mql.htm). For available dimensions, review the metric definition for the supported service. See [Supported Services](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#SupportedServices).
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> builtins.str:
        """
        Identifier of the alarm's base values for alarm evaluation, for use when the alarm contains overrides.  Default value is `BASE`. For information about alarm overrides, see [AlarmOverride](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/AlarmOverride).
        """
        return pulumi.get(self, "rule_name")

    @property
    @pulumi.getter
    def severity(self) -> builtins.str:
        """
        The perceived type of response required when the alarm is in the "FIRING" state.  Example: `CRITICAL`
        """
        return pulumi.get(self, "severity")


@pulumi.output_type
class GetAlarmsAlarmSuppressionResult(dict):
    def __init__(__self__, *,
                 description: builtins.str,
                 time_suppress_from: builtins.str,
                 time_suppress_until: builtins.str):
        """
        :param builtins.str description: Human-readable reason for suppressing alarm notifications. It does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param builtins.str time_suppress_from: The start date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T01:02:29.600Z`
        :param builtins.str time_suppress_until: The end date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T02:02:29.600Z`
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "time_suppress_from", time_suppress_from)
        pulumi.set(__self__, "time_suppress_until", time_suppress_until)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Human-readable reason for suppressing alarm notifications. It does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="timeSuppressFrom")
    def time_suppress_from(self) -> builtins.str:
        """
        The start date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T01:02:29.600Z`
        """
        return pulumi.get(self, "time_suppress_from")

    @property
    @pulumi.getter(name="timeSuppressUntil")
    def time_suppress_until(self) -> builtins.str:
        """
        The end date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T02:02:29.600Z`
        """
        return pulumi.get(self, "time_suppress_until")


@pulumi.output_type
class GetAlarmsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetMetricDataFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: The name of the metric.  Example: `CpuUtilization`
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the metric.  Example: `CpuUtilization`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetMetricDataMetricDataResult(dict):
    def __init__(__self__, *,
                 aggregated_datapoints: Sequence['outputs.GetMetricDataMetricDataAggregatedDatapointResult'],
                 compartment_id: builtins.str,
                 compartment_id_in_subtree: builtins.bool,
                 dimensions: Mapping[str, builtins.str],
                 end_time: builtins.str,
                 metadata: Mapping[str, builtins.str],
                 name: builtins.str,
                 namespace: builtins.str,
                 query: builtins.str,
                 resolution: builtins.str,
                 resource_group: builtins.str,
                 start_time: builtins.str):
        """
        :param Sequence['GetMetricDataMetricDataAggregatedDatapointArgs'] aggregated_datapoints: The list of timestamp-value pairs returned for the specified request. Metric values are rolled up to the start time specified in the request. For important limits information related to data points, see MetricData Reference at the top of this page.
        :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the resources monitored by the metric that you are searching for. Use tenancyId to search in the root compartment.  Example: `ocid1.compartment.oc1..exampleuniqueID`
        :param builtins.bool compartment_id_in_subtree: When true, returns resources from all compartments and subcompartments. The parameter can only be set to true when compartmentId is the tenancy OCID (the tenancy is the root compartment). A true value requires the user to have tenancy-level permissions. If this requirement is not met, then the call is rejected. When false, returns resources from only the compartment specified in compartmentId. Default is false.
        :param Mapping[str, builtins.str] dimensions: Qualifiers provided in the definition of the returned metric. Available dimensions vary by metric namespace. Each dimension takes the form of a key-value pair.  Example: `{"resourceId": "instance.region1.phx.exampleuniqueID"}`
        :param builtins.str end_time: The end of the time range to use when searching for metric data points. Format is defined by RFC3339. The response excludes metric data points for the endTime. Default value: the timestamp representing when the call was sent.  Example: `2023-02-01T02:02:29.600Z`
        :param Mapping[str, builtins.str] metadata: The references provided in a metric definition to indicate extra information about the metric.  Example: `"unit": "bytes"`
        :param builtins.str name: The name of the metric.  Example: `CpuUtilization`
        :param builtins.str namespace: The source service or application to use when searching for metric data points to aggregate.  Example: `oci_computeagent`
        :param builtins.str query: The Monitoring Query Language (MQL) expression to use when searching for metric data points to aggregate. The query must specify a metric, statistic, and interval. Supported values for interval depend on the specified time range. More interval values are supported for smaller time ranges. You can optionally specify dimensions and grouping functions. When specifying a dimension value, surround it with double quotes, and escape each double quote with a backslash (`\\`) character. Supported grouping functions: `grouping()`, `groupBy()`.
               
               Construct your query to avoid exceeding limits on returned data. See [MetricData Reference](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/20180401/MetricData).
               
               For details about Monitoring Query Language (MQL), see [Monitoring Query Language (MQL) Reference](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Reference/mql.htm). For available dimensions, review the metric definition for the supported service. See [Supported Services](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#SupportedServices).
               
               Example 1: `CpuUtilization[1m].sum()`
               
               Example 2 (escaped double quotes for value string): `CpuUtilization[1m]{resourceId = \\"<var>&lt;instance_OCID&gt;</var>\\"}.max()`
        :param builtins.str resolution: The time between calculated aggregation windows. Use with the query interval to vary the frequency for returning aggregated data points. For example, use a query interval of 5 minutes with a resolution of 1 minute to retrieve five-minute aggregations at a one-minute frequency. The resolution must be equal or less than the interval in the query. The default resolution is 1m (one minute). Supported values: `1m`-`60m`, `1h`-`24h`, `1d`.  Example: `5m`
        :param builtins.str resource_group: Resource group that you want to match. A null value returns only metric data that has no resource groups. The specified resource group must exist in the definition of the posted metric. Only one resource group can be applied per metric. A valid resourceGroup value starts with an alphabetical character and includes only alphanumeric characters, periods (.), underscores (_), hyphens (-), and dollar signs ($).  Example: `frontend-fleet`
        :param builtins.str start_time: The beginning of the time range to use when searching for metric data points. Format is defined by RFC3339. The response includes metric data points for the startTime. Default value: the timestamp 3 hours before the call was sent.  Example: `2023-02-01T01:02:29.600Z`
        """
        pulumi.set(__self__, "aggregated_datapoints", aggregated_datapoints)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        pulumi.set(__self__, "dimensions", dimensions)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "resolution", resolution)
        pulumi.set(__self__, "resource_group", resource_group)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="aggregatedDatapoints")
    def aggregated_datapoints(self) -> Sequence['outputs.GetMetricDataMetricDataAggregatedDatapointResult']:
        """
        The list of timestamp-value pairs returned for the specified request. Metric values are rolled up to the start time specified in the request. For important limits information related to data points, see MetricData Reference at the top of this page.
        """
        return pulumi.get(self, "aggregated_datapoints")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the resources monitored by the metric that you are searching for. Use tenancyId to search in the root compartment.  Example: `ocid1.compartment.oc1..exampleuniqueID`
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> builtins.bool:
        """
        When true, returns resources from all compartments and subcompartments. The parameter can only be set to true when compartmentId is the tenancy OCID (the tenancy is the root compartment). A true value requires the user to have tenancy-level permissions. If this requirement is not met, then the call is rejected. When false, returns resources from only the compartment specified in compartmentId. Default is false.
        """
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter
    def dimensions(self) -> Mapping[str, builtins.str]:
        """
        Qualifiers provided in the definition of the returned metric. Available dimensions vary by metric namespace. Each dimension takes the form of a key-value pair.  Example: `{"resourceId": "instance.region1.phx.exampleuniqueID"}`
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> builtins.str:
        """
        The end of the time range to use when searching for metric data points. Format is defined by RFC3339. The response excludes metric data points for the endTime. Default value: the timestamp representing when the call was sent.  Example: `2023-02-01T02:02:29.600Z`
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, builtins.str]:
        """
        The references provided in a metric definition to indicate extra information about the metric.  Example: `"unit": "bytes"`
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the metric.  Example: `CpuUtilization`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        The source service or application to use when searching for metric data points to aggregate.  Example: `oci_computeagent`
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def query(self) -> builtins.str:
        """
        The Monitoring Query Language (MQL) expression to use when searching for metric data points to aggregate. The query must specify a metric, statistic, and interval. Supported values for interval depend on the specified time range. More interval values are supported for smaller time ranges. You can optionally specify dimensions and grouping functions. When specifying a dimension value, surround it with double quotes, and escape each double quote with a backslash (`\\`) character. Supported grouping functions: `grouping()`, `groupBy()`.

        Construct your query to avoid exceeding limits on returned data. See [MetricData Reference](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/20180401/MetricData).

        For details about Monitoring Query Language (MQL), see [Monitoring Query Language (MQL) Reference](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Reference/mql.htm). For available dimensions, review the metric definition for the supported service. See [Supported Services](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#SupportedServices).

        Example 1: `CpuUtilization[1m].sum()`

        Example 2 (escaped double quotes for value string): `CpuUtilization[1m]{resourceId = \\"<var>&lt;instance_OCID&gt;</var>\\"}.max()`
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter
    def resolution(self) -> builtins.str:
        """
        The time between calculated aggregation windows. Use with the query interval to vary the frequency for returning aggregated data points. For example, use a query interval of 5 minutes with a resolution of 1 minute to retrieve five-minute aggregations at a one-minute frequency. The resolution must be equal or less than the interval in the query. The default resolution is 1m (one minute). Supported values: `1m`-`60m`, `1h`-`24h`, `1d`.  Example: `5m`
        """
        return pulumi.get(self, "resolution")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> builtins.str:
        """
        Resource group that you want to match. A null value returns only metric data that has no resource groups. The specified resource group must exist in the definition of the posted metric. Only one resource group can be applied per metric. A valid resourceGroup value starts with an alphabetical character and includes only alphanumeric characters, periods (.), underscores (_), hyphens (-), and dollar signs ($).  Example: `frontend-fleet`
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> builtins.str:
        """
        The beginning of the time range to use when searching for metric data points. Format is defined by RFC3339. The response includes metric data points for the startTime. Default value: the timestamp 3 hours before the call was sent.  Example: `2023-02-01T01:02:29.600Z`
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class GetMetricDataMetricDataAggregatedDatapointResult(dict):
    def __init__(__self__, *,
                 timestamp: builtins.str,
                 value: builtins.float):
        """
        :param builtins.str timestamp: The date and time associated with the value of this data point. Format defined by RFC3339.  Example: `2023-02-01T01:02:29.600Z`
        :param builtins.float value: Numeric value of the metric.  Example: `10.4`
        """
        pulumi.set(__self__, "timestamp", timestamp)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def timestamp(self) -> builtins.str:
        """
        The date and time associated with the value of this data point. Format defined by RFC3339.  Example: `2023-02-01T01:02:29.600Z`
        """
        return pulumi.get(self, "timestamp")

    @property
    @pulumi.getter
    def value(self) -> builtins.float:
        """
        Numeric value of the metric.  Example: `10.4`
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetMetricsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: The metric name to use when searching for metric definitions.  Example: `CpuUtilization`
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The metric name to use when searching for metric definitions.  Example: `CpuUtilization`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetMetricsMetricResult(dict):
    def __init__(__self__, *,
                 compartment_id: builtins.str,
                 compartment_id_in_subtree: builtins.bool,
                 dimension_filters: Mapping[str, builtins.str],
                 dimensions: Mapping[str, builtins.str],
                 group_bies: Sequence[builtins.str],
                 name: builtins.str,
                 namespace: builtins.str,
                 resource_group: builtins.str):
        """
        :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the resources monitored by the metric that you are searching for. Use tenancyId to search in the root compartment.  Example: `ocid1.compartment.oc1..exampleuniqueID`
        :param builtins.bool compartment_id_in_subtree: When true, returns resources from all compartments and subcompartments. The parameter can only be set to true when compartmentId is the tenancy OCID (the tenancy is the root compartment). A true value requires the user to have tenancy-level permissions. If this requirement is not met, then the call is rejected. When false, returns resources from only the compartment specified in compartmentId. Default is false.
        :param Mapping[str, builtins.str] dimension_filters: Qualifiers that you want to use when searching for metric definitions. Available dimensions vary by metric namespace. Each dimension takes the form of a key-value pair.  Example: `{"resourceId": "instance.region1.phx.exampleuniqueID"}`
        :param Mapping[str, builtins.str] dimensions: Qualifiers provided in a metric definition. Available dimensions vary by metric namespace. Each dimension takes the form of a key-value pair.  Example: `{"resourceId": "instance.region1.phx.exampleuniqueID"}`
        :param Sequence[builtins.str] group_bies: Group metrics by these fields in the response. For example, to list all metric namespaces available in a compartment, groupBy the "namespace" field. Supported fields: namespace, name, resourceGroup. If `groupBy` is used, then `dimensionFilters` is ignored.
               
               Example - group by namespace: `[ "namespace" ]`
        :param builtins.str name: The metric name to use when searching for metric definitions.  Example: `CpuUtilization`
        :param builtins.str namespace: The source service or application to use when searching for metric definitions.  Example: `oci_computeagent`
        :param builtins.str resource_group: Resource group that you want to match. A null value returns only metric data that has no resource groups. The specified resource group must exist in the definition of the posted metric. Only one resource group can be applied per metric. A valid resourceGroup value starts with an alphabetical character and includes only alphanumeric characters, periods (.), underscores (_), hyphens (-), and dollar signs ($).  Example: `frontend-fleet`
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        pulumi.set(__self__, "dimension_filters", dimension_filters)
        pulumi.set(__self__, "dimensions", dimensions)
        pulumi.set(__self__, "group_bies", group_bies)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "resource_group", resource_group)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the resources monitored by the metric that you are searching for. Use tenancyId to search in the root compartment.  Example: `ocid1.compartment.oc1..exampleuniqueID`
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> builtins.bool:
        """
        When true, returns resources from all compartments and subcompartments. The parameter can only be set to true when compartmentId is the tenancy OCID (the tenancy is the root compartment). A true value requires the user to have tenancy-level permissions. If this requirement is not met, then the call is rejected. When false, returns resources from only the compartment specified in compartmentId. Default is false.
        """
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter(name="dimensionFilters")
    def dimension_filters(self) -> Mapping[str, builtins.str]:
        """
        Qualifiers that you want to use when searching for metric definitions. Available dimensions vary by metric namespace. Each dimension takes the form of a key-value pair.  Example: `{"resourceId": "instance.region1.phx.exampleuniqueID"}`
        """
        return pulumi.get(self, "dimension_filters")

    @property
    @pulumi.getter
    def dimensions(self) -> Mapping[str, builtins.str]:
        """
        Qualifiers provided in a metric definition. Available dimensions vary by metric namespace. Each dimension takes the form of a key-value pair.  Example: `{"resourceId": "instance.region1.phx.exampleuniqueID"}`
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> Sequence[builtins.str]:
        """
        Group metrics by these fields in the response. For example, to list all metric namespaces available in a compartment, groupBy the "namespace" field. Supported fields: namespace, name, resourceGroup. If `groupBy` is used, then `dimensionFilters` is ignored.

        Example - group by namespace: `[ "namespace" ]`
        """
        return pulumi.get(self, "group_bies")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The metric name to use when searching for metric definitions.  Example: `CpuUtilization`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        The source service or application to use when searching for metric definitions.  Example: `oci_computeagent`
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> builtins.str:
        """
        Resource group that you want to match. A null value returns only metric data that has no resource groups. The specified resource group must exist in the definition of the posted metric. Only one resource group can be applied per metric. A valid resourceGroup value starts with an alphabetical character and includes only alphanumeric characters, periods (.), underscores (_), hyphens (-), and dollar signs ($).  Example: `frontend-fleet`
        """
        return pulumi.get(self, "resource_group")


