# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetNetworkFirewallPoliciesResult',
    'AwaitableGetNetworkFirewallPoliciesResult',
    'get_network_firewall_policies',
    'get_network_firewall_policies_output',
]

@pulumi.output_type
class GetNetworkFirewallPoliciesResult:
    """
    A collection of values returned by getNetworkFirewallPolicies.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, network_firewall_policy_summary_collections=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if network_firewall_policy_summary_collections and not isinstance(network_firewall_policy_summary_collections, list):
            raise TypeError("Expected argument 'network_firewall_policy_summary_collections' to be a list")
        pulumi.set(__self__, "network_firewall_policy_summary_collections", network_firewall_policy_summary_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the NetworkFirewall Policy.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        A user-friendly optional name for the firewall policy. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetNetworkFirewallPoliciesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource - Network Firewall Policy.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="networkFirewallPolicySummaryCollections")
    def network_firewall_policy_summary_collections(self) -> Sequence['outputs.GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionResult']:
        """
        The list of network_firewall_policy_summary_collection.
        """
        return pulumi.get(self, "network_firewall_policy_summary_collections")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the Network Firewall Policy.
        """
        return pulumi.get(self, "state")


class AwaitableGetNetworkFirewallPoliciesResult(GetNetworkFirewallPoliciesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkFirewallPoliciesResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            network_firewall_policy_summary_collections=self.network_firewall_policy_summary_collections,
            state=self.state)


def get_network_firewall_policies(compartment_id: Optional[builtins.str] = None,
                                  display_name: Optional[builtins.str] = None,
                                  filters: Optional[Sequence[Union['GetNetworkFirewallPoliciesFilterArgs', 'GetNetworkFirewallPoliciesFilterArgsDict']]] = None,
                                  id: Optional[builtins.str] = None,
                                  state: Optional[builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkFirewallPoliciesResult:
    """
    This data source provides the list of Network Firewall Policies in Oracle Cloud Infrastructure Network Firewall service.

    Returns a list of Network Firewall Policies.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_network_firewall_policies = oci.NetworkFirewall.get_network_firewall_policies(compartment_id=compartment_id,
        display_name=network_firewall_policy_display_name,
        id=network_firewall_policy_id,
        state=network_firewall_policy_state)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str id: Unique Network Firewall Policy identifier
    :param builtins.str state: A filter to return only resources with a lifecycleState matching the given value.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:NetworkFirewall/getNetworkFirewallPolicies:getNetworkFirewallPolicies', __args__, opts=opts, typ=GetNetworkFirewallPoliciesResult).value

    return AwaitableGetNetworkFirewallPoliciesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        network_firewall_policy_summary_collections=pulumi.get(__ret__, 'network_firewall_policy_summary_collections'),
        state=pulumi.get(__ret__, 'state'))
def get_network_firewall_policies_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                         display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                         filters: Optional[pulumi.Input[Optional[Sequence[Union['GetNetworkFirewallPoliciesFilterArgs', 'GetNetworkFirewallPoliciesFilterArgsDict']]]]] = None,
                                         id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                         state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNetworkFirewallPoliciesResult]:
    """
    This data source provides the list of Network Firewall Policies in Oracle Cloud Infrastructure Network Firewall service.

    Returns a list of Network Firewall Policies.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_network_firewall_policies = oci.NetworkFirewall.get_network_firewall_policies(compartment_id=compartment_id,
        display_name=network_firewall_policy_display_name,
        id=network_firewall_policy_id,
        state=network_firewall_policy_state)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str id: Unique Network Firewall Policy identifier
    :param builtins.str state: A filter to return only resources with a lifecycleState matching the given value.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:NetworkFirewall/getNetworkFirewallPolicies:getNetworkFirewallPolicies', __args__, opts=opts, typ=GetNetworkFirewallPoliciesResult)
    return __ret__.apply(lambda __response__: GetNetworkFirewallPoliciesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        network_firewall_policy_summary_collections=pulumi.get(__response__, 'network_firewall_policy_summary_collections'),
        state=pulumi.get(__response__, 'state')))
