# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'BackendSetBackendArgs',
    'BackendSetBackendArgsDict',
    'BackendSetHealthCheckerArgs',
    'BackendSetHealthCheckerArgsDict',
    'BackendSetHealthCheckerDnsArgs',
    'BackendSetHealthCheckerDnsArgsDict',
    'NetworkLoadBalancerIpAddressArgs',
    'NetworkLoadBalancerIpAddressArgsDict',
    'NetworkLoadBalancerIpAddressReservedIpArgs',
    'NetworkLoadBalancerIpAddressReservedIpArgsDict',
    'NetworkLoadBalancerReservedIpArgs',
    'NetworkLoadBalancerReservedIpArgsDict',
    'NetworkLoadBalancersBackendSetsUnifiedBackendArgs',
    'NetworkLoadBalancersBackendSetsUnifiedBackendArgsDict',
    'NetworkLoadBalancersBackendSetsUnifiedHealthCheckerArgs',
    'NetworkLoadBalancersBackendSetsUnifiedHealthCheckerArgsDict',
    'NetworkLoadBalancersBackendSetsUnifiedHealthCheckerDnsArgs',
    'NetworkLoadBalancersBackendSetsUnifiedHealthCheckerDnsArgsDict',
    'GetBackendSetsFilterArgs',
    'GetBackendSetsFilterArgsDict',
    'GetBackendsFilterArgs',
    'GetBackendsFilterArgsDict',
    'GetListenersFilterArgs',
    'GetListenersFilterArgsDict',
    'GetNetworkLoadBalancersFilterArgs',
    'GetNetworkLoadBalancersFilterArgsDict',
    'GetNetworkLoadBalancersPoliciesFilterArgs',
    'GetNetworkLoadBalancersPoliciesFilterArgsDict',
    'GetNetworkLoadBalancersProtocolsFilterArgs',
    'GetNetworkLoadBalancersProtocolsFilterArgsDict',
]

MYPY = False

if not MYPY:
    class BackendSetBackendArgsDict(TypedDict):
        port: pulumi.Input[builtins.int]
        """
        (Updatable) The communication port for the backend server.  Example: `8080`
        """
        ip_address: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) The IP address of the backend server.  Example: `10.0.0.3`
        """
        is_backup: NotRequired[pulumi.Input[builtins.bool]]
        """
        (Updatable) Whether the network load balancer should treat this server as a backup unit. If `true`, then the network load balancer forwards no ingress traffic to this backend server unless all other backend servers not marked as "isBackup" fail the health check policy.  Example: `false`
        """
        is_drain: NotRequired[pulumi.Input[builtins.bool]]
        """
        (Updatable) Whether the network load balancer should drain this server. Servers marked "isDrain" receive no incoming traffic.  Example: `false`
        """
        is_offline: NotRequired[pulumi.Input[builtins.bool]]
        """
        (Updatable) Whether the network load balancer should treat this server as offline. Offline servers receive no incoming traffic.  Example: `false`
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) A read-only field showing the IP address/OCID and port that uniquely identify this backend server in the backend set.  Example: `10.0.0.3:8080`, or `ocid1.privateip..oc1.<var>&lt;unique_ID&gt;</var>:443` or `10.0.0.3:0`
        """
        target_id: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) The IP OCID/Instance OCID associated with the backend server. Example: `ocid1.privateip..oc1.<var>&lt;unique_ID&gt;</var>`
        """
        weight: NotRequired[pulumi.Input[builtins.int]]
        """
        (Updatable) The network load balancing policy weight assigned to the server. Backend servers with a higher weight receive a larger proportion of incoming traffic. For example, a server weighted '3' receives three times the number of new connections as a server weighted '1'. For more information about load balancing policies, see [Network Load Balancer Policies](https://docs.cloud.oracle.com/iaas/Content/NetworkLoadBalancer/introduction.htm#Policies).  Example: `3`
        """
elif False:
    BackendSetBackendArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackendSetBackendArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[builtins.int],
                 ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 is_backup: Optional[pulumi.Input[builtins.bool]] = None,
                 is_drain: Optional[pulumi.Input[builtins.bool]] = None,
                 is_offline: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 target_id: Optional[pulumi.Input[builtins.str]] = None,
                 weight: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.int] port: (Updatable) The communication port for the backend server.  Example: `8080`
        :param pulumi.Input[builtins.str] ip_address: (Updatable) The IP address of the backend server.  Example: `10.0.0.3`
        :param pulumi.Input[builtins.bool] is_backup: (Updatable) Whether the network load balancer should treat this server as a backup unit. If `true`, then the network load balancer forwards no ingress traffic to this backend server unless all other backend servers not marked as "isBackup" fail the health check policy.  Example: `false`
        :param pulumi.Input[builtins.bool] is_drain: (Updatable) Whether the network load balancer should drain this server. Servers marked "isDrain" receive no incoming traffic.  Example: `false`
        :param pulumi.Input[builtins.bool] is_offline: (Updatable) Whether the network load balancer should treat this server as offline. Offline servers receive no incoming traffic.  Example: `false`
        :param pulumi.Input[builtins.str] name: (Updatable) A read-only field showing the IP address/OCID and port that uniquely identify this backend server in the backend set.  Example: `10.0.0.3:8080`, or `ocid1.privateip..oc1.<var>&lt;unique_ID&gt;</var>:443` or `10.0.0.3:0`
        :param pulumi.Input[builtins.str] target_id: (Updatable) The IP OCID/Instance OCID associated with the backend server. Example: `ocid1.privateip..oc1.<var>&lt;unique_ID&gt;</var>`
        :param pulumi.Input[builtins.int] weight: (Updatable) The network load balancing policy weight assigned to the server. Backend servers with a higher weight receive a larger proportion of incoming traffic. For example, a server weighted '3' receives three times the number of new connections as a server weighted '1'. For more information about load balancing policies, see [Network Load Balancer Policies](https://docs.cloud.oracle.com/iaas/Content/NetworkLoadBalancer/introduction.htm#Policies).  Example: `3`
        """
        pulumi.set(__self__, "port", port)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if is_backup is not None:
            pulumi.set(__self__, "is_backup", is_backup)
        if is_drain is not None:
            pulumi.set(__self__, "is_drain", is_drain)
        if is_offline is not None:
            pulumi.set(__self__, "is_offline", is_offline)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[builtins.int]:
        """
        (Updatable) The communication port for the backend server.  Example: `8080`
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The IP address of the backend server.  Example: `10.0.0.3`
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="isBackup")
    def is_backup(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Whether the network load balancer should treat this server as a backup unit. If `true`, then the network load balancer forwards no ingress traffic to this backend server unless all other backend servers not marked as "isBackup" fail the health check policy.  Example: `false`
        """
        return pulumi.get(self, "is_backup")

    @is_backup.setter
    def is_backup(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_backup", value)

    @property
    @pulumi.getter(name="isDrain")
    def is_drain(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Whether the network load balancer should drain this server. Servers marked "isDrain" receive no incoming traffic.  Example: `false`
        """
        return pulumi.get(self, "is_drain")

    @is_drain.setter
    def is_drain(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_drain", value)

    @property
    @pulumi.getter(name="isOffline")
    def is_offline(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Whether the network load balancer should treat this server as offline. Offline servers receive no incoming traffic.  Example: `false`
        """
        return pulumi.get(self, "is_offline")

    @is_offline.setter
    def is_offline(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_offline", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A read-only field showing the IP address/OCID and port that uniquely identify this backend server in the backend set.  Example: `10.0.0.3:8080`, or `ocid1.privateip..oc1.<var>&lt;unique_ID&gt;</var>:443` or `10.0.0.3:0`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The IP OCID/Instance OCID associated with the backend server. Example: `ocid1.privateip..oc1.<var>&lt;unique_ID&gt;</var>`
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_id", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The network load balancing policy weight assigned to the server. Backend servers with a higher weight receive a larger proportion of incoming traffic. For example, a server weighted '3' receives three times the number of new connections as a server weighted '1'. For more information about load balancing policies, see [Network Load Balancer Policies](https://docs.cloud.oracle.com/iaas/Content/NetworkLoadBalancer/introduction.htm#Policies).  Example: `3`
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "weight", value)


if not MYPY:
    class BackendSetHealthCheckerArgsDict(TypedDict):
        protocol: pulumi.Input[builtins.str]
        """
        (Updatable) The protocol the health check must use; either HTTP, HTTPS, UDP, TCP or DNS.  Example: `HTTP`
        """
        dns: NotRequired[pulumi.Input['BackendSetHealthCheckerDnsArgsDict']]
        """
        (Updatable) DNS healthcheck configurations.
        """
        interval_in_millis: NotRequired[pulumi.Input[builtins.int]]
        """
        (Updatable) The interval between health checks, in milliseconds. The default value is 10000 (10 seconds).  Example: `10000`
        """
        port: NotRequired[pulumi.Input[builtins.int]]
        """
        (Updatable) The backend server port against which to run the health check. If the port is not specified, then the network load balancer uses the port information from the `Backend` object. The port must be specified if the backend port is 0.  Example: `8080`
        """
        request_data: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) Base64 encoded pattern to be sent as UDP or TCP health check probe.
        """
        response_body_regex: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) A regular expression for parsing the response body from the backend server.  Example: `^((?!false).|\\s)*$`
        """
        response_data: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) Base64 encoded pattern to be validated as UDP or TCP health check probe response.
        """
        retries: NotRequired[pulumi.Input[builtins.int]]
        """
        (Updatable) The number of retries to attempt before a backend server is considered "unhealthy". This number also applies when recovering a server to the "healthy" state. The default value is 3.  Example: `3`
        """
        return_code: NotRequired[pulumi.Input[builtins.int]]
        """
        (Updatable) The status code a healthy backend server should return. If you configure the health check policy to use the HTTP protocol, then you can use common HTTP status codes such as "200".  Example: `200`
        """
        timeout_in_millis: NotRequired[pulumi.Input[builtins.int]]
        """
        (Updatable) The maximum time, in milliseconds, to wait for a reply to a health check. A health check is successful only if a reply returns within this timeout period. The default value is 3000 (3 seconds).  Example: `3000`
        """
        url_path: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) The path against which to run the health check.  Example: `/healthcheck`
        """
elif False:
    BackendSetHealthCheckerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackendSetHealthCheckerArgs:
    def __init__(__self__, *,
                 protocol: pulumi.Input[builtins.str],
                 dns: Optional[pulumi.Input['BackendSetHealthCheckerDnsArgs']] = None,
                 interval_in_millis: Optional[pulumi.Input[builtins.int]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 request_data: Optional[pulumi.Input[builtins.str]] = None,
                 response_body_regex: Optional[pulumi.Input[builtins.str]] = None,
                 response_data: Optional[pulumi.Input[builtins.str]] = None,
                 retries: Optional[pulumi.Input[builtins.int]] = None,
                 return_code: Optional[pulumi.Input[builtins.int]] = None,
                 timeout_in_millis: Optional[pulumi.Input[builtins.int]] = None,
                 url_path: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] protocol: (Updatable) The protocol the health check must use; either HTTP, HTTPS, UDP, TCP or DNS.  Example: `HTTP`
        :param pulumi.Input['BackendSetHealthCheckerDnsArgs'] dns: (Updatable) DNS healthcheck configurations.
        :param pulumi.Input[builtins.int] interval_in_millis: (Updatable) The interval between health checks, in milliseconds. The default value is 10000 (10 seconds).  Example: `10000`
        :param pulumi.Input[builtins.int] port: (Updatable) The backend server port against which to run the health check. If the port is not specified, then the network load balancer uses the port information from the `Backend` object. The port must be specified if the backend port is 0.  Example: `8080`
        :param pulumi.Input[builtins.str] request_data: (Updatable) Base64 encoded pattern to be sent as UDP or TCP health check probe.
        :param pulumi.Input[builtins.str] response_body_regex: (Updatable) A regular expression for parsing the response body from the backend server.  Example: `^((?!false).|\\s)*$`
        :param pulumi.Input[builtins.str] response_data: (Updatable) Base64 encoded pattern to be validated as UDP or TCP health check probe response.
        :param pulumi.Input[builtins.int] retries: (Updatable) The number of retries to attempt before a backend server is considered "unhealthy". This number also applies when recovering a server to the "healthy" state. The default value is 3.  Example: `3`
        :param pulumi.Input[builtins.int] return_code: (Updatable) The status code a healthy backend server should return. If you configure the health check policy to use the HTTP protocol, then you can use common HTTP status codes such as "200".  Example: `200`
        :param pulumi.Input[builtins.int] timeout_in_millis: (Updatable) The maximum time, in milliseconds, to wait for a reply to a health check. A health check is successful only if a reply returns within this timeout period. The default value is 3000 (3 seconds).  Example: `3000`
        :param pulumi.Input[builtins.str] url_path: (Updatable) The path against which to run the health check.  Example: `/healthcheck`
        """
        pulumi.set(__self__, "protocol", protocol)
        if dns is not None:
            pulumi.set(__self__, "dns", dns)
        if interval_in_millis is not None:
            pulumi.set(__self__, "interval_in_millis", interval_in_millis)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if request_data is not None:
            pulumi.set(__self__, "request_data", request_data)
        if response_body_regex is not None:
            pulumi.set(__self__, "response_body_regex", response_body_regex)
        if response_data is not None:
            pulumi.set(__self__, "response_data", response_data)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if return_code is not None:
            pulumi.set(__self__, "return_code", return_code)
        if timeout_in_millis is not None:
            pulumi.set(__self__, "timeout_in_millis", timeout_in_millis)
        if url_path is not None:
            pulumi.set(__self__, "url_path", url_path)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The protocol the health check must use; either HTTP, HTTPS, UDP, TCP or DNS.  Example: `HTTP`
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def dns(self) -> Optional[pulumi.Input['BackendSetHealthCheckerDnsArgs']]:
        """
        (Updatable) DNS healthcheck configurations.
        """
        return pulumi.get(self, "dns")

    @dns.setter
    def dns(self, value: Optional[pulumi.Input['BackendSetHealthCheckerDnsArgs']]):
        pulumi.set(self, "dns", value)

    @property
    @pulumi.getter(name="intervalInMillis")
    def interval_in_millis(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The interval between health checks, in milliseconds. The default value is 10000 (10 seconds).  Example: `10000`
        """
        return pulumi.get(self, "interval_in_millis")

    @interval_in_millis.setter
    def interval_in_millis(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "interval_in_millis", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The backend server port against which to run the health check. If the port is not specified, then the network load balancer uses the port information from the `Backend` object. The port must be specified if the backend port is 0.  Example: `8080`
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="requestData")
    def request_data(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Base64 encoded pattern to be sent as UDP or TCP health check probe.
        """
        return pulumi.get(self, "request_data")

    @request_data.setter
    def request_data(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "request_data", value)

    @property
    @pulumi.getter(name="responseBodyRegex")
    def response_body_regex(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A regular expression for parsing the response body from the backend server.  Example: `^((?!false).|\\s)*$`
        """
        return pulumi.get(self, "response_body_regex")

    @response_body_regex.setter
    def response_body_regex(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "response_body_regex", value)

    @property
    @pulumi.getter(name="responseData")
    def response_data(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Base64 encoded pattern to be validated as UDP or TCP health check probe response.
        """
        return pulumi.get(self, "response_data")

    @response_data.setter
    def response_data(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "response_data", value)

    @property
    @pulumi.getter
    def retries(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The number of retries to attempt before a backend server is considered "unhealthy". This number also applies when recovering a server to the "healthy" state. The default value is 3.  Example: `3`
        """
        return pulumi.get(self, "retries")

    @retries.setter
    def retries(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "retries", value)

    @property
    @pulumi.getter(name="returnCode")
    def return_code(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The status code a healthy backend server should return. If you configure the health check policy to use the HTTP protocol, then you can use common HTTP status codes such as "200".  Example: `200`
        """
        return pulumi.get(self, "return_code")

    @return_code.setter
    def return_code(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "return_code", value)

    @property
    @pulumi.getter(name="timeoutInMillis")
    def timeout_in_millis(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The maximum time, in milliseconds, to wait for a reply to a health check. A health check is successful only if a reply returns within this timeout period. The default value is 3000 (3 seconds).  Example: `3000`
        """
        return pulumi.get(self, "timeout_in_millis")

    @timeout_in_millis.setter
    def timeout_in_millis(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "timeout_in_millis", value)

    @property
    @pulumi.getter(name="urlPath")
    def url_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The path against which to run the health check.  Example: `/healthcheck`
        """
        return pulumi.get(self, "url_path")

    @url_path.setter
    def url_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "url_path", value)


if not MYPY:
    class BackendSetHealthCheckerDnsArgsDict(TypedDict):
        domain_name: pulumi.Input[builtins.str]
        """
        (Updatable) The absolute fully-qualified domain name to perform periodic DNS queries. If not provided, an extra dot will be added at the end of a domain name during the query.
        """
        query_class: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) The class the dns health check query to use; either IN or CH.  Example: `IN`
        """
        query_type: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) The type the dns health check query to use; A, AAAA, TXT.  Example: `A`
        """
        rcodes: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        (Updatable) An array that represents accepetable RCODE values for DNS query response. Example: ["NOERROR", "NXDOMAIN"]
        """
        transport_protocol: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) DNS transport protocol; either UDP or TCP.  Example: `UDP`
        """
elif False:
    BackendSetHealthCheckerDnsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackendSetHealthCheckerDnsArgs:
    def __init__(__self__, *,
                 domain_name: pulumi.Input[builtins.str],
                 query_class: Optional[pulumi.Input[builtins.str]] = None,
                 query_type: Optional[pulumi.Input[builtins.str]] = None,
                 rcodes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 transport_protocol: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] domain_name: (Updatable) The absolute fully-qualified domain name to perform periodic DNS queries. If not provided, an extra dot will be added at the end of a domain name during the query.
        :param pulumi.Input[builtins.str] query_class: (Updatable) The class the dns health check query to use; either IN or CH.  Example: `IN`
        :param pulumi.Input[builtins.str] query_type: (Updatable) The type the dns health check query to use; A, AAAA, TXT.  Example: `A`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] rcodes: (Updatable) An array that represents accepetable RCODE values for DNS query response. Example: ["NOERROR", "NXDOMAIN"]
        :param pulumi.Input[builtins.str] transport_protocol: (Updatable) DNS transport protocol; either UDP or TCP.  Example: `UDP`
        """
        pulumi.set(__self__, "domain_name", domain_name)
        if query_class is not None:
            pulumi.set(__self__, "query_class", query_class)
        if query_type is not None:
            pulumi.set(__self__, "query_type", query_type)
        if rcodes is not None:
            pulumi.set(__self__, "rcodes", rcodes)
        if transport_protocol is not None:
            pulumi.set(__self__, "transport_protocol", transport_protocol)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The absolute fully-qualified domain name to perform periodic DNS queries. If not provided, an extra dot will be added at the end of a domain name during the query.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="queryClass")
    def query_class(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The class the dns health check query to use; either IN or CH.  Example: `IN`
        """
        return pulumi.get(self, "query_class")

    @query_class.setter
    def query_class(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "query_class", value)

    @property
    @pulumi.getter(name="queryType")
    def query_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The type the dns health check query to use; A, AAAA, TXT.  Example: `A`
        """
        return pulumi.get(self, "query_type")

    @query_type.setter
    def query_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "query_type", value)

    @property
    @pulumi.getter
    def rcodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) An array that represents accepetable RCODE values for DNS query response. Example: ["NOERROR", "NXDOMAIN"]
        """
        return pulumi.get(self, "rcodes")

    @rcodes.setter
    def rcodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "rcodes", value)

    @property
    @pulumi.getter(name="transportProtocol")
    def transport_protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) DNS transport protocol; either UDP or TCP.  Example: `UDP`
        """
        return pulumi.get(self, "transport_protocol")

    @transport_protocol.setter
    def transport_protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "transport_protocol", value)


if not MYPY:
    class NetworkLoadBalancerIpAddressArgsDict(TypedDict):
        ip_address: NotRequired[pulumi.Input[builtins.str]]
        """
        An IP address.  Example: `192.168.0.3`
        """
        ip_version: NotRequired[pulumi.Input[builtins.str]]
        """
        IP version associated with the listener.
        """
        is_public: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether the IP address is public or private.
        """
        reserved_ips: NotRequired[pulumi.Input[Sequence[pulumi.Input['NetworkLoadBalancerIpAddressReservedIpArgsDict']]]]
        """
        An object representing a reserved IP address to be attached or that is already attached to a network load balancer.
        """
elif False:
    NetworkLoadBalancerIpAddressArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkLoadBalancerIpAddressArgs:
    def __init__(__self__, *,
                 ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[builtins.str]] = None,
                 is_public: Optional[pulumi.Input[builtins.bool]] = None,
                 reserved_ips: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkLoadBalancerIpAddressReservedIpArgs']]]] = None):
        """
        :param pulumi.Input[builtins.str] ip_address: An IP address.  Example: `192.168.0.3`
        :param pulumi.Input[builtins.str] ip_version: IP version associated with the listener.
        :param pulumi.Input[builtins.bool] is_public: Whether the IP address is public or private.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkLoadBalancerIpAddressReservedIpArgs']]] reserved_ips: An object representing a reserved IP address to be attached or that is already attached to a network load balancer.
        """
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if is_public is not None:
            pulumi.set(__self__, "is_public", is_public)
        if reserved_ips is not None:
            pulumi.set(__self__, "reserved_ips", reserved_ips)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An IP address.  Example: `192.168.0.3`
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IP version associated with the listener.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_version", value)

    @property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the IP address is public or private.
        """
        return pulumi.get(self, "is_public")

    @is_public.setter
    def is_public(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_public", value)

    @property
    @pulumi.getter(name="reservedIps")
    def reserved_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkLoadBalancerIpAddressReservedIpArgs']]]]:
        """
        An object representing a reserved IP address to be attached or that is already attached to a network load balancer.
        """
        return pulumi.get(self, "reserved_ips")

    @reserved_ips.setter
    def reserved_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkLoadBalancerIpAddressReservedIpArgs']]]]):
        pulumi.set(self, "reserved_ips", value)


if not MYPY:
    class NetworkLoadBalancerIpAddressReservedIpArgsDict(TypedDict):
        id: NotRequired[pulumi.Input[builtins.str]]
        """
        OCID of the reserved public IP address created with the virtual cloud network.
        """
elif False:
    NetworkLoadBalancerIpAddressReservedIpArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkLoadBalancerIpAddressReservedIpArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] id: OCID of the reserved public IP address created with the virtual cloud network.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        OCID of the reserved public IP address created with the virtual cloud network.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "id", value)


if not MYPY:
    class NetworkLoadBalancerReservedIpArgsDict(TypedDict):
        id: NotRequired[pulumi.Input[builtins.str]]
        """
        OCID of the reserved public IP address created with the virtual cloud network.

        Reserved public IP addresses are IP addresses that are registered using the virtual cloud network API.

        Create a reserved public IP address. When you create the network load balancer, enter the OCID of the reserved public IP address in the reservedIp field to attach the IP address to the network load balancer. This task configures the network load balancer to listen to traffic on this IP address.

        Reserved public IP addresses are not deleted when the network load balancer is deleted. The IP addresses become unattached from the network load balancer.

        Example: "ocid1.publicip.oc1.phx.unique_ID"
        """
elif False:
    NetworkLoadBalancerReservedIpArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkLoadBalancerReservedIpArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] id: OCID of the reserved public IP address created with the virtual cloud network.
               
               Reserved public IP addresses are IP addresses that are registered using the virtual cloud network API.
               
               Create a reserved public IP address. When you create the network load balancer, enter the OCID of the reserved public IP address in the reservedIp field to attach the IP address to the network load balancer. This task configures the network load balancer to listen to traffic on this IP address.
               
               Reserved public IP addresses are not deleted when the network load balancer is deleted. The IP addresses become unattached from the network load balancer.
               
               Example: "ocid1.publicip.oc1.phx.unique_ID"
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        OCID of the reserved public IP address created with the virtual cloud network.

        Reserved public IP addresses are IP addresses that are registered using the virtual cloud network API.

        Create a reserved public IP address. When you create the network load balancer, enter the OCID of the reserved public IP address in the reservedIp field to attach the IP address to the network load balancer. This task configures the network load balancer to listen to traffic on this IP address.

        Reserved public IP addresses are not deleted when the network load balancer is deleted. The IP addresses become unattached from the network load balancer.

        Example: "ocid1.publicip.oc1.phx.unique_ID"
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "id", value)


if not MYPY:
    class NetworkLoadBalancersBackendSetsUnifiedBackendArgsDict(TypedDict):
        port: pulumi.Input[builtins.int]
        """
        (Updatable) The communication port for the backend server.  Example: `8080`
        """
        ip_address: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) The IP address of the backend server.  Example: `10.0.0.3`
        """
        is_backup: NotRequired[pulumi.Input[builtins.bool]]
        """
        (Updatable) Whether the network load balancer should treat this server as a backup unit. If `true`, then the network load balancer forwards no ingress traffic to this backend server unless all other backend servers not marked as "isBackup" fail the health check policy.  Example: `false`
        """
        is_drain: NotRequired[pulumi.Input[builtins.bool]]
        """
        (Updatable) Whether the network load balancer should drain this server. Servers marked "isDrain" receive no incoming traffic.  Example: `false`
        """
        is_offline: NotRequired[pulumi.Input[builtins.bool]]
        """
        (Updatable) Whether the network load balancer should treat this server as offline. Offline servers receive no incoming traffic.  Example: `false`
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) A read-only field showing the IP address/OCID and port that uniquely identify this backend server in the backend set.  Example: `10.0.0.3:8080`, or `ocid1.privateip..oc1.<var>&lt;unique_ID&gt;</var>:443` or `10.0.0.3:0`
        """
        target_id: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) The IP OCID/Instance OCID associated with the backend server. Example: `ocid1.privateip..oc1.<var>&lt;unique_ID&gt;</var>`
        """
        weight: NotRequired[pulumi.Input[builtins.int]]
        """
        (Updatable) The network load balancing policy weight assigned to the server. Backend servers with a higher weight receive a larger proportion of incoming traffic. For example, a server weighted '3' receives three times the number of new connections as a server weighted '1'. For more information about load balancing policies, see [Network Load Balancer Policies](https://docs.cloud.oracle.com/iaas/Content/NetworkLoadBalancer/introduction.htm#Policies).  Example: `3`
        """
elif False:
    NetworkLoadBalancersBackendSetsUnifiedBackendArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkLoadBalancersBackendSetsUnifiedBackendArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[builtins.int],
                 ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 is_backup: Optional[pulumi.Input[builtins.bool]] = None,
                 is_drain: Optional[pulumi.Input[builtins.bool]] = None,
                 is_offline: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 target_id: Optional[pulumi.Input[builtins.str]] = None,
                 weight: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.int] port: (Updatable) The communication port for the backend server.  Example: `8080`
        :param pulumi.Input[builtins.str] ip_address: (Updatable) The IP address of the backend server.  Example: `10.0.0.3`
        :param pulumi.Input[builtins.bool] is_backup: (Updatable) Whether the network load balancer should treat this server as a backup unit. If `true`, then the network load balancer forwards no ingress traffic to this backend server unless all other backend servers not marked as "isBackup" fail the health check policy.  Example: `false`
        :param pulumi.Input[builtins.bool] is_drain: (Updatable) Whether the network load balancer should drain this server. Servers marked "isDrain" receive no incoming traffic.  Example: `false`
        :param pulumi.Input[builtins.bool] is_offline: (Updatable) Whether the network load balancer should treat this server as offline. Offline servers receive no incoming traffic.  Example: `false`
        :param pulumi.Input[builtins.str] name: (Updatable) A read-only field showing the IP address/OCID and port that uniquely identify this backend server in the backend set.  Example: `10.0.0.3:8080`, or `ocid1.privateip..oc1.<var>&lt;unique_ID&gt;</var>:443` or `10.0.0.3:0`
        :param pulumi.Input[builtins.str] target_id: (Updatable) The IP OCID/Instance OCID associated with the backend server. Example: `ocid1.privateip..oc1.<var>&lt;unique_ID&gt;</var>`
        :param pulumi.Input[builtins.int] weight: (Updatable) The network load balancing policy weight assigned to the server. Backend servers with a higher weight receive a larger proportion of incoming traffic. For example, a server weighted '3' receives three times the number of new connections as a server weighted '1'. For more information about load balancing policies, see [Network Load Balancer Policies](https://docs.cloud.oracle.com/iaas/Content/NetworkLoadBalancer/introduction.htm#Policies).  Example: `3`
        """
        pulumi.set(__self__, "port", port)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if is_backup is not None:
            pulumi.set(__self__, "is_backup", is_backup)
        if is_drain is not None:
            pulumi.set(__self__, "is_drain", is_drain)
        if is_offline is not None:
            pulumi.set(__self__, "is_offline", is_offline)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[builtins.int]:
        """
        (Updatable) The communication port for the backend server.  Example: `8080`
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The IP address of the backend server.  Example: `10.0.0.3`
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="isBackup")
    def is_backup(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Whether the network load balancer should treat this server as a backup unit. If `true`, then the network load balancer forwards no ingress traffic to this backend server unless all other backend servers not marked as "isBackup" fail the health check policy.  Example: `false`
        """
        return pulumi.get(self, "is_backup")

    @is_backup.setter
    def is_backup(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_backup", value)

    @property
    @pulumi.getter(name="isDrain")
    def is_drain(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Whether the network load balancer should drain this server. Servers marked "isDrain" receive no incoming traffic.  Example: `false`
        """
        return pulumi.get(self, "is_drain")

    @is_drain.setter
    def is_drain(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_drain", value)

    @property
    @pulumi.getter(name="isOffline")
    def is_offline(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Whether the network load balancer should treat this server as offline. Offline servers receive no incoming traffic.  Example: `false`
        """
        return pulumi.get(self, "is_offline")

    @is_offline.setter
    def is_offline(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_offline", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A read-only field showing the IP address/OCID and port that uniquely identify this backend server in the backend set.  Example: `10.0.0.3:8080`, or `ocid1.privateip..oc1.<var>&lt;unique_ID&gt;</var>:443` or `10.0.0.3:0`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The IP OCID/Instance OCID associated with the backend server. Example: `ocid1.privateip..oc1.<var>&lt;unique_ID&gt;</var>`
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_id", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The network load balancing policy weight assigned to the server. Backend servers with a higher weight receive a larger proportion of incoming traffic. For example, a server weighted '3' receives three times the number of new connections as a server weighted '1'. For more information about load balancing policies, see [Network Load Balancer Policies](https://docs.cloud.oracle.com/iaas/Content/NetworkLoadBalancer/introduction.htm#Policies).  Example: `3`
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "weight", value)


if not MYPY:
    class NetworkLoadBalancersBackendSetsUnifiedHealthCheckerArgsDict(TypedDict):
        protocol: pulumi.Input[builtins.str]
        """
        (Updatable) The protocol the health check must use; either HTTP or HTTPS, or UDP or TCP.  Example: `HTTP`
        """
        dns: NotRequired[pulumi.Input['NetworkLoadBalancersBackendSetsUnifiedHealthCheckerDnsArgsDict']]
        """
        (Updatable) DNS healthcheck configurations.
        """
        interval_in_millis: NotRequired[pulumi.Input[builtins.int]]
        """
        (Updatable) The interval between health checks, in milliseconds. The default value is 10000 (10 seconds).  Example: `10000`
        """
        port: NotRequired[pulumi.Input[builtins.int]]
        """
        (Updatable) The backend server port against which to run the health check. If the port is not specified, then the network load balancer uses the port information from the `Backend` object. The port must be specified if the backend port is 0.  Example: `8080`
        """
        request_data: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) Base64 encoded pattern to be sent as UDP or TCP health check probe.
        """
        response_body_regex: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) A regular expression for parsing the response body from the backend server.  Example: `^((?!false).|\\s)*$`
        """
        response_data: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) Base64 encoded pattern to be validated as UDP or TCP health check probe response.
        """
        retries: NotRequired[pulumi.Input[builtins.int]]
        """
        (Updatable) The number of retries to attempt before a backend server is considered "unhealthy". This number also applies when recovering a server to the "healthy" state. The default value is 3.  Example: `3`
        """
        return_code: NotRequired[pulumi.Input[builtins.int]]
        """
        (Updatable) The status code a healthy backend server should return. If you configure the health check policy to use the HTTP protocol, then you can use common HTTP status codes such as "200".  Example: `200`
        """
        timeout_in_millis: NotRequired[pulumi.Input[builtins.int]]
        """
        (Updatable) The maximum time, in milliseconds, to wait for a reply to a health check. A health check is successful only if a reply returns within this timeout period. The default value is 3000 (3 seconds).  Example: `3000`
        """
        url_path: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) The path against which to run the health check.  Example: `/healthcheck`
        """
elif False:
    NetworkLoadBalancersBackendSetsUnifiedHealthCheckerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkLoadBalancersBackendSetsUnifiedHealthCheckerArgs:
    def __init__(__self__, *,
                 protocol: pulumi.Input[builtins.str],
                 dns: Optional[pulumi.Input['NetworkLoadBalancersBackendSetsUnifiedHealthCheckerDnsArgs']] = None,
                 interval_in_millis: Optional[pulumi.Input[builtins.int]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 request_data: Optional[pulumi.Input[builtins.str]] = None,
                 response_body_regex: Optional[pulumi.Input[builtins.str]] = None,
                 response_data: Optional[pulumi.Input[builtins.str]] = None,
                 retries: Optional[pulumi.Input[builtins.int]] = None,
                 return_code: Optional[pulumi.Input[builtins.int]] = None,
                 timeout_in_millis: Optional[pulumi.Input[builtins.int]] = None,
                 url_path: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] protocol: (Updatable) The protocol the health check must use; either HTTP or HTTPS, or UDP or TCP.  Example: `HTTP`
        :param pulumi.Input['NetworkLoadBalancersBackendSetsUnifiedHealthCheckerDnsArgs'] dns: (Updatable) DNS healthcheck configurations.
        :param pulumi.Input[builtins.int] interval_in_millis: (Updatable) The interval between health checks, in milliseconds. The default value is 10000 (10 seconds).  Example: `10000`
        :param pulumi.Input[builtins.int] port: (Updatable) The backend server port against which to run the health check. If the port is not specified, then the network load balancer uses the port information from the `Backend` object. The port must be specified if the backend port is 0.  Example: `8080`
        :param pulumi.Input[builtins.str] request_data: (Updatable) Base64 encoded pattern to be sent as UDP or TCP health check probe.
        :param pulumi.Input[builtins.str] response_body_regex: (Updatable) A regular expression for parsing the response body from the backend server.  Example: `^((?!false).|\\s)*$`
        :param pulumi.Input[builtins.str] response_data: (Updatable) Base64 encoded pattern to be validated as UDP or TCP health check probe response.
        :param pulumi.Input[builtins.int] retries: (Updatable) The number of retries to attempt before a backend server is considered "unhealthy". This number also applies when recovering a server to the "healthy" state. The default value is 3.  Example: `3`
        :param pulumi.Input[builtins.int] return_code: (Updatable) The status code a healthy backend server should return. If you configure the health check policy to use the HTTP protocol, then you can use common HTTP status codes such as "200".  Example: `200`
        :param pulumi.Input[builtins.int] timeout_in_millis: (Updatable) The maximum time, in milliseconds, to wait for a reply to a health check. A health check is successful only if a reply returns within this timeout period. The default value is 3000 (3 seconds).  Example: `3000`
        :param pulumi.Input[builtins.str] url_path: (Updatable) The path against which to run the health check.  Example: `/healthcheck`
        """
        pulumi.set(__self__, "protocol", protocol)
        if dns is not None:
            pulumi.set(__self__, "dns", dns)
        if interval_in_millis is not None:
            pulumi.set(__self__, "interval_in_millis", interval_in_millis)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if request_data is not None:
            pulumi.set(__self__, "request_data", request_data)
        if response_body_regex is not None:
            pulumi.set(__self__, "response_body_regex", response_body_regex)
        if response_data is not None:
            pulumi.set(__self__, "response_data", response_data)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if return_code is not None:
            pulumi.set(__self__, "return_code", return_code)
        if timeout_in_millis is not None:
            pulumi.set(__self__, "timeout_in_millis", timeout_in_millis)
        if url_path is not None:
            pulumi.set(__self__, "url_path", url_path)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The protocol the health check must use; either HTTP or HTTPS, or UDP or TCP.  Example: `HTTP`
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def dns(self) -> Optional[pulumi.Input['NetworkLoadBalancersBackendSetsUnifiedHealthCheckerDnsArgs']]:
        """
        (Updatable) DNS healthcheck configurations.
        """
        return pulumi.get(self, "dns")

    @dns.setter
    def dns(self, value: Optional[pulumi.Input['NetworkLoadBalancersBackendSetsUnifiedHealthCheckerDnsArgs']]):
        pulumi.set(self, "dns", value)

    @property
    @pulumi.getter(name="intervalInMillis")
    def interval_in_millis(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The interval between health checks, in milliseconds. The default value is 10000 (10 seconds).  Example: `10000`
        """
        return pulumi.get(self, "interval_in_millis")

    @interval_in_millis.setter
    def interval_in_millis(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "interval_in_millis", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The backend server port against which to run the health check. If the port is not specified, then the network load balancer uses the port information from the `Backend` object. The port must be specified if the backend port is 0.  Example: `8080`
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="requestData")
    def request_data(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Base64 encoded pattern to be sent as UDP or TCP health check probe.
        """
        return pulumi.get(self, "request_data")

    @request_data.setter
    def request_data(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "request_data", value)

    @property
    @pulumi.getter(name="responseBodyRegex")
    def response_body_regex(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A regular expression for parsing the response body from the backend server.  Example: `^((?!false).|\\s)*$`
        """
        return pulumi.get(self, "response_body_regex")

    @response_body_regex.setter
    def response_body_regex(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "response_body_regex", value)

    @property
    @pulumi.getter(name="responseData")
    def response_data(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Base64 encoded pattern to be validated as UDP or TCP health check probe response.
        """
        return pulumi.get(self, "response_data")

    @response_data.setter
    def response_data(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "response_data", value)

    @property
    @pulumi.getter
    def retries(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The number of retries to attempt before a backend server is considered "unhealthy". This number also applies when recovering a server to the "healthy" state. The default value is 3.  Example: `3`
        """
        return pulumi.get(self, "retries")

    @retries.setter
    def retries(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "retries", value)

    @property
    @pulumi.getter(name="returnCode")
    def return_code(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The status code a healthy backend server should return. If you configure the health check policy to use the HTTP protocol, then you can use common HTTP status codes such as "200".  Example: `200`
        """
        return pulumi.get(self, "return_code")

    @return_code.setter
    def return_code(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "return_code", value)

    @property
    @pulumi.getter(name="timeoutInMillis")
    def timeout_in_millis(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The maximum time, in milliseconds, to wait for a reply to a health check. A health check is successful only if a reply returns within this timeout period. The default value is 3000 (3 seconds).  Example: `3000`
        """
        return pulumi.get(self, "timeout_in_millis")

    @timeout_in_millis.setter
    def timeout_in_millis(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "timeout_in_millis", value)

    @property
    @pulumi.getter(name="urlPath")
    def url_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The path against which to run the health check.  Example: `/healthcheck`
        """
        return pulumi.get(self, "url_path")

    @url_path.setter
    def url_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "url_path", value)


if not MYPY:
    class NetworkLoadBalancersBackendSetsUnifiedHealthCheckerDnsArgsDict(TypedDict):
        domain_name: pulumi.Input[builtins.str]
        """
        (Updatable) The absolute fully-qualified domain name to perform periodic DNS queries. If not provided, an extra dot will be added at the end of a domain name during the query.
        """
        query_class: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) The class the dns health check query to use; either IN or CH.  Example: `IN`
        """
        query_type: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) The type the dns health check query to use; A, AAAA, TXT.  Example: `A`
        """
        rcodes: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        (Updatable) An array that represents accepetable RCODE values for DNS query response. Example: ["NOERROR", "NXDOMAIN"]
        """
        transport_protocol: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) DNS transport protocol; either UDP or TCP.  Example: `UDP`
        """
elif False:
    NetworkLoadBalancersBackendSetsUnifiedHealthCheckerDnsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkLoadBalancersBackendSetsUnifiedHealthCheckerDnsArgs:
    def __init__(__self__, *,
                 domain_name: pulumi.Input[builtins.str],
                 query_class: Optional[pulumi.Input[builtins.str]] = None,
                 query_type: Optional[pulumi.Input[builtins.str]] = None,
                 rcodes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 transport_protocol: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] domain_name: (Updatable) The absolute fully-qualified domain name to perform periodic DNS queries. If not provided, an extra dot will be added at the end of a domain name during the query.
        :param pulumi.Input[builtins.str] query_class: (Updatable) The class the dns health check query to use; either IN or CH.  Example: `IN`
        :param pulumi.Input[builtins.str] query_type: (Updatable) The type the dns health check query to use; A, AAAA, TXT.  Example: `A`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] rcodes: (Updatable) An array that represents accepetable RCODE values for DNS query response. Example: ["NOERROR", "NXDOMAIN"]
        :param pulumi.Input[builtins.str] transport_protocol: (Updatable) DNS transport protocol; either UDP or TCP.  Example: `UDP`
        """
        pulumi.set(__self__, "domain_name", domain_name)
        if query_class is not None:
            pulumi.set(__self__, "query_class", query_class)
        if query_type is not None:
            pulumi.set(__self__, "query_type", query_type)
        if rcodes is not None:
            pulumi.set(__self__, "rcodes", rcodes)
        if transport_protocol is not None:
            pulumi.set(__self__, "transport_protocol", transport_protocol)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The absolute fully-qualified domain name to perform periodic DNS queries. If not provided, an extra dot will be added at the end of a domain name during the query.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="queryClass")
    def query_class(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The class the dns health check query to use; either IN or CH.  Example: `IN`
        """
        return pulumi.get(self, "query_class")

    @query_class.setter
    def query_class(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "query_class", value)

    @property
    @pulumi.getter(name="queryType")
    def query_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The type the dns health check query to use; A, AAAA, TXT.  Example: `A`
        """
        return pulumi.get(self, "query_type")

    @query_type.setter
    def query_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "query_type", value)

    @property
    @pulumi.getter
    def rcodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) An array that represents accepetable RCODE values for DNS query response. Example: ["NOERROR", "NXDOMAIN"]
        """
        return pulumi.get(self, "rcodes")

    @rcodes.setter
    def rcodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "rcodes", value)

    @property
    @pulumi.getter(name="transportProtocol")
    def transport_protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) DNS transport protocol; either UDP or TCP.  Example: `UDP`
        """
        return pulumi.get(self, "transport_protocol")

    @transport_protocol.setter
    def transport_protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "transport_protocol", value)


if not MYPY:
    class GetBackendSetsFilterArgsDict(TypedDict):
        name: builtins.str
        """
        A user-friendly name for the backend set that must be unique and cannot be changed.
        """
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetBackendSetsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetBackendSetsFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: A user-friendly name for the backend set that must be unique and cannot be changed.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A user-friendly name for the backend set that must be unique and cannot be changed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetBackendsFilterArgsDict(TypedDict):
        name: builtins.str
        """
        A read-only field showing the IP address/IP OCID and port that uniquely identify this backend server in the backend set.  Example: `10.0.0.3:8080`, or `ocid1.privateip..oc1.<var>&lt;unique_ID&gt;</var>:443` or `10.0.0.3:0`
        """
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetBackendsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetBackendsFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: A read-only field showing the IP address/IP OCID and port that uniquely identify this backend server in the backend set.  Example: `10.0.0.3:8080`, or `ocid1.privateip..oc1.<var>&lt;unique_ID&gt;</var>:443` or `10.0.0.3:0`
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A read-only field showing the IP address/IP OCID and port that uniquely identify this backend server in the backend set.  Example: `10.0.0.3:8080`, or `ocid1.privateip..oc1.<var>&lt;unique_ID&gt;</var>:443` or `10.0.0.3:0`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetListenersFilterArgsDict(TypedDict):
        name: builtins.str
        """
        A friendly name for the listener. It must be unique and it cannot be changed.  Example: `example_listener`
        """
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetListenersFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetListenersFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: A friendly name for the listener. It must be unique and it cannot be changed.  Example: `example_listener`
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A friendly name for the listener. It must be unique and it cannot be changed.  Example: `example_listener`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetNetworkLoadBalancersFilterArgsDict(TypedDict):
        name: builtins.str
        """
        A friendly name for the listener. It must be unique and it cannot be changed.  Example: `example_listener`
        """
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetNetworkLoadBalancersFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetNetworkLoadBalancersFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: A friendly name for the listener. It must be unique and it cannot be changed.  Example: `example_listener`
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A friendly name for the listener. It must be unique and it cannot be changed.  Example: `example_listener`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetNetworkLoadBalancersPoliciesFilterArgsDict(TypedDict):
        name: builtins.str
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetNetworkLoadBalancersPoliciesFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetNetworkLoadBalancersPoliciesFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetNetworkLoadBalancersProtocolsFilterArgsDict(TypedDict):
        name: builtins.str
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetNetworkLoadBalancersProtocolsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetNetworkLoadBalancersProtocolsFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


