# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetBackendSetResult',
    'AwaitableGetBackendSetResult',
    'get_backend_set',
    'get_backend_set_output',
]

@pulumi.output_type
class GetBackendSetResult:
    """
    A collection of values returned by getBackendSet.
    """
    def __init__(__self__, are_operationally_active_backends_preferred=None, backend_set_name=None, backends=None, health_checkers=None, id=None, ip_version=None, is_fail_open=None, is_instant_failover_enabled=None, is_instant_failover_tcp_reset_enabled=None, is_preserve_source=None, name=None, network_load_balancer_id=None, policy=None):
        if are_operationally_active_backends_preferred and not isinstance(are_operationally_active_backends_preferred, bool):
            raise TypeError("Expected argument 'are_operationally_active_backends_preferred' to be a bool")
        pulumi.set(__self__, "are_operationally_active_backends_preferred", are_operationally_active_backends_preferred)
        if backend_set_name and not isinstance(backend_set_name, str):
            raise TypeError("Expected argument 'backend_set_name' to be a str")
        pulumi.set(__self__, "backend_set_name", backend_set_name)
        if backends and not isinstance(backends, list):
            raise TypeError("Expected argument 'backends' to be a list")
        pulumi.set(__self__, "backends", backends)
        if health_checkers and not isinstance(health_checkers, list):
            raise TypeError("Expected argument 'health_checkers' to be a list")
        pulumi.set(__self__, "health_checkers", health_checkers)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_version and not isinstance(ip_version, str):
            raise TypeError("Expected argument 'ip_version' to be a str")
        pulumi.set(__self__, "ip_version", ip_version)
        if is_fail_open and not isinstance(is_fail_open, bool):
            raise TypeError("Expected argument 'is_fail_open' to be a bool")
        pulumi.set(__self__, "is_fail_open", is_fail_open)
        if is_instant_failover_enabled and not isinstance(is_instant_failover_enabled, bool):
            raise TypeError("Expected argument 'is_instant_failover_enabled' to be a bool")
        pulumi.set(__self__, "is_instant_failover_enabled", is_instant_failover_enabled)
        if is_instant_failover_tcp_reset_enabled and not isinstance(is_instant_failover_tcp_reset_enabled, bool):
            raise TypeError("Expected argument 'is_instant_failover_tcp_reset_enabled' to be a bool")
        pulumi.set(__self__, "is_instant_failover_tcp_reset_enabled", is_instant_failover_tcp_reset_enabled)
        if is_preserve_source and not isinstance(is_preserve_source, bool):
            raise TypeError("Expected argument 'is_preserve_source' to be a bool")
        pulumi.set(__self__, "is_preserve_source", is_preserve_source)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_load_balancer_id and not isinstance(network_load_balancer_id, str):
            raise TypeError("Expected argument 'network_load_balancer_id' to be a str")
        pulumi.set(__self__, "network_load_balancer_id", network_load_balancer_id)
        if policy and not isinstance(policy, str):
            raise TypeError("Expected argument 'policy' to be a str")
        pulumi.set(__self__, "policy", policy)

    @property
    @pulumi.getter(name="areOperationallyActiveBackendsPreferred")
    def are_operationally_active_backends_preferred(self) -> builtins.bool:
        """
        If enabled, NLB supports active-standby backends. The standby backend takes over the traffic when the active node fails, and continues to serve the traffic even when the old active node is back healthy.
        """
        return pulumi.get(self, "are_operationally_active_backends_preferred")

    @property
    @pulumi.getter(name="backendSetName")
    def backend_set_name(self) -> builtins.str:
        return pulumi.get(self, "backend_set_name")

    @property
    @pulumi.getter
    def backends(self) -> Sequence['outputs.GetBackendSetBackendResult']:
        """
        An array of backends.
        """
        return pulumi.get(self, "backends")

    @property
    @pulumi.getter(name="healthCheckers")
    def health_checkers(self) -> Sequence['outputs.GetBackendSetHealthCheckerResult']:
        """
        The health check policy configuration. For more information, see [Editing Network Load Balancer Health Check Policies](https://docs.cloud.oracle.com/iaas/Content/NetworkLoadBalancer/HealthCheckPolicies/update-health-check-management.htm).
        """
        return pulumi.get(self, "health_checkers")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> builtins.str:
        """
        IP version associated with the backend set.
        """
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter(name="isFailOpen")
    def is_fail_open(self) -> builtins.bool:
        """
        If enabled, the network load balancer will continue to distribute traffic in the configured distribution in the event all backends are unhealthy. The value is false by default.
        """
        return pulumi.get(self, "is_fail_open")

    @property
    @pulumi.getter(name="isInstantFailoverEnabled")
    def is_instant_failover_enabled(self) -> builtins.bool:
        """
        If enabled existing connections will be forwarded to an alternative healthy backend as soon as current backend becomes unhealthy.
        """
        return pulumi.get(self, "is_instant_failover_enabled")

    @property
    @pulumi.getter(name="isInstantFailoverTcpResetEnabled")
    def is_instant_failover_tcp_reset_enabled(self) -> builtins.bool:
        """
        If enabled along with instant failover, the network load balancer will send TCP RST to the clients for the existing connections instead of failing over to a healthy backend. This only applies when using the instant failover. By default, TCP RST is enabled.
        """
        return pulumi.get(self, "is_instant_failover_tcp_reset_enabled")

    @property
    @pulumi.getter(name="isPreserveSource")
    def is_preserve_source(self) -> builtins.bool:
        """
        If this parameter is enabled, then the network load balancer preserves the source IP of the packet when it is forwarded to backends. Backends see the original source IP. If the isPreserveSourceDestination parameter is enabled for the network load balancer resource, then this parameter cannot be disabled. The value is true by default.
        """
        return pulumi.get(self, "is_preserve_source")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A user-friendly name for the backend set that must be unique and cannot be changed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkLoadBalancerId")
    def network_load_balancer_id(self) -> builtins.str:
        return pulumi.get(self, "network_load_balancer_id")

    @property
    @pulumi.getter
    def policy(self) -> builtins.str:
        """
        The network load balancer policy for the backend set.  Example: `FIVE_TUPLE`
        """
        return pulumi.get(self, "policy")


class AwaitableGetBackendSetResult(GetBackendSetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBackendSetResult(
            are_operationally_active_backends_preferred=self.are_operationally_active_backends_preferred,
            backend_set_name=self.backend_set_name,
            backends=self.backends,
            health_checkers=self.health_checkers,
            id=self.id,
            ip_version=self.ip_version,
            is_fail_open=self.is_fail_open,
            is_instant_failover_enabled=self.is_instant_failover_enabled,
            is_instant_failover_tcp_reset_enabled=self.is_instant_failover_tcp_reset_enabled,
            is_preserve_source=self.is_preserve_source,
            name=self.name,
            network_load_balancer_id=self.network_load_balancer_id,
            policy=self.policy)


def get_backend_set(backend_set_name: Optional[builtins.str] = None,
                    network_load_balancer_id: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBackendSetResult:
    """
    This data source provides details about a specific Backend Set resource in Oracle Cloud Infrastructure Network Load Balancer service.

    Retrieves the configuration information for the specified backend set.


    :param builtins.str backend_set_name: The name of the backend set to retrieve.  Example: `example_backend_set`
    :param builtins.str network_load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer to update.
    """
    __args__ = dict()
    __args__['backendSetName'] = backend_set_name
    __args__['networkLoadBalancerId'] = network_load_balancer_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:NetworkLoadBalancer/getBackendSet:getBackendSet', __args__, opts=opts, typ=GetBackendSetResult).value

    return AwaitableGetBackendSetResult(
        are_operationally_active_backends_preferred=pulumi.get(__ret__, 'are_operationally_active_backends_preferred'),
        backend_set_name=pulumi.get(__ret__, 'backend_set_name'),
        backends=pulumi.get(__ret__, 'backends'),
        health_checkers=pulumi.get(__ret__, 'health_checkers'),
        id=pulumi.get(__ret__, 'id'),
        ip_version=pulumi.get(__ret__, 'ip_version'),
        is_fail_open=pulumi.get(__ret__, 'is_fail_open'),
        is_instant_failover_enabled=pulumi.get(__ret__, 'is_instant_failover_enabled'),
        is_instant_failover_tcp_reset_enabled=pulumi.get(__ret__, 'is_instant_failover_tcp_reset_enabled'),
        is_preserve_source=pulumi.get(__ret__, 'is_preserve_source'),
        name=pulumi.get(__ret__, 'name'),
        network_load_balancer_id=pulumi.get(__ret__, 'network_load_balancer_id'),
        policy=pulumi.get(__ret__, 'policy'))
def get_backend_set_output(backend_set_name: Optional[pulumi.Input[builtins.str]] = None,
                           network_load_balancer_id: Optional[pulumi.Input[builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBackendSetResult]:
    """
    This data source provides details about a specific Backend Set resource in Oracle Cloud Infrastructure Network Load Balancer service.

    Retrieves the configuration information for the specified backend set.


    :param builtins.str backend_set_name: The name of the backend set to retrieve.  Example: `example_backend_set`
    :param builtins.str network_load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer to update.
    """
    __args__ = dict()
    __args__['backendSetName'] = backend_set_name
    __args__['networkLoadBalancerId'] = network_load_balancer_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:NetworkLoadBalancer/getBackendSet:getBackendSet', __args__, opts=opts, typ=GetBackendSetResult)
    return __ret__.apply(lambda __response__: GetBackendSetResult(
        are_operationally_active_backends_preferred=pulumi.get(__response__, 'are_operationally_active_backends_preferred'),
        backend_set_name=pulumi.get(__response__, 'backend_set_name'),
        backends=pulumi.get(__response__, 'backends'),
        health_checkers=pulumi.get(__response__, 'health_checkers'),
        id=pulumi.get(__response__, 'id'),
        ip_version=pulumi.get(__response__, 'ip_version'),
        is_fail_open=pulumi.get(__response__, 'is_fail_open'),
        is_instant_failover_enabled=pulumi.get(__response__, 'is_instant_failover_enabled'),
        is_instant_failover_tcp_reset_enabled=pulumi.get(__response__, 'is_instant_failover_tcp_reset_enabled'),
        is_preserve_source=pulumi.get(__response__, 'is_preserve_source'),
        name=pulumi.get(__response__, 'name'),
        network_load_balancer_id=pulumi.get(__response__, 'network_load_balancer_id'),
        policy=pulumi.get(__response__, 'policy')))
