# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetNetworkLoadBalancerBackendSetBackendOperationalStatusResult',
    'AwaitableGetNetworkLoadBalancerBackendSetBackendOperationalStatusResult',
    'get_network_load_balancer_backend_set_backend_operational_status',
    'get_network_load_balancer_backend_set_backend_operational_status_output',
]

@pulumi.output_type
class GetNetworkLoadBalancerBackendSetBackendOperationalStatusResult:
    """
    A collection of values returned by getNetworkLoadBalancerBackendSetBackendOperationalStatus.
    """
    def __init__(__self__, backend_name=None, backend_set_name=None, id=None, network_load_balancer_id=None, status=None):
        if backend_name and not isinstance(backend_name, str):
            raise TypeError("Expected argument 'backend_name' to be a str")
        pulumi.set(__self__, "backend_name", backend_name)
        if backend_set_name and not isinstance(backend_set_name, str):
            raise TypeError("Expected argument 'backend_set_name' to be a str")
        pulumi.set(__self__, "backend_set_name", backend_set_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if network_load_balancer_id and not isinstance(network_load_balancer_id, str):
            raise TypeError("Expected argument 'network_load_balancer_id' to be a str")
        pulumi.set(__self__, "network_load_balancer_id", network_load_balancer_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="backendName")
    def backend_name(self) -> builtins.str:
        return pulumi.get(self, "backend_name")

    @property
    @pulumi.getter(name="backendSetName")
    def backend_set_name(self) -> builtins.str:
        return pulumi.get(self, "backend_set_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="networkLoadBalancerId")
    def network_load_balancer_id(self) -> builtins.str:
        return pulumi.get(self, "network_load_balancer_id")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        The operational status.
        """
        return pulumi.get(self, "status")


class AwaitableGetNetworkLoadBalancerBackendSetBackendOperationalStatusResult(GetNetworkLoadBalancerBackendSetBackendOperationalStatusResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkLoadBalancerBackendSetBackendOperationalStatusResult(
            backend_name=self.backend_name,
            backend_set_name=self.backend_set_name,
            id=self.id,
            network_load_balancer_id=self.network_load_balancer_id,
            status=self.status)


def get_network_load_balancer_backend_set_backend_operational_status(backend_name: Optional[builtins.str] = None,
                                                                     backend_set_name: Optional[builtins.str] = None,
                                                                     network_load_balancer_id: Optional[builtins.str] = None,
                                                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkLoadBalancerBackendSetBackendOperationalStatusResult:
    """
    This data source provides details about a specific Network Load Balancer Backend Set Backend Operational Status resource in Oracle Cloud Infrastructure Network Load Balancer service.

    Retrieves the current operational status of the specified backend server.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_network_load_balancer_backend_set_backend_operational_status = oci.NetworkLoadBalancer.get_network_load_balancer_backend_set_backend_operational_status(backend_name=test_backend["name"],
        backend_set_name=test_backend_set["name"],
        network_load_balancer_id=test_network_load_balancer["id"])
    ```


    :param builtins.str backend_name: The name of the backend server to retrieve health status for. If the backend was created with an explicitly specified name, that name should be used here. If the backend was created without explicitly specifying the name, but was created using ipAddress, this is specified as <ipAddress>:<port>. If the backend was created without explicitly specifying the name, but was created using targetId, this is specified as <targetId>:<port>.  Example: `10.0.0.3:8080` or `ocid1.privateip..oc1.<var>&lt;unique_ID&gt;</var>:8080`
    :param builtins.str backend_set_name: The name of the backend set associated with the backend server for which to retrieve the operational status.  Example: `example_backend_set`
    :param builtins.str network_load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer to update.
    """
    __args__ = dict()
    __args__['backendName'] = backend_name
    __args__['backendSetName'] = backend_set_name
    __args__['networkLoadBalancerId'] = network_load_balancer_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:NetworkLoadBalancer/getNetworkLoadBalancerBackendSetBackendOperationalStatus:getNetworkLoadBalancerBackendSetBackendOperationalStatus', __args__, opts=opts, typ=GetNetworkLoadBalancerBackendSetBackendOperationalStatusResult).value

    return AwaitableGetNetworkLoadBalancerBackendSetBackendOperationalStatusResult(
        backend_name=pulumi.get(__ret__, 'backend_name'),
        backend_set_name=pulumi.get(__ret__, 'backend_set_name'),
        id=pulumi.get(__ret__, 'id'),
        network_load_balancer_id=pulumi.get(__ret__, 'network_load_balancer_id'),
        status=pulumi.get(__ret__, 'status'))
def get_network_load_balancer_backend_set_backend_operational_status_output(backend_name: Optional[pulumi.Input[builtins.str]] = None,
                                                                            backend_set_name: Optional[pulumi.Input[builtins.str]] = None,
                                                                            network_load_balancer_id: Optional[pulumi.Input[builtins.str]] = None,
                                                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNetworkLoadBalancerBackendSetBackendOperationalStatusResult]:
    """
    This data source provides details about a specific Network Load Balancer Backend Set Backend Operational Status resource in Oracle Cloud Infrastructure Network Load Balancer service.

    Retrieves the current operational status of the specified backend server.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_network_load_balancer_backend_set_backend_operational_status = oci.NetworkLoadBalancer.get_network_load_balancer_backend_set_backend_operational_status(backend_name=test_backend["name"],
        backend_set_name=test_backend_set["name"],
        network_load_balancer_id=test_network_load_balancer["id"])
    ```


    :param builtins.str backend_name: The name of the backend server to retrieve health status for. If the backend was created with an explicitly specified name, that name should be used here. If the backend was created without explicitly specifying the name, but was created using ipAddress, this is specified as <ipAddress>:<port>. If the backend was created without explicitly specifying the name, but was created using targetId, this is specified as <targetId>:<port>.  Example: `10.0.0.3:8080` or `ocid1.privateip..oc1.<var>&lt;unique_ID&gt;</var>:8080`
    :param builtins.str backend_set_name: The name of the backend set associated with the backend server for which to retrieve the operational status.  Example: `example_backend_set`
    :param builtins.str network_load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer to update.
    """
    __args__ = dict()
    __args__['backendName'] = backend_name
    __args__['backendSetName'] = backend_set_name
    __args__['networkLoadBalancerId'] = network_load_balancer_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:NetworkLoadBalancer/getNetworkLoadBalancerBackendSetBackendOperationalStatus:getNetworkLoadBalancerBackendSetBackendOperationalStatus', __args__, opts=opts, typ=GetNetworkLoadBalancerBackendSetBackendOperationalStatusResult)
    return __ret__.apply(lambda __response__: GetNetworkLoadBalancerBackendSetBackendOperationalStatusResult(
        backend_name=pulumi.get(__response__, 'backend_name'),
        backend_set_name=pulumi.get(__response__, 'backend_set_name'),
        id=pulumi.get(__response__, 'id'),
        network_load_balancer_id=pulumi.get(__response__, 'network_load_balancer_id'),
        status=pulumi.get(__response__, 'status')))
