# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConfigurationArgs', 'Configuration']

@pulumi.input_type
class ConfigurationArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 environment: pulumi.Input[builtins.str],
                 is_opc_dry_run: Optional[pulumi.Input[builtins.bool]] = None,
                 kms_key: Optional[pulumi.Input['ConfigurationKmsKeyArgs']] = None):
        """
        The set of arguments for constructing a Configuration resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The tenancy's OCID
        :param pulumi.Input[builtins.str] environment: (Updatable) The service environment type.
        :param pulumi.Input[builtins.bool] is_opc_dry_run: (Updatable) If true, indicates that the request is a dry run. A dry run request does not modify the configuration item details and is used only to perform validation on the submitted data.
        :param pulumi.Input['ConfigurationKmsKeyArgs'] kms_key: (Updatable) Information about the state of the service's encryption key management. The following properties are read-only and ignored when this object is used in UpdateConfiguration: kmsKeyState, timeCreated, timeUpdated.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "environment", environment)
        if is_opc_dry_run is not None:
            pulumi.set(__self__, "is_opc_dry_run", is_opc_dry_run)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The tenancy's OCID
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The service environment type.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter(name="isOpcDryRun")
    def is_opc_dry_run(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) If true, indicates that the request is a dry run. A dry run request does not modify the configuration item details and is used only to perform validation on the submitted data.
        """
        return pulumi.get(self, "is_opc_dry_run")

    @is_opc_dry_run.setter
    def is_opc_dry_run(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_opc_dry_run", value)

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[pulumi.Input['ConfigurationKmsKeyArgs']]:
        """
        (Updatable) Information about the state of the service's encryption key management. The following properties are read-only and ignored when this object is used in UpdateConfiguration: kmsKeyState, timeCreated, timeUpdated.
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: Optional[pulumi.Input['ConfigurationKmsKeyArgs']]):
        pulumi.set(self, "kms_key", value)


@pulumi.input_type
class _ConfigurationState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 environment: Optional[pulumi.Input[builtins.str]] = None,
                 is_opc_dry_run: Optional[pulumi.Input[builtins.bool]] = None,
                 kms_key: Optional[pulumi.Input['ConfigurationKmsKeyArgs']] = None):
        """
        Input properties used for looking up and filtering Configuration resources.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The tenancy's OCID
        :param pulumi.Input[builtins.str] environment: (Updatable) The service environment type.
        :param pulumi.Input[builtins.bool] is_opc_dry_run: (Updatable) If true, indicates that the request is a dry run. A dry run request does not modify the configuration item details and is used only to perform validation on the submitted data.
        :param pulumi.Input['ConfigurationKmsKeyArgs'] kms_key: (Updatable) Information about the state of the service's encryption key management. The following properties are read-only and ignored when this object is used in UpdateConfiguration: kmsKeyState, timeCreated, timeUpdated.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if is_opc_dry_run is not None:
            pulumi.set(__self__, "is_opc_dry_run", is_opc_dry_run)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The tenancy's OCID
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The service environment type.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter(name="isOpcDryRun")
    def is_opc_dry_run(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) If true, indicates that the request is a dry run. A dry run request does not modify the configuration item details and is used only to perform validation on the submitted data.
        """
        return pulumi.get(self, "is_opc_dry_run")

    @is_opc_dry_run.setter
    def is_opc_dry_run(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_opc_dry_run", value)

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[pulumi.Input['ConfigurationKmsKeyArgs']]:
        """
        (Updatable) Information about the state of the service's encryption key management. The following properties are read-only and ignored when this object is used in UpdateConfiguration: kmsKeyState, timeCreated, timeUpdated.
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: Optional[pulumi.Input['ConfigurationKmsKeyArgs']]):
        pulumi.set(self, "kms_key", value)


@pulumi.type_token("oci:Nosql/configuration:Configuration")
class Configuration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 environment: Optional[pulumi.Input[builtins.str]] = None,
                 is_opc_dry_run: Optional[pulumi.Input[builtins.bool]] = None,
                 kms_key: Optional[pulumi.Input[Union['ConfigurationKmsKeyArgs', 'ConfigurationKmsKeyArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Configuration in Oracle Cloud Infrastructure NoSQL Database service.

        Updates the service-level configuration.  The discriminator value
        `UpdateConfigurationDetails.environment` must match the service's
        environment type.

        A configuration serves as a centralized repository for global parameters that
        affect the NoSQL service. Currently, there is only one such parameter: a
        customer-provided key for encrypting NoSQL data at rest.

        The Customer-Managed Encryption Keys (CMEK) feature is exclusively available
        in private NoSQL environments dedicated to a single tenancy, where the CMEK
        option has been enabled. Updating the configuration of the default, regional,
        multi-tenancy NoSQL service is not supported.

        To specify the dedicated environment, set the environment variable
        CLIENT_HOST_OVERRIDES=oci_nosql.NosqlClient=$ENDPOINT
        Where $ENDPOINT is the endpoint of the dedicated NoSQL environment.
        For example:
        $ export CLIENT_HOST_OVERRIDES=oci_nosql.NosqlClient=https://acme-widgets.nosql.oci.oraclecloud.com

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_configuration = oci.nosql.Configuration("test_configuration",
            compartment_id=compartment_id,
            environment="HOSTED",
            is_opc_dry_run=configuration_is_opc_dry_run,
            kms_key={
                "id": configuration_kms_key_id,
                "kms_vault_id": test_vault["id"],
            })
        ```

        ## Import

        Configurations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Nosql/configuration:Configuration test_configuration "configuration/compartmentId/{compartmentId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The tenancy's OCID
        :param pulumi.Input[builtins.str] environment: (Updatable) The service environment type.
        :param pulumi.Input[builtins.bool] is_opc_dry_run: (Updatable) If true, indicates that the request is a dry run. A dry run request does not modify the configuration item details and is used only to perform validation on the submitted data.
        :param pulumi.Input[Union['ConfigurationKmsKeyArgs', 'ConfigurationKmsKeyArgsDict']] kms_key: (Updatable) Information about the state of the service's encryption key management. The following properties are read-only and ignored when this object is used in UpdateConfiguration: kmsKeyState, timeCreated, timeUpdated.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Configuration in Oracle Cloud Infrastructure NoSQL Database service.

        Updates the service-level configuration.  The discriminator value
        `UpdateConfigurationDetails.environment` must match the service's
        environment type.

        A configuration serves as a centralized repository for global parameters that
        affect the NoSQL service. Currently, there is only one such parameter: a
        customer-provided key for encrypting NoSQL data at rest.

        The Customer-Managed Encryption Keys (CMEK) feature is exclusively available
        in private NoSQL environments dedicated to a single tenancy, where the CMEK
        option has been enabled. Updating the configuration of the default, regional,
        multi-tenancy NoSQL service is not supported.

        To specify the dedicated environment, set the environment variable
        CLIENT_HOST_OVERRIDES=oci_nosql.NosqlClient=$ENDPOINT
        Where $ENDPOINT is the endpoint of the dedicated NoSQL environment.
        For example:
        $ export CLIENT_HOST_OVERRIDES=oci_nosql.NosqlClient=https://acme-widgets.nosql.oci.oraclecloud.com

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_configuration = oci.nosql.Configuration("test_configuration",
            compartment_id=compartment_id,
            environment="HOSTED",
            is_opc_dry_run=configuration_is_opc_dry_run,
            kms_key={
                "id": configuration_kms_key_id,
                "kms_vault_id": test_vault["id"],
            })
        ```

        ## Import

        Configurations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Nosql/configuration:Configuration test_configuration "configuration/compartmentId/{compartmentId}"
        ```

        :param str resource_name: The name of the resource.
        :param ConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 environment: Optional[pulumi.Input[builtins.str]] = None,
                 is_opc_dry_run: Optional[pulumi.Input[builtins.bool]] = None,
                 kms_key: Optional[pulumi.Input[Union['ConfigurationKmsKeyArgs', 'ConfigurationKmsKeyArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConfigurationArgs.__new__(ConfigurationArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if environment is None and not opts.urn:
                raise TypeError("Missing required property 'environment'")
            __props__.__dict__["environment"] = environment
            __props__.__dict__["is_opc_dry_run"] = is_opc_dry_run
            __props__.__dict__["kms_key"] = kms_key
        super(Configuration, __self__).__init__(
            'oci:Nosql/configuration:Configuration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            environment: Optional[pulumi.Input[builtins.str]] = None,
            is_opc_dry_run: Optional[pulumi.Input[builtins.bool]] = None,
            kms_key: Optional[pulumi.Input[Union['ConfigurationKmsKeyArgs', 'ConfigurationKmsKeyArgsDict']]] = None) -> 'Configuration':
        """
        Get an existing Configuration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The tenancy's OCID
        :param pulumi.Input[builtins.str] environment: (Updatable) The service environment type.
        :param pulumi.Input[builtins.bool] is_opc_dry_run: (Updatable) If true, indicates that the request is a dry run. A dry run request does not modify the configuration item details and is used only to perform validation on the submitted data.
        :param pulumi.Input[Union['ConfigurationKmsKeyArgs', 'ConfigurationKmsKeyArgsDict']] kms_key: (Updatable) Information about the state of the service's encryption key management. The following properties are read-only and ignored when this object is used in UpdateConfiguration: kmsKeyState, timeCreated, timeUpdated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConfigurationState.__new__(_ConfigurationState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["environment"] = environment
        __props__.__dict__["is_opc_dry_run"] = is_opc_dry_run
        __props__.__dict__["kms_key"] = kms_key
        return Configuration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The tenancy's OCID
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The service environment type.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="isOpcDryRun")
    def is_opc_dry_run(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) If true, indicates that the request is a dry run. A dry run request does not modify the configuration item details and is used only to perform validation on the submitted data.
        """
        return pulumi.get(self, "is_opc_dry_run")

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> pulumi.Output['outputs.ConfigurationKmsKey']:
        """
        (Updatable) Information about the state of the service's encryption key management. The following properties are read-only and ignored when this object is used in UpdateConfiguration: kmsKeyState, timeCreated, timeUpdated.
        """
        return pulumi.get(self, "kms_key")

