# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetConfigurationResult',
    'AwaitableGetConfigurationResult',
    'get_configuration',
    'get_configuration_output',
]

@pulumi.output_type
class GetConfigurationResult:
    """
    A collection of values returned by getConfiguration.
    """
    def __init__(__self__, compartment_id=None, environment=None, id=None, is_opc_dry_run=None, kms_keys=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if environment and not isinstance(environment, str):
            raise TypeError("Expected argument 'environment' to be a str")
        pulumi.set(__self__, "environment", environment)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_opc_dry_run and not isinstance(is_opc_dry_run, bool):
            raise TypeError("Expected argument 'is_opc_dry_run' to be a bool")
        pulumi.set(__self__, "is_opc_dry_run", is_opc_dry_run)
        if kms_keys and not isinstance(kms_keys, list):
            raise TypeError("Expected argument 'kms_keys' to be a list")
        pulumi.set(__self__, "kms_keys", kms_keys)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def environment(self) -> builtins.str:
        """
        The service environment type.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the KMS encryption key assigned to this Hosted Environment. If the Hosted Environment is using an Oracle-managed Key (i.e., not a CMEK), then the id will be a null string.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isOpcDryRun")
    def is_opc_dry_run(self) -> builtins.bool:
        return pulumi.get(self, "is_opc_dry_run")

    @property
    @pulumi.getter(name="kmsKeys")
    def kms_keys(self) -> Sequence['outputs.GetConfigurationKmsKeyResult']:
        """
        Information about the state of the service's encryption key management. The following properties are read-only and ignored when this object is used in UpdateConfiguration: kmsKeyState, timeCreated, timeUpdated.
        """
        return pulumi.get(self, "kms_keys")


class AwaitableGetConfigurationResult(GetConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConfigurationResult(
            compartment_id=self.compartment_id,
            environment=self.environment,
            id=self.id,
            is_opc_dry_run=self.is_opc_dry_run,
            kms_keys=self.kms_keys)


def get_configuration(compartment_id: Optional[builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConfigurationResult:
    """
    This data source provides details about a specific Configuration resource in Oracle Cloud Infrastructure NoSQL Database service.

    Retrieves the current service-level configuration.  The
    service may of the standard MULTI_TENANCY type, or of the
    HOSTED environment type.  In the latter case, information about the
    current state of the environment's global encryption key is
    included in the response.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_configuration = oci.Nosql.get_configuration(compartment_id=compartment_id)
    ```


    :param builtins.str compartment_id: The ID of a table's compartment.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Nosql/getConfiguration:getConfiguration', __args__, opts=opts, typ=GetConfigurationResult).value

    return AwaitableGetConfigurationResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        environment=pulumi.get(__ret__, 'environment'),
        id=pulumi.get(__ret__, 'id'),
        is_opc_dry_run=pulumi.get(__ret__, 'is_opc_dry_run'),
        kms_keys=pulumi.get(__ret__, 'kms_keys'))
def get_configuration_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetConfigurationResult]:
    """
    This data source provides details about a specific Configuration resource in Oracle Cloud Infrastructure NoSQL Database service.

    Retrieves the current service-level configuration.  The
    service may of the standard MULTI_TENANCY type, or of the
    HOSTED environment type.  In the latter case, information about the
    current state of the environment's global encryption key is
    included in the response.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_configuration = oci.Nosql.get_configuration(compartment_id=compartment_id)
    ```


    :param builtins.str compartment_id: The ID of a table's compartment.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Nosql/getConfiguration:getConfiguration', __args__, opts=opts, typ=GetConfigurationResult)
    return __ret__.apply(lambda __response__: GetConfigurationResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        environment=pulumi.get(__response__, 'environment'),
        id=pulumi.get(__response__, 'id'),
        is_opc_dry_run=pulumi.get(__response__, 'is_opc_dry_run'),
        kms_keys=pulumi.get(__response__, 'kms_keys')))
