# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDbmulticloudOracleDbAzureBlobContainersResult',
    'AwaitableGetDbmulticloudOracleDbAzureBlobContainersResult',
    'get_dbmulticloud_oracle_db_azure_blob_containers',
    'get_dbmulticloud_oracle_db_azure_blob_containers_output',
]

@pulumi.output_type
class GetDbmulticloudOracleDbAzureBlobContainersResult:
    """
    A collection of values returned by getDbmulticloudOracleDbAzureBlobContainers.
    """
    def __init__(__self__, azure_storage_account_name=None, azure_storage_container_name=None, compartment_id=None, display_name=None, filters=None, id=None, oracle_db_azure_blob_container_id=None, oracle_db_azure_blob_container_summary_collections=None, state=None):
        if azure_storage_account_name and not isinstance(azure_storage_account_name, str):
            raise TypeError("Expected argument 'azure_storage_account_name' to be a str")
        pulumi.set(__self__, "azure_storage_account_name", azure_storage_account_name)
        if azure_storage_container_name and not isinstance(azure_storage_container_name, str):
            raise TypeError("Expected argument 'azure_storage_container_name' to be a str")
        pulumi.set(__self__, "azure_storage_container_name", azure_storage_container_name)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if oracle_db_azure_blob_container_id and not isinstance(oracle_db_azure_blob_container_id, str):
            raise TypeError("Expected argument 'oracle_db_azure_blob_container_id' to be a str")
        pulumi.set(__self__, "oracle_db_azure_blob_container_id", oracle_db_azure_blob_container_id)
        if oracle_db_azure_blob_container_summary_collections and not isinstance(oracle_db_azure_blob_container_summary_collections, list):
            raise TypeError("Expected argument 'oracle_db_azure_blob_container_summary_collections' to be a list")
        pulumi.set(__self__, "oracle_db_azure_blob_container_summary_collections", oracle_db_azure_blob_container_summary_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="azureStorageAccountName")
    def azure_storage_account_name(self) -> Optional[builtins.str]:
        """
        Azure Storage Account Name.
        """
        return pulumi.get(self, "azure_storage_account_name")

    @property
    @pulumi.getter(name="azureStorageContainerName")
    def azure_storage_container_name(self) -> Optional[builtins.str]:
        """
        Azure Storage Container Name.
        """
        return pulumi.get(self, "azure_storage_container_name")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The ID of the compartment that contains Oracle DB Azure Blob Container Resource.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        Display name of Oracle DB Azure Blob Container.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDbmulticloudOracleDbAzureBlobContainersFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="oracleDbAzureBlobContainerId")
    def oracle_db_azure_blob_container_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "oracle_db_azure_blob_container_id")

    @property
    @pulumi.getter(name="oracleDbAzureBlobContainerSummaryCollections")
    def oracle_db_azure_blob_container_summary_collections(self) -> Sequence['outputs.GetDbmulticloudOracleDbAzureBlobContainersOracleDbAzureBlobContainerSummaryCollectionResult']:
        """
        The list of oracle_db_azure_blob_container_summary_collection.
        """
        return pulumi.get(self, "oracle_db_azure_blob_container_summary_collections")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current lifecycle state of the Oracle DB Azure Blob Container Resource.
        """
        return pulumi.get(self, "state")


class AwaitableGetDbmulticloudOracleDbAzureBlobContainersResult(GetDbmulticloudOracleDbAzureBlobContainersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbmulticloudOracleDbAzureBlobContainersResult(
            azure_storage_account_name=self.azure_storage_account_name,
            azure_storage_container_name=self.azure_storage_container_name,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            oracle_db_azure_blob_container_id=self.oracle_db_azure_blob_container_id,
            oracle_db_azure_blob_container_summary_collections=self.oracle_db_azure_blob_container_summary_collections,
            state=self.state)


def get_dbmulticloud_oracle_db_azure_blob_containers(azure_storage_account_name: Optional[builtins.str] = None,
                                                     azure_storage_container_name: Optional[builtins.str] = None,
                                                     compartment_id: Optional[builtins.str] = None,
                                                     display_name: Optional[builtins.str] = None,
                                                     filters: Optional[Sequence[Union['GetDbmulticloudOracleDbAzureBlobContainersFilterArgs', 'GetDbmulticloudOracleDbAzureBlobContainersFilterArgsDict']]] = None,
                                                     oracle_db_azure_blob_container_id: Optional[builtins.str] = None,
                                                     state: Optional[builtins.str] = None,
                                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbmulticloudOracleDbAzureBlobContainersResult:
    """
    This data source provides the list of Oracle Db Azure Blob Containers in Oracle Cloud Infrastructure Dbmulticloud service.

    Lists the all Oracle DB Azure Blob Container based on filter.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oracle_db_azure_blob_containers = oci.oci.get_dbmulticloud_oracle_db_azure_blob_containers(compartment_id=compartment_id,
        azure_storage_account_name=oracle_db_azure_blob_container_azure_storage_account_name,
        azure_storage_container_name=oracle_db_azure_blob_container_azure_storage_container_name,
        display_name=oracle_db_azure_blob_container_display_name,
        oracle_db_azure_blob_container_id=test_oracle_db_azure_blob_container["id"],
        state=oracle_db_azure_blob_container_state)
    ```


    :param builtins.str azure_storage_account_name: A filter to return Azure Blob Containers.
    :param builtins.str azure_storage_container_name: A filter to return Azure Blob containers.
    :param builtins.str compartment_id: The [ID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.str display_name: A filter to return Azure Containers.
    :param builtins.str oracle_db_azure_blob_container_id: A filter to return Oracle DB Azure Blob Mount Resources.
    :param builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['azureStorageAccountName'] = azure_storage_account_name
    __args__['azureStorageContainerName'] = azure_storage_container_name
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['oracleDbAzureBlobContainerId'] = oracle_db_azure_blob_container_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getDbmulticloudOracleDbAzureBlobContainers:getDbmulticloudOracleDbAzureBlobContainers', __args__, opts=opts, typ=GetDbmulticloudOracleDbAzureBlobContainersResult).value

    return AwaitableGetDbmulticloudOracleDbAzureBlobContainersResult(
        azure_storage_account_name=pulumi.get(__ret__, 'azure_storage_account_name'),
        azure_storage_container_name=pulumi.get(__ret__, 'azure_storage_container_name'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        oracle_db_azure_blob_container_id=pulumi.get(__ret__, 'oracle_db_azure_blob_container_id'),
        oracle_db_azure_blob_container_summary_collections=pulumi.get(__ret__, 'oracle_db_azure_blob_container_summary_collections'),
        state=pulumi.get(__ret__, 'state'))
def get_dbmulticloud_oracle_db_azure_blob_containers_output(azure_storage_account_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                            azure_storage_container_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                                            display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                            filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDbmulticloudOracleDbAzureBlobContainersFilterArgs', 'GetDbmulticloudOracleDbAzureBlobContainersFilterArgsDict']]]]] = None,
                                                            oracle_db_azure_blob_container_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                            state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDbmulticloudOracleDbAzureBlobContainersResult]:
    """
    This data source provides the list of Oracle Db Azure Blob Containers in Oracle Cloud Infrastructure Dbmulticloud service.

    Lists the all Oracle DB Azure Blob Container based on filter.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oracle_db_azure_blob_containers = oci.oci.get_dbmulticloud_oracle_db_azure_blob_containers(compartment_id=compartment_id,
        azure_storage_account_name=oracle_db_azure_blob_container_azure_storage_account_name,
        azure_storage_container_name=oracle_db_azure_blob_container_azure_storage_container_name,
        display_name=oracle_db_azure_blob_container_display_name,
        oracle_db_azure_blob_container_id=test_oracle_db_azure_blob_container["id"],
        state=oracle_db_azure_blob_container_state)
    ```


    :param builtins.str azure_storage_account_name: A filter to return Azure Blob Containers.
    :param builtins.str azure_storage_container_name: A filter to return Azure Blob containers.
    :param builtins.str compartment_id: The [ID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.str display_name: A filter to return Azure Containers.
    :param builtins.str oracle_db_azure_blob_container_id: A filter to return Oracle DB Azure Blob Mount Resources.
    :param builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['azureStorageAccountName'] = azure_storage_account_name
    __args__['azureStorageContainerName'] = azure_storage_container_name
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['oracleDbAzureBlobContainerId'] = oracle_db_azure_blob_container_id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getDbmulticloudOracleDbAzureBlobContainers:getDbmulticloudOracleDbAzureBlobContainers', __args__, opts=opts, typ=GetDbmulticloudOracleDbAzureBlobContainersResult)
    return __ret__.apply(lambda __response__: GetDbmulticloudOracleDbAzureBlobContainersResult(
        azure_storage_account_name=pulumi.get(__response__, 'azure_storage_account_name'),
        azure_storage_container_name=pulumi.get(__response__, 'azure_storage_container_name'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        oracle_db_azure_blob_container_id=pulumi.get(__response__, 'oracle_db_azure_blob_container_id'),
        oracle_db_azure_blob_container_summary_collections=pulumi.get(__response__, 'oracle_db_azure_blob_container_summary_collections'),
        state=pulumi.get(__response__, 'state')))
