# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDbmulticloudOracleDbAzureConnectorsResult',
    'AwaitableGetDbmulticloudOracleDbAzureConnectorsResult',
    'get_dbmulticloud_oracle_db_azure_connectors',
    'get_dbmulticloud_oracle_db_azure_connectors_output',
]

@pulumi.output_type
class GetDbmulticloudOracleDbAzureConnectorsResult:
    """
    A collection of values returned by getDbmulticloudOracleDbAzureConnectors.
    """
    def __init__(__self__, compartment_id=None, db_cluster_resource_id=None, display_name=None, filters=None, id=None, oracle_db_azure_connector_id=None, oracle_db_azure_connector_summary_collections=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if db_cluster_resource_id and not isinstance(db_cluster_resource_id, str):
            raise TypeError("Expected argument 'db_cluster_resource_id' to be a str")
        pulumi.set(__self__, "db_cluster_resource_id", db_cluster_resource_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if oracle_db_azure_connector_id and not isinstance(oracle_db_azure_connector_id, str):
            raise TypeError("Expected argument 'oracle_db_azure_connector_id' to be a str")
        pulumi.set(__self__, "oracle_db_azure_connector_id", oracle_db_azure_connector_id)
        if oracle_db_azure_connector_summary_collections and not isinstance(oracle_db_azure_connector_summary_collections, list):
            raise TypeError("Expected argument 'oracle_db_azure_connector_summary_collections' to be a list")
        pulumi.set(__self__, "oracle_db_azure_connector_summary_collections", oracle_db_azure_connector_summary_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The ID of the compartment that contains Oracle DB Azure Connector resource.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dbClusterResourceId")
    def db_cluster_resource_id(self) -> Optional[builtins.str]:
        """
        The ID of the DB Cluster Resource where this Azure Arc Agent identity to configure.
        """
        return pulumi.get(self, "db_cluster_resource_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        Oracle DB Azure Connector resource name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDbmulticloudOracleDbAzureConnectorsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="oracleDbAzureConnectorId")
    def oracle_db_azure_connector_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "oracle_db_azure_connector_id")

    @property
    @pulumi.getter(name="oracleDbAzureConnectorSummaryCollections")
    def oracle_db_azure_connector_summary_collections(self) -> Sequence['outputs.GetDbmulticloudOracleDbAzureConnectorsOracleDbAzureConnectorSummaryCollectionResult']:
        """
        The list of oracle_db_azure_connector_summary_collection.
        """
        return pulumi.get(self, "oracle_db_azure_connector_summary_collections")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current lifecycle state of the Azure Arc Agent Resource.
        """
        return pulumi.get(self, "state")


class AwaitableGetDbmulticloudOracleDbAzureConnectorsResult(GetDbmulticloudOracleDbAzureConnectorsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbmulticloudOracleDbAzureConnectorsResult(
            compartment_id=self.compartment_id,
            db_cluster_resource_id=self.db_cluster_resource_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            oracle_db_azure_connector_id=self.oracle_db_azure_connector_id,
            oracle_db_azure_connector_summary_collections=self.oracle_db_azure_connector_summary_collections,
            state=self.state)


def get_dbmulticloud_oracle_db_azure_connectors(compartment_id: Optional[builtins.str] = None,
                                                db_cluster_resource_id: Optional[builtins.str] = None,
                                                display_name: Optional[builtins.str] = None,
                                                filters: Optional[Sequence[Union['GetDbmulticloudOracleDbAzureConnectorsFilterArgs', 'GetDbmulticloudOracleDbAzureConnectorsFilterArgsDict']]] = None,
                                                oracle_db_azure_connector_id: Optional[builtins.str] = None,
                                                state: Optional[builtins.str] = None,
                                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbmulticloudOracleDbAzureConnectorsResult:
    """
    This data source provides the list of Oracle Db Azure Connectors in Oracle Cloud Infrastructure Dbmulticloud service.

    Lists the all Oracle DB Azure Connector Resource based on filters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oracle_db_azure_connectors = oci.oci.get_dbmulticloud_oracle_db_azure_connectors(compartment_id=compartment_id,
        db_cluster_resource_id=test_resource["id"],
        display_name=oracle_db_azure_connector_display_name,
        oracle_db_azure_connector_id=test_oracle_db_azure_connector["id"],
        state=oracle_db_azure_connector_state)
    ```


    :param builtins.str compartment_id: The [ID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.str db_cluster_resource_id: The [ID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Resource.
    :param builtins.str display_name: A filter to return Oracle DB Azure Connector Resource that match the given display name.
    :param builtins.str oracle_db_azure_connector_id: A filter to return Oracle DB Azure Blob Mount Resources.
    :param builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['dbClusterResourceId'] = db_cluster_resource_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['oracleDbAzureConnectorId'] = oracle_db_azure_connector_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getDbmulticloudOracleDbAzureConnectors:getDbmulticloudOracleDbAzureConnectors', __args__, opts=opts, typ=GetDbmulticloudOracleDbAzureConnectorsResult).value

    return AwaitableGetDbmulticloudOracleDbAzureConnectorsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        db_cluster_resource_id=pulumi.get(__ret__, 'db_cluster_resource_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        oracle_db_azure_connector_id=pulumi.get(__ret__, 'oracle_db_azure_connector_id'),
        oracle_db_azure_connector_summary_collections=pulumi.get(__ret__, 'oracle_db_azure_connector_summary_collections'),
        state=pulumi.get(__ret__, 'state'))
def get_dbmulticloud_oracle_db_azure_connectors_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                                       db_cluster_resource_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                       display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                       filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDbmulticloudOracleDbAzureConnectorsFilterArgs', 'GetDbmulticloudOracleDbAzureConnectorsFilterArgsDict']]]]] = None,
                                                       oracle_db_azure_connector_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                       state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDbmulticloudOracleDbAzureConnectorsResult]:
    """
    This data source provides the list of Oracle Db Azure Connectors in Oracle Cloud Infrastructure Dbmulticloud service.

    Lists the all Oracle DB Azure Connector Resource based on filters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oracle_db_azure_connectors = oci.oci.get_dbmulticloud_oracle_db_azure_connectors(compartment_id=compartment_id,
        db_cluster_resource_id=test_resource["id"],
        display_name=oracle_db_azure_connector_display_name,
        oracle_db_azure_connector_id=test_oracle_db_azure_connector["id"],
        state=oracle_db_azure_connector_state)
    ```


    :param builtins.str compartment_id: The [ID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.str db_cluster_resource_id: The [ID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Resource.
    :param builtins.str display_name: A filter to return Oracle DB Azure Connector Resource that match the given display name.
    :param builtins.str oracle_db_azure_connector_id: A filter to return Oracle DB Azure Blob Mount Resources.
    :param builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['dbClusterResourceId'] = db_cluster_resource_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['oracleDbAzureConnectorId'] = oracle_db_azure_connector_id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getDbmulticloudOracleDbAzureConnectors:getDbmulticloudOracleDbAzureConnectors', __args__, opts=opts, typ=GetDbmulticloudOracleDbAzureConnectorsResult)
    return __ret__.apply(lambda __response__: GetDbmulticloudOracleDbAzureConnectorsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        db_cluster_resource_id=pulumi.get(__response__, 'db_cluster_resource_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        oracle_db_azure_connector_id=pulumi.get(__response__, 'oracle_db_azure_connector_id'),
        oracle_db_azure_connector_summary_collections=pulumi.get(__response__, 'oracle_db_azure_connector_summary_collections'),
        state=pulumi.get(__response__, 'state')))
