# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetWlmsManagedInstanceServerInstalledPatchesResult',
    'AwaitableGetWlmsManagedInstanceServerInstalledPatchesResult',
    'get_wlms_managed_instance_server_installed_patches',
    'get_wlms_managed_instance_server_installed_patches_output',
]

@pulumi.output_type
class GetWlmsManagedInstanceServerInstalledPatchesResult:
    """
    A collection of values returned by getWlmsManagedInstanceServerInstalledPatches.
    """
    def __init__(__self__, filters=None, id=None, installed_patch_collections=None, managed_instance_id=None, server_id=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if installed_patch_collections and not isinstance(installed_patch_collections, list):
            raise TypeError("Expected argument 'installed_patch_collections' to be a list")
        pulumi.set(__self__, "installed_patch_collections", installed_patch_collections)
        if managed_instance_id and not isinstance(managed_instance_id, str):
            raise TypeError("Expected argument 'managed_instance_id' to be a str")
        pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if server_id and not isinstance(server_id, str):
            raise TypeError("Expected argument 'server_id' to be a str")
        pulumi.set(__self__, "server_id", server_id)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetWlmsManagedInstanceServerInstalledPatchesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="installedPatchCollections")
    def installed_patch_collections(self) -> Sequence['outputs.GetWlmsManagedInstanceServerInstalledPatchesInstalledPatchCollectionResult']:
        """
        The list of installed_patch_collection.
        """
        return pulumi.get(self, "installed_patch_collections")

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> builtins.str:
        return pulumi.get(self, "managed_instance_id")

    @property
    @pulumi.getter(name="serverId")
    def server_id(self) -> builtins.str:
        return pulumi.get(self, "server_id")


class AwaitableGetWlmsManagedInstanceServerInstalledPatchesResult(GetWlmsManagedInstanceServerInstalledPatchesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWlmsManagedInstanceServerInstalledPatchesResult(
            filters=self.filters,
            id=self.id,
            installed_patch_collections=self.installed_patch_collections,
            managed_instance_id=self.managed_instance_id,
            server_id=self.server_id)


def get_wlms_managed_instance_server_installed_patches(filters: Optional[Sequence[Union['GetWlmsManagedInstanceServerInstalledPatchesFilterArgs', 'GetWlmsManagedInstanceServerInstalledPatchesFilterArgsDict']]] = None,
                                                       managed_instance_id: Optional[builtins.str] = None,
                                                       server_id: Optional[builtins.str] = None,
                                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWlmsManagedInstanceServerInstalledPatchesResult:
    """
    This data source provides the list of Managed Instance Server Installed Patches in Oracle Cloud Infrastructure Wlms service.

    Gets a list of installed patches on a server in a managed instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_instance_server_installed_patches = oci.oci.get_wlms_managed_instance_server_installed_patches(managed_instance_id=test_managed_instance["id"],
        server_id=test_server["id"])
    ```


    :param builtins.str managed_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance.
    :param builtins.str server_id: The unique identifier of a server.
           
           **Note:** Not an [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['managedInstanceId'] = managed_instance_id
    __args__['serverId'] = server_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getWlmsManagedInstanceServerInstalledPatches:getWlmsManagedInstanceServerInstalledPatches', __args__, opts=opts, typ=GetWlmsManagedInstanceServerInstalledPatchesResult).value

    return AwaitableGetWlmsManagedInstanceServerInstalledPatchesResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        installed_patch_collections=pulumi.get(__ret__, 'installed_patch_collections'),
        managed_instance_id=pulumi.get(__ret__, 'managed_instance_id'),
        server_id=pulumi.get(__ret__, 'server_id'))
def get_wlms_managed_instance_server_installed_patches_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetWlmsManagedInstanceServerInstalledPatchesFilterArgs', 'GetWlmsManagedInstanceServerInstalledPatchesFilterArgsDict']]]]] = None,
                                                              managed_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                                                              server_id: Optional[pulumi.Input[builtins.str]] = None,
                                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWlmsManagedInstanceServerInstalledPatchesResult]:
    """
    This data source provides the list of Managed Instance Server Installed Patches in Oracle Cloud Infrastructure Wlms service.

    Gets a list of installed patches on a server in a managed instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_instance_server_installed_patches = oci.oci.get_wlms_managed_instance_server_installed_patches(managed_instance_id=test_managed_instance["id"],
        server_id=test_server["id"])
    ```


    :param builtins.str managed_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance.
    :param builtins.str server_id: The unique identifier of a server.
           
           **Note:** Not an [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['managedInstanceId'] = managed_instance_id
    __args__['serverId'] = server_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getWlmsManagedInstanceServerInstalledPatches:getWlmsManagedInstanceServerInstalledPatches', __args__, opts=opts, typ=GetWlmsManagedInstanceServerInstalledPatchesResult)
    return __ret__.apply(lambda __response__: GetWlmsManagedInstanceServerInstalledPatchesResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        installed_patch_collections=pulumi.get(__response__, 'installed_patch_collections'),
        managed_instance_id=pulumi.get(__response__, 'managed_instance_id'),
        server_id=pulumi.get(__response__, 'server_id')))
