# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetWlmsWlsDomainsResult',
    'AwaitableGetWlmsWlsDomainsResult',
    'get_wlms_wls_domains',
    'get_wlms_wls_domains_output',
]

@pulumi.output_type
class GetWlmsWlsDomainsResult:
    """
    A collection of values returned by getWlmsWlsDomains.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, middleware_type=None, patch_readiness_status=None, state=None, weblogic_version=None, wls_domain_collections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if middleware_type and not isinstance(middleware_type, str):
            raise TypeError("Expected argument 'middleware_type' to be a str")
        pulumi.set(__self__, "middleware_type", middleware_type)
        if patch_readiness_status and not isinstance(patch_readiness_status, str):
            raise TypeError("Expected argument 'patch_readiness_status' to be a str")
        pulumi.set(__self__, "patch_readiness_status", patch_readiness_status)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if weblogic_version and not isinstance(weblogic_version, str):
            raise TypeError("Expected argument 'weblogic_version' to be a str")
        pulumi.set(__self__, "weblogic_version", weblogic_version)
        if wls_domain_collections and not isinstance(wls_domain_collections, list):
            raise TypeError("Expected argument 'wls_domain_collections' to be a list")
        pulumi.set(__self__, "wls_domain_collections", wls_domain_collections)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        A user-friendly name that does not have to be unique and is changeable.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetWlmsWlsDomainsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the WebLogic domain.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="middlewareType")
    def middleware_type(self) -> Optional[builtins.str]:
        """
        The middleware type on the administration server of the WebLogic domain.
        """
        return pulumi.get(self, "middleware_type")

    @property
    @pulumi.getter(name="patchReadinessStatus")
    def patch_readiness_status(self) -> Optional[builtins.str]:
        """
        The patch readiness status of the WebLogic domain.
        """
        return pulumi.get(self, "patch_readiness_status")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the WebLogic service domain.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="weblogicVersion")
    def weblogic_version(self) -> Optional[builtins.str]:
        """
        The version of the WebLogic domain.
        """
        return pulumi.get(self, "weblogic_version")

    @property
    @pulumi.getter(name="wlsDomainCollections")
    def wls_domain_collections(self) -> Sequence['outputs.GetWlmsWlsDomainsWlsDomainCollectionResult']:
        """
        The list of wls_domain_collection.
        """
        return pulumi.get(self, "wls_domain_collections")


class AwaitableGetWlmsWlsDomainsResult(GetWlmsWlsDomainsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWlmsWlsDomainsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            middleware_type=self.middleware_type,
            patch_readiness_status=self.patch_readiness_status,
            state=self.state,
            weblogic_version=self.weblogic_version,
            wls_domain_collections=self.wls_domain_collections)


def get_wlms_wls_domains(compartment_id: Optional[builtins.str] = None,
                         display_name: Optional[builtins.str] = None,
                         filters: Optional[Sequence[Union['GetWlmsWlsDomainsFilterArgs', 'GetWlmsWlsDomainsFilterArgsDict']]] = None,
                         id: Optional[builtins.str] = None,
                         middleware_type: Optional[builtins.str] = None,
                         patch_readiness_status: Optional[builtins.str] = None,
                         state: Optional[builtins.str] = None,
                         weblogic_version: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWlmsWlsDomainsResult:
    """
    This data source provides the list of Wls Domains in Oracle Cloud Infrastructure Wlms service.

    Gets all WebLogic domains in a given compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_wls_domains = oci.oci.get_wlms_wls_domains(compartment_id=compartment_id,
        display_name=wls_domain_display_name,
        id=wls_domain_id,
        middleware_type=wls_domain_middleware_type,
        patch_readiness_status=wls_domain_patch_readiness_status,
        state=wls_domain_state,
        weblogic_version=wls_domain_weblogic_version)
    ```


    :param builtins.str compartment_id: The OCID of the compartment that contains the resources to list. This filter returns  only resources contained within the specified compartment.
    :param builtins.str display_name: The display name.
    :param builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the WebLogic domain.
    :param builtins.str middleware_type: A filter to return WebLogic domains based on the type of middleware of the WebLogic domain.
    :param builtins.str patch_readiness_status: A filter to return domains based on the patch readiness status.
    :param builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    :param builtins.str weblogic_version: A filter to return WebLogic domains based on the WebLogic version.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['middlewareType'] = middleware_type
    __args__['patchReadinessStatus'] = patch_readiness_status
    __args__['state'] = state
    __args__['weblogicVersion'] = weblogic_version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getWlmsWlsDomains:getWlmsWlsDomains', __args__, opts=opts, typ=GetWlmsWlsDomainsResult).value

    return AwaitableGetWlmsWlsDomainsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        middleware_type=pulumi.get(__ret__, 'middleware_type'),
        patch_readiness_status=pulumi.get(__ret__, 'patch_readiness_status'),
        state=pulumi.get(__ret__, 'state'),
        weblogic_version=pulumi.get(__ret__, 'weblogic_version'),
        wls_domain_collections=pulumi.get(__ret__, 'wls_domain_collections'))
def get_wlms_wls_domains_output(compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                filters: Optional[pulumi.Input[Optional[Sequence[Union['GetWlmsWlsDomainsFilterArgs', 'GetWlmsWlsDomainsFilterArgsDict']]]]] = None,
                                id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                middleware_type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                patch_readiness_status: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                weblogic_version: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWlmsWlsDomainsResult]:
    """
    This data source provides the list of Wls Domains in Oracle Cloud Infrastructure Wlms service.

    Gets all WebLogic domains in a given compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_wls_domains = oci.oci.get_wlms_wls_domains(compartment_id=compartment_id,
        display_name=wls_domain_display_name,
        id=wls_domain_id,
        middleware_type=wls_domain_middleware_type,
        patch_readiness_status=wls_domain_patch_readiness_status,
        state=wls_domain_state,
        weblogic_version=wls_domain_weblogic_version)
    ```


    :param builtins.str compartment_id: The OCID of the compartment that contains the resources to list. This filter returns  only resources contained within the specified compartment.
    :param builtins.str display_name: The display name.
    :param builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the WebLogic domain.
    :param builtins.str middleware_type: A filter to return WebLogic domains based on the type of middleware of the WebLogic domain.
    :param builtins.str patch_readiness_status: A filter to return domains based on the patch readiness status.
    :param builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    :param builtins.str weblogic_version: A filter to return WebLogic domains based on the WebLogic version.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['middlewareType'] = middleware_type
    __args__['patchReadinessStatus'] = patch_readiness_status
    __args__['state'] = state
    __args__['weblogicVersion'] = weblogic_version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getWlmsWlsDomains:getWlmsWlsDomains', __args__, opts=opts, typ=GetWlmsWlsDomainsResult)
    return __ret__.apply(lambda __response__: GetWlmsWlsDomainsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        middleware_type=pulumi.get(__response__, 'middleware_type'),
        patch_readiness_status=pulumi.get(__response__, 'patch_readiness_status'),
        state=pulumi.get(__response__, 'state'),
        weblogic_version=pulumi.get(__response__, 'weblogic_version'),
        wls_domain_collections=pulumi.get(__response__, 'wls_domain_collections')))
