# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetInvoicesResult',
    'AwaitableGetInvoicesResult',
    'get_invoices',
    'get_invoices_output',
]

@pulumi.output_type
class GetInvoicesResult:
    """
    A collection of values returned by getInvoices.
    """
    def __init__(__self__, ar_customer_transaction_id=None, compartment_id=None, fields=None, filters=None, id=None, invoices=None, time_from=None, time_to=None):
        if ar_customer_transaction_id and not isinstance(ar_customer_transaction_id, str):
            raise TypeError("Expected argument 'ar_customer_transaction_id' to be a str")
        pulumi.set(__self__, "ar_customer_transaction_id", ar_customer_transaction_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if fields and not isinstance(fields, list):
            raise TypeError("Expected argument 'fields' to be a list")
        pulumi.set(__self__, "fields", fields)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if invoices and not isinstance(invoices, list):
            raise TypeError("Expected argument 'invoices' to be a list")
        pulumi.set(__self__, "invoices", invoices)
        if time_from and not isinstance(time_from, str):
            raise TypeError("Expected argument 'time_from' to be a str")
        pulumi.set(__self__, "time_from", time_from)
        if time_to and not isinstance(time_to, str):
            raise TypeError("Expected argument 'time_to' to be a str")
        pulumi.set(__self__, "time_to", time_to)

    @property
    @pulumi.getter(name="arCustomerTransactionId")
    def ar_customer_transaction_id(self) -> builtins.str:
        return pulumi.get(self, "ar_customer_transaction_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def fields(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetInvoicesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def invoices(self) -> Sequence['outputs.GetInvoicesInvoiceResult']:
        """
        The list of invoices.
        """
        return pulumi.get(self, "invoices")

    @property
    @pulumi.getter(name="timeFrom")
    def time_from(self) -> Optional[builtins.str]:
        return pulumi.get(self, "time_from")

    @property
    @pulumi.getter(name="timeTo")
    def time_to(self) -> Optional[builtins.str]:
        return pulumi.get(self, "time_to")


class AwaitableGetInvoicesResult(GetInvoicesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInvoicesResult(
            ar_customer_transaction_id=self.ar_customer_transaction_id,
            compartment_id=self.compartment_id,
            fields=self.fields,
            filters=self.filters,
            id=self.id,
            invoices=self.invoices,
            time_from=self.time_from,
            time_to=self.time_to)


def get_invoices(ar_customer_transaction_id: Optional[builtins.str] = None,
                 compartment_id: Optional[builtins.str] = None,
                 fields: Optional[Sequence[builtins.str]] = None,
                 filters: Optional[Sequence[Union['GetInvoicesFilterArgs', 'GetInvoicesFilterArgsDict']]] = None,
                 time_from: Optional[builtins.str] = None,
                 time_to: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInvoicesResult:
    """
    This data source provides the list of Invoices in Oracle Cloud Infrastructure Onesubscription service.

    This is a collection API which returns a list of Invoices for given filters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_invoices = oci.OneSubsription.get_invoices(ar_customer_transaction_id=test_ar_customer_transaction["id"],
        compartment_id=compartment_id,
        fields=invoice_fields,
        time_from=invoice_time_from,
        time_to=invoice_time_to)
    ```


    :param builtins.str ar_customer_transaction_id: AR Unique identifier for an invoice .
    :param builtins.str compartment_id: The OCID of the root compartment.
    :param Sequence[builtins.str] fields: Partial response refers to an optimization technique offered by the RESTful web APIs to return only the information  (fields) required by the client. This parameter is used to control what fields to return.
    :param builtins.str time_from: Initial date to filter Invoice data in SPM.
    :param builtins.str time_to: Final date to filter Invoice data in SPM.
    """
    __args__ = dict()
    __args__['arCustomerTransactionId'] = ar_customer_transaction_id
    __args__['compartmentId'] = compartment_id
    __args__['fields'] = fields
    __args__['filters'] = filters
    __args__['timeFrom'] = time_from
    __args__['timeTo'] = time_to
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OneSubsription/getInvoices:getInvoices', __args__, opts=opts, typ=GetInvoicesResult).value

    return AwaitableGetInvoicesResult(
        ar_customer_transaction_id=pulumi.get(__ret__, 'ar_customer_transaction_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        fields=pulumi.get(__ret__, 'fields'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        invoices=pulumi.get(__ret__, 'invoices'),
        time_from=pulumi.get(__ret__, 'time_from'),
        time_to=pulumi.get(__ret__, 'time_to'))
def get_invoices_output(ar_customer_transaction_id: Optional[pulumi.Input[builtins.str]] = None,
                        compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                        fields: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                        filters: Optional[pulumi.Input[Optional[Sequence[Union['GetInvoicesFilterArgs', 'GetInvoicesFilterArgsDict']]]]] = None,
                        time_from: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        time_to: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInvoicesResult]:
    """
    This data source provides the list of Invoices in Oracle Cloud Infrastructure Onesubscription service.

    This is a collection API which returns a list of Invoices for given filters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_invoices = oci.OneSubsription.get_invoices(ar_customer_transaction_id=test_ar_customer_transaction["id"],
        compartment_id=compartment_id,
        fields=invoice_fields,
        time_from=invoice_time_from,
        time_to=invoice_time_to)
    ```


    :param builtins.str ar_customer_transaction_id: AR Unique identifier for an invoice .
    :param builtins.str compartment_id: The OCID of the root compartment.
    :param Sequence[builtins.str] fields: Partial response refers to an optimization technique offered by the RESTful web APIs to return only the information  (fields) required by the client. This parameter is used to control what fields to return.
    :param builtins.str time_from: Initial date to filter Invoice data in SPM.
    :param builtins.str time_to: Final date to filter Invoice data in SPM.
    """
    __args__ = dict()
    __args__['arCustomerTransactionId'] = ar_customer_transaction_id
    __args__['compartmentId'] = compartment_id
    __args__['fields'] = fields
    __args__['filters'] = filters
    __args__['timeFrom'] = time_from
    __args__['timeTo'] = time_to
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:OneSubsription/getInvoices:getInvoices', __args__, opts=opts, typ=GetInvoicesResult)
    return __ret__.apply(lambda __response__: GetInvoicesResult(
        ar_customer_transaction_id=pulumi.get(__response__, 'ar_customer_transaction_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        fields=pulumi.get(__response__, 'fields'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        invoices=pulumi.get(__response__, 'invoices'),
        time_from=pulumi.get(__response__, 'time_from'),
        time_to=pulumi.get(__response__, 'time_to')))
