# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ClusterMaintenanceDetailsArgs',
    'ClusterMaintenanceDetailsArgsDict',
    'ClusterOutboundClusterConfigArgs',
    'ClusterOutboundClusterConfigArgsDict',
    'ClusterOutboundClusterConfigOutboundClusterArgs',
    'ClusterOutboundClusterConfigOutboundClusterArgsDict',
    'ClusterReverseConnectionEndpointArgs',
    'ClusterReverseConnectionEndpointArgsDict',
    'ClusterSecuritySamlConfigArgs',
    'ClusterSecuritySamlConfigArgsDict',
    'OpensearchClusterPipelineReverseConnectionEndpointArgs',
    'OpensearchClusterPipelineReverseConnectionEndpointArgsDict',
    'GetOpensearchClusterPipelinesFilterArgs',
    'GetOpensearchClusterPipelinesFilterArgsDict',
    'GetOpensearchClustersFilterArgs',
    'GetOpensearchClustersFilterArgsDict',
    'GetOpensearchVersionsFilterArgs',
    'GetOpensearchVersionsFilterArgsDict',
]

MYPY = False

if not MYPY:
    class ClusterMaintenanceDetailsArgsDict(TypedDict):
        end_time: NotRequired[pulumi.Input[builtins.str]]
        """
        End time of the maintenance activity
        """
        notification_email_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        (Updatable) The Email IDs given by the customer to get notified about maintenance activities
        """
        start_time: NotRequired[pulumi.Input[builtins.str]]
        """
        Start time of the maintenance activity
        """
        state: NotRequired[pulumi.Input[builtins.str]]
        """
        The current state of the cluster.
        """
elif False:
    ClusterMaintenanceDetailsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterMaintenanceDetailsArgs:
    def __init__(__self__, *,
                 end_time: Optional[pulumi.Input[builtins.str]] = None,
                 notification_email_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 start_time: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] end_time: End time of the maintenance activity
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] notification_email_ids: (Updatable) The Email IDs given by the customer to get notified about maintenance activities
        :param pulumi.Input[builtins.str] start_time: Start time of the maintenance activity
        :param pulumi.Input[builtins.str] state: The current state of the cluster.
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if notification_email_ids is not None:
            pulumi.set(__self__, "notification_email_ids", notification_email_ids)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        End time of the maintenance activity
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="notificationEmailIds")
    def notification_email_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) The Email IDs given by the customer to get notified about maintenance activities
        """
        return pulumi.get(self, "notification_email_ids")

    @notification_email_ids.setter
    def notification_email_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "notification_email_ids", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Start time of the maintenance activity
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the cluster.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)


if not MYPY:
    class ClusterOutboundClusterConfigArgsDict(TypedDict):
        is_enabled: pulumi.Input[builtins.bool]
        """
        (Updatable) Flag to indicate whether outbound cluster configuration is enabled
        """
        outbound_clusters: pulumi.Input[Sequence[pulumi.Input['ClusterOutboundClusterConfigOutboundClusterArgsDict']]]
        """
        (Updatable) List of outbound clusters to be connected to the inbound cluster
        """
elif False:
    ClusterOutboundClusterConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterOutboundClusterConfigArgs:
    def __init__(__self__, *,
                 is_enabled: pulumi.Input[builtins.bool],
                 outbound_clusters: pulumi.Input[Sequence[pulumi.Input['ClusterOutboundClusterConfigOutboundClusterArgs']]]):
        """
        :param pulumi.Input[builtins.bool] is_enabled: (Updatable) Flag to indicate whether outbound cluster configuration is enabled
        :param pulumi.Input[Sequence[pulumi.Input['ClusterOutboundClusterConfigOutboundClusterArgs']]] outbound_clusters: (Updatable) List of outbound clusters to be connected to the inbound cluster
        """
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "outbound_clusters", outbound_clusters)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[builtins.bool]:
        """
        (Updatable) Flag to indicate whether outbound cluster configuration is enabled
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="outboundClusters")
    def outbound_clusters(self) -> pulumi.Input[Sequence[pulumi.Input['ClusterOutboundClusterConfigOutboundClusterArgs']]]:
        """
        (Updatable) List of outbound clusters to be connected to the inbound cluster
        """
        return pulumi.get(self, "outbound_clusters")

    @outbound_clusters.setter
    def outbound_clusters(self, value: pulumi.Input[Sequence[pulumi.Input['ClusterOutboundClusterConfigOutboundClusterArgs']]]):
        pulumi.set(self, "outbound_clusters", value)


if not MYPY:
    class ClusterOutboundClusterConfigOutboundClusterArgsDict(TypedDict):
        display_name: pulumi.Input[builtins.str]
        """
        (Updatable) Name of the Outbound cluster. Avoid entering confidential information.
        """
        seed_cluster_id: pulumi.Input[builtins.str]
        """
        (Updatable) OCID of the Outbound cluster
        """
        is_skip_unavailable: NotRequired[pulumi.Input[builtins.bool]]
        """
        (Updatable) Flag to indicate whether to skip the Outbound cluster during cross cluster search, if it is unavailable
        """
        mode: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) Mode for the cross cluster connection
        """
        ping_schedule: NotRequired[pulumi.Input[builtins.str]]
        """
        (Updatable) Sets the time interval between regular application-level ping messages that are sent to try and keep outbound cluster connections alive. If set to -1, application-level ping messages to this outbound cluster are not sent. If unset, application-level ping messages are sent according to the global transport.ping_schedule setting, which defaults to -1 meaning that pings are not sent.
        """
elif False:
    ClusterOutboundClusterConfigOutboundClusterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterOutboundClusterConfigOutboundClusterArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[builtins.str],
                 seed_cluster_id: pulumi.Input[builtins.str],
                 is_skip_unavailable: Optional[pulumi.Input[builtins.bool]] = None,
                 mode: Optional[pulumi.Input[builtins.str]] = None,
                 ping_schedule: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] display_name: (Updatable) Name of the Outbound cluster. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] seed_cluster_id: (Updatable) OCID of the Outbound cluster
        :param pulumi.Input[builtins.bool] is_skip_unavailable: (Updatable) Flag to indicate whether to skip the Outbound cluster during cross cluster search, if it is unavailable
        :param pulumi.Input[builtins.str] mode: (Updatable) Mode for the cross cluster connection
        :param pulumi.Input[builtins.str] ping_schedule: (Updatable) Sets the time interval between regular application-level ping messages that are sent to try and keep outbound cluster connections alive. If set to -1, application-level ping messages to this outbound cluster are not sent. If unset, application-level ping messages are sent according to the global transport.ping_schedule setting, which defaults to -1 meaning that pings are not sent.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "seed_cluster_id", seed_cluster_id)
        if is_skip_unavailable is not None:
            pulumi.set(__self__, "is_skip_unavailable", is_skip_unavailable)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if ping_schedule is not None:
            pulumi.set(__self__, "ping_schedule", ping_schedule)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Name of the Outbound cluster. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="seedClusterId")
    def seed_cluster_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) OCID of the Outbound cluster
        """
        return pulumi.get(self, "seed_cluster_id")

    @seed_cluster_id.setter
    def seed_cluster_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "seed_cluster_id", value)

    @property
    @pulumi.getter(name="isSkipUnavailable")
    def is_skip_unavailable(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Flag to indicate whether to skip the Outbound cluster during cross cluster search, if it is unavailable
        """
        return pulumi.get(self, "is_skip_unavailable")

    @is_skip_unavailable.setter
    def is_skip_unavailable(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_skip_unavailable", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Mode for the cross cluster connection
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="pingSchedule")
    def ping_schedule(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Sets the time interval between regular application-level ping messages that are sent to try and keep outbound cluster connections alive. If set to -1, application-level ping messages to this outbound cluster are not sent. If unset, application-level ping messages are sent according to the global transport.ping_schedule setting, which defaults to -1 meaning that pings are not sent.
        """
        return pulumi.get(self, "ping_schedule")

    @ping_schedule.setter
    def ping_schedule(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ping_schedule", value)


if not MYPY:
    class ClusterReverseConnectionEndpointArgsDict(TypedDict):
        customer_ip: NotRequired[pulumi.Input[builtins.str]]
        """
        The IP addresses of the endpoint in customer VCN
        """
        nat_ip: NotRequired[pulumi.Input[builtins.str]]
        """
        The NAT IP addresses of the endpoint in service VCN
        """
elif False:
    ClusterReverseConnectionEndpointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterReverseConnectionEndpointArgs:
    def __init__(__self__, *,
                 customer_ip: Optional[pulumi.Input[builtins.str]] = None,
                 nat_ip: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] customer_ip: The IP addresses of the endpoint in customer VCN
        :param pulumi.Input[builtins.str] nat_ip: The NAT IP addresses of the endpoint in service VCN
        """
        if customer_ip is not None:
            pulumi.set(__self__, "customer_ip", customer_ip)
        if nat_ip is not None:
            pulumi.set(__self__, "nat_ip", nat_ip)

    @property
    @pulumi.getter(name="customerIp")
    def customer_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP addresses of the endpoint in customer VCN
        """
        return pulumi.get(self, "customer_ip")

    @customer_ip.setter
    def customer_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "customer_ip", value)

    @property
    @pulumi.getter(name="natIp")
    def nat_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The NAT IP addresses of the endpoint in service VCN
        """
        return pulumi.get(self, "nat_ip")

    @nat_ip.setter
    def nat_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "nat_ip", value)


if not MYPY:
    class ClusterSecuritySamlConfigArgsDict(TypedDict):
        idp_entity_id: pulumi.Input[builtins.str]
        """
        The unique name for a identity provider entity
        """
        idp_metadata_content: pulumi.Input[builtins.str]
        """
        The content of identity provider metadata
        """
        is_enabled: pulumi.Input[builtins.bool]
        """
        A flag determine whether SAML is enabled
        """
        admin_backend_role: NotRequired[pulumi.Input[builtins.str]]
        """
        The backend role of admins who have all permissions like local master user
        """
        opendashboard_url: NotRequired[pulumi.Input[builtins.str]]
        """
        The endpoint of opendashboard
        """
        roles_key: NotRequired[pulumi.Input[builtins.str]]
        """
        The roles key is sued to get backend roles from SAML assertion
        """
        subject_key: NotRequired[pulumi.Input[builtins.str]]
        """
        The subject key is used to get username from SAML assertion. By default, it is NameID
        """
elif False:
    ClusterSecuritySamlConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterSecuritySamlConfigArgs:
    def __init__(__self__, *,
                 idp_entity_id: pulumi.Input[builtins.str],
                 idp_metadata_content: pulumi.Input[builtins.str],
                 is_enabled: pulumi.Input[builtins.bool],
                 admin_backend_role: Optional[pulumi.Input[builtins.str]] = None,
                 opendashboard_url: Optional[pulumi.Input[builtins.str]] = None,
                 roles_key: Optional[pulumi.Input[builtins.str]] = None,
                 subject_key: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] idp_entity_id: The unique name for a identity provider entity
        :param pulumi.Input[builtins.str] idp_metadata_content: The content of identity provider metadata
        :param pulumi.Input[builtins.bool] is_enabled: A flag determine whether SAML is enabled
        :param pulumi.Input[builtins.str] admin_backend_role: The backend role of admins who have all permissions like local master user
        :param pulumi.Input[builtins.str] opendashboard_url: The endpoint of opendashboard
        :param pulumi.Input[builtins.str] roles_key: The roles key is sued to get backend roles from SAML assertion
        :param pulumi.Input[builtins.str] subject_key: The subject key is used to get username from SAML assertion. By default, it is NameID
        """
        pulumi.set(__self__, "idp_entity_id", idp_entity_id)
        pulumi.set(__self__, "idp_metadata_content", idp_metadata_content)
        pulumi.set(__self__, "is_enabled", is_enabled)
        if admin_backend_role is not None:
            pulumi.set(__self__, "admin_backend_role", admin_backend_role)
        if opendashboard_url is not None:
            pulumi.set(__self__, "opendashboard_url", opendashboard_url)
        if roles_key is not None:
            pulumi.set(__self__, "roles_key", roles_key)
        if subject_key is not None:
            pulumi.set(__self__, "subject_key", subject_key)

    @property
    @pulumi.getter(name="idpEntityId")
    def idp_entity_id(self) -> pulumi.Input[builtins.str]:
        """
        The unique name for a identity provider entity
        """
        return pulumi.get(self, "idp_entity_id")

    @idp_entity_id.setter
    def idp_entity_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "idp_entity_id", value)

    @property
    @pulumi.getter(name="idpMetadataContent")
    def idp_metadata_content(self) -> pulumi.Input[builtins.str]:
        """
        The content of identity provider metadata
        """
        return pulumi.get(self, "idp_metadata_content")

    @idp_metadata_content.setter
    def idp_metadata_content(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "idp_metadata_content", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[builtins.bool]:
        """
        A flag determine whether SAML is enabled
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="adminBackendRole")
    def admin_backend_role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The backend role of admins who have all permissions like local master user
        """
        return pulumi.get(self, "admin_backend_role")

    @admin_backend_role.setter
    def admin_backend_role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "admin_backend_role", value)

    @property
    @pulumi.getter(name="opendashboardUrl")
    def opendashboard_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The endpoint of opendashboard
        """
        return pulumi.get(self, "opendashboard_url")

    @opendashboard_url.setter
    def opendashboard_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "opendashboard_url", value)

    @property
    @pulumi.getter(name="rolesKey")
    def roles_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The roles key is sued to get backend roles from SAML assertion
        """
        return pulumi.get(self, "roles_key")

    @roles_key.setter
    def roles_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "roles_key", value)

    @property
    @pulumi.getter(name="subjectKey")
    def subject_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The subject key is used to get username from SAML assertion. By default, it is NameID
        """
        return pulumi.get(self, "subject_key")

    @subject_key.setter
    def subject_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subject_key", value)


if not MYPY:
    class OpensearchClusterPipelineReverseConnectionEndpointArgsDict(TypedDict):
        customer_fqdn: pulumi.Input[builtins.str]
        """
        (Updatable) The fully qualified domain name of the customerIp in the customer VCN
        """
        customer_ip: pulumi.Input[builtins.str]
        """
        (Updatable) The IPv4 address in the customer VCN
        """
elif False:
    OpensearchClusterPipelineReverseConnectionEndpointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OpensearchClusterPipelineReverseConnectionEndpointArgs:
    def __init__(__self__, *,
                 customer_fqdn: pulumi.Input[builtins.str],
                 customer_ip: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] customer_fqdn: (Updatable) The fully qualified domain name of the customerIp in the customer VCN
        :param pulumi.Input[builtins.str] customer_ip: (Updatable) The IPv4 address in the customer VCN
        """
        pulumi.set(__self__, "customer_fqdn", customer_fqdn)
        pulumi.set(__self__, "customer_ip", customer_ip)

    @property
    @pulumi.getter(name="customerFqdn")
    def customer_fqdn(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The fully qualified domain name of the customerIp in the customer VCN
        """
        return pulumi.get(self, "customer_fqdn")

    @customer_fqdn.setter
    def customer_fqdn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "customer_fqdn", value)

    @property
    @pulumi.getter(name="customerIp")
    def customer_ip(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The IPv4 address in the customer VCN
        """
        return pulumi.get(self, "customer_ip")

    @customer_ip.setter
    def customer_ip(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "customer_ip", value)


if not MYPY:
    class GetOpensearchClusterPipelinesFilterArgsDict(TypedDict):
        name: builtins.str
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetOpensearchClusterPipelinesFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetOpensearchClusterPipelinesFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetOpensearchClustersFilterArgsDict(TypedDict):
        name: builtins.str
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetOpensearchClustersFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetOpensearchClustersFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetOpensearchVersionsFilterArgsDict(TypedDict):
        name: builtins.str
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetOpensearchVersionsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetOpensearchVersionsFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


