# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAwrHubAwrSourcesSummaryResult',
    'AwaitableGetAwrHubAwrSourcesSummaryResult',
    'get_awr_hub_awr_sources_summary',
    'get_awr_hub_awr_sources_summary_output',
]

@pulumi.output_type
class GetAwrHubAwrSourcesSummaryResult:
    """
    A collection of values returned by getAwrHubAwrSourcesSummary.
    """
    def __init__(__self__, awr_hub_id=None, compartment_id=None, id=None, items=None, name=None):
        if awr_hub_id and not isinstance(awr_hub_id, str):
            raise TypeError("Expected argument 'awr_hub_id' to be a str")
        pulumi.set(__self__, "awr_hub_id", awr_hub_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="awrHubId")
    def awr_hub_id(self) -> builtins.str:
        """
        AWR Hub OCID
        """
        return pulumi.get(self, "awr_hub_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetAwrHubAwrSourcesSummaryItemResult']:
        """
        Array of AwrSource summary objects.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Database name of the Source database for which AWR Data will be uploaded to AWR Hub.
        """
        return pulumi.get(self, "name")


class AwaitableGetAwrHubAwrSourcesSummaryResult(GetAwrHubAwrSourcesSummaryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAwrHubAwrSourcesSummaryResult(
            awr_hub_id=self.awr_hub_id,
            compartment_id=self.compartment_id,
            id=self.id,
            items=self.items,
            name=self.name)


def get_awr_hub_awr_sources_summary(awr_hub_id: Optional[builtins.str] = None,
                                    compartment_id: Optional[builtins.str] = None,
                                    name: Optional[builtins.str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAwrHubAwrSourcesSummaryResult:
    """
    This data source provides details about a specific Awr Hub Awr Sources Summary resource in Oracle Cloud Infrastructure Opsi service.

    Gets a list of summary of AWR Sources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_awr_hub_awr_sources_summary = oci.Opsi.get_awr_hub_awr_sources_summary(awr_hub_id=test_awr_hub["id"],
        compartment_id=compartment_id,
        name=awr_hub_awr_sources_summary_name)
    ```


    :param builtins.str awr_hub_id: Unique Awr Hub identifier
    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.str name: Name for an Awr source database
    """
    __args__ = dict()
    __args__['awrHubId'] = awr_hub_id
    __args__['compartmentId'] = compartment_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Opsi/getAwrHubAwrSourcesSummary:getAwrHubAwrSourcesSummary', __args__, opts=opts, typ=GetAwrHubAwrSourcesSummaryResult).value

    return AwaitableGetAwrHubAwrSourcesSummaryResult(
        awr_hub_id=pulumi.get(__ret__, 'awr_hub_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        name=pulumi.get(__ret__, 'name'))
def get_awr_hub_awr_sources_summary_output(awr_hub_id: Optional[pulumi.Input[builtins.str]] = None,
                                           compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                           name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAwrHubAwrSourcesSummaryResult]:
    """
    This data source provides details about a specific Awr Hub Awr Sources Summary resource in Oracle Cloud Infrastructure Opsi service.

    Gets a list of summary of AWR Sources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_awr_hub_awr_sources_summary = oci.Opsi.get_awr_hub_awr_sources_summary(awr_hub_id=test_awr_hub["id"],
        compartment_id=compartment_id,
        name=awr_hub_awr_sources_summary_name)
    ```


    :param builtins.str awr_hub_id: Unique Awr Hub identifier
    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.str name: Name for an Awr source database
    """
    __args__ = dict()
    __args__['awrHubId'] = awr_hub_id
    __args__['compartmentId'] = compartment_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Opsi/getAwrHubAwrSourcesSummary:getAwrHubAwrSourcesSummary', __args__, opts=opts, typ=GetAwrHubAwrSourcesSummaryResult)
    return __ret__.apply(lambda __response__: GetAwrHubAwrSourcesSummaryResult(
        awr_hub_id=pulumi.get(__response__, 'awr_hub_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        id=pulumi.get(__response__, 'id'),
        items=pulumi.get(__response__, 'items'),
        name=pulumi.get(__response__, 'name')))
