# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSoftwareSourcePackageGroupResult',
    'AwaitableGetSoftwareSourcePackageGroupResult',
    'get_software_source_package_group',
    'get_software_source_package_group_output',
]

@pulumi.output_type
class GetSoftwareSourcePackageGroupResult:
    """
    A collection of values returned by getSoftwareSourcePackageGroup.
    """
    def __init__(__self__, description=None, display_order=None, group_type=None, id=None, is_default=None, is_user_visible=None, name=None, package_group_id=None, packages=None, repositories=None, software_source_id=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_order and not isinstance(display_order, int):
            raise TypeError("Expected argument 'display_order' to be a int")
        pulumi.set(__self__, "display_order", display_order)
        if group_type and not isinstance(group_type, str):
            raise TypeError("Expected argument 'group_type' to be a str")
        pulumi.set(__self__, "group_type", group_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_default and not isinstance(is_default, bool):
            raise TypeError("Expected argument 'is_default' to be a bool")
        pulumi.set(__self__, "is_default", is_default)
        if is_user_visible and not isinstance(is_user_visible, bool):
            raise TypeError("Expected argument 'is_user_visible' to be a bool")
        pulumi.set(__self__, "is_user_visible", is_user_visible)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if package_group_id and not isinstance(package_group_id, str):
            raise TypeError("Expected argument 'package_group_id' to be a str")
        pulumi.set(__self__, "package_group_id", package_group_id)
        if packages and not isinstance(packages, list):
            raise TypeError("Expected argument 'packages' to be a list")
        pulumi.set(__self__, "packages", packages)
        if repositories and not isinstance(repositories, list):
            raise TypeError("Expected argument 'repositories' to be a list")
        pulumi.set(__self__, "repositories", repositories)
        if software_source_id and not isinstance(software_source_id, str):
            raise TypeError("Expected argument 'software_source_id' to be a str")
        pulumi.set(__self__, "software_source_id", software_source_id)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the package group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayOrder")
    def display_order(self) -> builtins.int:
        """
        Indicates the order to display category or environment.
        """
        return pulumi.get(self, "display_order")

    @property
    @pulumi.getter(name="groupType")
    def group_type(self) -> builtins.str:
        """
        Indicates if this is a group, category, or environment.
        """
        return pulumi.get(self, "group_type")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> builtins.bool:
        """
        Indicates if this package group is the default.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter(name="isUserVisible")
    def is_user_visible(self) -> builtins.bool:
        """
        Indicates if this package group is visible to users.
        """
        return pulumi.get(self, "is_user_visible")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Package group name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="packageGroupId")
    def package_group_id(self) -> builtins.str:
        return pulumi.get(self, "package_group_id")

    @property
    @pulumi.getter
    def packages(self) -> Sequence[builtins.str]:
        """
        The list of packages in the package group.
        """
        return pulumi.get(self, "packages")

    @property
    @pulumi.getter
    def repositories(self) -> Sequence[builtins.str]:
        """
        The repository IDs of the package group's repositories.
        """
        return pulumi.get(self, "repositories")

    @property
    @pulumi.getter(name="softwareSourceId")
    def software_source_id(self) -> builtins.str:
        return pulumi.get(self, "software_source_id")


class AwaitableGetSoftwareSourcePackageGroupResult(GetSoftwareSourcePackageGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSoftwareSourcePackageGroupResult(
            description=self.description,
            display_order=self.display_order,
            group_type=self.group_type,
            id=self.id,
            is_default=self.is_default,
            is_user_visible=self.is_user_visible,
            name=self.name,
            package_group_id=self.package_group_id,
            packages=self.packages,
            repositories=self.repositories,
            software_source_id=self.software_source_id)


def get_software_source_package_group(package_group_id: Optional[builtins.str] = None,
                                      software_source_id: Optional[builtins.str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSoftwareSourcePackageGroupResult:
    """
    This data source provides details about a specific Software Source Package Group resource in Oracle Cloud Infrastructure Os Management Hub service.

    Returns information about the specified package group from a software source.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_software_source_package_group = oci.OsManagementHub.get_software_source_package_group(package_group_id=test_group["id"],
        software_source_id=test_software_source["id"])
    ```


    :param builtins.str package_group_id: The unique package group identifier.
    :param builtins.str software_source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the software source.
    """
    __args__ = dict()
    __args__['packageGroupId'] = package_group_id
    __args__['softwareSourceId'] = software_source_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagementHub/getSoftwareSourcePackageGroup:getSoftwareSourcePackageGroup', __args__, opts=opts, typ=GetSoftwareSourcePackageGroupResult).value

    return AwaitableGetSoftwareSourcePackageGroupResult(
        description=pulumi.get(__ret__, 'description'),
        display_order=pulumi.get(__ret__, 'display_order'),
        group_type=pulumi.get(__ret__, 'group_type'),
        id=pulumi.get(__ret__, 'id'),
        is_default=pulumi.get(__ret__, 'is_default'),
        is_user_visible=pulumi.get(__ret__, 'is_user_visible'),
        name=pulumi.get(__ret__, 'name'),
        package_group_id=pulumi.get(__ret__, 'package_group_id'),
        packages=pulumi.get(__ret__, 'packages'),
        repositories=pulumi.get(__ret__, 'repositories'),
        software_source_id=pulumi.get(__ret__, 'software_source_id'))
def get_software_source_package_group_output(package_group_id: Optional[pulumi.Input[builtins.str]] = None,
                                             software_source_id: Optional[pulumi.Input[builtins.str]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSoftwareSourcePackageGroupResult]:
    """
    This data source provides details about a specific Software Source Package Group resource in Oracle Cloud Infrastructure Os Management Hub service.

    Returns information about the specified package group from a software source.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_software_source_package_group = oci.OsManagementHub.get_software_source_package_group(package_group_id=test_group["id"],
        software_source_id=test_software_source["id"])
    ```


    :param builtins.str package_group_id: The unique package group identifier.
    :param builtins.str software_source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the software source.
    """
    __args__ = dict()
    __args__['packageGroupId'] = package_group_id
    __args__['softwareSourceId'] = software_source_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:OsManagementHub/getSoftwareSourcePackageGroup:getSoftwareSourcePackageGroup', __args__, opts=opts, typ=GetSoftwareSourcePackageGroupResult)
    return __ret__.apply(lambda __response__: GetSoftwareSourcePackageGroupResult(
        description=pulumi.get(__response__, 'description'),
        display_order=pulumi.get(__response__, 'display_order'),
        group_type=pulumi.get(__response__, 'group_type'),
        id=pulumi.get(__response__, 'id'),
        is_default=pulumi.get(__response__, 'is_default'),
        is_user_visible=pulumi.get(__response__, 'is_user_visible'),
        name=pulumi.get(__response__, 'name'),
        package_group_id=pulumi.get(__response__, 'package_group_id'),
        packages=pulumi.get(__response__, 'packages'),
        repositories=pulumi.get(__response__, 'repositories'),
        software_source_id=pulumi.get(__response__, 'software_source_id')))
