# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'BackupCopyStatus',
    'BackupDbSystemDetail',
    'BackupSourceBackupDetails',
    'ConfigurationConfigurationDetail',
    'ConfigurationConfigurationDetailItem',
    'ConfigurationDbConfigurationOverrides',
    'ConfigurationDbConfigurationOverridesItem',
    'DbSystemCredentials',
    'DbSystemCredentialsPasswordDetails',
    'DbSystemInstance',
    'DbSystemInstancesDetail',
    'DbSystemManagementPolicy',
    'DbSystemManagementPolicyBackupPolicy',
    'DbSystemManagementPolicyBackupPolicyCopyPolicy',
    'DbSystemNetworkDetails',
    'DbSystemPatchOperation',
    'DbSystemSource',
    'DbSystemStorageDetails',
    'GetBackupCopyStatusResult',
    'GetBackupDbSystemDetailResult',
    'GetBackupSourceBackupDetailResult',
    'GetBackupsBackupCollectionResult',
    'GetBackupsBackupCollectionItemResult',
    'GetBackupsBackupCollectionItemCopyStatusResult',
    'GetBackupsBackupCollectionItemDbSystemDetailResult',
    'GetBackupsBackupCollectionItemSourceBackupDetailResult',
    'GetBackupsFilterResult',
    'GetConfigurationConfigurationDetailResult',
    'GetConfigurationConfigurationDetailItemResult',
    'GetConfigurationDbConfigurationOverrideResult',
    'GetConfigurationDbConfigurationOverrideItemResult',
    'GetConfigurationsConfigurationCollectionResult',
    'GetConfigurationsConfigurationCollectionItemResult',
    'GetConfigurationsConfigurationCollectionItemConfigurationDetailResult',
    'GetConfigurationsConfigurationCollectionItemConfigurationDetailItemResult',
    'GetConfigurationsConfigurationCollectionItemDbConfigurationOverrideResult',
    'GetConfigurationsConfigurationCollectionItemDbConfigurationOverrideItemResult',
    'GetConfigurationsFilterResult',
    'GetDbSystemConnectionDetailInstanceEndpointResult',
    'GetDbSystemConnectionDetailInstanceEndpointEndpointResult',
    'GetDbSystemConnectionDetailPrimaryDbEndpointResult',
    'GetDbSystemConnectionDetailReaderEndpointResult',
    'GetDbSystemCredentialResult',
    'GetDbSystemCredentialPasswordDetailResult',
    'GetDbSystemInstanceResult',
    'GetDbSystemInstancesDetailResult',
    'GetDbSystemManagementPolicyResult',
    'GetDbSystemManagementPolicyBackupPolicyResult',
    'GetDbSystemManagementPolicyBackupPolicyCopyPolicyResult',
    'GetDbSystemNetworkDetailResult',
    'GetDbSystemPatchOperationResult',
    'GetDbSystemSourceResult',
    'GetDbSystemStorageDetailResult',
    'GetDbSystemsDbSystemCollectionResult',
    'GetDbSystemsDbSystemCollectionItemResult',
    'GetDbSystemsDbSystemCollectionItemCredentialResult',
    'GetDbSystemsDbSystemCollectionItemCredentialPasswordDetailResult',
    'GetDbSystemsDbSystemCollectionItemInstanceResult',
    'GetDbSystemsDbSystemCollectionItemInstancesDetailResult',
    'GetDbSystemsDbSystemCollectionItemManagementPolicyResult',
    'GetDbSystemsDbSystemCollectionItemManagementPolicyBackupPolicyResult',
    'GetDbSystemsDbSystemCollectionItemManagementPolicyBackupPolicyCopyPolicyResult',
    'GetDbSystemsDbSystemCollectionItemNetworkDetailResult',
    'GetDbSystemsDbSystemCollectionItemPatchOperationResult',
    'GetDbSystemsDbSystemCollectionItemSourceResult',
    'GetDbSystemsDbSystemCollectionItemStorageDetailResult',
    'GetDbSystemsFilterResult',
    'GetDefaultConfigurationConfigurationDetailResult',
    'GetDefaultConfigurationConfigurationDetailItemResult',
    'GetDefaultConfigurationsDefaultConfigurationCollectionResult',
    'GetDefaultConfigurationsDefaultConfigurationCollectionItemResult',
    'GetDefaultConfigurationsDefaultConfigurationCollectionItemConfigurationDetailResult',
    'GetDefaultConfigurationsDefaultConfigurationCollectionItemConfigurationDetailItemResult',
    'GetDefaultConfigurationsFilterResult',
    'GetShapesFilterResult',
    'GetShapesShapeCollectionResult',
    'GetShapesShapeCollectionItemResult',
    'GetShapesShapeCollectionItemShapeMemoryOptionResult',
    'GetShapesShapeCollectionItemShapeOcpuOptionResult',
]

@pulumi.output_type
class BackupCopyStatus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupId":
            suggest = "backup_id"
        elif key == "stateDetails":
            suggest = "state_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupCopyStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupCopyStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupCopyStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_id: Optional[builtins.str] = None,
                 region: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None,
                 state_details: Optional[builtins.str] = None):
        """
        :param builtins.str backup_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup in the source region
        :param builtins.str region: Region name of the remote region
        :param builtins.str state: The current state of the backup.
        :param builtins.str state_details: A message describing the current state of copy in more detail
        """
        if backup_id is not None:
            pulumi.set(__self__, "backup_id", backup_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_details is not None:
            pulumi.set(__self__, "state_details", state_details)

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup in the source region
        """
        return pulumi.get(self, "backup_id")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        Region name of the remote region
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the backup.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateDetails")
    def state_details(self) -> Optional[builtins.str]:
        """
        A message describing the current state of copy in more detail
        """
        return pulumi.get(self, "state_details")


@pulumi.output_type
class BackupDbSystemDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configId":
            suggest = "config_id"
        elif key == "dbVersion":
            suggest = "db_version"
        elif key == "systemType":
            suggest = "system_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupDbSystemDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupDbSystemDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupDbSystemDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_id: Optional[builtins.str] = None,
                 db_version: Optional[builtins.str] = None,
                 system_type: Optional[builtins.str] = None):
        """
        :param builtins.str config_id: OCID of the configuration that was applied on the source dbSystem at the time when backup was taken.
        :param builtins.str db_version: The major and minor versions of the database system software.
        :param builtins.str system_type: Type of the database system.
        """
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if db_version is not None:
            pulumi.set(__self__, "db_version", db_version)
        if system_type is not None:
            pulumi.set(__self__, "system_type", system_type)

    @property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[builtins.str]:
        """
        OCID of the configuration that was applied on the source dbSystem at the time when backup was taken.
        """
        return pulumi.get(self, "config_id")

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> Optional[builtins.str]:
        """
        The major and minor versions of the database system software.
        """
        return pulumi.get(self, "db_version")

    @property
    @pulumi.getter(name="systemType")
    def system_type(self) -> Optional[builtins.str]:
        """
        Type of the database system.
        """
        return pulumi.get(self, "system_type")


@pulumi.output_type
class BackupSourceBackupDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceBackupId":
            suggest = "source_backup_id"
        elif key == "sourceRegion":
            suggest = "source_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupSourceBackupDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupSourceBackupDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupSourceBackupDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_backup_id: builtins.str,
                 source_region: builtins.str):
        """
        :param builtins.str source_backup_id: Backup ID of the COPY source type.
        :param builtins.str source_region: Backup Region of the COPY source type.
        """
        pulumi.set(__self__, "source_backup_id", source_backup_id)
        pulumi.set(__self__, "source_region", source_region)

    @property
    @pulumi.getter(name="sourceBackupId")
    def source_backup_id(self) -> builtins.str:
        """
        Backup ID of the COPY source type.
        """
        return pulumi.get(self, "source_backup_id")

    @property
    @pulumi.getter(name="sourceRegion")
    def source_region(self) -> builtins.str:
        """
        Backup Region of the COPY source type.
        """
        return pulumi.get(self, "source_region")


@pulumi.output_type
class ConfigurationConfigurationDetail(dict):
    def __init__(__self__, *,
                 items: Optional[Sequence['outputs.ConfigurationConfigurationDetailItem']] = None):
        """
        :param Sequence['ConfigurationConfigurationDetailItemArgs'] items: List of ConfigParms object.
        """
        if items is not None:
            pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Optional[Sequence['outputs.ConfigurationConfigurationDetailItem']]:
        """
        List of ConfigParms object.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class ConfigurationConfigurationDetailItem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedValues":
            suggest = "allowed_values"
        elif key == "configKey":
            suggest = "config_key"
        elif key == "dataType":
            suggest = "data_type"
        elif key == "defaultConfigValue":
            suggest = "default_config_value"
        elif key == "isOverridable":
            suggest = "is_overridable"
        elif key == "isRestartRequired":
            suggest = "is_restart_required"
        elif key == "overridenConfigValue":
            suggest = "overriden_config_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationConfigurationDetailItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationConfigurationDetailItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationConfigurationDetailItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_values: Optional[builtins.str] = None,
                 config_key: Optional[builtins.str] = None,
                 data_type: Optional[builtins.str] = None,
                 default_config_value: Optional[builtins.str] = None,
                 description: Optional[builtins.str] = None,
                 is_overridable: Optional[builtins.bool] = None,
                 is_restart_required: Optional[builtins.bool] = None,
                 overriden_config_value: Optional[builtins.str] = None):
        """
        :param builtins.str allowed_values: Range or list of allowed values.
        :param builtins.str config_key: The configuration variable name.
        :param builtins.str data_type: Data type of the variable.
        :param builtins.str default_config_value: Default value for the configuration variable.
        :param builtins.str description: (Updatable) Details about the configuration set.
        :param builtins.bool is_overridable: Whether the value can be overridden or not.
        :param builtins.bool is_restart_required: If true, modifying this configuration value will require a restart of the database.
        :param builtins.str overriden_config_value: User-selected configuration variable value.
        """
        if allowed_values is not None:
            pulumi.set(__self__, "allowed_values", allowed_values)
        if config_key is not None:
            pulumi.set(__self__, "config_key", config_key)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if default_config_value is not None:
            pulumi.set(__self__, "default_config_value", default_config_value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_overridable is not None:
            pulumi.set(__self__, "is_overridable", is_overridable)
        if is_restart_required is not None:
            pulumi.set(__self__, "is_restart_required", is_restart_required)
        if overriden_config_value is not None:
            pulumi.set(__self__, "overriden_config_value", overriden_config_value)

    @property
    @pulumi.getter(name="allowedValues")
    def allowed_values(self) -> Optional[builtins.str]:
        """
        Range or list of allowed values.
        """
        return pulumi.get(self, "allowed_values")

    @property
    @pulumi.getter(name="configKey")
    def config_key(self) -> Optional[builtins.str]:
        """
        The configuration variable name.
        """
        return pulumi.get(self, "config_key")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[builtins.str]:
        """
        Data type of the variable.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter(name="defaultConfigValue")
    def default_config_value(self) -> Optional[builtins.str]:
        """
        Default value for the configuration variable.
        """
        return pulumi.get(self, "default_config_value")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        (Updatable) Details about the configuration set.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isOverridable")
    def is_overridable(self) -> Optional[builtins.bool]:
        """
        Whether the value can be overridden or not.
        """
        return pulumi.get(self, "is_overridable")

    @property
    @pulumi.getter(name="isRestartRequired")
    def is_restart_required(self) -> Optional[builtins.bool]:
        """
        If true, modifying this configuration value will require a restart of the database.
        """
        return pulumi.get(self, "is_restart_required")

    @property
    @pulumi.getter(name="overridenConfigValue")
    def overriden_config_value(self) -> Optional[builtins.str]:
        """
        User-selected configuration variable value.
        """
        return pulumi.get(self, "overriden_config_value")


@pulumi.output_type
class ConfigurationDbConfigurationOverrides(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.ConfigurationDbConfigurationOverridesItem']):
        """
        :param Sequence['ConfigurationDbConfigurationOverridesItemArgs'] items: List of configuration overridden values.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.ConfigurationDbConfigurationOverridesItem']:
        """
        List of configuration overridden values.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class ConfigurationDbConfigurationOverridesItem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configKey":
            suggest = "config_key"
        elif key == "overridenConfigValue":
            suggest = "overriden_config_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationDbConfigurationOverridesItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationDbConfigurationOverridesItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationDbConfigurationOverridesItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_key: builtins.str,
                 overriden_config_value: builtins.str):
        """
        :param builtins.str config_key: Configuration variable name.
        :param builtins.str overriden_config_value: User-selected variable value.
        """
        pulumi.set(__self__, "config_key", config_key)
        pulumi.set(__self__, "overriden_config_value", overriden_config_value)

    @property
    @pulumi.getter(name="configKey")
    def config_key(self) -> builtins.str:
        """
        Configuration variable name.
        """
        return pulumi.get(self, "config_key")

    @property
    @pulumi.getter(name="overridenConfigValue")
    def overriden_config_value(self) -> builtins.str:
        """
        User-selected variable value.
        """
        return pulumi.get(self, "overriden_config_value")


@pulumi.output_type
class DbSystemCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordDetails":
            suggest = "password_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbSystemCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbSystemCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbSystemCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password_details: 'outputs.DbSystemCredentialsPasswordDetails',
                 username: builtins.str):
        """
        :param 'DbSystemCredentialsPasswordDetailsArgs' password_details: Details for the database system password. Password can be passed as `VaultSecretPasswordDetails` or `PlainTextPasswordDetails`.
        :param builtins.str username: The database system administrator username.
        """
        pulumi.set(__self__, "password_details", password_details)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="passwordDetails")
    def password_details(self) -> 'outputs.DbSystemCredentialsPasswordDetails':
        """
        Details for the database system password. Password can be passed as `VaultSecretPasswordDetails` or `PlainTextPasswordDetails`.
        """
        return pulumi.get(self, "password_details")

    @property
    @pulumi.getter
    def username(self) -> builtins.str:
        """
        The database system administrator username.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class DbSystemCredentialsPasswordDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordType":
            suggest = "password_type"
        elif key == "secretId":
            suggest = "secret_id"
        elif key == "secretVersion":
            suggest = "secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbSystemCredentialsPasswordDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbSystemCredentialsPasswordDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbSystemCredentialsPasswordDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password_type: builtins.str,
                 password: Optional[builtins.str] = None,
                 secret_id: Optional[builtins.str] = None,
                 secret_version: Optional[builtins.str] = None):
        """
        :param builtins.str password_type: The password type.
        :param builtins.str password: The database system password.
        :param builtins.str secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret where the password is stored.
        :param builtins.str secret_version: The secret version of the stored password.
        """
        pulumi.set(__self__, "password_type", password_type)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)
        if secret_version is not None:
            pulumi.set(__self__, "secret_version", secret_version)

    @property
    @pulumi.getter(name="passwordType")
    def password_type(self) -> builtins.str:
        """
        The password type.
        """
        return pulumi.get(self, "password_type")

    @property
    @pulumi.getter
    def password(self) -> Optional[builtins.str]:
        """
        The database system password.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret where the password is stored.
        """
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> Optional[builtins.str]:
        """
        The secret version of the stored password.
        """
        return pulumi.get(self, "secret_version")


@pulumi.output_type
class DbSystemInstance(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityDomain":
            suggest = "availability_domain"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "lifecycleDetails":
            suggest = "lifecycle_details"
        elif key == "timeCreated":
            suggest = "time_created"
        elif key == "timeUpdated":
            suggest = "time_updated"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbSystemInstance. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbSystemInstance.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbSystemInstance.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_domain: Optional[builtins.str] = None,
                 description: Optional[builtins.str] = None,
                 display_name: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None,
                 lifecycle_details: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None,
                 time_created: Optional[builtins.str] = None,
                 time_updated: Optional[builtins.str] = None):
        """
        :param builtins.str availability_domain: Specifies the availability domain of AD-local storage. If `isRegionallyDurable` is set to true, `availabilityDomain` should not be specified. If `isRegionallyDurable` is set to false, `availabilityDomain` must be specified.
        :param builtins.str description: (Updatable) A user-provided description of a database system.
        :param builtins.str display_name: (Updatable) A user-friendly display name for the database system. Avoid entering confidential information.
        :param builtins.str id: A unique identifier for the database instance node. Immutable on creation.
        :param builtins.str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param builtins.str state: The current state of the database system.
        :param builtins.str time_created: The date and time that the database system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        :param builtins.str time_updated: The date and time that the database system was updated, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[builtins.str]:
        """
        Specifies the availability domain of AD-local storage. If `isRegionallyDurable` is set to true, `availabilityDomain` should not be specified. If `isRegionallyDurable` is set to false, `availabilityDomain` must be specified.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        (Updatable) A user-provided description of a database system.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        (Updatable) A user-friendly display name for the database system. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        A unique identifier for the database instance node. Immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[builtins.str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the database system.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[builtins.str]:
        """
        The date and time that the database system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[builtins.str]:
        """
        The date and time that the database system was updated, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class DbSystemInstancesDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "privateIp":
            suggest = "private_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbSystemInstancesDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbSystemInstancesDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbSystemInstancesDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[builtins.str] = None,
                 display_name: Optional[builtins.str] = None,
                 private_ip: Optional[builtins.str] = None):
        """
        :param builtins.str description: A user-provided description of the database instance node.
        :param builtins.str display_name: Display name of the database instance node. Avoid entering confidential information.
        :param builtins.str private_ip: Private IP in customer subnet that will be assigned to the database instance node. This value is optional. If the IP is not provided, the IP will be chosen from the available IP addresses in the specified subnet.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A user-provided description of the database instance node.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        Display name of the database instance node. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[builtins.str]:
        """
        Private IP in customer subnet that will be assigned to the database instance node. This value is optional. If the IP is not provided, the IP will be chosen from the available IP addresses in the specified subnet.
        """
        return pulumi.get(self, "private_ip")


@pulumi.output_type
class DbSystemManagementPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupPolicy":
            suggest = "backup_policy"
        elif key == "maintenanceWindowStart":
            suggest = "maintenance_window_start"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbSystemManagementPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbSystemManagementPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbSystemManagementPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_policy: Optional['outputs.DbSystemManagementPolicyBackupPolicy'] = None,
                 maintenance_window_start: Optional[builtins.str] = None):
        """
        :param 'DbSystemManagementPolicyBackupPolicyArgs' backup_policy: (Updatable) PostgreSQL database system backup policy.
        :param builtins.str maintenance_window_start: (Updatable) The start of the maintenance window in UTC.
               
               This string is of the format: "{day-of-week} {time-of-day}". "{day-of-week}" is a case-insensitive string like "mon", "tue", &c. "{time-of-day}" is the "Time" portion of an RFC3339-formatted timestamp. Any second or sub-second time data will be truncated to zero.
        """
        if backup_policy is not None:
            pulumi.set(__self__, "backup_policy", backup_policy)
        if maintenance_window_start is not None:
            pulumi.set(__self__, "maintenance_window_start", maintenance_window_start)

    @property
    @pulumi.getter(name="backupPolicy")
    def backup_policy(self) -> Optional['outputs.DbSystemManagementPolicyBackupPolicy']:
        """
        (Updatable) PostgreSQL database system backup policy.
        """
        return pulumi.get(self, "backup_policy")

    @property
    @pulumi.getter(name="maintenanceWindowStart")
    def maintenance_window_start(self) -> Optional[builtins.str]:
        """
        (Updatable) The start of the maintenance window in UTC.

        This string is of the format: "{day-of-week} {time-of-day}". "{day-of-week}" is a case-insensitive string like "mon", "tue", &c. "{time-of-day}" is the "Time" portion of an RFC3339-formatted timestamp. Any second or sub-second time data will be truncated to zero.
        """
        return pulumi.get(self, "maintenance_window_start")


@pulumi.output_type
class DbSystemManagementPolicyBackupPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupStart":
            suggest = "backup_start"
        elif key == "copyPolicy":
            suggest = "copy_policy"
        elif key == "daysOfTheMonths":
            suggest = "days_of_the_months"
        elif key == "daysOfTheWeeks":
            suggest = "days_of_the_weeks"
        elif key == "retentionDays":
            suggest = "retention_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbSystemManagementPolicyBackupPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbSystemManagementPolicyBackupPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbSystemManagementPolicyBackupPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_start: Optional[builtins.str] = None,
                 copy_policy: Optional['outputs.DbSystemManagementPolicyBackupPolicyCopyPolicy'] = None,
                 days_of_the_months: Optional[Sequence[builtins.int]] = None,
                 days_of_the_weeks: Optional[Sequence[builtins.str]] = None,
                 kind: Optional[builtins.str] = None,
                 retention_days: Optional[builtins.int] = None):
        """
        :param builtins.str backup_start: (Updatable) Hour of the day when the backup starts.
        :param 'DbSystemManagementPolicyBackupPolicyCopyPolicyArgs' copy_policy: (Updatable) Backup copy details
        :param Sequence[builtins.int] days_of_the_months: (Updatable) Day of the month when the backup should start. To ensure that the backup runs monthly, the latest day of the month that you can use to schedule a backup is the the 28th day.
        :param Sequence[builtins.str] days_of_the_weeks: (Updatable) The day of the week that the backup starts.
        :param builtins.str kind: (Updatable) The kind of backup policy.
        :param builtins.int retention_days: (Updatable) How many days the data should be stored after the database system deletion.
        """
        if backup_start is not None:
            pulumi.set(__self__, "backup_start", backup_start)
        if copy_policy is not None:
            pulumi.set(__self__, "copy_policy", copy_policy)
        if days_of_the_months is not None:
            pulumi.set(__self__, "days_of_the_months", days_of_the_months)
        if days_of_the_weeks is not None:
            pulumi.set(__self__, "days_of_the_weeks", days_of_the_weeks)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if retention_days is not None:
            pulumi.set(__self__, "retention_days", retention_days)

    @property
    @pulumi.getter(name="backupStart")
    def backup_start(self) -> Optional[builtins.str]:
        """
        (Updatable) Hour of the day when the backup starts.
        """
        return pulumi.get(self, "backup_start")

    @property
    @pulumi.getter(name="copyPolicy")
    def copy_policy(self) -> Optional['outputs.DbSystemManagementPolicyBackupPolicyCopyPolicy']:
        """
        (Updatable) Backup copy details
        """
        return pulumi.get(self, "copy_policy")

    @property
    @pulumi.getter(name="daysOfTheMonths")
    def days_of_the_months(self) -> Optional[Sequence[builtins.int]]:
        """
        (Updatable) Day of the month when the backup should start. To ensure that the backup runs monthly, the latest day of the month that you can use to schedule a backup is the the 28th day.
        """
        return pulumi.get(self, "days_of_the_months")

    @property
    @pulumi.getter(name="daysOfTheWeeks")
    def days_of_the_weeks(self) -> Optional[Sequence[builtins.str]]:
        """
        (Updatable) The day of the week that the backup starts.
        """
        return pulumi.get(self, "days_of_the_weeks")

    @property
    @pulumi.getter
    def kind(self) -> Optional[builtins.str]:
        """
        (Updatable) The kind of backup policy.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> Optional[builtins.int]:
        """
        (Updatable) How many days the data should be stored after the database system deletion.
        """
        return pulumi.get(self, "retention_days")


@pulumi.output_type
class DbSystemManagementPolicyBackupPolicyCopyPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compartmentId":
            suggest = "compartment_id"
        elif key == "retentionPeriod":
            suggest = "retention_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbSystemManagementPolicyBackupPolicyCopyPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbSystemManagementPolicyBackupPolicyCopyPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbSystemManagementPolicyBackupPolicyCopyPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compartment_id: builtins.str,
                 regions: Sequence[builtins.str],
                 retention_period: Optional[builtins.int] = None):
        """
        :param builtins.str compartment_id: (Updatable) target compartment to place a new backup
        :param Sequence[builtins.str] regions: (Updatable) List of region names of the remote region
        :param builtins.int retention_period: (Updatable) Retention period in days of the backup copy.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "regions", regions)
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        (Updatable) target compartment to place a new backup
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def regions(self) -> Sequence[builtins.str]:
        """
        (Updatable) List of region names of the remote region
        """
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> Optional[builtins.int]:
        """
        (Updatable) Retention period in days of the backup copy.
        """
        return pulumi.get(self, "retention_period")


@pulumi.output_type
class DbSystemNetworkDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"
        elif key == "isReaderEndpointEnabled":
            suggest = "is_reader_endpoint_enabled"
        elif key == "nsgIds":
            suggest = "nsg_ids"
        elif key == "primaryDbEndpointPrivateIp":
            suggest = "primary_db_endpoint_private_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbSystemNetworkDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbSystemNetworkDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbSystemNetworkDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_id: builtins.str,
                 is_reader_endpoint_enabled: Optional[builtins.bool] = None,
                 nsg_ids: Optional[Sequence[builtins.str]] = None,
                 primary_db_endpoint_private_ip: Optional[builtins.str] = None):
        """
        :param builtins.str subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the customer subnet associated with the database system.
        :param builtins.bool is_reader_endpoint_enabled: (Updatable) Specifies if the reader endpoint is enabled on the dbSystem.
        :param Sequence[builtins.str] nsg_ids: (Updatable) List of customer Network Security Group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with the database system.
        :param builtins.str primary_db_endpoint_private_ip: Private IP in customer subnet. The value is optional. If the IP is not provided, the IP will be chosen from the available IP addresses from the specified subnet.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        if is_reader_endpoint_enabled is not None:
            pulumi.set(__self__, "is_reader_endpoint_enabled", is_reader_endpoint_enabled)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if primary_db_endpoint_private_ip is not None:
            pulumi.set(__self__, "primary_db_endpoint_private_ip", primary_db_endpoint_private_ip)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the customer subnet associated with the database system.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="isReaderEndpointEnabled")
    def is_reader_endpoint_enabled(self) -> Optional[builtins.bool]:
        """
        (Updatable) Specifies if the reader endpoint is enabled on the dbSystem.
        """
        return pulumi.get(self, "is_reader_endpoint_enabled")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        (Updatable) List of customer Network Security Group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with the database system.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="primaryDbEndpointPrivateIp")
    def primary_db_endpoint_private_ip(self) -> Optional[builtins.str]:
        """
        Private IP in customer subnet. The value is optional. If the IP is not provided, the IP will be chosen from the available IP addresses from the specified subnet.
        """
        return pulumi.get(self, "primary_db_endpoint_private_ip")


@pulumi.output_type
class DbSystemPatchOperation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "from":
            suggest = "from_"
        elif key == "selectedItem":
            suggest = "selected_item"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbSystemPatchOperation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbSystemPatchOperation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbSystemPatchOperation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operation: builtins.str,
                 selection: builtins.str,
                 from_: Optional[builtins.str] = None,
                 position: Optional[builtins.str] = None,
                 selected_item: Optional[builtins.str] = None,
                 value: Optional[Mapping[str, builtins.str]] = None):
        """
        :param builtins.str operation: The operation can be one of these values: `INSERT`, `REMOVE`.
        :param builtins.str selection: In case of `INSERT`, selection is `instances`. In case of `REMOVE`, selection is `instances[?id == '${var.instance_id}']`.
        :param Mapping[str, builtins.str] value: Specify instance details such as displayName, description or privateIp. Example: `{"displayName": "value"}`.
        """
        pulumi.set(__self__, "operation", operation)
        pulumi.set(__self__, "selection", selection)
        if from_ is not None:
            pulumi.set(__self__, "from_", from_)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if selected_item is not None:
            pulumi.set(__self__, "selected_item", selected_item)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def operation(self) -> builtins.str:
        """
        The operation can be one of these values: `INSERT`, `REMOVE`.
        """
        return pulumi.get(self, "operation")

    @property
    @pulumi.getter
    def selection(self) -> builtins.str:
        """
        In case of `INSERT`, selection is `instances`. In case of `REMOVE`, selection is `instances[?id == '${var.instance_id}']`.
        """
        return pulumi.get(self, "selection")

    @property
    @pulumi.getter(name="from")
    def from_(self) -> Optional[builtins.str]:
        return pulumi.get(self, "from_")

    @property
    @pulumi.getter
    def position(self) -> Optional[builtins.str]:
        return pulumi.get(self, "position")

    @property
    @pulumi.getter(name="selectedItem")
    def selected_item(self) -> Optional[builtins.str]:
        return pulumi.get(self, "selected_item")

    @property
    @pulumi.getter
    def value(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Specify instance details such as displayName, description or privateIp. Example: `{"displayName": "value"}`.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DbSystemSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceType":
            suggest = "source_type"
        elif key == "backupId":
            suggest = "backup_id"
        elif key == "isHavingRestoreConfigOverrides":
            suggest = "is_having_restore_config_overrides"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbSystemSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbSystemSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbSystemSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_type: builtins.str,
                 backup_id: Optional[builtins.str] = None,
                 is_having_restore_config_overrides: Optional[builtins.bool] = None):
        """
        :param builtins.str source_type: The source descriminator. Example: `{"source_type": "BACKUP"}`.
        :param builtins.str backup_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database system backup.
        :param builtins.bool is_having_restore_config_overrides: Deprecated. Don't use.
        """
        pulumi.set(__self__, "source_type", source_type)
        if backup_id is not None:
            pulumi.set(__self__, "backup_id", backup_id)
        if is_having_restore_config_overrides is not None:
            pulumi.set(__self__, "is_having_restore_config_overrides", is_having_restore_config_overrides)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> builtins.str:
        """
        The source descriminator. Example: `{"source_type": "BACKUP"}`.
        """
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database system backup.
        """
        return pulumi.get(self, "backup_id")

    @property
    @pulumi.getter(name="isHavingRestoreConfigOverrides")
    def is_having_restore_config_overrides(self) -> Optional[builtins.bool]:
        """
        Deprecated. Don't use.
        """
        return pulumi.get(self, "is_having_restore_config_overrides")


@pulumi.output_type
class DbSystemStorageDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isRegionallyDurable":
            suggest = "is_regionally_durable"
        elif key == "systemType":
            suggest = "system_type"
        elif key == "availabilityDomain":
            suggest = "availability_domain"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbSystemStorageDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbSystemStorageDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbSystemStorageDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_regionally_durable: builtins.bool,
                 system_type: builtins.str,
                 availability_domain: Optional[builtins.str] = None,
                 iops: Optional[builtins.str] = None):
        """
        :param builtins.bool is_regionally_durable: Specifies if the block volume used for the database system is regional or AD-local. If not specified, it will be set to false. If `isRegionallyDurable` is set to true, `availabilityDomain` should not be specified. If `isRegionallyDurable` is set to false, `availabilityDomain` must be specified.
        :param builtins.str system_type: Type of the database system.
        :param builtins.str availability_domain: Specifies the availability domain of AD-local storage. If `isRegionallyDurable` is set to true, `availabilityDomain` should not be specified. If `isRegionallyDurable` is set to false, `availabilityDomain` must be specified.
        :param builtins.str iops: (Updatable) Guaranteed input/output storage requests per second (IOPS) available to the database system. Find more about the supported Peformance Tiers [here](https://docs.oracle.com/en-us/iaas/Content/postgresql/performance-tiers.htm).
        """
        pulumi.set(__self__, "is_regionally_durable", is_regionally_durable)
        pulumi.set(__self__, "system_type", system_type)
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)

    @property
    @pulumi.getter(name="isRegionallyDurable")
    def is_regionally_durable(self) -> builtins.bool:
        """
        Specifies if the block volume used for the database system is regional or AD-local. If not specified, it will be set to false. If `isRegionallyDurable` is set to true, `availabilityDomain` should not be specified. If `isRegionallyDurable` is set to false, `availabilityDomain` must be specified.
        """
        return pulumi.get(self, "is_regionally_durable")

    @property
    @pulumi.getter(name="systemType")
    def system_type(self) -> builtins.str:
        """
        Type of the database system.
        """
        return pulumi.get(self, "system_type")

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[builtins.str]:
        """
        Specifies the availability domain of AD-local storage. If `isRegionallyDurable` is set to true, `availabilityDomain` should not be specified. If `isRegionallyDurable` is set to false, `availabilityDomain` must be specified.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter
    def iops(self) -> Optional[builtins.str]:
        """
        (Updatable) Guaranteed input/output storage requests per second (IOPS) available to the database system. Find more about the supported Peformance Tiers [here](https://docs.oracle.com/en-us/iaas/Content/postgresql/performance-tiers.htm).
        """
        return pulumi.get(self, "iops")


@pulumi.output_type
class GetBackupCopyStatusResult(dict):
    def __init__(__self__, *,
                 backup_id: builtins.str,
                 region: builtins.str,
                 state: builtins.str,
                 state_details: builtins.str):
        """
        :param builtins.str backup_id: A unique identifier for the backup.
        :param builtins.str region: Region name of the remote region
        :param builtins.str state: The current state of the backup.
        :param builtins.str state_details: A message describing the current state of copy in more detail
        """
        pulumi.set(__self__, "backup_id", backup_id)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "state_details", state_details)

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> builtins.str:
        """
        A unique identifier for the backup.
        """
        return pulumi.get(self, "backup_id")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        Region name of the remote region
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the backup.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateDetails")
    def state_details(self) -> builtins.str:
        """
        A message describing the current state of copy in more detail
        """
        return pulumi.get(self, "state_details")


@pulumi.output_type
class GetBackupDbSystemDetailResult(dict):
    def __init__(__self__, *,
                 config_id: builtins.str,
                 db_version: builtins.str,
                 system_type: builtins.str):
        """
        :param builtins.str config_id: OCID of the configuration that was applied on the source dbSystem at the time when backup was taken.
        :param builtins.str db_version: The major and minor versions of the database system software.
        :param builtins.str system_type: Type of the database system.
        """
        pulumi.set(__self__, "config_id", config_id)
        pulumi.set(__self__, "db_version", db_version)
        pulumi.set(__self__, "system_type", system_type)

    @property
    @pulumi.getter(name="configId")
    def config_id(self) -> builtins.str:
        """
        OCID of the configuration that was applied on the source dbSystem at the time when backup was taken.
        """
        return pulumi.get(self, "config_id")

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> builtins.str:
        """
        The major and minor versions of the database system software.
        """
        return pulumi.get(self, "db_version")

    @property
    @pulumi.getter(name="systemType")
    def system_type(self) -> builtins.str:
        """
        Type of the database system.
        """
        return pulumi.get(self, "system_type")


@pulumi.output_type
class GetBackupSourceBackupDetailResult(dict):
    def __init__(__self__, *,
                 source_backup_id: builtins.str,
                 source_region: builtins.str):
        """
        :param builtins.str source_backup_id: Backup ID of the COPY source type.
        :param builtins.str source_region: Backup Region of the COPY source type.
        """
        pulumi.set(__self__, "source_backup_id", source_backup_id)
        pulumi.set(__self__, "source_region", source_region)

    @property
    @pulumi.getter(name="sourceBackupId")
    def source_backup_id(self) -> builtins.str:
        """
        Backup ID of the COPY source type.
        """
        return pulumi.get(self, "source_backup_id")

    @property
    @pulumi.getter(name="sourceRegion")
    def source_region(self) -> builtins.str:
        """
        Backup Region of the COPY source type.
        """
        return pulumi.get(self, "source_region")


@pulumi.output_type
class GetBackupsBackupCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetBackupsBackupCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetBackupsBackupCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetBackupsBackupCollectionItemResult(dict):
    def __init__(__self__, *,
                 backup_size: builtins.int,
                 compartment_id: builtins.str,
                 copy_statuses: Sequence['outputs.GetBackupsBackupCollectionItemCopyStatusResult'],
                 db_system_details: Sequence['outputs.GetBackupsBackupCollectionItemDbSystemDetailResult'],
                 db_system_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 description: builtins.str,
                 display_name: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 last_accepted_request_token: builtins.str,
                 last_completed_request_token: builtins.str,
                 lifecycle_details: builtins.str,
                 retention_period: builtins.int,
                 source_backup_details: Sequence['outputs.GetBackupsBackupCollectionItemSourceBackupDetailResult'],
                 source_type: builtins.str,
                 state: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 time_created: builtins.str,
                 time_created_precise: builtins.str,
                 time_updated: builtins.str):
        """
        :param builtins.int backup_size: The size of the backup, in gigabytes.
        :param builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param Sequence['GetBackupsBackupCollectionItemCopyStatusArgs'] copy_statuses: List of status for Backup Copy
        :param Sequence['GetBackupsBackupCollectionItemDbSystemDetailArgs'] db_system_details: Information about the database system associated with a backup.
        :param builtins.str db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup's source database system.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param builtins.str description: A description for the backup.
        :param builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param builtins.str id: A unique identifier for the database system.
        :param builtins.str last_accepted_request_token: lastAcceptedRequestToken from MP.
        :param builtins.str last_completed_request_token: lastCompletedRequestToken from MP.
        :param builtins.str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param builtins.int retention_period: Backup retention period in days.
        :param Sequence['GetBackupsBackupCollectionItemSourceBackupDetailArgs'] source_backup_details: Information about the Source Backup associated with a backup.
        :param builtins.str source_type: Specifies whether the backup was created manually, taken on schedule defined in the a backup policy, or copied from the remote location.
        :param builtins.str state: A filter to return only resources if their `lifecycleState` matches the given `lifecycleState`.
        :param Mapping[str, builtins.str] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param builtins.str time_created: The date and time the backup request was received, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        :param builtins.str time_created_precise: The date and time the backup was created. This is the time the actual point-in-time data snapshot was taken, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        :param builtins.str time_updated: The date and time the backup was updated, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "backup_size", backup_size)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "copy_statuses", copy_statuses)
        pulumi.set(__self__, "db_system_details", db_system_details)
        pulumi.set(__self__, "db_system_id", db_system_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "last_accepted_request_token", last_accepted_request_token)
        pulumi.set(__self__, "last_completed_request_token", last_completed_request_token)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "retention_period", retention_period)
        pulumi.set(__self__, "source_backup_details", source_backup_details)
        pulumi.set(__self__, "source_type", source_type)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_created_precise", time_created_precise)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="backupSize")
    def backup_size(self) -> builtins.int:
        """
        The size of the backup, in gigabytes.
        """
        return pulumi.get(self, "backup_size")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="copyStatuses")
    def copy_statuses(self) -> Sequence['outputs.GetBackupsBackupCollectionItemCopyStatusResult']:
        """
        List of status for Backup Copy
        """
        return pulumi.get(self, "copy_statuses")

    @property
    @pulumi.getter(name="dbSystemDetails")
    def db_system_details(self) -> Sequence['outputs.GetBackupsBackupCollectionItemDbSystemDetailResult']:
        """
        Information about the database system associated with a backup.
        """
        return pulumi.get(self, "db_system_details")

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup's source database system.
        """
        return pulumi.get(self, "db_system_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A description for the backup.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        A unique identifier for the database system.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastAcceptedRequestToken")
    def last_accepted_request_token(self) -> builtins.str:
        """
        lastAcceptedRequestToken from MP.
        """
        return pulumi.get(self, "last_accepted_request_token")

    @property
    @pulumi.getter(name="lastCompletedRequestToken")
    def last_completed_request_token(self) -> builtins.str:
        """
        lastCompletedRequestToken from MP.
        """
        return pulumi.get(self, "last_completed_request_token")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> builtins.int:
        """
        Backup retention period in days.
        """
        return pulumi.get(self, "retention_period")

    @property
    @pulumi.getter(name="sourceBackupDetails")
    def source_backup_details(self) -> Sequence['outputs.GetBackupsBackupCollectionItemSourceBackupDetailResult']:
        """
        Information about the Source Backup associated with a backup.
        """
        return pulumi.get(self, "source_backup_details")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> builtins.str:
        """
        Specifies whether the backup was created manually, taken on schedule defined in the a backup policy, or copied from the remote location.
        """
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        A filter to return only resources if their `lifecycleState` matches the given `lifecycleState`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the backup request was received, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeCreatedPrecise")
    def time_created_precise(self) -> builtins.str:
        """
        The date and time the backup was created. This is the time the actual point-in-time data snapshot was taken, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created_precise")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the backup was updated, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetBackupsBackupCollectionItemCopyStatusResult(dict):
    def __init__(__self__, *,
                 backup_id: builtins.str,
                 region: builtins.str,
                 state: builtins.str,
                 state_details: builtins.str):
        """
        :param builtins.str backup_id: A unique identifier for the backup.
        :param builtins.str region: Region name of the remote region
        :param builtins.str state: A filter to return only resources if their `lifecycleState` matches the given `lifecycleState`.
        :param builtins.str state_details: A message describing the current state of copy in more detail
        """
        pulumi.set(__self__, "backup_id", backup_id)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "state_details", state_details)

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> builtins.str:
        """
        A unique identifier for the backup.
        """
        return pulumi.get(self, "backup_id")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        Region name of the remote region
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        A filter to return only resources if their `lifecycleState` matches the given `lifecycleState`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateDetails")
    def state_details(self) -> builtins.str:
        """
        A message describing the current state of copy in more detail
        """
        return pulumi.get(self, "state_details")


@pulumi.output_type
class GetBackupsBackupCollectionItemDbSystemDetailResult(dict):
    def __init__(__self__, *,
                 config_id: builtins.str,
                 db_version: builtins.str,
                 system_type: builtins.str):
        """
        :param builtins.str config_id: OCID of the configuration that was applied on the source dbSystem at the time when backup was taken.
        :param builtins.str db_version: The major and minor versions of the database system software.
        :param builtins.str system_type: Type of the database system.
        """
        pulumi.set(__self__, "config_id", config_id)
        pulumi.set(__self__, "db_version", db_version)
        pulumi.set(__self__, "system_type", system_type)

    @property
    @pulumi.getter(name="configId")
    def config_id(self) -> builtins.str:
        """
        OCID of the configuration that was applied on the source dbSystem at the time when backup was taken.
        """
        return pulumi.get(self, "config_id")

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> builtins.str:
        """
        The major and minor versions of the database system software.
        """
        return pulumi.get(self, "db_version")

    @property
    @pulumi.getter(name="systemType")
    def system_type(self) -> builtins.str:
        """
        Type of the database system.
        """
        return pulumi.get(self, "system_type")


@pulumi.output_type
class GetBackupsBackupCollectionItemSourceBackupDetailResult(dict):
    def __init__(__self__, *,
                 source_backup_id: builtins.str,
                 source_region: builtins.str):
        """
        :param builtins.str source_backup_id: Backup ID of the COPY source type.
        :param builtins.str source_region: Backup Region of the COPY source type.
        """
        pulumi.set(__self__, "source_backup_id", source_backup_id)
        pulumi.set(__self__, "source_region", source_region)

    @property
    @pulumi.getter(name="sourceBackupId")
    def source_backup_id(self) -> builtins.str:
        """
        Backup ID of the COPY source type.
        """
        return pulumi.get(self, "source_backup_id")

    @property
    @pulumi.getter(name="sourceRegion")
    def source_region(self) -> builtins.str:
        """
        Backup Region of the COPY source type.
        """
        return pulumi.get(self, "source_region")


@pulumi.output_type
class GetBackupsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetConfigurationConfigurationDetailResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetConfigurationConfigurationDetailItemResult']):
        """
        :param Sequence['GetConfigurationConfigurationDetailItemArgs'] items: List of ConfigParms object.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetConfigurationConfigurationDetailItemResult']:
        """
        List of ConfigParms object.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetConfigurationConfigurationDetailItemResult(dict):
    def __init__(__self__, *,
                 allowed_values: builtins.str,
                 config_key: builtins.str,
                 data_type: builtins.str,
                 default_config_value: builtins.str,
                 description: builtins.str,
                 is_overridable: builtins.bool,
                 is_restart_required: builtins.bool,
                 overriden_config_value: builtins.str):
        """
        :param builtins.str allowed_values: Range or list of allowed values.
        :param builtins.str config_key: The configuration variable name.
        :param builtins.str data_type: Data type of the variable.
        :param builtins.str default_config_value: Default value for the configuration variable.
        :param builtins.str description: A description for the configuration.
        :param builtins.bool is_overridable: Whether the value can be overridden or not.
        :param builtins.bool is_restart_required: If true, modifying this configuration value will require a restart of the database.
        :param builtins.str overriden_config_value: User-selected configuration variable value.
        """
        pulumi.set(__self__, "allowed_values", allowed_values)
        pulumi.set(__self__, "config_key", config_key)
        pulumi.set(__self__, "data_type", data_type)
        pulumi.set(__self__, "default_config_value", default_config_value)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "is_overridable", is_overridable)
        pulumi.set(__self__, "is_restart_required", is_restart_required)
        pulumi.set(__self__, "overriden_config_value", overriden_config_value)

    @property
    @pulumi.getter(name="allowedValues")
    def allowed_values(self) -> builtins.str:
        """
        Range or list of allowed values.
        """
        return pulumi.get(self, "allowed_values")

    @property
    @pulumi.getter(name="configKey")
    def config_key(self) -> builtins.str:
        """
        The configuration variable name.
        """
        return pulumi.get(self, "config_key")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> builtins.str:
        """
        Data type of the variable.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter(name="defaultConfigValue")
    def default_config_value(self) -> builtins.str:
        """
        Default value for the configuration variable.
        """
        return pulumi.get(self, "default_config_value")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A description for the configuration.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isOverridable")
    def is_overridable(self) -> builtins.bool:
        """
        Whether the value can be overridden or not.
        """
        return pulumi.get(self, "is_overridable")

    @property
    @pulumi.getter(name="isRestartRequired")
    def is_restart_required(self) -> builtins.bool:
        """
        If true, modifying this configuration value will require a restart of the database.
        """
        return pulumi.get(self, "is_restart_required")

    @property
    @pulumi.getter(name="overridenConfigValue")
    def overriden_config_value(self) -> builtins.str:
        """
        User-selected configuration variable value.
        """
        return pulumi.get(self, "overriden_config_value")


@pulumi.output_type
class GetConfigurationDbConfigurationOverrideResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetConfigurationDbConfigurationOverrideItemResult']):
        """
        :param Sequence['GetConfigurationDbConfigurationOverrideItemArgs'] items: List of ConfigParms object.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetConfigurationDbConfigurationOverrideItemResult']:
        """
        List of ConfigParms object.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetConfigurationDbConfigurationOverrideItemResult(dict):
    def __init__(__self__, *,
                 config_key: builtins.str,
                 overriden_config_value: builtins.str):
        """
        :param builtins.str config_key: The configuration variable name.
        :param builtins.str overriden_config_value: User-selected configuration variable value.
        """
        pulumi.set(__self__, "config_key", config_key)
        pulumi.set(__self__, "overriden_config_value", overriden_config_value)

    @property
    @pulumi.getter(name="configKey")
    def config_key(self) -> builtins.str:
        """
        The configuration variable name.
        """
        return pulumi.get(self, "config_key")

    @property
    @pulumi.getter(name="overridenConfigValue")
    def overriden_config_value(self) -> builtins.str:
        """
        User-selected configuration variable value.
        """
        return pulumi.get(self, "overriden_config_value")


@pulumi.output_type
class GetConfigurationsConfigurationCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetConfigurationsConfigurationCollectionItemResult']):
        """
        :param Sequence['GetConfigurationsConfigurationCollectionItemArgs'] items: List of ConfigParms object.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetConfigurationsConfigurationCollectionItemResult']:
        """
        List of ConfigParms object.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetConfigurationsConfigurationCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: builtins.str,
                 config_type: builtins.str,
                 configuration_details: Sequence['outputs.GetConfigurationsConfigurationCollectionItemConfigurationDetailResult'],
                 db_configuration_overrides: Sequence['outputs.GetConfigurationsConfigurationCollectionItemDbConfigurationOverrideResult'],
                 db_version: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 description: builtins.str,
                 display_name: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 instance_memory_size_in_gbs: builtins.int,
                 instance_ocpu_count: builtins.int,
                 is_flexible: builtins.bool,
                 lifecycle_details: builtins.str,
                 shape: builtins.str,
                 state: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 time_created: builtins.str):
        """
        :param builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param builtins.str config_type: A filter to return only resources if their `configType` matches the given `configType`.
        :param Sequence['GetConfigurationsConfigurationCollectionItemConfigurationDetailArgs'] configuration_details: List of configuration details.
        :param builtins.str db_version: Version of the PostgreSQL database, such as 14.9.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param builtins.str description: A description for the configuration.
        :param builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param builtins.str id: A unique identifier for the configuration. Immutable on creation.
        :param builtins.int instance_memory_size_in_gbs: Memory size in gigabytes with 1GB increment.
        :param builtins.int instance_ocpu_count: CPU core count.
        :param builtins.bool is_flexible: Whether the configuration supports flexible shapes.
        :param builtins.str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param builtins.str shape: The name of the shape for the configuration. Example: `VM.Standard.E4.Flex`
        :param builtins.str state: A filter to return only resources if their `lifecycleState` matches the given `lifecycleState`.
        :param Mapping[str, builtins.str] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param builtins.str time_created: The date and time that the configuration was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "config_type", config_type)
        pulumi.set(__self__, "configuration_details", configuration_details)
        pulumi.set(__self__, "db_configuration_overrides", db_configuration_overrides)
        pulumi.set(__self__, "db_version", db_version)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_memory_size_in_gbs", instance_memory_size_in_gbs)
        pulumi.set(__self__, "instance_ocpu_count", instance_ocpu_count)
        pulumi.set(__self__, "is_flexible", is_flexible)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "shape", shape)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="configType")
    def config_type(self) -> builtins.str:
        """
        A filter to return only resources if their `configType` matches the given `configType`.
        """
        return pulumi.get(self, "config_type")

    @property
    @pulumi.getter(name="configurationDetails")
    def configuration_details(self) -> Sequence['outputs.GetConfigurationsConfigurationCollectionItemConfigurationDetailResult']:
        """
        List of configuration details.
        """
        return pulumi.get(self, "configuration_details")

    @property
    @pulumi.getter(name="dbConfigurationOverrides")
    def db_configuration_overrides(self) -> Sequence['outputs.GetConfigurationsConfigurationCollectionItemDbConfigurationOverrideResult']:
        return pulumi.get(self, "db_configuration_overrides")

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> builtins.str:
        """
        Version of the PostgreSQL database, such as 14.9.
        """
        return pulumi.get(self, "db_version")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A description for the configuration.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        A unique identifier for the configuration. Immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceMemorySizeInGbs")
    def instance_memory_size_in_gbs(self) -> builtins.int:
        """
        Memory size in gigabytes with 1GB increment.
        """
        return pulumi.get(self, "instance_memory_size_in_gbs")

    @property
    @pulumi.getter(name="instanceOcpuCount")
    def instance_ocpu_count(self) -> builtins.int:
        """
        CPU core count.
        """
        return pulumi.get(self, "instance_ocpu_count")

    @property
    @pulumi.getter(name="isFlexible")
    def is_flexible(self) -> builtins.bool:
        """
        Whether the configuration supports flexible shapes.
        """
        return pulumi.get(self, "is_flexible")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def shape(self) -> builtins.str:
        """
        The name of the shape for the configuration. Example: `VM.Standard.E4.Flex`
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        A filter to return only resources if their `lifecycleState` matches the given `lifecycleState`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time that the configuration was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetConfigurationsConfigurationCollectionItemConfigurationDetailResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetConfigurationsConfigurationCollectionItemConfigurationDetailItemResult']):
        """
        :param Sequence['GetConfigurationsConfigurationCollectionItemConfigurationDetailItemArgs'] items: List of ConfigParms object.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetConfigurationsConfigurationCollectionItemConfigurationDetailItemResult']:
        """
        List of ConfigParms object.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetConfigurationsConfigurationCollectionItemConfigurationDetailItemResult(dict):
    def __init__(__self__, *,
                 allowed_values: builtins.str,
                 config_key: builtins.str,
                 data_type: builtins.str,
                 default_config_value: builtins.str,
                 description: builtins.str,
                 is_overridable: builtins.bool,
                 is_restart_required: builtins.bool,
                 overriden_config_value: builtins.str):
        """
        :param builtins.str allowed_values: Range or list of allowed values.
        :param builtins.str config_key: The configuration variable name.
        :param builtins.str data_type: Data type of the variable.
        :param builtins.str default_config_value: Default value for the configuration variable.
        :param builtins.str description: A description for the configuration.
        :param builtins.bool is_overridable: Whether the value can be overridden or not.
        :param builtins.bool is_restart_required: If true, modifying this configuration value will require a restart of the database.
        :param builtins.str overriden_config_value: User-selected configuration variable value.
        """
        pulumi.set(__self__, "allowed_values", allowed_values)
        pulumi.set(__self__, "config_key", config_key)
        pulumi.set(__self__, "data_type", data_type)
        pulumi.set(__self__, "default_config_value", default_config_value)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "is_overridable", is_overridable)
        pulumi.set(__self__, "is_restart_required", is_restart_required)
        pulumi.set(__self__, "overriden_config_value", overriden_config_value)

    @property
    @pulumi.getter(name="allowedValues")
    def allowed_values(self) -> builtins.str:
        """
        Range or list of allowed values.
        """
        return pulumi.get(self, "allowed_values")

    @property
    @pulumi.getter(name="configKey")
    def config_key(self) -> builtins.str:
        """
        The configuration variable name.
        """
        return pulumi.get(self, "config_key")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> builtins.str:
        """
        Data type of the variable.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter(name="defaultConfigValue")
    def default_config_value(self) -> builtins.str:
        """
        Default value for the configuration variable.
        """
        return pulumi.get(self, "default_config_value")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A description for the configuration.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isOverridable")
    def is_overridable(self) -> builtins.bool:
        """
        Whether the value can be overridden or not.
        """
        return pulumi.get(self, "is_overridable")

    @property
    @pulumi.getter(name="isRestartRequired")
    def is_restart_required(self) -> builtins.bool:
        """
        If true, modifying this configuration value will require a restart of the database.
        """
        return pulumi.get(self, "is_restart_required")

    @property
    @pulumi.getter(name="overridenConfigValue")
    def overriden_config_value(self) -> builtins.str:
        """
        User-selected configuration variable value.
        """
        return pulumi.get(self, "overriden_config_value")


@pulumi.output_type
class GetConfigurationsConfigurationCollectionItemDbConfigurationOverrideResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetConfigurationsConfigurationCollectionItemDbConfigurationOverrideItemResult']):
        """
        :param Sequence['GetConfigurationsConfigurationCollectionItemDbConfigurationOverrideItemArgs'] items: List of ConfigParms object.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetConfigurationsConfigurationCollectionItemDbConfigurationOverrideItemResult']:
        """
        List of ConfigParms object.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetConfigurationsConfigurationCollectionItemDbConfigurationOverrideItemResult(dict):
    def __init__(__self__, *,
                 config_key: builtins.str,
                 overriden_config_value: builtins.str):
        """
        :param builtins.str config_key: The configuration variable name.
        :param builtins.str overriden_config_value: User-selected configuration variable value.
        """
        pulumi.set(__self__, "config_key", config_key)
        pulumi.set(__self__, "overriden_config_value", overriden_config_value)

    @property
    @pulumi.getter(name="configKey")
    def config_key(self) -> builtins.str:
        """
        The configuration variable name.
        """
        return pulumi.get(self, "config_key")

    @property
    @pulumi.getter(name="overridenConfigValue")
    def overriden_config_value(self) -> builtins.str:
        """
        User-selected configuration variable value.
        """
        return pulumi.get(self, "overriden_config_value")


@pulumi.output_type
class GetConfigurationsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDbSystemConnectionDetailInstanceEndpointResult(dict):
    def __init__(__self__, *,
                 db_instance_id: builtins.str,
                 endpoints: Sequence['outputs.GetDbSystemConnectionDetailInstanceEndpointEndpointResult']):
        """
        :param builtins.str db_instance_id: Unique identifier of the database instance node.
        :param Sequence['GetDbSystemConnectionDetailInstanceEndpointEndpointArgs'] endpoints: Information about the database instance node endpoint.
        """
        pulumi.set(__self__, "db_instance_id", db_instance_id)
        pulumi.set(__self__, "endpoints", endpoints)

    @property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> builtins.str:
        """
        Unique identifier of the database instance node.
        """
        return pulumi.get(self, "db_instance_id")

    @property
    @pulumi.getter
    def endpoints(self) -> Sequence['outputs.GetDbSystemConnectionDetailInstanceEndpointEndpointResult']:
        """
        Information about the database instance node endpoint.
        """
        return pulumi.get(self, "endpoints")


@pulumi.output_type
class GetDbSystemConnectionDetailInstanceEndpointEndpointResult(dict):
    def __init__(__self__, *,
                 fqdn: builtins.str,
                 ip_address: builtins.str,
                 port: builtins.int):
        """
        :param builtins.str fqdn: The FQDN of the endpoint.
        :param builtins.str ip_address: The IP address of the endpoint.
        :param builtins.int port: The port address of the endpoint.
        """
        pulumi.set(__self__, "fqdn", fqdn)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def fqdn(self) -> builtins.str:
        """
        The FQDN of the endpoint.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> builtins.str:
        """
        The IP address of the endpoint.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        The port address of the endpoint.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetDbSystemConnectionDetailPrimaryDbEndpointResult(dict):
    def __init__(__self__, *,
                 fqdn: builtins.str,
                 ip_address: builtins.str,
                 port: builtins.int):
        """
        :param builtins.str fqdn: The FQDN of the endpoint.
        :param builtins.str ip_address: The IP address of the endpoint.
        :param builtins.int port: The port address of the endpoint.
        """
        pulumi.set(__self__, "fqdn", fqdn)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def fqdn(self) -> builtins.str:
        """
        The FQDN of the endpoint.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> builtins.str:
        """
        The IP address of the endpoint.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        The port address of the endpoint.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetDbSystemConnectionDetailReaderEndpointResult(dict):
    def __init__(__self__, *,
                 fqdn: builtins.str,
                 ip_address: builtins.str,
                 port: builtins.int):
        """
        :param builtins.str fqdn: The FQDN of the endpoint.
        :param builtins.str ip_address: The IP address of the endpoint.
        :param builtins.int port: The port address of the endpoint.
        """
        pulumi.set(__self__, "fqdn", fqdn)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def fqdn(self) -> builtins.str:
        """
        The FQDN of the endpoint.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> builtins.str:
        """
        The IP address of the endpoint.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        The port address of the endpoint.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetDbSystemCredentialResult(dict):
    def __init__(__self__, *,
                 password_details: Sequence['outputs.GetDbSystemCredentialPasswordDetailResult'],
                 username: builtins.str):
        pulumi.set(__self__, "password_details", password_details)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="passwordDetails")
    def password_details(self) -> Sequence['outputs.GetDbSystemCredentialPasswordDetailResult']:
        return pulumi.get(self, "password_details")

    @property
    @pulumi.getter
    def username(self) -> builtins.str:
        return pulumi.get(self, "username")


@pulumi.output_type
class GetDbSystemCredentialPasswordDetailResult(dict):
    def __init__(__self__, *,
                 password: builtins.str,
                 password_type: builtins.str,
                 secret_id: builtins.str,
                 secret_version: builtins.str):
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "password_type", password_type)
        pulumi.set(__self__, "secret_id", secret_id)
        pulumi.set(__self__, "secret_version", secret_version)

    @property
    @pulumi.getter
    def password(self) -> builtins.str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="passwordType")
    def password_type(self) -> builtins.str:
        return pulumi.get(self, "password_type")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> builtins.str:
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> builtins.str:
        return pulumi.get(self, "secret_version")


@pulumi.output_type
class GetDbSystemInstanceResult(dict):
    def __init__(__self__, *,
                 availability_domain: builtins.str,
                 description: builtins.str,
                 display_name: builtins.str,
                 id: builtins.str,
                 lifecycle_details: builtins.str,
                 state: builtins.str,
                 time_created: builtins.str,
                 time_updated: builtins.str):
        """
        :param builtins.str availability_domain: Specifies the availability domain of AD-local storage. If `isRegionallyDurable` is set to true, `availabilityDomain` should not be specified. If `isRegionallyDurable` is set to false, `availabilityDomain` must be specified.
        :param builtins.str description: Description of the database instance node.
        :param builtins.str display_name: A user-friendly display name for the database instance node. Avoid entering confidential information.
        :param builtins.str id: A unique identifier for the database instance node. Immutable on creation.
        :param builtins.str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param builtins.str state: The current state of the database system.
        :param builtins.str time_created: The date and time that the database system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        :param builtins.str time_updated: The date and time that the database system was updated, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> builtins.str:
        """
        Specifies the availability domain of AD-local storage. If `isRegionallyDurable` is set to true, `availabilityDomain` should not be specified. If `isRegionallyDurable` is set to false, `availabilityDomain` must be specified.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the database instance node.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly display name for the database instance node. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        A unique identifier for the database instance node. Immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the database system.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time that the database system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time that the database system was updated, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetDbSystemInstancesDetailResult(dict):
    def __init__(__self__, *,
                 description: builtins.str,
                 display_name: builtins.str,
                 private_ip: builtins.str):
        """
        :param builtins.str description: Description of the database instance node.
        :param builtins.str display_name: A user-friendly display name for the database instance node. Avoid entering confidential information.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "private_ip", private_ip)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the database instance node.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly display name for the database instance node. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> builtins.str:
        return pulumi.get(self, "private_ip")


@pulumi.output_type
class GetDbSystemManagementPolicyResult(dict):
    def __init__(__self__, *,
                 backup_policies: Sequence['outputs.GetDbSystemManagementPolicyBackupPolicyResult'],
                 maintenance_window_start: builtins.str):
        """
        :param Sequence['GetDbSystemManagementPolicyBackupPolicyArgs'] backup_policies: PostgreSQL database system backup policy.
        :param builtins.str maintenance_window_start: The start of the maintenance window.
        """
        pulumi.set(__self__, "backup_policies", backup_policies)
        pulumi.set(__self__, "maintenance_window_start", maintenance_window_start)

    @property
    @pulumi.getter(name="backupPolicies")
    def backup_policies(self) -> Sequence['outputs.GetDbSystemManagementPolicyBackupPolicyResult']:
        """
        PostgreSQL database system backup policy.
        """
        return pulumi.get(self, "backup_policies")

    @property
    @pulumi.getter(name="maintenanceWindowStart")
    def maintenance_window_start(self) -> builtins.str:
        """
        The start of the maintenance window.
        """
        return pulumi.get(self, "maintenance_window_start")


@pulumi.output_type
class GetDbSystemManagementPolicyBackupPolicyResult(dict):
    def __init__(__self__, *,
                 backup_start: builtins.str,
                 copy_policies: Sequence['outputs.GetDbSystemManagementPolicyBackupPolicyCopyPolicyResult'],
                 days_of_the_months: Sequence[builtins.int],
                 days_of_the_weeks: Sequence[builtins.str],
                 kind: builtins.str,
                 retention_days: builtins.int):
        """
        :param builtins.str backup_start: Hour of the day when the backup starts.
        :param Sequence['GetDbSystemManagementPolicyBackupPolicyCopyPolicyArgs'] copy_policies: Backup copy details
        :param Sequence[builtins.int] days_of_the_months: Day of the month when the backup should start. To ensure that the backup runs monthly, the latest day of the month that you can use to schedule a backup is the the 28th day.
        :param Sequence[builtins.str] days_of_the_weeks: The day of the week that the backup starts.
        :param builtins.str kind: The kind of backup policy.
        :param builtins.int retention_days: How many days the data should be stored after the database system deletion.
        """
        pulumi.set(__self__, "backup_start", backup_start)
        pulumi.set(__self__, "copy_policies", copy_policies)
        pulumi.set(__self__, "days_of_the_months", days_of_the_months)
        pulumi.set(__self__, "days_of_the_weeks", days_of_the_weeks)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "retention_days", retention_days)

    @property
    @pulumi.getter(name="backupStart")
    def backup_start(self) -> builtins.str:
        """
        Hour of the day when the backup starts.
        """
        return pulumi.get(self, "backup_start")

    @property
    @pulumi.getter(name="copyPolicies")
    def copy_policies(self) -> Sequence['outputs.GetDbSystemManagementPolicyBackupPolicyCopyPolicyResult']:
        """
        Backup copy details
        """
        return pulumi.get(self, "copy_policies")

    @property
    @pulumi.getter(name="daysOfTheMonths")
    def days_of_the_months(self) -> Sequence[builtins.int]:
        """
        Day of the month when the backup should start. To ensure that the backup runs monthly, the latest day of the month that you can use to schedule a backup is the the 28th day.
        """
        return pulumi.get(self, "days_of_the_months")

    @property
    @pulumi.getter(name="daysOfTheWeeks")
    def days_of_the_weeks(self) -> Sequence[builtins.str]:
        """
        The day of the week that the backup starts.
        """
        return pulumi.get(self, "days_of_the_weeks")

    @property
    @pulumi.getter
    def kind(self) -> builtins.str:
        """
        The kind of backup policy.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> builtins.int:
        """
        How many days the data should be stored after the database system deletion.
        """
        return pulumi.get(self, "retention_days")


@pulumi.output_type
class GetDbSystemManagementPolicyBackupPolicyCopyPolicyResult(dict):
    def __init__(__self__, *,
                 compartment_id: builtins.str,
                 regions: Sequence[builtins.str],
                 retention_period: builtins.int):
        """
        :param builtins.str compartment_id: target compartment to place a new backup
        :param Sequence[builtins.str] regions: List of region names of the remote region
        :param builtins.int retention_period: Retention period in days of the backup copy.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "regions", regions)
        pulumi.set(__self__, "retention_period", retention_period)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        target compartment to place a new backup
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def regions(self) -> Sequence[builtins.str]:
        """
        List of region names of the remote region
        """
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> builtins.int:
        """
        Retention period in days of the backup copy.
        """
        return pulumi.get(self, "retention_period")


@pulumi.output_type
class GetDbSystemNetworkDetailResult(dict):
    def __init__(__self__, *,
                 is_reader_endpoint_enabled: builtins.bool,
                 nsg_ids: Sequence[builtins.str],
                 primary_db_endpoint_private_ip: builtins.str,
                 subnet_id: builtins.str):
        """
        :param builtins.bool is_reader_endpoint_enabled: Specifies if the reader endpoint is enabled on the dbSystem.
        :param Sequence[builtins.str] nsg_ids: List of customer Network Security Group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with the database system.
        :param builtins.str primary_db_endpoint_private_ip: Private IP in customer subnet. The value is optional. If the IP is not provided, the IP will be chosen from the available IP addresses from the specified subnet.
        :param builtins.str subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the customer subnet associated with the database system.
        """
        pulumi.set(__self__, "is_reader_endpoint_enabled", is_reader_endpoint_enabled)
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        pulumi.set(__self__, "primary_db_endpoint_private_ip", primary_db_endpoint_private_ip)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="isReaderEndpointEnabled")
    def is_reader_endpoint_enabled(self) -> builtins.bool:
        """
        Specifies if the reader endpoint is enabled on the dbSystem.
        """
        return pulumi.get(self, "is_reader_endpoint_enabled")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[builtins.str]:
        """
        List of customer Network Security Group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with the database system.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="primaryDbEndpointPrivateIp")
    def primary_db_endpoint_private_ip(self) -> builtins.str:
        """
        Private IP in customer subnet. The value is optional. If the IP is not provided, the IP will be chosen from the available IP addresses from the specified subnet.
        """
        return pulumi.get(self, "primary_db_endpoint_private_ip")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the customer subnet associated with the database system.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetDbSystemPatchOperationResult(dict):
    def __init__(__self__, *,
                 from_: builtins.str,
                 operation: builtins.str,
                 position: builtins.str,
                 selected_item: builtins.str,
                 selection: builtins.str,
                 value: Mapping[str, builtins.str]):
        pulumi.set(__self__, "from_", from_)
        pulumi.set(__self__, "operation", operation)
        pulumi.set(__self__, "position", position)
        pulumi.set(__self__, "selected_item", selected_item)
        pulumi.set(__self__, "selection", selection)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="from")
    def from_(self) -> builtins.str:
        return pulumi.get(self, "from_")

    @property
    @pulumi.getter
    def operation(self) -> builtins.str:
        return pulumi.get(self, "operation")

    @property
    @pulumi.getter
    def position(self) -> builtins.str:
        return pulumi.get(self, "position")

    @property
    @pulumi.getter(name="selectedItem")
    def selected_item(self) -> builtins.str:
        return pulumi.get(self, "selected_item")

    @property
    @pulumi.getter
    def selection(self) -> builtins.str:
        return pulumi.get(self, "selection")

    @property
    @pulumi.getter
    def value(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetDbSystemSourceResult(dict):
    def __init__(__self__, *,
                 backup_id: builtins.str,
                 is_having_restore_config_overrides: builtins.bool,
                 source_type: builtins.str):
        """
        :param builtins.str backup_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database system backup.
        :param builtins.bool is_having_restore_config_overrides: Deprecated. Don't use.
        :param builtins.str source_type: The source descriminator.
        """
        pulumi.set(__self__, "backup_id", backup_id)
        pulumi.set(__self__, "is_having_restore_config_overrides", is_having_restore_config_overrides)
        pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database system backup.
        """
        return pulumi.get(self, "backup_id")

    @property
    @pulumi.getter(name="isHavingRestoreConfigOverrides")
    def is_having_restore_config_overrides(self) -> builtins.bool:
        """
        Deprecated. Don't use.
        """
        return pulumi.get(self, "is_having_restore_config_overrides")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> builtins.str:
        """
        The source descriminator.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class GetDbSystemStorageDetailResult(dict):
    def __init__(__self__, *,
                 availability_domain: builtins.str,
                 iops: builtins.str,
                 is_regionally_durable: builtins.bool,
                 system_type: builtins.str):
        """
        :param builtins.str availability_domain: Specifies the availability domain of AD-local storage. If `isRegionallyDurable` is set to true, `availabilityDomain` should not be specified. If `isRegionallyDurable` is set to false, `availabilityDomain` must be specified.
        :param builtins.str iops: Guaranteed input/output storage requests per second (IOPS) available to the database system.
        :param builtins.bool is_regionally_durable: Specifies if the block volume used for the database system is regional or AD-local. If not specified, it will be set to false. If `isRegionallyDurable` is set to true, `availabilityDomain` should not be specified. If `isRegionallyDurable` is set to false, `availabilityDomain` must be specified.
        :param builtins.str system_type: Type of the database system.
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "iops", iops)
        pulumi.set(__self__, "is_regionally_durable", is_regionally_durable)
        pulumi.set(__self__, "system_type", system_type)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> builtins.str:
        """
        Specifies the availability domain of AD-local storage. If `isRegionallyDurable` is set to true, `availabilityDomain` should not be specified. If `isRegionallyDurable` is set to false, `availabilityDomain` must be specified.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter
    def iops(self) -> builtins.str:
        """
        Guaranteed input/output storage requests per second (IOPS) available to the database system.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="isRegionallyDurable")
    def is_regionally_durable(self) -> builtins.bool:
        """
        Specifies if the block volume used for the database system is regional or AD-local. If not specified, it will be set to false. If `isRegionallyDurable` is set to true, `availabilityDomain` should not be specified. If `isRegionallyDurable` is set to false, `availabilityDomain` must be specified.
        """
        return pulumi.get(self, "is_regionally_durable")

    @property
    @pulumi.getter(name="systemType")
    def system_type(self) -> builtins.str:
        """
        Type of the database system.
        """
        return pulumi.get(self, "system_type")


@pulumi.output_type
class GetDbSystemsDbSystemCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDbSystemsDbSystemCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDbSystemsDbSystemCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDbSystemsDbSystemCollectionItemResult(dict):
    def __init__(__self__, *,
                 admin_username: builtins.str,
                 apply_config: builtins.str,
                 compartment_id: builtins.str,
                 config_id: builtins.str,
                 credentials: Sequence['outputs.GetDbSystemsDbSystemCollectionItemCredentialResult'],
                 db_version: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 description: builtins.str,
                 display_name: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 instance_count: builtins.int,
                 instance_memory_size_in_gbs: builtins.int,
                 instance_ocpu_count: builtins.int,
                 instances: Sequence['outputs.GetDbSystemsDbSystemCollectionItemInstanceResult'],
                 instances_details: Sequence['outputs.GetDbSystemsDbSystemCollectionItemInstancesDetailResult'],
                 lifecycle_details: builtins.str,
                 management_policies: Sequence['outputs.GetDbSystemsDbSystemCollectionItemManagementPolicyResult'],
                 network_details: Sequence['outputs.GetDbSystemsDbSystemCollectionItemNetworkDetailResult'],
                 patch_operations: Sequence['outputs.GetDbSystemsDbSystemCollectionItemPatchOperationResult'],
                 shape: builtins.str,
                 sources: Sequence['outputs.GetDbSystemsDbSystemCollectionItemSourceResult'],
                 state: builtins.str,
                 storage_details: Sequence['outputs.GetDbSystemsDbSystemCollectionItemStorageDetailResult'],
                 system_tags: Mapping[str, builtins.str],
                 system_type: builtins.str,
                 time_created: builtins.str,
                 time_updated: builtins.str):
        """
        :param builtins.str admin_username: The database system administrator username.
        :param builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param builtins.str config_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the configuration associated with the database system.
        :param builtins.str db_version: The major and minor versions of the database system software.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param builtins.str description: Description of the database instance node.
        :param builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param builtins.str id: A unique identifier for the database system.
        :param builtins.int instance_count: Count of instances, or nodes, in the database system.
        :param builtins.int instance_memory_size_in_gbs: The total amount of memory available to each database instance node, in gigabytes.
        :param builtins.int instance_ocpu_count: The total number of OCPUs available to each database instance node.
        :param Sequence['GetDbSystemsDbSystemCollectionItemInstanceArgs'] instances: The list of instances, or nodes, in the database system.
        :param builtins.str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param Sequence['GetDbSystemsDbSystemCollectionItemManagementPolicyArgs'] management_policies: PostgreSQL database system management policy.
        :param Sequence['GetDbSystemsDbSystemCollectionItemNetworkDetailArgs'] network_details: Network details for the database system.
        :param builtins.str shape: The name of the shape for the database instance. Example: `VM.Standard.E4.Flex`
        :param Sequence['GetDbSystemsDbSystemCollectionItemSourceArgs'] sources: The source used to restore the database system.
        :param builtins.str state: A filter to return only resources if their `lifecycleState` matches the given `lifecycleState`.
        :param Sequence['GetDbSystemsDbSystemCollectionItemStorageDetailArgs'] storage_details: Storage details of the database system.
        :param Mapping[str, builtins.str] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param builtins.str system_type: Type of the database system.
        :param builtins.str time_created: The date and time that the database system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        :param builtins.str time_updated: The date and time that the database system was updated, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "admin_username", admin_username)
        pulumi.set(__self__, "apply_config", apply_config)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "config_id", config_id)
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "db_version", db_version)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_count", instance_count)
        pulumi.set(__self__, "instance_memory_size_in_gbs", instance_memory_size_in_gbs)
        pulumi.set(__self__, "instance_ocpu_count", instance_ocpu_count)
        pulumi.set(__self__, "instances", instances)
        pulumi.set(__self__, "instances_details", instances_details)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "management_policies", management_policies)
        pulumi.set(__self__, "network_details", network_details)
        pulumi.set(__self__, "patch_operations", patch_operations)
        pulumi.set(__self__, "shape", shape)
        pulumi.set(__self__, "sources", sources)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "storage_details", storage_details)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "system_type", system_type)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> builtins.str:
        """
        The database system administrator username.
        """
        return pulumi.get(self, "admin_username")

    @property
    @pulumi.getter(name="applyConfig")
    def apply_config(self) -> builtins.str:
        return pulumi.get(self, "apply_config")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="configId")
    def config_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the configuration associated with the database system.
        """
        return pulumi.get(self, "config_id")

    @property
    @pulumi.getter
    def credentials(self) -> Sequence['outputs.GetDbSystemsDbSystemCollectionItemCredentialResult']:
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> builtins.str:
        """
        The major and minor versions of the database system software.
        """
        return pulumi.get(self, "db_version")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the database instance node.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        A unique identifier for the database system.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> builtins.int:
        """
        Count of instances, or nodes, in the database system.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceMemorySizeInGbs")
    def instance_memory_size_in_gbs(self) -> builtins.int:
        """
        The total amount of memory available to each database instance node, in gigabytes.
        """
        return pulumi.get(self, "instance_memory_size_in_gbs")

    @property
    @pulumi.getter(name="instanceOcpuCount")
    def instance_ocpu_count(self) -> builtins.int:
        """
        The total number of OCPUs available to each database instance node.
        """
        return pulumi.get(self, "instance_ocpu_count")

    @property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.GetDbSystemsDbSystemCollectionItemInstanceResult']:
        """
        The list of instances, or nodes, in the database system.
        """
        return pulumi.get(self, "instances")

    @property
    @pulumi.getter(name="instancesDetails")
    def instances_details(self) -> Sequence['outputs.GetDbSystemsDbSystemCollectionItemInstancesDetailResult']:
        return pulumi.get(self, "instances_details")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="managementPolicies")
    def management_policies(self) -> Sequence['outputs.GetDbSystemsDbSystemCollectionItemManagementPolicyResult']:
        """
        PostgreSQL database system management policy.
        """
        return pulumi.get(self, "management_policies")

    @property
    @pulumi.getter(name="networkDetails")
    def network_details(self) -> Sequence['outputs.GetDbSystemsDbSystemCollectionItemNetworkDetailResult']:
        """
        Network details for the database system.
        """
        return pulumi.get(self, "network_details")

    @property
    @pulumi.getter(name="patchOperations")
    def patch_operations(self) -> Sequence['outputs.GetDbSystemsDbSystemCollectionItemPatchOperationResult']:
        return pulumi.get(self, "patch_operations")

    @property
    @pulumi.getter
    def shape(self) -> builtins.str:
        """
        The name of the shape for the database instance. Example: `VM.Standard.E4.Flex`
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.GetDbSystemsDbSystemCollectionItemSourceResult']:
        """
        The source used to restore the database system.
        """
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        A filter to return only resources if their `lifecycleState` matches the given `lifecycleState`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="storageDetails")
    def storage_details(self) -> Sequence['outputs.GetDbSystemsDbSystemCollectionItemStorageDetailResult']:
        """
        Storage details of the database system.
        """
        return pulumi.get(self, "storage_details")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="systemType")
    def system_type(self) -> builtins.str:
        """
        Type of the database system.
        """
        return pulumi.get(self, "system_type")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time that the database system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time that the database system was updated, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetDbSystemsDbSystemCollectionItemCredentialResult(dict):
    def __init__(__self__, *,
                 password_details: Sequence['outputs.GetDbSystemsDbSystemCollectionItemCredentialPasswordDetailResult'],
                 username: builtins.str):
        pulumi.set(__self__, "password_details", password_details)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="passwordDetails")
    def password_details(self) -> Sequence['outputs.GetDbSystemsDbSystemCollectionItemCredentialPasswordDetailResult']:
        return pulumi.get(self, "password_details")

    @property
    @pulumi.getter
    def username(self) -> builtins.str:
        return pulumi.get(self, "username")


@pulumi.output_type
class GetDbSystemsDbSystemCollectionItemCredentialPasswordDetailResult(dict):
    def __init__(__self__, *,
                 password: builtins.str,
                 password_type: builtins.str,
                 secret_id: builtins.str,
                 secret_version: builtins.str):
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "password_type", password_type)
        pulumi.set(__self__, "secret_id", secret_id)
        pulumi.set(__self__, "secret_version", secret_version)

    @property
    @pulumi.getter
    def password(self) -> builtins.str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="passwordType")
    def password_type(self) -> builtins.str:
        return pulumi.get(self, "password_type")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> builtins.str:
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> builtins.str:
        return pulumi.get(self, "secret_version")


@pulumi.output_type
class GetDbSystemsDbSystemCollectionItemInstanceResult(dict):
    def __init__(__self__, *,
                 availability_domain: builtins.str,
                 description: builtins.str,
                 display_name: builtins.str,
                 id: builtins.str,
                 lifecycle_details: builtins.str,
                 state: builtins.str,
                 time_created: builtins.str,
                 time_updated: builtins.str):
        """
        :param builtins.str availability_domain: Specifies the availability domain of AD-local storage. If `isRegionallyDurable` is set to true, `availabilityDomain` should not be specified. If `isRegionallyDurable` is set to false, `availabilityDomain` must be specified.
        :param builtins.str description: Description of the database instance node.
        :param builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param builtins.str id: A unique identifier for the database system.
        :param builtins.str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param builtins.str state: A filter to return only resources if their `lifecycleState` matches the given `lifecycleState`.
        :param builtins.str time_created: The date and time that the database system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        :param builtins.str time_updated: The date and time that the database system was updated, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> builtins.str:
        """
        Specifies the availability domain of AD-local storage. If `isRegionallyDurable` is set to true, `availabilityDomain` should not be specified. If `isRegionallyDurable` is set to false, `availabilityDomain` must be specified.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the database instance node.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        A unique identifier for the database system.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        A filter to return only resources if their `lifecycleState` matches the given `lifecycleState`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time that the database system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time that the database system was updated, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetDbSystemsDbSystemCollectionItemInstancesDetailResult(dict):
    def __init__(__self__, *,
                 description: builtins.str,
                 display_name: builtins.str,
                 private_ip: builtins.str):
        """
        :param builtins.str description: Description of the database instance node.
        :param builtins.str display_name: A filter to return only resources that match the entire display name given.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "private_ip", private_ip)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the database instance node.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> builtins.str:
        return pulumi.get(self, "private_ip")


@pulumi.output_type
class GetDbSystemsDbSystemCollectionItemManagementPolicyResult(dict):
    def __init__(__self__, *,
                 backup_policies: Sequence['outputs.GetDbSystemsDbSystemCollectionItemManagementPolicyBackupPolicyResult'],
                 maintenance_window_start: builtins.str):
        """
        :param Sequence['GetDbSystemsDbSystemCollectionItemManagementPolicyBackupPolicyArgs'] backup_policies: PostgreSQL database system backup policy.
        :param builtins.str maintenance_window_start: The start of the maintenance window.
        """
        pulumi.set(__self__, "backup_policies", backup_policies)
        pulumi.set(__self__, "maintenance_window_start", maintenance_window_start)

    @property
    @pulumi.getter(name="backupPolicies")
    def backup_policies(self) -> Sequence['outputs.GetDbSystemsDbSystemCollectionItemManagementPolicyBackupPolicyResult']:
        """
        PostgreSQL database system backup policy.
        """
        return pulumi.get(self, "backup_policies")

    @property
    @pulumi.getter(name="maintenanceWindowStart")
    def maintenance_window_start(self) -> builtins.str:
        """
        The start of the maintenance window.
        """
        return pulumi.get(self, "maintenance_window_start")


@pulumi.output_type
class GetDbSystemsDbSystemCollectionItemManagementPolicyBackupPolicyResult(dict):
    def __init__(__self__, *,
                 backup_start: builtins.str,
                 copy_policies: Sequence['outputs.GetDbSystemsDbSystemCollectionItemManagementPolicyBackupPolicyCopyPolicyResult'],
                 days_of_the_months: Sequence[builtins.int],
                 days_of_the_weeks: Sequence[builtins.str],
                 kind: builtins.str,
                 retention_days: builtins.int):
        """
        :param builtins.str backup_start: Hour of the day when the backup starts.
        :param Sequence['GetDbSystemsDbSystemCollectionItemManagementPolicyBackupPolicyCopyPolicyArgs'] copy_policies: Backup copy details
        :param Sequence[builtins.int] days_of_the_months: Day of the month when the backup should start. To ensure that the backup runs monthly, the latest day of the month that you can use to schedule a backup is the the 28th day.
        :param Sequence[builtins.str] days_of_the_weeks: The day of the week that the backup starts.
        :param builtins.str kind: The kind of backup policy.
        :param builtins.int retention_days: How many days the data should be stored after the database system deletion.
        """
        pulumi.set(__self__, "backup_start", backup_start)
        pulumi.set(__self__, "copy_policies", copy_policies)
        pulumi.set(__self__, "days_of_the_months", days_of_the_months)
        pulumi.set(__self__, "days_of_the_weeks", days_of_the_weeks)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "retention_days", retention_days)

    @property
    @pulumi.getter(name="backupStart")
    def backup_start(self) -> builtins.str:
        """
        Hour of the day when the backup starts.
        """
        return pulumi.get(self, "backup_start")

    @property
    @pulumi.getter(name="copyPolicies")
    def copy_policies(self) -> Sequence['outputs.GetDbSystemsDbSystemCollectionItemManagementPolicyBackupPolicyCopyPolicyResult']:
        """
        Backup copy details
        """
        return pulumi.get(self, "copy_policies")

    @property
    @pulumi.getter(name="daysOfTheMonths")
    def days_of_the_months(self) -> Sequence[builtins.int]:
        """
        Day of the month when the backup should start. To ensure that the backup runs monthly, the latest day of the month that you can use to schedule a backup is the the 28th day.
        """
        return pulumi.get(self, "days_of_the_months")

    @property
    @pulumi.getter(name="daysOfTheWeeks")
    def days_of_the_weeks(self) -> Sequence[builtins.str]:
        """
        The day of the week that the backup starts.
        """
        return pulumi.get(self, "days_of_the_weeks")

    @property
    @pulumi.getter
    def kind(self) -> builtins.str:
        """
        The kind of backup policy.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> builtins.int:
        """
        How many days the data should be stored after the database system deletion.
        """
        return pulumi.get(self, "retention_days")


@pulumi.output_type
class GetDbSystemsDbSystemCollectionItemManagementPolicyBackupPolicyCopyPolicyResult(dict):
    def __init__(__self__, *,
                 compartment_id: builtins.str,
                 regions: Sequence[builtins.str],
                 retention_period: builtins.int):
        """
        :param builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param Sequence[builtins.str] regions: List of region names of the remote region
        :param builtins.int retention_period: Retention period in days of the backup copy.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "regions", regions)
        pulumi.set(__self__, "retention_period", retention_period)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def regions(self) -> Sequence[builtins.str]:
        """
        List of region names of the remote region
        """
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> builtins.int:
        """
        Retention period in days of the backup copy.
        """
        return pulumi.get(self, "retention_period")


@pulumi.output_type
class GetDbSystemsDbSystemCollectionItemNetworkDetailResult(dict):
    def __init__(__self__, *,
                 is_reader_endpoint_enabled: builtins.bool,
                 nsg_ids: Sequence[builtins.str],
                 primary_db_endpoint_private_ip: builtins.str,
                 subnet_id: builtins.str):
        """
        :param builtins.bool is_reader_endpoint_enabled: Specifies if the reader endpoint is enabled on the dbSystem.
        :param Sequence[builtins.str] nsg_ids: List of customer Network Security Group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with the database system.
        :param builtins.str primary_db_endpoint_private_ip: Private IP in customer subnet. The value is optional. If the IP is not provided, the IP will be chosen from the available IP addresses from the specified subnet.
        :param builtins.str subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the customer subnet associated with the database system.
        """
        pulumi.set(__self__, "is_reader_endpoint_enabled", is_reader_endpoint_enabled)
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        pulumi.set(__self__, "primary_db_endpoint_private_ip", primary_db_endpoint_private_ip)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="isReaderEndpointEnabled")
    def is_reader_endpoint_enabled(self) -> builtins.bool:
        """
        Specifies if the reader endpoint is enabled on the dbSystem.
        """
        return pulumi.get(self, "is_reader_endpoint_enabled")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[builtins.str]:
        """
        List of customer Network Security Group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with the database system.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="primaryDbEndpointPrivateIp")
    def primary_db_endpoint_private_ip(self) -> builtins.str:
        """
        Private IP in customer subnet. The value is optional. If the IP is not provided, the IP will be chosen from the available IP addresses from the specified subnet.
        """
        return pulumi.get(self, "primary_db_endpoint_private_ip")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the customer subnet associated with the database system.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetDbSystemsDbSystemCollectionItemPatchOperationResult(dict):
    def __init__(__self__, *,
                 from_: builtins.str,
                 operation: builtins.str,
                 position: builtins.str,
                 selected_item: builtins.str,
                 selection: builtins.str,
                 value: Mapping[str, builtins.str]):
        pulumi.set(__self__, "from_", from_)
        pulumi.set(__self__, "operation", operation)
        pulumi.set(__self__, "position", position)
        pulumi.set(__self__, "selected_item", selected_item)
        pulumi.set(__self__, "selection", selection)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="from")
    def from_(self) -> builtins.str:
        return pulumi.get(self, "from_")

    @property
    @pulumi.getter
    def operation(self) -> builtins.str:
        return pulumi.get(self, "operation")

    @property
    @pulumi.getter
    def position(self) -> builtins.str:
        return pulumi.get(self, "position")

    @property
    @pulumi.getter(name="selectedItem")
    def selected_item(self) -> builtins.str:
        return pulumi.get(self, "selected_item")

    @property
    @pulumi.getter
    def selection(self) -> builtins.str:
        return pulumi.get(self, "selection")

    @property
    @pulumi.getter
    def value(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetDbSystemsDbSystemCollectionItemSourceResult(dict):
    def __init__(__self__, *,
                 backup_id: builtins.str,
                 is_having_restore_config_overrides: builtins.bool,
                 source_type: builtins.str):
        """
        :param builtins.str backup_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database system backup.
        :param builtins.bool is_having_restore_config_overrides: Deprecated. Don't use.
        :param builtins.str source_type: The source descriminator.
        """
        pulumi.set(__self__, "backup_id", backup_id)
        pulumi.set(__self__, "is_having_restore_config_overrides", is_having_restore_config_overrides)
        pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database system backup.
        """
        return pulumi.get(self, "backup_id")

    @property
    @pulumi.getter(name="isHavingRestoreConfigOverrides")
    def is_having_restore_config_overrides(self) -> builtins.bool:
        """
        Deprecated. Don't use.
        """
        return pulumi.get(self, "is_having_restore_config_overrides")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> builtins.str:
        """
        The source descriminator.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class GetDbSystemsDbSystemCollectionItemStorageDetailResult(dict):
    def __init__(__self__, *,
                 availability_domain: builtins.str,
                 iops: builtins.str,
                 is_regionally_durable: builtins.bool,
                 system_type: builtins.str):
        """
        :param builtins.str availability_domain: Specifies the availability domain of AD-local storage. If `isRegionallyDurable` is set to true, `availabilityDomain` should not be specified. If `isRegionallyDurable` is set to false, `availabilityDomain` must be specified.
        :param builtins.str iops: Guaranteed input/output storage requests per second (IOPS) available to the database system.
        :param builtins.bool is_regionally_durable: Specifies if the block volume used for the database system is regional or AD-local. If not specified, it will be set to false. If `isRegionallyDurable` is set to true, `availabilityDomain` should not be specified. If `isRegionallyDurable` is set to false, `availabilityDomain` must be specified.
        :param builtins.str system_type: Type of the database system.
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "iops", iops)
        pulumi.set(__self__, "is_regionally_durable", is_regionally_durable)
        pulumi.set(__self__, "system_type", system_type)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> builtins.str:
        """
        Specifies the availability domain of AD-local storage. If `isRegionallyDurable` is set to true, `availabilityDomain` should not be specified. If `isRegionallyDurable` is set to false, `availabilityDomain` must be specified.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter
    def iops(self) -> builtins.str:
        """
        Guaranteed input/output storage requests per second (IOPS) available to the database system.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="isRegionallyDurable")
    def is_regionally_durable(self) -> builtins.bool:
        """
        Specifies if the block volume used for the database system is regional or AD-local. If not specified, it will be set to false. If `isRegionallyDurable` is set to true, `availabilityDomain` should not be specified. If `isRegionallyDurable` is set to false, `availabilityDomain` must be specified.
        """
        return pulumi.get(self, "is_regionally_durable")

    @property
    @pulumi.getter(name="systemType")
    def system_type(self) -> builtins.str:
        """
        Type of the database system.
        """
        return pulumi.get(self, "system_type")


@pulumi.output_type
class GetDbSystemsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDefaultConfigurationConfigurationDetailResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDefaultConfigurationConfigurationDetailItemResult']):
        """
        :param Sequence['GetDefaultConfigurationConfigurationDetailItemArgs'] items: List of ConfigParms object.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDefaultConfigurationConfigurationDetailItemResult']:
        """
        List of ConfigParms object.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDefaultConfigurationConfigurationDetailItemResult(dict):
    def __init__(__self__, *,
                 allowed_values: builtins.str,
                 config_key: builtins.str,
                 data_type: builtins.str,
                 default_config_value: builtins.str,
                 description: builtins.str,
                 is_overridable: builtins.bool,
                 is_restart_required: builtins.bool):
        """
        :param builtins.str allowed_values: Range or list of allowed values.
        :param builtins.str config_key: The configuration variable name.
        :param builtins.str data_type: Data type of the variable.
        :param builtins.str default_config_value: Default value for the variable.
        :param builtins.str description: A description for the configuration.
        :param builtins.bool is_overridable: Whether the value can be overridden or not.
        :param builtins.bool is_restart_required: If true, modifying this configuration value will require a restart.
        """
        pulumi.set(__self__, "allowed_values", allowed_values)
        pulumi.set(__self__, "config_key", config_key)
        pulumi.set(__self__, "data_type", data_type)
        pulumi.set(__self__, "default_config_value", default_config_value)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "is_overridable", is_overridable)
        pulumi.set(__self__, "is_restart_required", is_restart_required)

    @property
    @pulumi.getter(name="allowedValues")
    def allowed_values(self) -> builtins.str:
        """
        Range or list of allowed values.
        """
        return pulumi.get(self, "allowed_values")

    @property
    @pulumi.getter(name="configKey")
    def config_key(self) -> builtins.str:
        """
        The configuration variable name.
        """
        return pulumi.get(self, "config_key")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> builtins.str:
        """
        Data type of the variable.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter(name="defaultConfigValue")
    def default_config_value(self) -> builtins.str:
        """
        Default value for the variable.
        """
        return pulumi.get(self, "default_config_value")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A description for the configuration.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isOverridable")
    def is_overridable(self) -> builtins.bool:
        """
        Whether the value can be overridden or not.
        """
        return pulumi.get(self, "is_overridable")

    @property
    @pulumi.getter(name="isRestartRequired")
    def is_restart_required(self) -> builtins.bool:
        """
        If true, modifying this configuration value will require a restart.
        """
        return pulumi.get(self, "is_restart_required")


@pulumi.output_type
class GetDefaultConfigurationsDefaultConfigurationCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDefaultConfigurationsDefaultConfigurationCollectionItemResult']):
        """
        :param Sequence['GetDefaultConfigurationsDefaultConfigurationCollectionItemArgs'] items: List of ConfigParms object.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDefaultConfigurationsDefaultConfigurationCollectionItemResult']:
        """
        List of ConfigParms object.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDefaultConfigurationsDefaultConfigurationCollectionItemResult(dict):
    def __init__(__self__, *,
                 configuration_details: Sequence['outputs.GetDefaultConfigurationsDefaultConfigurationCollectionItemConfigurationDetailResult'],
                 db_version: builtins.str,
                 description: builtins.str,
                 display_name: builtins.str,
                 id: builtins.str,
                 instance_memory_size_in_gbs: builtins.int,
                 instance_ocpu_count: builtins.int,
                 is_flexible: builtins.bool,
                 lifecycle_details: builtins.str,
                 shape: builtins.str,
                 state: builtins.str,
                 time_created: builtins.str):
        """
        :param Sequence['GetDefaultConfigurationsDefaultConfigurationCollectionItemConfigurationDetailArgs'] configuration_details: List of default configuration values for databases.
        :param builtins.str db_version: Version of the PostgreSQL database, such as 14.9.
        :param builtins.str description: A description for the configuration.
        :param builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param builtins.str id: A unique identifier for the configuration.
        :param builtins.int instance_memory_size_in_gbs: Memory size in gigabytes with 1GB increment.
        :param builtins.int instance_ocpu_count: CPU core count.
        :param builtins.bool is_flexible: True if the configuration supports flexible shapes, false otherwise.
        :param builtins.str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param builtins.str shape: The name of the shape for the configuration. Example: `VM.Standard.E4.Flex`
        :param builtins.str state: A filter to return only resources if their `lifecycleState` matches the given `lifecycleState`.
        :param builtins.str time_created: The date and time that the configuration was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "configuration_details", configuration_details)
        pulumi.set(__self__, "db_version", db_version)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_memory_size_in_gbs", instance_memory_size_in_gbs)
        pulumi.set(__self__, "instance_ocpu_count", instance_ocpu_count)
        pulumi.set(__self__, "is_flexible", is_flexible)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "shape", shape)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="configurationDetails")
    def configuration_details(self) -> Sequence['outputs.GetDefaultConfigurationsDefaultConfigurationCollectionItemConfigurationDetailResult']:
        """
        List of default configuration values for databases.
        """
        return pulumi.get(self, "configuration_details")

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> builtins.str:
        """
        Version of the PostgreSQL database, such as 14.9.
        """
        return pulumi.get(self, "db_version")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A description for the configuration.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        A unique identifier for the configuration.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceMemorySizeInGbs")
    def instance_memory_size_in_gbs(self) -> builtins.int:
        """
        Memory size in gigabytes with 1GB increment.
        """
        return pulumi.get(self, "instance_memory_size_in_gbs")

    @property
    @pulumi.getter(name="instanceOcpuCount")
    def instance_ocpu_count(self) -> builtins.int:
        """
        CPU core count.
        """
        return pulumi.get(self, "instance_ocpu_count")

    @property
    @pulumi.getter(name="isFlexible")
    def is_flexible(self) -> builtins.bool:
        """
        True if the configuration supports flexible shapes, false otherwise.
        """
        return pulumi.get(self, "is_flexible")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def shape(self) -> builtins.str:
        """
        The name of the shape for the configuration. Example: `VM.Standard.E4.Flex`
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        A filter to return only resources if their `lifecycleState` matches the given `lifecycleState`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time that the configuration was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetDefaultConfigurationsDefaultConfigurationCollectionItemConfigurationDetailResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDefaultConfigurationsDefaultConfigurationCollectionItemConfigurationDetailItemResult']):
        """
        :param Sequence['GetDefaultConfigurationsDefaultConfigurationCollectionItemConfigurationDetailItemArgs'] items: List of ConfigParms object.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDefaultConfigurationsDefaultConfigurationCollectionItemConfigurationDetailItemResult']:
        """
        List of ConfigParms object.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDefaultConfigurationsDefaultConfigurationCollectionItemConfigurationDetailItemResult(dict):
    def __init__(__self__, *,
                 allowed_values: builtins.str,
                 config_key: builtins.str,
                 data_type: builtins.str,
                 default_config_value: builtins.str,
                 description: builtins.str,
                 is_overridable: builtins.bool,
                 is_restart_required: builtins.bool):
        """
        :param builtins.str allowed_values: Range or list of allowed values.
        :param builtins.str config_key: The configuration variable name.
        :param builtins.str data_type: Data type of the variable.
        :param builtins.str default_config_value: Default value for the variable.
        :param builtins.str description: A description for the configuration.
        :param builtins.bool is_overridable: Whether the value can be overridden or not.
        :param builtins.bool is_restart_required: If true, modifying this configuration value will require a restart.
        """
        pulumi.set(__self__, "allowed_values", allowed_values)
        pulumi.set(__self__, "config_key", config_key)
        pulumi.set(__self__, "data_type", data_type)
        pulumi.set(__self__, "default_config_value", default_config_value)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "is_overridable", is_overridable)
        pulumi.set(__self__, "is_restart_required", is_restart_required)

    @property
    @pulumi.getter(name="allowedValues")
    def allowed_values(self) -> builtins.str:
        """
        Range or list of allowed values.
        """
        return pulumi.get(self, "allowed_values")

    @property
    @pulumi.getter(name="configKey")
    def config_key(self) -> builtins.str:
        """
        The configuration variable name.
        """
        return pulumi.get(self, "config_key")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> builtins.str:
        """
        Data type of the variable.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter(name="defaultConfigValue")
    def default_config_value(self) -> builtins.str:
        """
        Default value for the variable.
        """
        return pulumi.get(self, "default_config_value")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A description for the configuration.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isOverridable")
    def is_overridable(self) -> builtins.bool:
        """
        Whether the value can be overridden or not.
        """
        return pulumi.get(self, "is_overridable")

    @property
    @pulumi.getter(name="isRestartRequired")
    def is_restart_required(self) -> builtins.bool:
        """
        If true, modifying this configuration value will require a restart.
        """
        return pulumi.get(self, "is_restart_required")


@pulumi.output_type
class GetDefaultConfigurationsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetShapesFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetShapesShapeCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetShapesShapeCollectionItemResult']):
        """
        :param Sequence['GetShapesShapeCollectionItemArgs'] items: List of supported shapes.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetShapesShapeCollectionItemResult']:
        """
        List of supported shapes.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetShapesShapeCollectionItemResult(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 is_flexible: builtins.bool,
                 memory_size_in_gbs: builtins.int,
                 ocpu_count: builtins.int,
                 shape: builtins.str,
                 shape_memory_options: Sequence['outputs.GetShapesShapeCollectionItemShapeMemoryOptionResult'],
                 shape_ocpu_options: Sequence['outputs.GetShapesShapeCollectionItemShapeOcpuOptionResult']):
        """
        :param builtins.str id: A filter to return the feature by the shape name.
        :param builtins.bool is_flexible: Indicates if the shape is a flex shape.
        :param builtins.int memory_size_in_gbs: The amount of memory in gigabytes.
        :param builtins.int ocpu_count: The number of OCPUs.
        :param builtins.str shape: The name of the Compute VM shape. Example: `VM.Standard.E4.Flex`
        :param Sequence['GetShapesShapeCollectionItemShapeMemoryOptionArgs'] shape_memory_options: Options for the the shape memory
        :param Sequence['GetShapesShapeCollectionItemShapeOcpuOptionArgs'] shape_ocpu_options: Options for the the shape OCPU
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_flexible", is_flexible)
        pulumi.set(__self__, "memory_size_in_gbs", memory_size_in_gbs)
        pulumi.set(__self__, "ocpu_count", ocpu_count)
        pulumi.set(__self__, "shape", shape)
        pulumi.set(__self__, "shape_memory_options", shape_memory_options)
        pulumi.set(__self__, "shape_ocpu_options", shape_ocpu_options)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        A filter to return the feature by the shape name.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isFlexible")
    def is_flexible(self) -> builtins.bool:
        """
        Indicates if the shape is a flex shape.
        """
        return pulumi.get(self, "is_flexible")

    @property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> builtins.int:
        """
        The amount of memory in gigabytes.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @property
    @pulumi.getter(name="ocpuCount")
    def ocpu_count(self) -> builtins.int:
        """
        The number of OCPUs.
        """
        return pulumi.get(self, "ocpu_count")

    @property
    @pulumi.getter
    def shape(self) -> builtins.str:
        """
        The name of the Compute VM shape. Example: `VM.Standard.E4.Flex`
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter(name="shapeMemoryOptions")
    def shape_memory_options(self) -> Sequence['outputs.GetShapesShapeCollectionItemShapeMemoryOptionResult']:
        """
        Options for the the shape memory
        """
        return pulumi.get(self, "shape_memory_options")

    @property
    @pulumi.getter(name="shapeOcpuOptions")
    def shape_ocpu_options(self) -> Sequence['outputs.GetShapesShapeCollectionItemShapeOcpuOptionResult']:
        """
        Options for the the shape OCPU
        """
        return pulumi.get(self, "shape_ocpu_options")


@pulumi.output_type
class GetShapesShapeCollectionItemShapeMemoryOptionResult(dict):
    def __init__(__self__, *,
                 default_per_ocpu_in_gbs: builtins.int,
                 max_in_gbs: builtins.int,
                 max_per_ocpu_in_gbs: builtins.int,
                 min_in_gbs: builtins.int,
                 min_per_ocpu_in_gbs: builtins.int):
        """
        :param builtins.int default_per_ocpu_in_gbs: Default per OCPU configuration in GBs
        :param builtins.int max_in_gbs: Maximum Memory configuration in GBs
        :param builtins.int max_per_ocpu_in_gbs: Maximum Memory configuration per OCPU in GBs
        :param builtins.int min_in_gbs: Minimum Memory configuration in GBs
        :param builtins.int min_per_ocpu_in_gbs: Minimum Memory configuration per OCPU in GBs
        """
        pulumi.set(__self__, "default_per_ocpu_in_gbs", default_per_ocpu_in_gbs)
        pulumi.set(__self__, "max_in_gbs", max_in_gbs)
        pulumi.set(__self__, "max_per_ocpu_in_gbs", max_per_ocpu_in_gbs)
        pulumi.set(__self__, "min_in_gbs", min_in_gbs)
        pulumi.set(__self__, "min_per_ocpu_in_gbs", min_per_ocpu_in_gbs)

    @property
    @pulumi.getter(name="defaultPerOcpuInGbs")
    def default_per_ocpu_in_gbs(self) -> builtins.int:
        """
        Default per OCPU configuration in GBs
        """
        return pulumi.get(self, "default_per_ocpu_in_gbs")

    @property
    @pulumi.getter(name="maxInGbs")
    def max_in_gbs(self) -> builtins.int:
        """
        Maximum Memory configuration in GBs
        """
        return pulumi.get(self, "max_in_gbs")

    @property
    @pulumi.getter(name="maxPerOcpuInGbs")
    def max_per_ocpu_in_gbs(self) -> builtins.int:
        """
        Maximum Memory configuration per OCPU in GBs
        """
        return pulumi.get(self, "max_per_ocpu_in_gbs")

    @property
    @pulumi.getter(name="minInGbs")
    def min_in_gbs(self) -> builtins.int:
        """
        Minimum Memory configuration in GBs
        """
        return pulumi.get(self, "min_in_gbs")

    @property
    @pulumi.getter(name="minPerOcpuInGbs")
    def min_per_ocpu_in_gbs(self) -> builtins.int:
        """
        Minimum Memory configuration per OCPU in GBs
        """
        return pulumi.get(self, "min_per_ocpu_in_gbs")


@pulumi.output_type
class GetShapesShapeCollectionItemShapeOcpuOptionResult(dict):
    def __init__(__self__, *,
                 max: builtins.int,
                 min: builtins.int):
        """
        :param builtins.int max: Maximum OCPU configuration
        :param builtins.int min: Minimum OCPU configuration
        """
        pulumi.set(__self__, "max", max)
        pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def max(self) -> builtins.int:
        """
        Maximum OCPU configuration
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> builtins.int:
        """
        Minimum OCPU configuration
        """
        return pulumi.get(self, "min")


