# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSecurityAttributeNamespacesResult',
    'AwaitableGetSecurityAttributeNamespacesResult',
    'get_security_attribute_namespaces',
    'get_security_attribute_namespaces_output',
]

@pulumi.output_type
class GetSecurityAttributeNamespacesResult:
    """
    A collection of values returned by getSecurityAttributeNamespaces.
    """
    def __init__(__self__, compartment_id=None, compartment_id_in_subtree=None, filters=None, id=None, name=None, security_attribute_namespaces=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if security_attribute_namespaces and not isinstance(security_attribute_namespaces, list):
            raise TypeError("Expected argument 'security_attribute_namespaces' to be a list")
        pulumi.set(__self__, "security_attribute_namespaces", security_attribute_namespaces)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        """
        The OCID of the compartment that contains the security attribute namespace.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSecurityAttributeNamespacesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the security attribute namespace. It must be unique across all security attribute namespaces in the tenancy and cannot be changed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="securityAttributeNamespaces")
    def security_attribute_namespaces(self) -> Sequence['outputs.GetSecurityAttributeNamespacesSecurityAttributeNamespaceResult']:
        """
        The list of security_attribute_namespaces.
        """
        return pulumi.get(self, "security_attribute_namespaces")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The security attribute namespace's current state. After creating a security attribute namespace, make sure its `lifecycleState` is ACTIVE before using it. After retiring a security attribute namespace, make sure its `lifecycleState` is INACTIVE.
        """
        return pulumi.get(self, "state")


class AwaitableGetSecurityAttributeNamespacesResult(GetSecurityAttributeNamespacesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityAttributeNamespacesResult(
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            filters=self.filters,
            id=self.id,
            name=self.name,
            security_attribute_namespaces=self.security_attribute_namespaces,
            state=self.state)


def get_security_attribute_namespaces(compartment_id: Optional[builtins.str] = None,
                                      compartment_id_in_subtree: Optional[builtins.bool] = None,
                                      filters: Optional[Sequence[Union['GetSecurityAttributeNamespacesFilterArgs', 'GetSecurityAttributeNamespacesFilterArgsDict']]] = None,
                                      name: Optional[builtins.str] = None,
                                      state: Optional[builtins.str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityAttributeNamespacesResult:
    """
    This data source provides the list of Security Attribute Namespaces in Oracle Cloud Infrastructure Security Attribute service.

    Lists the security attribute namespaces in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_attribute_namespaces = oci.SecurityAttribute.get_security_attribute_namespaces(compartment_id=compartment_id,
        compartment_id_in_subtree=security_attribute_namespace_compartment_id_in_subtree,
        name=security_attribute_namespace_name,
        state=security_attribute_namespace_state)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param builtins.bool compartment_id_in_subtree: An optional boolean parameter indicating whether to retrieve all security attribute namespaces in subcompartments. If this parameter is not specified, only the namespaces defined in the specified compartment are retrieved.
    :param builtins.str name: A filter to return only resources that match the entire display name given.
    :param builtins.str state: A filter to only return resources that match the given lifecycle state.  The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:SecurityAttribute/getSecurityAttributeNamespaces:getSecurityAttributeNamespaces', __args__, opts=opts, typ=GetSecurityAttributeNamespacesResult).value

    return AwaitableGetSecurityAttributeNamespacesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        security_attribute_namespaces=pulumi.get(__ret__, 'security_attribute_namespaces'),
        state=pulumi.get(__ret__, 'state'))
def get_security_attribute_namespaces_output(compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                             compartment_id_in_subtree: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSecurityAttributeNamespacesFilterArgs', 'GetSecurityAttributeNamespacesFilterArgsDict']]]]] = None,
                                             name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                             state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecurityAttributeNamespacesResult]:
    """
    This data source provides the list of Security Attribute Namespaces in Oracle Cloud Infrastructure Security Attribute service.

    Lists the security attribute namespaces in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_attribute_namespaces = oci.SecurityAttribute.get_security_attribute_namespaces(compartment_id=compartment_id,
        compartment_id_in_subtree=security_attribute_namespace_compartment_id_in_subtree,
        name=security_attribute_namespace_name,
        state=security_attribute_namespace_state)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param builtins.bool compartment_id_in_subtree: An optional boolean parameter indicating whether to retrieve all security attribute namespaces in subcompartments. If this parameter is not specified, only the namespaces defined in the specified compartment are retrieved.
    :param builtins.str name: A filter to return only resources that match the entire display name given.
    :param builtins.str state: A filter to only return resources that match the given lifecycle state.  The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:SecurityAttribute/getSecurityAttributeNamespaces:getSecurityAttributeNamespaces', __args__, opts=opts, typ=GetSecurityAttributeNamespacesResult)
    return __ret__.apply(lambda __response__: GetSecurityAttributeNamespacesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        security_attribute_namespaces=pulumi.get(__response__, 'security_attribute_namespaces'),
        state=pulumi.get(__response__, 'state')))
