# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConfigArgs', 'Config']

@pulumi.input_type
class ConfigArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 config_type: pulumi.Input[builtins.str],
                 additional_configurations: Optional[pulumi.Input['ConfigAdditionalConfigurationsArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 dynamic_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigDynamicGroupArgs']]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_manually_onboarded: Optional[pulumi.Input[builtins.bool]] = None,
                 license: Optional[pulumi.Input[builtins.str]] = None,
                 policy_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 resource_type: Optional[pulumi.Input[builtins.str]] = None,
                 user_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigUserGroupArgs']]]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Config resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) Compartment in which the configuration is created.
        :param pulumi.Input[builtins.str] config_type: The type of configuration. The only valid value is `"AUTO_PROMOTE"`.
        :param pulumi.Input['ConfigAdditionalConfigurationsArgs'] additional_configurations: (Updatable) Property Details
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) The display name of the configuration.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigDynamicGroupArgs']]] dynamic_groups: (Updatable) List of dynamic groups dedicated for Stack Monitoring.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.bool] is_enabled: (Updatable) True if enterprise extensibility is enabled, false if it is not enabled.
        :param pulumi.Input[builtins.bool] is_manually_onboarded: (Updatable) True if customer decides marks configuration as manually configured.
        :param pulumi.Input[builtins.str] license: (Updatable) License edition.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] policy_names: (Updatable) List of policy names assigned for onboarding
        :param pulumi.Input[builtins.str] resource_type: The type of resource to configure for automatic promotion.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigUserGroupArgs']]] user_groups: (Updatable) List of user groups dedicated for Stack Monitoring.
        :param pulumi.Input[builtins.str] version: (Updatable) Assigned version to given onboard configuration.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "config_type", config_type)
        if additional_configurations is not None:
            pulumi.set(__self__, "additional_configurations", additional_configurations)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if dynamic_groups is not None:
            pulumi.set(__self__, "dynamic_groups", dynamic_groups)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if is_manually_onboarded is not None:
            pulumi.set(__self__, "is_manually_onboarded", is_manually_onboarded)
        if license is not None:
            pulumi.set(__self__, "license", license)
        if policy_names is not None:
            pulumi.set(__self__, "policy_names", policy_names)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if user_groups is not None:
            pulumi.set(__self__, "user_groups", user_groups)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Compartment in which the configuration is created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="configType")
    def config_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of configuration. The only valid value is `"AUTO_PROMOTE"`.
        """
        return pulumi.get(self, "config_type")

    @config_type.setter
    def config_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "config_type", value)

    @property
    @pulumi.getter(name="additionalConfigurations")
    def additional_configurations(self) -> Optional[pulumi.Input['ConfigAdditionalConfigurationsArgs']]:
        """
        (Updatable) Property Details
        """
        return pulumi.get(self, "additional_configurations")

    @additional_configurations.setter
    def additional_configurations(self, value: Optional[pulumi.Input['ConfigAdditionalConfigurationsArgs']]):
        pulumi.set(self, "additional_configurations", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The display name of the configuration.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="dynamicGroups")
    def dynamic_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigDynamicGroupArgs']]]]:
        """
        (Updatable) List of dynamic groups dedicated for Stack Monitoring.
        """
        return pulumi.get(self, "dynamic_groups")

    @dynamic_groups.setter
    def dynamic_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigDynamicGroupArgs']]]]):
        pulumi.set(self, "dynamic_groups", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) True if enterprise extensibility is enabled, false if it is not enabled.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="isManuallyOnboarded")
    def is_manually_onboarded(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) True if customer decides marks configuration as manually configured.
        """
        return pulumi.get(self, "is_manually_onboarded")

    @is_manually_onboarded.setter
    def is_manually_onboarded(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_manually_onboarded", value)

    @property
    @pulumi.getter
    def license(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) License edition.
        """
        return pulumi.get(self, "license")

    @license.setter
    def license(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "license", value)

    @property
    @pulumi.getter(name="policyNames")
    def policy_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) List of policy names assigned for onboarding
        """
        return pulumi.get(self, "policy_names")

    @policy_names.setter
    def policy_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "policy_names", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of resource to configure for automatic promotion.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="userGroups")
    def user_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigUserGroupArgs']]]]:
        """
        (Updatable) List of user groups dedicated for Stack Monitoring.
        """
        return pulumi.get(self, "user_groups")

    @user_groups.setter
    def user_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigUserGroupArgs']]]]):
        pulumi.set(self, "user_groups", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Assigned version to given onboard configuration.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _ConfigState:
    def __init__(__self__, *,
                 additional_configurations: Optional[pulumi.Input['ConfigAdditionalConfigurationsArgs']] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 config_type: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 dynamic_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigDynamicGroupArgs']]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_manually_onboarded: Optional[pulumi.Input[builtins.bool]] = None,
                 license: Optional[pulumi.Input[builtins.str]] = None,
                 policy_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 resource_type: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None,
                 user_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigUserGroupArgs']]]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Config resources.
        :param pulumi.Input['ConfigAdditionalConfigurationsArgs'] additional_configurations: (Updatable) Property Details
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) Compartment in which the configuration is created.
        :param pulumi.Input[builtins.str] config_type: The type of configuration. The only valid value is `"AUTO_PROMOTE"`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) The display name of the configuration.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigDynamicGroupArgs']]] dynamic_groups: (Updatable) List of dynamic groups dedicated for Stack Monitoring.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.bool] is_enabled: (Updatable) True if enterprise extensibility is enabled, false if it is not enabled.
        :param pulumi.Input[builtins.bool] is_manually_onboarded: (Updatable) True if customer decides marks configuration as manually configured.
        :param pulumi.Input[builtins.str] license: (Updatable) License edition.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] policy_names: (Updatable) List of policy names assigned for onboarding
        :param pulumi.Input[builtins.str] resource_type: The type of resource to configure for automatic promotion.
        :param pulumi.Input[builtins.str] state: The current state of the configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The time the configuration was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[builtins.str] time_updated: The time the Config was updated.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigUserGroupArgs']]] user_groups: (Updatable) List of user groups dedicated for Stack Monitoring.
        :param pulumi.Input[builtins.str] version: (Updatable) Assigned version to given onboard configuration.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if additional_configurations is not None:
            pulumi.set(__self__, "additional_configurations", additional_configurations)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if config_type is not None:
            pulumi.set(__self__, "config_type", config_type)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if dynamic_groups is not None:
            pulumi.set(__self__, "dynamic_groups", dynamic_groups)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if is_manually_onboarded is not None:
            pulumi.set(__self__, "is_manually_onboarded", is_manually_onboarded)
        if license is not None:
            pulumi.set(__self__, "license", license)
        if policy_names is not None:
            pulumi.set(__self__, "policy_names", policy_names)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if user_groups is not None:
            pulumi.set(__self__, "user_groups", user_groups)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="additionalConfigurations")
    def additional_configurations(self) -> Optional[pulumi.Input['ConfigAdditionalConfigurationsArgs']]:
        """
        (Updatable) Property Details
        """
        return pulumi.get(self, "additional_configurations")

    @additional_configurations.setter
    def additional_configurations(self, value: Optional[pulumi.Input['ConfigAdditionalConfigurationsArgs']]):
        pulumi.set(self, "additional_configurations", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Compartment in which the configuration is created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="configType")
    def config_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of configuration. The only valid value is `"AUTO_PROMOTE"`.
        """
        return pulumi.get(self, "config_type")

    @config_type.setter
    def config_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "config_type", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The display name of the configuration.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="dynamicGroups")
    def dynamic_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigDynamicGroupArgs']]]]:
        """
        (Updatable) List of dynamic groups dedicated for Stack Monitoring.
        """
        return pulumi.get(self, "dynamic_groups")

    @dynamic_groups.setter
    def dynamic_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigDynamicGroupArgs']]]]):
        pulumi.set(self, "dynamic_groups", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) True if enterprise extensibility is enabled, false if it is not enabled.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="isManuallyOnboarded")
    def is_manually_onboarded(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) True if customer decides marks configuration as manually configured.
        """
        return pulumi.get(self, "is_manually_onboarded")

    @is_manually_onboarded.setter
    def is_manually_onboarded(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_manually_onboarded", value)

    @property
    @pulumi.getter
    def license(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) License edition.
        """
        return pulumi.get(self, "license")

    @license.setter
    def license(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "license", value)

    @property
    @pulumi.getter(name="policyNames")
    def policy_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) List of policy names assigned for onboarding
        """
        return pulumi.get(self, "policy_names")

    @policy_names.setter
    def policy_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "policy_names", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of resource to configure for automatic promotion.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the configuration.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the configuration was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the Config was updated.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="userGroups")
    def user_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigUserGroupArgs']]]]:
        """
        (Updatable) List of user groups dedicated for Stack Monitoring.
        """
        return pulumi.get(self, "user_groups")

    @user_groups.setter
    def user_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigUserGroupArgs']]]]):
        pulumi.set(self, "user_groups", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Assigned version to given onboard configuration.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("oci:StackMonitoring/config:Config")
class Config(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_configurations: Optional[pulumi.Input[Union['ConfigAdditionalConfigurationsArgs', 'ConfigAdditionalConfigurationsArgsDict']]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 config_type: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 dynamic_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigDynamicGroupArgs', 'ConfigDynamicGroupArgsDict']]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_manually_onboarded: Optional[pulumi.Input[builtins.bool]] = None,
                 license: Optional[pulumi.Input[builtins.str]] = None,
                 policy_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 resource_type: Optional[pulumi.Input[builtins.str]] = None,
                 user_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigUserGroupArgs', 'ConfigUserGroupArgsDict']]]]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Config resource in Oracle Cloud Infrastructure Stack Monitoring service.

        Creates a configuration item, for example to define
        whether resources of a specific type should be discovered automatically.

        For example, when a new Management Agent gets registered in a certain compartment,
        this Management Agent can potentially get promoted to a HOST resource.
        The configuration item will determine if HOST resources in the selected compartment will be
        discovered automatically.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_config = oci.stack_monitoring.Config("test_config",
            compartment_id=compartment_id,
            config_type=config_config_type,
            is_enabled=config_is_enabled,
            resource_type=config_resource_type,
            license=config_license,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=config_display_name,
            freeform_tags={
                "bar-key": "value",
            })
        ```

        ## Import

        Configs can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:StackMonitoring/config:Config test_config "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ConfigAdditionalConfigurationsArgs', 'ConfigAdditionalConfigurationsArgsDict']] additional_configurations: (Updatable) Property Details
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) Compartment in which the configuration is created.
        :param pulumi.Input[builtins.str] config_type: The type of configuration. The only valid value is `"AUTO_PROMOTE"`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) The display name of the configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigDynamicGroupArgs', 'ConfigDynamicGroupArgsDict']]]] dynamic_groups: (Updatable) List of dynamic groups dedicated for Stack Monitoring.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.bool] is_enabled: (Updatable) True if enterprise extensibility is enabled, false if it is not enabled.
        :param pulumi.Input[builtins.bool] is_manually_onboarded: (Updatable) True if customer decides marks configuration as manually configured.
        :param pulumi.Input[builtins.str] license: (Updatable) License edition.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] policy_names: (Updatable) List of policy names assigned for onboarding
        :param pulumi.Input[builtins.str] resource_type: The type of resource to configure for automatic promotion.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigUserGroupArgs', 'ConfigUserGroupArgsDict']]]] user_groups: (Updatable) List of user groups dedicated for Stack Monitoring.
        :param pulumi.Input[builtins.str] version: (Updatable) Assigned version to given onboard configuration.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Config resource in Oracle Cloud Infrastructure Stack Monitoring service.

        Creates a configuration item, for example to define
        whether resources of a specific type should be discovered automatically.

        For example, when a new Management Agent gets registered in a certain compartment,
        this Management Agent can potentially get promoted to a HOST resource.
        The configuration item will determine if HOST resources in the selected compartment will be
        discovered automatically.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_config = oci.stack_monitoring.Config("test_config",
            compartment_id=compartment_id,
            config_type=config_config_type,
            is_enabled=config_is_enabled,
            resource_type=config_resource_type,
            license=config_license,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=config_display_name,
            freeform_tags={
                "bar-key": "value",
            })
        ```

        ## Import

        Configs can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:StackMonitoring/config:Config test_config "id"
        ```

        :param str resource_name: The name of the resource.
        :param ConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_configurations: Optional[pulumi.Input[Union['ConfigAdditionalConfigurationsArgs', 'ConfigAdditionalConfigurationsArgsDict']]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 config_type: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 dynamic_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigDynamicGroupArgs', 'ConfigDynamicGroupArgsDict']]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_manually_onboarded: Optional[pulumi.Input[builtins.bool]] = None,
                 license: Optional[pulumi.Input[builtins.str]] = None,
                 policy_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 resource_type: Optional[pulumi.Input[builtins.str]] = None,
                 user_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigUserGroupArgs', 'ConfigUserGroupArgsDict']]]]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConfigArgs.__new__(ConfigArgs)

            __props__.__dict__["additional_configurations"] = additional_configurations
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if config_type is None and not opts.urn:
                raise TypeError("Missing required property 'config_type'")
            __props__.__dict__["config_type"] = config_type
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["dynamic_groups"] = dynamic_groups
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_enabled"] = is_enabled
            __props__.__dict__["is_manually_onboarded"] = is_manually_onboarded
            __props__.__dict__["license"] = license
            __props__.__dict__["policy_names"] = policy_names
            __props__.__dict__["resource_type"] = resource_type
            __props__.__dict__["user_groups"] = user_groups
            __props__.__dict__["version"] = version
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(Config, __self__).__init__(
            'oci:StackMonitoring/config:Config',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_configurations: Optional[pulumi.Input[Union['ConfigAdditionalConfigurationsArgs', 'ConfigAdditionalConfigurationsArgsDict']]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            config_type: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            dynamic_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigDynamicGroupArgs', 'ConfigDynamicGroupArgsDict']]]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            is_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            is_manually_onboarded: Optional[pulumi.Input[builtins.bool]] = None,
            license: Optional[pulumi.Input[builtins.str]] = None,
            policy_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            resource_type: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None,
            user_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigUserGroupArgs', 'ConfigUserGroupArgsDict']]]]] = None,
            version: Optional[pulumi.Input[builtins.str]] = None) -> 'Config':
        """
        Get an existing Config resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ConfigAdditionalConfigurationsArgs', 'ConfigAdditionalConfigurationsArgsDict']] additional_configurations: (Updatable) Property Details
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) Compartment in which the configuration is created.
        :param pulumi.Input[builtins.str] config_type: The type of configuration. The only valid value is `"AUTO_PROMOTE"`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) The display name of the configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigDynamicGroupArgs', 'ConfigDynamicGroupArgsDict']]]] dynamic_groups: (Updatable) List of dynamic groups dedicated for Stack Monitoring.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.bool] is_enabled: (Updatable) True if enterprise extensibility is enabled, false if it is not enabled.
        :param pulumi.Input[builtins.bool] is_manually_onboarded: (Updatable) True if customer decides marks configuration as manually configured.
        :param pulumi.Input[builtins.str] license: (Updatable) License edition.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] policy_names: (Updatable) List of policy names assigned for onboarding
        :param pulumi.Input[builtins.str] resource_type: The type of resource to configure for automatic promotion.
        :param pulumi.Input[builtins.str] state: The current state of the configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The time the configuration was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[builtins.str] time_updated: The time the Config was updated.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigUserGroupArgs', 'ConfigUserGroupArgsDict']]]] user_groups: (Updatable) List of user groups dedicated for Stack Monitoring.
        :param pulumi.Input[builtins.str] version: (Updatable) Assigned version to given onboard configuration.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConfigState.__new__(_ConfigState)

        __props__.__dict__["additional_configurations"] = additional_configurations
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["config_type"] = config_type
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["dynamic_groups"] = dynamic_groups
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_enabled"] = is_enabled
        __props__.__dict__["is_manually_onboarded"] = is_manually_onboarded
        __props__.__dict__["license"] = license
        __props__.__dict__["policy_names"] = policy_names
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["user_groups"] = user_groups
        __props__.__dict__["version"] = version
        return Config(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalConfigurations")
    def additional_configurations(self) -> pulumi.Output[Optional['outputs.ConfigAdditionalConfigurations']]:
        """
        (Updatable) Property Details
        """
        return pulumi.get(self, "additional_configurations")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Compartment in which the configuration is created.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="configType")
    def config_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of configuration. The only valid value is `"AUTO_PROMOTE"`.
        """
        return pulumi.get(self, "config_type")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The display name of the configuration.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="dynamicGroups")
    def dynamic_groups(self) -> pulumi.Output[Optional[Sequence['outputs.ConfigDynamicGroup']]]:
        """
        (Updatable) List of dynamic groups dedicated for Stack Monitoring.
        """
        return pulumi.get(self, "dynamic_groups")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) True if enterprise extensibility is enabled, false if it is not enabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="isManuallyOnboarded")
    def is_manually_onboarded(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        (Updatable) True if customer decides marks configuration as manually configured.
        """
        return pulumi.get(self, "is_manually_onboarded")

    @property
    @pulumi.getter
    def license(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) License edition.
        """
        return pulumi.get(self, "license")

    @property
    @pulumi.getter(name="policyNames")
    def policy_names(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        (Updatable) List of policy names assigned for onboarding
        """
        return pulumi.get(self, "policy_names")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of resource to configure for automatic promotion.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the configuration.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The time the configuration was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The time the Config was updated.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="userGroups")
    def user_groups(self) -> pulumi.Output[Optional[Sequence['outputs.ConfigUserGroup']]]:
        """
        (Updatable) List of user groups dedicated for Stack Monitoring.
        """
        return pulumi.get(self, "user_groups")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Updatable) Assigned version to given onboard configuration.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "version")

