# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetMonitoringTemplateResult',
    'AwaitableGetMonitoringTemplateResult',
    'get_monitoring_template',
    'get_monitoring_template_output',
]

@pulumi.output_type
class GetMonitoringTemplateResult:
    """
    A collection of values returned by getMonitoringTemplate.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, description=None, destinations=None, display_name=None, freeform_tags=None, id=None, is_alarms_enabled=None, is_split_notification_enabled=None, members=None, message_format=None, monitoring_template_id=None, repeat_notification_duration=None, state=None, status=None, system_tags=None, tenant_id=None, time_created=None, time_updated=None, total_alarm_conditions=None, total_applied_alarm_conditions=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if destinations and not isinstance(destinations, list):
            raise TypeError("Expected argument 'destinations' to be a list")
        pulumi.set(__self__, "destinations", destinations)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_alarms_enabled and not isinstance(is_alarms_enabled, bool):
            raise TypeError("Expected argument 'is_alarms_enabled' to be a bool")
        pulumi.set(__self__, "is_alarms_enabled", is_alarms_enabled)
        if is_split_notification_enabled and not isinstance(is_split_notification_enabled, bool):
            raise TypeError("Expected argument 'is_split_notification_enabled' to be a bool")
        pulumi.set(__self__, "is_split_notification_enabled", is_split_notification_enabled)
        if members and not isinstance(members, list):
            raise TypeError("Expected argument 'members' to be a list")
        pulumi.set(__self__, "members", members)
        if message_format and not isinstance(message_format, str):
            raise TypeError("Expected argument 'message_format' to be a str")
        pulumi.set(__self__, "message_format", message_format)
        if monitoring_template_id and not isinstance(monitoring_template_id, str):
            raise TypeError("Expected argument 'monitoring_template_id' to be a str")
        pulumi.set(__self__, "monitoring_template_id", monitoring_template_id)
        if repeat_notification_duration and not isinstance(repeat_notification_duration, str):
            raise TypeError("Expected argument 'repeat_notification_duration' to be a str")
        pulumi.set(__self__, "repeat_notification_duration", repeat_notification_duration)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if total_alarm_conditions and not isinstance(total_alarm_conditions, float):
            raise TypeError("Expected argument 'total_alarm_conditions' to be a float")
        pulumi.set(__self__, "total_alarm_conditions", total_alarm_conditions)
        if total_applied_alarm_conditions and not isinstance(total_applied_alarm_conditions, float):
            raise TypeError("Expected argument 'total_applied_alarm_conditions' to be a float")
        pulumi.set(__self__, "total_applied_alarm_conditions", total_applied_alarm_conditions)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment containing the monitoringTemplate.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A user-friendly description for the monitoring template. It does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def destinations(self) -> Sequence[builtins.str]:
        """
        A list of destinations for alarm notifications. Each destination is represented by the OCID of a related resource.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name for the monitoring template. It should be unique, and it's mutable in nature. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the resourceInstance/resourceType/resourceGroup
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAlarmsEnabled")
    def is_alarms_enabled(self) -> builtins.bool:
        """
        Whether the alarm is enabled or disabled. Default value is enabled.
        """
        return pulumi.get(self, "is_alarms_enabled")

    @property
    @pulumi.getter(name="isSplitNotificationEnabled")
    def is_split_notification_enabled(self) -> builtins.bool:
        """
        Whether the alarm notification is enabled or disabled, it will be Enabled by default.
        """
        return pulumi.get(self, "is_split_notification_enabled")

    @property
    @pulumi.getter
    def members(self) -> Sequence['outputs.GetMonitoringTemplateMemberResult']:
        """
        List of members of this monitoring template.
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter(name="messageFormat")
    def message_format(self) -> builtins.str:
        """
        The format to use for alarm notifications.
        """
        return pulumi.get(self, "message_format")

    @property
    @pulumi.getter(name="monitoringTemplateId")
    def monitoring_template_id(self) -> builtins.str:
        return pulumi.get(self, "monitoring_template_id")

    @property
    @pulumi.getter(name="repeatNotificationDuration")
    def repeat_notification_duration(self) -> builtins.str:
        """
        The frequency for re-submitting alarm notifications, if the alarm keeps firing without interruption. Format defined by ISO 8601. For example, PT4H indicates four hours. Minimum- PT1M. Maximum - P30D.
        """
        return pulumi.get(self, "repeat_notification_duration")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current lifecycle state of the monitoring template.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        The current status of the monitoring template i.e. whether it is Applied or NotApplied.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> builtins.str:
        """
        Tenant Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the monitoringTemplate was created. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the monitoringTemplate was last updated. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="totalAlarmConditions")
    def total_alarm_conditions(self) -> builtins.float:
        """
        Total Alarm Conditions
        """
        return pulumi.get(self, "total_alarm_conditions")

    @property
    @pulumi.getter(name="totalAppliedAlarmConditions")
    def total_applied_alarm_conditions(self) -> builtins.float:
        """
        Total Applied Alarm Conditions
        """
        return pulumi.get(self, "total_applied_alarm_conditions")


class AwaitableGetMonitoringTemplateResult(GetMonitoringTemplateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMonitoringTemplateResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            destinations=self.destinations,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_alarms_enabled=self.is_alarms_enabled,
            is_split_notification_enabled=self.is_split_notification_enabled,
            members=self.members,
            message_format=self.message_format,
            monitoring_template_id=self.monitoring_template_id,
            repeat_notification_duration=self.repeat_notification_duration,
            state=self.state,
            status=self.status,
            system_tags=self.system_tags,
            tenant_id=self.tenant_id,
            time_created=self.time_created,
            time_updated=self.time_updated,
            total_alarm_conditions=self.total_alarm_conditions,
            total_applied_alarm_conditions=self.total_applied_alarm_conditions)


def get_monitoring_template(monitoring_template_id: Optional[builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMonitoringTemplateResult:
    """
    This data source provides details about a specific Monitoring Template resource in Oracle Cloud Infrastructure Stack Monitoring service.

    Gets a Monitoring Template by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_monitoring_template = oci.StackMonitoring.get_monitoring_template(monitoring_template_id=test_monitoring_template_oci_stack_monitoring_monitoring_template["id"])
    ```


    :param builtins.str monitoring_template_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the monitoring template.
    """
    __args__ = dict()
    __args__['monitoringTemplateId'] = monitoring_template_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:StackMonitoring/getMonitoringTemplate:getMonitoringTemplate', __args__, opts=opts, typ=GetMonitoringTemplateResult).value

    return AwaitableGetMonitoringTemplateResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        destinations=pulumi.get(__ret__, 'destinations'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_alarms_enabled=pulumi.get(__ret__, 'is_alarms_enabled'),
        is_split_notification_enabled=pulumi.get(__ret__, 'is_split_notification_enabled'),
        members=pulumi.get(__ret__, 'members'),
        message_format=pulumi.get(__ret__, 'message_format'),
        monitoring_template_id=pulumi.get(__ret__, 'monitoring_template_id'),
        repeat_notification_duration=pulumi.get(__ret__, 'repeat_notification_duration'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        total_alarm_conditions=pulumi.get(__ret__, 'total_alarm_conditions'),
        total_applied_alarm_conditions=pulumi.get(__ret__, 'total_applied_alarm_conditions'))
def get_monitoring_template_output(monitoring_template_id: Optional[pulumi.Input[builtins.str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMonitoringTemplateResult]:
    """
    This data source provides details about a specific Monitoring Template resource in Oracle Cloud Infrastructure Stack Monitoring service.

    Gets a Monitoring Template by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_monitoring_template = oci.StackMonitoring.get_monitoring_template(monitoring_template_id=test_monitoring_template_oci_stack_monitoring_monitoring_template["id"])
    ```


    :param builtins.str monitoring_template_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the monitoring template.
    """
    __args__ = dict()
    __args__['monitoringTemplateId'] = monitoring_template_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:StackMonitoring/getMonitoringTemplate:getMonitoringTemplate', __args__, opts=opts, typ=GetMonitoringTemplateResult)
    return __ret__.apply(lambda __response__: GetMonitoringTemplateResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        destinations=pulumi.get(__response__, 'destinations'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_alarms_enabled=pulumi.get(__response__, 'is_alarms_enabled'),
        is_split_notification_enabled=pulumi.get(__response__, 'is_split_notification_enabled'),
        members=pulumi.get(__response__, 'members'),
        message_format=pulumi.get(__response__, 'message_format'),
        monitoring_template_id=pulumi.get(__response__, 'monitoring_template_id'),
        repeat_notification_duration=pulumi.get(__response__, 'repeat_notification_duration'),
        state=pulumi.get(__response__, 'state'),
        status=pulumi.get(__response__, 'status'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        tenant_id=pulumi.get(__response__, 'tenant_id'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        total_alarm_conditions=pulumi.get(__response__, 'total_alarm_conditions'),
        total_applied_alarm_conditions=pulumi.get(__response__, 'total_applied_alarm_conditions')))
