# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetStreamPoolsResult',
    'AwaitableGetStreamPoolsResult',
    'get_stream_pools',
    'get_stream_pools_output',
]

@pulumi.output_type
class GetStreamPoolsResult:
    """
    A collection of values returned by getStreamPools.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, name=None, state=None, stream_pools=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if stream_pools and not isinstance(stream_pools, list):
            raise TypeError("Expected argument 'stream_pools' to be a list")
        pulumi.set(__self__, "stream_pools", stream_pools)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        Compartment OCID that the pool belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetStreamPoolsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The OCID of the stream pool.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the stream pool.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the stream pool.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="streamPools")
    def stream_pools(self) -> Sequence['outputs.GetStreamPoolsStreamPoolResult']:
        """
        The list of stream_pools.
        """
        return pulumi.get(self, "stream_pools")


class AwaitableGetStreamPoolsResult(GetStreamPoolsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStreamPoolsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            name=self.name,
            state=self.state,
            stream_pools=self.stream_pools)


def get_stream_pools(compartment_id: Optional[builtins.str] = None,
                     filters: Optional[Sequence[Union['GetStreamPoolsFilterArgs', 'GetStreamPoolsFilterArgsDict']]] = None,
                     id: Optional[builtins.str] = None,
                     name: Optional[builtins.str] = None,
                     state: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStreamPoolsResult:
    """
    This data source provides the list of Stream Pools in Oracle Cloud Infrastructure Streaming service.

    List the stream pools for a given compartment ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_stream_pools = oci.Streaming.get_stream_pools(compartment_id=compartment_id,
        id=stream_pool_id,
        name=stream_pool_name,
        state=stream_pool_state)
    ```


    :param builtins.str compartment_id: The OCID of the compartment.
    :param builtins.str id: A filter to return only resources that match the given ID exactly.
    :param builtins.str name: A filter to return only resources that match the given name exactly.
    :param builtins.str state: A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Streaming/getStreamPools:getStreamPools', __args__, opts=opts, typ=GetStreamPoolsResult).value

    return AwaitableGetStreamPoolsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        state=pulumi.get(__ret__, 'state'),
        stream_pools=pulumi.get(__ret__, 'stream_pools'))
def get_stream_pools_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                            filters: Optional[pulumi.Input[Optional[Sequence[Union['GetStreamPoolsFilterArgs', 'GetStreamPoolsFilterArgsDict']]]]] = None,
                            id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStreamPoolsResult]:
    """
    This data source provides the list of Stream Pools in Oracle Cloud Infrastructure Streaming service.

    List the stream pools for a given compartment ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_stream_pools = oci.Streaming.get_stream_pools(compartment_id=compartment_id,
        id=stream_pool_id,
        name=stream_pool_name,
        state=stream_pool_state)
    ```


    :param builtins.str compartment_id: The OCID of the compartment.
    :param builtins.str id: A filter to return only resources that match the given ID exactly.
    :param builtins.str name: A filter to return only resources that match the given name exactly.
    :param builtins.str state: A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Streaming/getStreamPools:getStreamPools', __args__, opts=opts, typ=GetStreamPoolsResult)
    return __ret__.apply(lambda __response__: GetStreamPoolsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        state=pulumi.get(__response__, 'state'),
        stream_pools=pulumi.get(__response__, 'stream_pools')))
