# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetOrganizationTenancyResult',
    'AwaitableGetOrganizationTenancyResult',
    'get_organization_tenancy',
    'get_organization_tenancy_output',
]

@pulumi.output_type
class GetOrganizationTenancyResult:
    """
    A collection of values returned by getOrganizationTenancy.
    """
    def __init__(__self__, governance_status=None, id=None, is_approved_for_transfer=None, name=None, organization_id=None, role=None, state=None, tenancy_id=None, time_joined=None, time_left=None):
        if governance_status and not isinstance(governance_status, str):
            raise TypeError("Expected argument 'governance_status' to be a str")
        pulumi.set(__self__, "governance_status", governance_status)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_approved_for_transfer and not isinstance(is_approved_for_transfer, bool):
            raise TypeError("Expected argument 'is_approved_for_transfer' to be a bool")
        pulumi.set(__self__, "is_approved_for_transfer", is_approved_for_transfer)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if role and not isinstance(role, str):
            raise TypeError("Expected argument 'role' to be a str")
        pulumi.set(__self__, "role", role)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if tenancy_id and not isinstance(tenancy_id, str):
            raise TypeError("Expected argument 'tenancy_id' to be a str")
        pulumi.set(__self__, "tenancy_id", tenancy_id)
        if time_joined and not isinstance(time_joined, str):
            raise TypeError("Expected argument 'time_joined' to be a str")
        pulumi.set(__self__, "time_joined", time_joined)
        if time_left and not isinstance(time_left, str):
            raise TypeError("Expected argument 'time_left' to be a str")
        pulumi.set(__self__, "time_left", time_left)

    @property
    @pulumi.getter(name="governanceStatus")
    def governance_status(self) -> builtins.str:
        """
        The governance status of the tenancy.
        """
        return pulumi.get(self, "governance_status")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isApprovedForTransfer")
    def is_approved_for_transfer(self) -> builtins.bool:
        """
        Parameter to indicate the tenancy is approved for transfer to another organization.
        """
        return pulumi.get(self, "is_approved_for_transfer")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the tenancy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> builtins.str:
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter
    def role(self) -> builtins.str:
        """
        Role of the organization tenancy.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        Lifecycle state of the organization tenancy.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> builtins.str:
        """
        OCID of the tenancy.
        """
        return pulumi.get(self, "tenancy_id")

    @property
    @pulumi.getter(name="timeJoined")
    def time_joined(self) -> builtins.str:
        """
        Date and time when the tenancy joined the organization.
        """
        return pulumi.get(self, "time_joined")

    @property
    @pulumi.getter(name="timeLeft")
    def time_left(self) -> builtins.str:
        """
        Date and time when the tenancy left the organization.
        """
        return pulumi.get(self, "time_left")


class AwaitableGetOrganizationTenancyResult(GetOrganizationTenancyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOrganizationTenancyResult(
            governance_status=self.governance_status,
            id=self.id,
            is_approved_for_transfer=self.is_approved_for_transfer,
            name=self.name,
            organization_id=self.organization_id,
            role=self.role,
            state=self.state,
            tenancy_id=self.tenancy_id,
            time_joined=self.time_joined,
            time_left=self.time_left)


def get_organization_tenancy(organization_id: Optional[builtins.str] = None,
                             tenancy_id: Optional[builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOrganizationTenancyResult:
    """
    This data source provides details about a specific Organization Tenancy resource in Oracle Cloud Infrastructure Tenantmanagercontrolplane service.

    Gets information about the organization's tenancy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_organization_tenancy = oci.Tenantmanagercontrolplane.get_organization_tenancy(organization_id=test_organization["id"],
        tenancy_id=test_tenancy["id"])
    ```


    :param builtins.str organization_id: OCID of the organization.
    :param builtins.str tenancy_id: OCID of the tenancy to retrieve.
    """
    __args__ = dict()
    __args__['organizationId'] = organization_id
    __args__['tenancyId'] = tenancy_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Tenantmanagercontrolplane/getOrganizationTenancy:getOrganizationTenancy', __args__, opts=opts, typ=GetOrganizationTenancyResult).value

    return AwaitableGetOrganizationTenancyResult(
        governance_status=pulumi.get(__ret__, 'governance_status'),
        id=pulumi.get(__ret__, 'id'),
        is_approved_for_transfer=pulumi.get(__ret__, 'is_approved_for_transfer'),
        name=pulumi.get(__ret__, 'name'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        role=pulumi.get(__ret__, 'role'),
        state=pulumi.get(__ret__, 'state'),
        tenancy_id=pulumi.get(__ret__, 'tenancy_id'),
        time_joined=pulumi.get(__ret__, 'time_joined'),
        time_left=pulumi.get(__ret__, 'time_left'))
def get_organization_tenancy_output(organization_id: Optional[pulumi.Input[builtins.str]] = None,
                                    tenancy_id: Optional[pulumi.Input[builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOrganizationTenancyResult]:
    """
    This data source provides details about a specific Organization Tenancy resource in Oracle Cloud Infrastructure Tenantmanagercontrolplane service.

    Gets information about the organization's tenancy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_organization_tenancy = oci.Tenantmanagercontrolplane.get_organization_tenancy(organization_id=test_organization["id"],
        tenancy_id=test_tenancy["id"])
    ```


    :param builtins.str organization_id: OCID of the organization.
    :param builtins.str tenancy_id: OCID of the tenancy to retrieve.
    """
    __args__ = dict()
    __args__['organizationId'] = organization_id
    __args__['tenancyId'] = tenancy_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Tenantmanagercontrolplane/getOrganizationTenancy:getOrganizationTenancy', __args__, opts=opts, typ=GetOrganizationTenancyResult)
    return __ret__.apply(lambda __response__: GetOrganizationTenancyResult(
        governance_status=pulumi.get(__response__, 'governance_status'),
        id=pulumi.get(__response__, 'id'),
        is_approved_for_transfer=pulumi.get(__response__, 'is_approved_for_transfer'),
        name=pulumi.get(__response__, 'name'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        role=pulumi.get(__response__, 'role'),
        state=pulumi.get(__response__, 'state'),
        tenancy_id=pulumi.get(__response__, 'tenancy_id'),
        time_joined=pulumi.get(__response__, 'time_joined'),
        time_left=pulumi.get(__response__, 'time_left')))
