# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'VbInstanceAlternateCustomEndpoint',
    'VbInstanceCustomEndpoint',
    'VbInstanceNetworkEndpointDetails',
    'VbInstanceNetworkEndpointDetailsAllowlistedHttpVcn',
    'GetVbInstanceAlternateCustomEndpointResult',
    'GetVbInstanceApplicationsApplicationSummaryCollectionResult',
    'GetVbInstanceApplicationsApplicationSummaryCollectionItemResult',
    'GetVbInstanceCustomEndpointResult',
    'GetVbInstanceNetworkEndpointDetailResult',
    'GetVbInstanceNetworkEndpointDetailAllowlistedHttpVcnResult',
    'GetVbInstancesFilterResult',
    'GetVbInstancesVbInstanceSummaryCollectionResult',
    'GetVbInstancesVbInstanceSummaryCollectionItemResult',
    'GetVbInstancesVbInstanceSummaryCollectionItemAlternateCustomEndpointResult',
    'GetVbInstancesVbInstanceSummaryCollectionItemCustomEndpointResult',
    'GetVbInstancesVbInstanceSummaryCollectionItemNetworkEndpointDetailResult',
    'GetVbInstancesVbInstanceSummaryCollectionItemNetworkEndpointDetailAllowlistedHttpVcnResult',
]

@pulumi.output_type
class VbInstanceAlternateCustomEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateSecretId":
            suggest = "certificate_secret_id"
        elif key == "certificateSecretVersion":
            suggest = "certificate_secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VbInstanceAlternateCustomEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VbInstanceAlternateCustomEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VbInstanceAlternateCustomEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hostname: builtins.str,
                 certificate_secret_id: Optional[builtins.str] = None,
                 certificate_secret_version: Optional[builtins.int] = None):
        """
        :param builtins.str hostname: (Updatable) A custom hostname to be used for the vb instance URL, in FQDN format.
        :param builtins.str certificate_secret_id: (Updatable) Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname. All certificates should be stored in a single base64 encoded secret Note the update will fail if this is not a valid certificate.
        :param builtins.int certificate_secret_version: The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        pulumi.set(__self__, "hostname", hostname)
        if certificate_secret_id is not None:
            pulumi.set(__self__, "certificate_secret_id", certificate_secret_id)
        if certificate_secret_version is not None:
            pulumi.set(__self__, "certificate_secret_version", certificate_secret_version)

    @property
    @pulumi.getter
    def hostname(self) -> builtins.str:
        """
        (Updatable) A custom hostname to be used for the vb instance URL, in FQDN format.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="certificateSecretId")
    def certificate_secret_id(self) -> Optional[builtins.str]:
        """
        (Updatable) Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname. All certificates should be stored in a single base64 encoded secret Note the update will fail if this is not a valid certificate.
        """
        return pulumi.get(self, "certificate_secret_id")

    @property
    @pulumi.getter(name="certificateSecretVersion")
    def certificate_secret_version(self) -> Optional[builtins.int]:
        """
        The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        return pulumi.get(self, "certificate_secret_version")


@pulumi.output_type
class VbInstanceCustomEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateSecretId":
            suggest = "certificate_secret_id"
        elif key == "certificateSecretVersion":
            suggest = "certificate_secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VbInstanceCustomEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VbInstanceCustomEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VbInstanceCustomEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hostname: builtins.str,
                 certificate_secret_id: Optional[builtins.str] = None,
                 certificate_secret_version: Optional[builtins.int] = None):
        """
        :param builtins.str hostname: (Updatable) A custom hostname to be used for the vb instance URL, in FQDN format.
        :param builtins.str certificate_secret_id: (Updatable) Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname. All certificates should be stored in a single base64 encoded secret Note the update will fail if this is not a valid certificate.
        :param builtins.int certificate_secret_version: The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        pulumi.set(__self__, "hostname", hostname)
        if certificate_secret_id is not None:
            pulumi.set(__self__, "certificate_secret_id", certificate_secret_id)
        if certificate_secret_version is not None:
            pulumi.set(__self__, "certificate_secret_version", certificate_secret_version)

    @property
    @pulumi.getter
    def hostname(self) -> builtins.str:
        """
        (Updatable) A custom hostname to be used for the vb instance URL, in FQDN format.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="certificateSecretId")
    def certificate_secret_id(self) -> Optional[builtins.str]:
        """
        (Updatable) Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname. All certificates should be stored in a single base64 encoded secret Note the update will fail if this is not a valid certificate.
        """
        return pulumi.get(self, "certificate_secret_id")

    @property
    @pulumi.getter(name="certificateSecretVersion")
    def certificate_secret_version(self) -> Optional[builtins.int]:
        """
        The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        return pulumi.get(self, "certificate_secret_version")


@pulumi.output_type
class VbInstanceNetworkEndpointDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkEndpointType":
            suggest = "network_endpoint_type"
        elif key == "allowlistedHttpIps":
            suggest = "allowlisted_http_ips"
        elif key == "allowlistedHttpVcns":
            suggest = "allowlisted_http_vcns"
        elif key == "networkSecurityGroupIds":
            suggest = "network_security_group_ids"
        elif key == "privateEndpointIp":
            suggest = "private_endpoint_ip"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VbInstanceNetworkEndpointDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VbInstanceNetworkEndpointDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VbInstanceNetworkEndpointDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_endpoint_type: builtins.str,
                 allowlisted_http_ips: Optional[Sequence[builtins.str]] = None,
                 allowlisted_http_vcns: Optional[Sequence['outputs.VbInstanceNetworkEndpointDetailsAllowlistedHttpVcn']] = None,
                 network_security_group_ids: Optional[Sequence[builtins.str]] = None,
                 private_endpoint_ip: Optional[builtins.str] = None,
                 subnet_id: Optional[builtins.str] = None):
        """
        :param builtins.str network_endpoint_type: (Updatable) The type of network endpoint.
               
               For private endpoint access
        :param Sequence[builtins.str] allowlisted_http_ips: (Updatable) Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5/32", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        :param Sequence['VbInstanceNetworkEndpointDetailsAllowlistedHttpVcnArgs'] allowlisted_http_vcns: (Updatable) Virtual Cloud Networks allowed to access this network endpoint.
        :param Sequence[builtins.str] network_security_group_ids: (Updatable) Network Security Group OCIDs for the Private Endpoint.
        :param builtins.str private_endpoint_ip: The IP address to be assigned to Private Endpoint
        :param builtins.str subnet_id: (Updatable) The subnet OCID for the private endpoint.
               
               For public network access control
        """
        pulumi.set(__self__, "network_endpoint_type", network_endpoint_type)
        if allowlisted_http_ips is not None:
            pulumi.set(__self__, "allowlisted_http_ips", allowlisted_http_ips)
        if allowlisted_http_vcns is not None:
            pulumi.set(__self__, "allowlisted_http_vcns", allowlisted_http_vcns)
        if network_security_group_ids is not None:
            pulumi.set(__self__, "network_security_group_ids", network_security_group_ids)
        if private_endpoint_ip is not None:
            pulumi.set(__self__, "private_endpoint_ip", private_endpoint_ip)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="networkEndpointType")
    def network_endpoint_type(self) -> builtins.str:
        """
        (Updatable) The type of network endpoint.

        For private endpoint access
        """
        return pulumi.get(self, "network_endpoint_type")

    @property
    @pulumi.getter(name="allowlistedHttpIps")
    def allowlisted_http_ips(self) -> Optional[Sequence[builtins.str]]:
        """
        (Updatable) Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5/32", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        """
        return pulumi.get(self, "allowlisted_http_ips")

    @property
    @pulumi.getter(name="allowlistedHttpVcns")
    def allowlisted_http_vcns(self) -> Optional[Sequence['outputs.VbInstanceNetworkEndpointDetailsAllowlistedHttpVcn']]:
        """
        (Updatable) Virtual Cloud Networks allowed to access this network endpoint.
        """
        return pulumi.get(self, "allowlisted_http_vcns")

    @property
    @pulumi.getter(name="networkSecurityGroupIds")
    def network_security_group_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        (Updatable) Network Security Group OCIDs for the Private Endpoint.
        """
        return pulumi.get(self, "network_security_group_ids")

    @property
    @pulumi.getter(name="privateEndpointIp")
    def private_endpoint_ip(self) -> Optional[builtins.str]:
        """
        The IP address to be assigned to Private Endpoint
        """
        return pulumi.get(self, "private_endpoint_ip")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[builtins.str]:
        """
        (Updatable) The subnet OCID for the private endpoint.

        For public network access control
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class VbInstanceNetworkEndpointDetailsAllowlistedHttpVcn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowlistedIpCidrs":
            suggest = "allowlisted_ip_cidrs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VbInstanceNetworkEndpointDetailsAllowlistedHttpVcn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VbInstanceNetworkEndpointDetailsAllowlistedHttpVcn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VbInstanceNetworkEndpointDetailsAllowlistedHttpVcn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: builtins.str,
                 allowlisted_ip_cidrs: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str id: (Updatable) The Virtual Cloud Network OCID.
        :param Sequence[builtins.str] allowlisted_ip_cidrs: (Updatable) Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5/32", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        """
        pulumi.set(__self__, "id", id)
        if allowlisted_ip_cidrs is not None:
            pulumi.set(__self__, "allowlisted_ip_cidrs", allowlisted_ip_cidrs)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        (Updatable) The Virtual Cloud Network OCID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="allowlistedIpCidrs")
    def allowlisted_ip_cidrs(self) -> Optional[Sequence[builtins.str]]:
        """
        (Updatable) Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5/32", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        """
        return pulumi.get(self, "allowlisted_ip_cidrs")


@pulumi.output_type
class GetVbInstanceAlternateCustomEndpointResult(dict):
    def __init__(__self__, *,
                 certificate_secret_id: builtins.str,
                 certificate_secret_version: builtins.int,
                 hostname: builtins.str):
        """
        :param builtins.str certificate_secret_id: Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        :param builtins.int certificate_secret_version: The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        :param builtins.str hostname: A custom hostname to be used for the vb instance URL, in FQDN format.
        """
        pulumi.set(__self__, "certificate_secret_id", certificate_secret_id)
        pulumi.set(__self__, "certificate_secret_version", certificate_secret_version)
        pulumi.set(__self__, "hostname", hostname)

    @property
    @pulumi.getter(name="certificateSecretId")
    def certificate_secret_id(self) -> builtins.str:
        """
        Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        """
        return pulumi.get(self, "certificate_secret_id")

    @property
    @pulumi.getter(name="certificateSecretVersion")
    def certificate_secret_version(self) -> builtins.int:
        """
        The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        return pulumi.get(self, "certificate_secret_version")

    @property
    @pulumi.getter
    def hostname(self) -> builtins.str:
        """
        A custom hostname to be used for the vb instance URL, in FQDN format.
        """
        return pulumi.get(self, "hostname")


@pulumi.output_type
class GetVbInstanceApplicationsApplicationSummaryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetVbInstanceApplicationsApplicationSummaryCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetVbInstanceApplicationsApplicationSummaryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetVbInstanceApplicationsApplicationSummaryCollectionItemResult(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 project_id: builtins.str,
                 state: builtins.str,
                 version: builtins.str):
        """
        :param builtins.str id: The Visual Builder application identifier.
        :param builtins.str project_id: The Visual Builder application project identifier.
        :param builtins.str state: The state of visual builder application. Either LIVE or STAGED
        :param builtins.str version: The Visual Builder application version
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The Visual Builder application identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        """
        The Visual Builder application project identifier.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The state of visual builder application. Either LIVE or STAGED
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        The Visual Builder application version
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetVbInstanceCustomEndpointResult(dict):
    def __init__(__self__, *,
                 certificate_secret_id: builtins.str,
                 certificate_secret_version: builtins.int,
                 hostname: builtins.str):
        """
        :param builtins.str certificate_secret_id: Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        :param builtins.int certificate_secret_version: The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        :param builtins.str hostname: A custom hostname to be used for the vb instance URL, in FQDN format.
        """
        pulumi.set(__self__, "certificate_secret_id", certificate_secret_id)
        pulumi.set(__self__, "certificate_secret_version", certificate_secret_version)
        pulumi.set(__self__, "hostname", hostname)

    @property
    @pulumi.getter(name="certificateSecretId")
    def certificate_secret_id(self) -> builtins.str:
        """
        Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        """
        return pulumi.get(self, "certificate_secret_id")

    @property
    @pulumi.getter(name="certificateSecretVersion")
    def certificate_secret_version(self) -> builtins.int:
        """
        The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        return pulumi.get(self, "certificate_secret_version")

    @property
    @pulumi.getter
    def hostname(self) -> builtins.str:
        """
        A custom hostname to be used for the vb instance URL, in FQDN format.
        """
        return pulumi.get(self, "hostname")


@pulumi.output_type
class GetVbInstanceNetworkEndpointDetailResult(dict):
    def __init__(__self__, *,
                 allowlisted_http_ips: Sequence[builtins.str],
                 allowlisted_http_vcns: Sequence['outputs.GetVbInstanceNetworkEndpointDetailAllowlistedHttpVcnResult'],
                 network_endpoint_type: builtins.str,
                 network_security_group_ids: Sequence[builtins.str],
                 private_endpoint_ip: builtins.str,
                 subnet_id: builtins.str):
        """
        :param Sequence[builtins.str] allowlisted_http_ips: Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5/32", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        :param Sequence['GetVbInstanceNetworkEndpointDetailAllowlistedHttpVcnArgs'] allowlisted_http_vcns: Virtual Cloud Networks allowed to access this network endpoint.
        :param builtins.str network_endpoint_type: The type of network endpoint.
        :param Sequence[builtins.str] network_security_group_ids: Network Security Group OCIDs for the Private Endpoint.
        :param builtins.str private_endpoint_ip: The IP address to be assigned to Private Endpoint
        :param builtins.str subnet_id: The subnet OCID for the private endpoint.
        """
        pulumi.set(__self__, "allowlisted_http_ips", allowlisted_http_ips)
        pulumi.set(__self__, "allowlisted_http_vcns", allowlisted_http_vcns)
        pulumi.set(__self__, "network_endpoint_type", network_endpoint_type)
        pulumi.set(__self__, "network_security_group_ids", network_security_group_ids)
        pulumi.set(__self__, "private_endpoint_ip", private_endpoint_ip)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="allowlistedHttpIps")
    def allowlisted_http_ips(self) -> Sequence[builtins.str]:
        """
        Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5/32", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        """
        return pulumi.get(self, "allowlisted_http_ips")

    @property
    @pulumi.getter(name="allowlistedHttpVcns")
    def allowlisted_http_vcns(self) -> Sequence['outputs.GetVbInstanceNetworkEndpointDetailAllowlistedHttpVcnResult']:
        """
        Virtual Cloud Networks allowed to access this network endpoint.
        """
        return pulumi.get(self, "allowlisted_http_vcns")

    @property
    @pulumi.getter(name="networkEndpointType")
    def network_endpoint_type(self) -> builtins.str:
        """
        The type of network endpoint.
        """
        return pulumi.get(self, "network_endpoint_type")

    @property
    @pulumi.getter(name="networkSecurityGroupIds")
    def network_security_group_ids(self) -> Sequence[builtins.str]:
        """
        Network Security Group OCIDs for the Private Endpoint.
        """
        return pulumi.get(self, "network_security_group_ids")

    @property
    @pulumi.getter(name="privateEndpointIp")
    def private_endpoint_ip(self) -> builtins.str:
        """
        The IP address to be assigned to Private Endpoint
        """
        return pulumi.get(self, "private_endpoint_ip")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The subnet OCID for the private endpoint.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetVbInstanceNetworkEndpointDetailAllowlistedHttpVcnResult(dict):
    def __init__(__self__, *,
                 allowlisted_ip_cidrs: Sequence[builtins.str],
                 id: builtins.str):
        """
        :param Sequence[builtins.str] allowlisted_ip_cidrs: Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5/32", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        :param builtins.str id: The Virtual Cloud Network OCID.
        """
        pulumi.set(__self__, "allowlisted_ip_cidrs", allowlisted_ip_cidrs)
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="allowlistedIpCidrs")
    def allowlisted_ip_cidrs(self) -> Sequence[builtins.str]:
        """
        Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5/32", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        """
        return pulumi.get(self, "allowlisted_ip_cidrs")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The Virtual Cloud Network OCID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetVbInstancesFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetVbInstancesVbInstanceSummaryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetVbInstancesVbInstanceSummaryCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetVbInstancesVbInstanceSummaryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetVbInstancesVbInstanceSummaryCollectionItemResult(dict):
    def __init__(__self__, *,
                 alternate_custom_endpoints: Sequence['outputs.GetVbInstancesVbInstanceSummaryCollectionItemAlternateCustomEndpointResult'],
                 compartment_id: builtins.str,
                 consumption_model: builtins.str,
                 custom_endpoints: Sequence['outputs.GetVbInstancesVbInstanceSummaryCollectionItemCustomEndpointResult'],
                 defined_tags: Mapping[str, builtins.str],
                 display_name: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 idcs_open_id: builtins.str,
                 instance_url: builtins.str,
                 is_visual_builder_enabled: builtins.bool,
                 management_nat_gateway_ip: builtins.str,
                 management_vcn_id: builtins.str,
                 network_endpoint_details: Sequence['outputs.GetVbInstancesVbInstanceSummaryCollectionItemNetworkEndpointDetailResult'],
                 node_count: builtins.int,
                 service_nat_gateway_ip: builtins.str,
                 service_vcn_id: builtins.str,
                 state: builtins.str,
                 state_message: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 time_created: builtins.str,
                 time_updated: builtins.str):
        """
        :param Sequence['GetVbInstancesVbInstanceSummaryCollectionItemAlternateCustomEndpointArgs'] alternate_custom_endpoints: A list of alternate custom endpoints used for the vb instance URL.
        :param builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param builtins.str consumption_model: The entitlement used for billing purposes.
        :param Sequence['GetVbInstancesVbInstanceSummaryCollectionItemCustomEndpointArgs'] custom_endpoints: Details for a custom endpoint for the vb instance.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param builtins.str display_name: A user-friendly name. Does not have to be unique, and it's changeable.  Example: `My new resource`
        :param Mapping[str, builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param builtins.str id: The Virtual Cloud Network OCID.
        :param builtins.str instance_url: The Vb Instance URL.
        :param builtins.bool is_visual_builder_enabled: Visual Builder is enabled or not.
        :param builtins.str management_nat_gateway_ip: The NAT gateway IP address for the VB management VCN
        :param builtins.str management_vcn_id: The Oracle Cloud ID (OCID) of the Visual Builder management VCN
        :param Sequence['GetVbInstancesVbInstanceSummaryCollectionItemNetworkEndpointDetailArgs'] network_endpoint_details: Base representation of a network endpoint. In input payload to update an Visual Builder instance endpoint details, an empty payload will clear out any existing configuration for Public Visual Builder instance.
        :param builtins.int node_count: The number of Nodes
        :param builtins.str service_nat_gateway_ip: The NAT gateway IP address for the VB service VCN
        :param builtins.str service_vcn_id: The Oracle Cloud ID (OCID) of the Visual Builder service VCN
        :param builtins.str state: Life cycle state to query on.
        :param builtins.str state_message: An message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param Mapping[str, builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param builtins.str time_created: The time the the VbInstance was created. An RFC3339 formatted datetime string.
        :param builtins.str time_updated: The time the VbInstance was updated. An RFC3339 formatted datetime string.
        """
        pulumi.set(__self__, "alternate_custom_endpoints", alternate_custom_endpoints)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "consumption_model", consumption_model)
        pulumi.set(__self__, "custom_endpoints", custom_endpoints)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "idcs_open_id", idcs_open_id)
        pulumi.set(__self__, "instance_url", instance_url)
        pulumi.set(__self__, "is_visual_builder_enabled", is_visual_builder_enabled)
        pulumi.set(__self__, "management_nat_gateway_ip", management_nat_gateway_ip)
        pulumi.set(__self__, "management_vcn_id", management_vcn_id)
        pulumi.set(__self__, "network_endpoint_details", network_endpoint_details)
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "service_nat_gateway_ip", service_nat_gateway_ip)
        pulumi.set(__self__, "service_vcn_id", service_vcn_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "state_message", state_message)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="alternateCustomEndpoints")
    def alternate_custom_endpoints(self) -> Sequence['outputs.GetVbInstancesVbInstanceSummaryCollectionItemAlternateCustomEndpointResult']:
        """
        A list of alternate custom endpoints used for the vb instance URL.
        """
        return pulumi.get(self, "alternate_custom_endpoints")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="consumptionModel")
    def consumption_model(self) -> builtins.str:
        """
        The entitlement used for billing purposes.
        """
        return pulumi.get(self, "consumption_model")

    @property
    @pulumi.getter(name="customEndpoints")
    def custom_endpoints(self) -> Sequence['outputs.GetVbInstancesVbInstanceSummaryCollectionItemCustomEndpointResult']:
        """
        Details for a custom endpoint for the vb instance.
        """
        return pulumi.get(self, "custom_endpoints")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The Virtual Cloud Network OCID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idcsOpenId")
    def idcs_open_id(self) -> builtins.str:
        return pulumi.get(self, "idcs_open_id")

    @property
    @pulumi.getter(name="instanceUrl")
    def instance_url(self) -> builtins.str:
        """
        The Vb Instance URL.
        """
        return pulumi.get(self, "instance_url")

    @property
    @pulumi.getter(name="isVisualBuilderEnabled")
    def is_visual_builder_enabled(self) -> builtins.bool:
        """
        Visual Builder is enabled or not.
        """
        return pulumi.get(self, "is_visual_builder_enabled")

    @property
    @pulumi.getter(name="managementNatGatewayIp")
    def management_nat_gateway_ip(self) -> builtins.str:
        """
        The NAT gateway IP address for the VB management VCN
        """
        return pulumi.get(self, "management_nat_gateway_ip")

    @property
    @pulumi.getter(name="managementVcnId")
    def management_vcn_id(self) -> builtins.str:
        """
        The Oracle Cloud ID (OCID) of the Visual Builder management VCN
        """
        return pulumi.get(self, "management_vcn_id")

    @property
    @pulumi.getter(name="networkEndpointDetails")
    def network_endpoint_details(self) -> Sequence['outputs.GetVbInstancesVbInstanceSummaryCollectionItemNetworkEndpointDetailResult']:
        """
        Base representation of a network endpoint. In input payload to update an Visual Builder instance endpoint details, an empty payload will clear out any existing configuration for Public Visual Builder instance.
        """
        return pulumi.get(self, "network_endpoint_details")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> builtins.int:
        """
        The number of Nodes
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="serviceNatGatewayIp")
    def service_nat_gateway_ip(self) -> builtins.str:
        """
        The NAT gateway IP address for the VB service VCN
        """
        return pulumi.get(self, "service_nat_gateway_ip")

    @property
    @pulumi.getter(name="serviceVcnId")
    def service_vcn_id(self) -> builtins.str:
        """
        The Oracle Cloud ID (OCID) of the Visual Builder service VCN
        """
        return pulumi.get(self, "service_vcn_id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        Life cycle state to query on.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> builtins.str:
        """
        An message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "state_message")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the the VbInstance was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time the VbInstance was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetVbInstancesVbInstanceSummaryCollectionItemAlternateCustomEndpointResult(dict):
    def __init__(__self__, *,
                 certificate_secret_id: builtins.str,
                 certificate_secret_version: builtins.int,
                 hostname: builtins.str):
        """
        :param builtins.str certificate_secret_id: Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        :param builtins.int certificate_secret_version: The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        :param builtins.str hostname: A custom hostname to be used for the vb instance URL, in FQDN format.
        """
        pulumi.set(__self__, "certificate_secret_id", certificate_secret_id)
        pulumi.set(__self__, "certificate_secret_version", certificate_secret_version)
        pulumi.set(__self__, "hostname", hostname)

    @property
    @pulumi.getter(name="certificateSecretId")
    def certificate_secret_id(self) -> builtins.str:
        """
        Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        """
        return pulumi.get(self, "certificate_secret_id")

    @property
    @pulumi.getter(name="certificateSecretVersion")
    def certificate_secret_version(self) -> builtins.int:
        """
        The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        return pulumi.get(self, "certificate_secret_version")

    @property
    @pulumi.getter
    def hostname(self) -> builtins.str:
        """
        A custom hostname to be used for the vb instance URL, in FQDN format.
        """
        return pulumi.get(self, "hostname")


@pulumi.output_type
class GetVbInstancesVbInstanceSummaryCollectionItemCustomEndpointResult(dict):
    def __init__(__self__, *,
                 certificate_secret_id: builtins.str,
                 certificate_secret_version: builtins.int,
                 hostname: builtins.str):
        """
        :param builtins.str certificate_secret_id: Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        :param builtins.int certificate_secret_version: The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        :param builtins.str hostname: A custom hostname to be used for the vb instance URL, in FQDN format.
        """
        pulumi.set(__self__, "certificate_secret_id", certificate_secret_id)
        pulumi.set(__self__, "certificate_secret_version", certificate_secret_version)
        pulumi.set(__self__, "hostname", hostname)

    @property
    @pulumi.getter(name="certificateSecretId")
    def certificate_secret_id(self) -> builtins.str:
        """
        Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        """
        return pulumi.get(self, "certificate_secret_id")

    @property
    @pulumi.getter(name="certificateSecretVersion")
    def certificate_secret_version(self) -> builtins.int:
        """
        The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        return pulumi.get(self, "certificate_secret_version")

    @property
    @pulumi.getter
    def hostname(self) -> builtins.str:
        """
        A custom hostname to be used for the vb instance URL, in FQDN format.
        """
        return pulumi.get(self, "hostname")


@pulumi.output_type
class GetVbInstancesVbInstanceSummaryCollectionItemNetworkEndpointDetailResult(dict):
    def __init__(__self__, *,
                 allowlisted_http_ips: Sequence[builtins.str],
                 allowlisted_http_vcns: Sequence['outputs.GetVbInstancesVbInstanceSummaryCollectionItemNetworkEndpointDetailAllowlistedHttpVcnResult'],
                 network_endpoint_type: builtins.str,
                 network_security_group_ids: Sequence[builtins.str],
                 private_endpoint_ip: builtins.str,
                 subnet_id: builtins.str):
        """
        :param Sequence[builtins.str] allowlisted_http_ips: Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5/32", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        :param Sequence['GetVbInstancesVbInstanceSummaryCollectionItemNetworkEndpointDetailAllowlistedHttpVcnArgs'] allowlisted_http_vcns: Virtual Cloud Networks allowed to access this network endpoint.
        :param builtins.str network_endpoint_type: The type of network endpoint.
        :param Sequence[builtins.str] network_security_group_ids: Network Security Group OCIDs for the Private Endpoint.
        :param builtins.str private_endpoint_ip: The IP address to be assigned to Private Endpoint
        :param builtins.str subnet_id: The subnet OCID for the private endpoint.
        """
        pulumi.set(__self__, "allowlisted_http_ips", allowlisted_http_ips)
        pulumi.set(__self__, "allowlisted_http_vcns", allowlisted_http_vcns)
        pulumi.set(__self__, "network_endpoint_type", network_endpoint_type)
        pulumi.set(__self__, "network_security_group_ids", network_security_group_ids)
        pulumi.set(__self__, "private_endpoint_ip", private_endpoint_ip)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="allowlistedHttpIps")
    def allowlisted_http_ips(self) -> Sequence[builtins.str]:
        """
        Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5/32", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        """
        return pulumi.get(self, "allowlisted_http_ips")

    @property
    @pulumi.getter(name="allowlistedHttpVcns")
    def allowlisted_http_vcns(self) -> Sequence['outputs.GetVbInstancesVbInstanceSummaryCollectionItemNetworkEndpointDetailAllowlistedHttpVcnResult']:
        """
        Virtual Cloud Networks allowed to access this network endpoint.
        """
        return pulumi.get(self, "allowlisted_http_vcns")

    @property
    @pulumi.getter(name="networkEndpointType")
    def network_endpoint_type(self) -> builtins.str:
        """
        The type of network endpoint.
        """
        return pulumi.get(self, "network_endpoint_type")

    @property
    @pulumi.getter(name="networkSecurityGroupIds")
    def network_security_group_ids(self) -> Sequence[builtins.str]:
        """
        Network Security Group OCIDs for the Private Endpoint.
        """
        return pulumi.get(self, "network_security_group_ids")

    @property
    @pulumi.getter(name="privateEndpointIp")
    def private_endpoint_ip(self) -> builtins.str:
        """
        The IP address to be assigned to Private Endpoint
        """
        return pulumi.get(self, "private_endpoint_ip")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The subnet OCID for the private endpoint.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetVbInstancesVbInstanceSummaryCollectionItemNetworkEndpointDetailAllowlistedHttpVcnResult(dict):
    def __init__(__self__, *,
                 allowlisted_ip_cidrs: Sequence[builtins.str],
                 id: builtins.str):
        """
        :param Sequence[builtins.str] allowlisted_ip_cidrs: Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5/32", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        :param builtins.str id: The Virtual Cloud Network OCID.
        """
        pulumi.set(__self__, "allowlisted_ip_cidrs", allowlisted_ip_cidrs)
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="allowlistedIpCidrs")
    def allowlisted_ip_cidrs(self) -> Sequence[builtins.str]:
        """
        Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5/32", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        """
        return pulumi.get(self, "allowlisted_ip_cidrs")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The Virtual Cloud Network OCID.
        """
        return pulumi.get(self, "id")


