# Generated by Django 2.1.8 on 2019-06-06 10:09

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('CORE', '0005_parameter_metaselect'),
        ('documents', '0003_document_sharekey'),
    ]

    operations = [
        migrations.CreateModel(
            name='AbstractContainer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=250, verbose_name='name')),
                ('description', models.TextField(verbose_name='description', blank=True)),
            ],
            options={'default_permissions': [], 'ordering': ['-foldercontainer__isnull', 'parent__name', 'name'], 'verbose_name': 'container', 'verbose_name_plural': 'containers'},
        ),
        migrations.CreateModel(
            name='DocumentContainer',
            fields=[
                ('abstractcontainer_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='documents.AbstractContainer')),
                ('date_modification', models.DateTimeField(verbose_name='date modification')),
                ('date_creation', models.DateTimeField(verbose_name='date creation')),
                ('sharekey', models.CharField(max_length=100, null=True, verbose_name='sharekey')),
                ('creator', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='documentcontainer_creator', to='CORE.LucteriosUser', verbose_name='creator')),
                ('modifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='documentcontainer_modifier', to='CORE.LucteriosUser', verbose_name='modifier')),
            ],
            options={
                'verbose_name': 'document',
                'verbose_name_plural': 'documents',
                'default_permissions': [],
                'ordering': ['parent__name', 'name'],
            },
            bases=('documents.abstractcontainer',),
        ),
        migrations.CreateModel(
            name='FolderContainer',
            fields=[
                ('abstractcontainer_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='documents.AbstractContainer')),
                ('modifier', models.ManyToManyField(blank=True, related_name='foldercontainer_modifier', to='CORE.LucteriosGroup', verbose_name='modifier')),
                ('viewer', models.ManyToManyField(blank=True, related_name='foldercontainer_viewer', to='CORE.LucteriosGroup', verbose_name='viewer')),
            ],
            options={
                'verbose_name': 'folder',
                'verbose_name_plural': 'folders',
                'default_permissions': [],
                'ordering': ['parent__name', 'name'],
            },
            bases=('documents.abstractcontainer',),
        ),
        migrations.AddField(
            model_name='abstractcontainer',
            name='parent',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='documents.FolderContainer', verbose_name='parent'),
        ),
    ]
