"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3Bucket = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const common_1 = require("./common");
const helpers_1 = require("./private/helpers");
/**
 * (experimental) An S3 bucket destination for data from a Kinesis Data Firehose delivery stream.
 *
 * @experimental
 */
class S3Bucket {
    /**
     * @experimental
     */
    constructor(bucket, props = {}) {
        var _b;
        this.bucket = bucket;
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_kinesisfirehose_destinations_S3BucketProps(props);
        if (((_b = this.props.s3Backup) === null || _b === void 0 ? void 0 : _b.mode) === common_1.BackupMode.FAILED) {
            throw new Error('S3 destinations do not support BackupMode.FAILED');
        }
    }
    /**
     * (experimental) (experimental) Binds this destination to the Kinesis Data Firehose delivery stream.
     *
     * Implementers should use this method to bind resources to the stack and initialize values using the provided stream.
     *
     * @experimental
     */
    bind(scope, _options) {
        var _b, _c, _d, _e;
        const role = (_b = this.props.role) !== null && _b !== void 0 ? _b : new iam.Role(scope, 'S3 Destination Role', {
            assumedBy: new iam.ServicePrincipal('firehose.amazonaws.com'),
        });
        const bucketGrant = this.bucket.grantReadWrite(role);
        const { loggingOptions, dependables: loggingDependables } = (_c = helpers_1.createLoggingOptions(scope, {
            logging: this.props.logging,
            logGroup: this.props.logGroup,
            role,
            streamId: 'S3Destination',
        })) !== null && _c !== void 0 ? _c : {};
        const { backupConfig, dependables: backupDependables } = (_d = helpers_1.createBackupConfig(scope, role, this.props.s3Backup)) !== null && _d !== void 0 ? _d : {};
        return {
            extendedS3DestinationConfiguration: {
                cloudWatchLoggingOptions: loggingOptions,
                processingConfiguration: helpers_1.createProcessingConfig(scope, role, this.props.processor),
                roleArn: role.roleArn,
                s3BackupConfiguration: backupConfig,
                s3BackupMode: this.getS3BackupMode(),
                bufferingHints: helpers_1.createBufferingHints(this.props.bufferingInterval, this.props.bufferingSize),
                bucketArn: this.bucket.bucketArn,
                compressionFormat: (_e = this.props.compression) === null || _e === void 0 ? void 0 : _e.value,
                encryptionConfiguration: helpers_1.createEncryptionConfig(role, this.props.encryptionKey),
                errorOutputPrefix: this.props.errorOutputPrefix,
                prefix: this.props.dataOutputPrefix,
            },
            dependables: [bucketGrant, ...(loggingDependables !== null && loggingDependables !== void 0 ? loggingDependables : []), ...(backupDependables !== null && backupDependables !== void 0 ? backupDependables : [])],
        };
    }
    getS3BackupMode() {
        var _b, _c;
        return ((_b = this.props.s3Backup) === null || _b === void 0 ? void 0 : _b.bucket) || ((_c = this.props.s3Backup) === null || _c === void 0 ? void 0 : _c.mode) === common_1.BackupMode.ALL
            ? 'Enabled'
            : undefined;
    }
}
exports.S3Bucket = S3Bucket;
_a = JSII_RTTI_SYMBOL_1;
S3Bucket[_a] = { fqn: "@aws-cdk/aws-kinesisfirehose-destinations.S3Bucket", version: "1.138.0" };
//# sourceMappingURL=data:application/json;base64,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