# Generated by Django 3.2.5 on 2021-07-18 02:40

import django.db.models.deletion
import modelcluster.fields
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("wagtailimages", "0023_add_choose_permissions"),
        ("wagtailcore", "0062_comment_models_and_pagesubscription"),
    ]

    operations = [
        migrations.CreateModel(
            name="SocialNetwork",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=63, verbose_name="Name")),
                (
                    "icon",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="wagtailimages.image",
                        verbose_name="Icon",
                    ),
                ),
            ],
            options={
                "verbose_name": "Social network",
                "verbose_name_plural": "Social networks",
            },
        ),
        migrations.CreateModel(
            name="SocialNetworkSettings",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "site",
                    models.OneToOneField(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="wagtailcore.site",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="SocialNetworkProfile",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("profile_url", models.URLField(verbose_name="Profile URL")),
                (
                    "social_network",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="wagtail_sb_socialnetworks.socialnetwork",
                        verbose_name="Social network",
                    ),
                ),
            ],
            options={
                "verbose_name": "Social network profile",
                "verbose_name_plural": "Social network profiles",
            },
        ),
        migrations.CreateModel(
            name="SiteSocialNetworkProfile",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "sort_order",
                    models.IntegerField(blank=True, editable=False, null=True),
                ),
                (
                    "profile",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="wagtail_sb_socialnetworks.socialnetworkprofile",
                        verbose_name="Social network profile",
                    ),
                ),
                (
                    "sitesettings",
                    modelcluster.fields.ParentalKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="site_socialnetworks",
                        related_query_name="site_socialnetwork",
                        to="wagtail_sb_socialnetworks.socialnetworksettings",
                        verbose_name="Site settings",
                    ),
                ),
            ],
            options={
                "unique_together": {("sitesettings", "profile")},
            },
        ),
    ]
