import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_DescribeImageReferencesCommand, se_DescribeImageReferencesCommand } from "../protocols/Aws_ec2";
export { $Command };
export class DescribeImageReferencesCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonEC2", "DescribeImageReferences", {})
    .n("EC2Client", "DescribeImageReferencesCommand")
    .f(void 0, void 0)
    .ser(se_DescribeImageReferencesCommand)
    .de(de_DescribeImageReferencesCommand)
    .build() {
}
