import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { ModifyVpcEndpointRequest, ModifyVpcEndpointResult } from "../models/models_7";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link ModifyVpcEndpointCommand}.
 */
export interface ModifyVpcEndpointCommandInput extends ModifyVpcEndpointRequest {
}
/**
 * @public
 *
 * The output of {@link ModifyVpcEndpointCommand}.
 */
export interface ModifyVpcEndpointCommandOutput extends ModifyVpcEndpointResult, __MetadataBearer {
}
declare const ModifyVpcEndpointCommand_base: {
    new (input: ModifyVpcEndpointCommandInput): import("@smithy/smithy-client").CommandImpl<ModifyVpcEndpointCommandInput, ModifyVpcEndpointCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: ModifyVpcEndpointCommandInput): import("@smithy/smithy-client").CommandImpl<ModifyVpcEndpointCommandInput, ModifyVpcEndpointCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Modifies attributes of a specified VPC endpoint. The attributes that you can modify
 *             depend on the type of VPC endpoint (interface, gateway, or Gateway Load Balancer). For more information,
 *             see the <a href="https://docs.aws.amazon.com/vpc/latest/privatelink/">Amazon Web Services PrivateLink
 *                 Guide</a>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, ModifyVpcEndpointCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, ModifyVpcEndpointCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * // import type { EC2ClientConfig } from "@aws-sdk/client-ec2";
 * const config = {}; // type is EC2ClientConfig
 * const client = new EC2Client(config);
 * const input = { // ModifyVpcEndpointRequest
 *   DryRun: true || false,
 *   VpcEndpointId: "STRING_VALUE", // required
 *   ResetPolicy: true || false,
 *   PolicyDocument: "STRING_VALUE",
 *   AddRouteTableIds: [ // VpcEndpointRouteTableIdList
 *     "STRING_VALUE",
 *   ],
 *   RemoveRouteTableIds: [
 *     "STRING_VALUE",
 *   ],
 *   AddSubnetIds: [ // VpcEndpointSubnetIdList
 *     "STRING_VALUE",
 *   ],
 *   RemoveSubnetIds: [
 *     "STRING_VALUE",
 *   ],
 *   AddSecurityGroupIds: [ // VpcEndpointSecurityGroupIdList
 *     "STRING_VALUE",
 *   ],
 *   RemoveSecurityGroupIds: [
 *     "STRING_VALUE",
 *   ],
 *   IpAddressType: "ipv4" || "dualstack" || "ipv6",
 *   DnsOptions: { // DnsOptionsSpecification
 *     DnsRecordIpType: "ipv4" || "dualstack" || "ipv6" || "service-defined",
 *     PrivateDnsOnlyForInboundResolverEndpoint: true || false,
 *   },
 *   PrivateDnsEnabled: true || false,
 *   SubnetConfigurations: [ // SubnetConfigurationsList
 *     { // SubnetConfiguration
 *       SubnetId: "STRING_VALUE",
 *       Ipv4: "STRING_VALUE",
 *       Ipv6: "STRING_VALUE",
 *     },
 *   ],
 * };
 * const command = new ModifyVpcEndpointCommand(input);
 * const response = await client.send(command);
 * // { // ModifyVpcEndpointResult
 * //   Return: true || false,
 * // };
 *
 * ```
 *
 * @param ModifyVpcEndpointCommandInput - {@link ModifyVpcEndpointCommandInput}
 * @returns {@link ModifyVpcEndpointCommandOutput}
 * @see {@link ModifyVpcEndpointCommandInput} for command's `input` shape.
 * @see {@link ModifyVpcEndpointCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @public
 */
export declare class ModifyVpcEndpointCommand extends ModifyVpcEndpointCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: ModifyVpcEndpointRequest;
            output: ModifyVpcEndpointResult;
        };
        sdk: {
            input: ModifyVpcEndpointCommandInput;
            output: ModifyVpcEndpointCommandOutput;
        };
    };
}
