import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { RejectVpcEndpointConnectionsRequest, RejectVpcEndpointConnectionsResult } from "../models/models_8";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link RejectVpcEndpointConnectionsCommand}.
 */
export interface RejectVpcEndpointConnectionsCommandInput extends RejectVpcEndpointConnectionsRequest {
}
/**
 * @public
 *
 * The output of {@link RejectVpcEndpointConnectionsCommand}.
 */
export interface RejectVpcEndpointConnectionsCommandOutput extends RejectVpcEndpointConnectionsResult, __MetadataBearer {
}
declare const RejectVpcEndpointConnectionsCommand_base: {
    new (input: RejectVpcEndpointConnectionsCommandInput): import("@smithy/smithy-client").CommandImpl<RejectVpcEndpointConnectionsCommandInput, RejectVpcEndpointConnectionsCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: RejectVpcEndpointConnectionsCommandInput): import("@smithy/smithy-client").CommandImpl<RejectVpcEndpointConnectionsCommandInput, RejectVpcEndpointConnectionsCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Rejects VPC endpoint connection requests to your VPC endpoint service.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, RejectVpcEndpointConnectionsCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, RejectVpcEndpointConnectionsCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * // import type { EC2ClientConfig } from "@aws-sdk/client-ec2";
 * const config = {}; // type is EC2ClientConfig
 * const client = new EC2Client(config);
 * const input = { // RejectVpcEndpointConnectionsRequest
 *   DryRun: true || false,
 *   ServiceId: "STRING_VALUE", // required
 *   VpcEndpointIds: [ // VpcEndpointIdList // required
 *     "STRING_VALUE",
 *   ],
 * };
 * const command = new RejectVpcEndpointConnectionsCommand(input);
 * const response = await client.send(command);
 * // { // RejectVpcEndpointConnectionsResult
 * //   Unsuccessful: [ // UnsuccessfulItemSet
 * //     { // UnsuccessfulItem
 * //       Error: { // UnsuccessfulItemError
 * //         Code: "STRING_VALUE",
 * //         Message: "STRING_VALUE",
 * //       },
 * //       ResourceId: "STRING_VALUE",
 * //     },
 * //   ],
 * // };
 *
 * ```
 *
 * @param RejectVpcEndpointConnectionsCommandInput - {@link RejectVpcEndpointConnectionsCommandInput}
 * @returns {@link RejectVpcEndpointConnectionsCommandOutput}
 * @see {@link RejectVpcEndpointConnectionsCommandInput} for command's `input` shape.
 * @see {@link RejectVpcEndpointConnectionsCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @public
 */
export declare class RejectVpcEndpointConnectionsCommand extends RejectVpcEndpointConnectionsCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: RejectVpcEndpointConnectionsRequest;
            output: RejectVpcEndpointConnectionsResult;
        };
        sdk: {
            input: RejectVpcEndpointConnectionsCommandInput;
            output: RejectVpcEndpointConnectionsCommandOutput;
        };
    };
}
