import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { ReportInstanceStatusRequest } from "../models/models_8";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link ReportInstanceStatusCommand}.
 */
export interface ReportInstanceStatusCommandInput extends ReportInstanceStatusRequest {
}
/**
 * @public
 *
 * The output of {@link ReportInstanceStatusCommand}.
 */
export interface ReportInstanceStatusCommandOutput extends __MetadataBearer {
}
declare const ReportInstanceStatusCommand_base: {
    new (input: ReportInstanceStatusCommandInput): import("@smithy/smithy-client").CommandImpl<ReportInstanceStatusCommandInput, ReportInstanceStatusCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: ReportInstanceStatusCommandInput): import("@smithy/smithy-client").CommandImpl<ReportInstanceStatusCommandInput, ReportInstanceStatusCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Submits feedback about the status of an instance. The instance must be in the
 *                 <code>running</code> state. If your experience with the instance differs from the
 *             instance status returned by <a>DescribeInstanceStatus</a>, use <a>ReportInstanceStatus</a> to report your experience with the instance. Amazon
 *             EC2 collects this information to improve the accuracy of status checks.</p>
 *          <p>Use of this action does not change the value returned by <a>DescribeInstanceStatus</a>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, ReportInstanceStatusCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, ReportInstanceStatusCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * // import type { EC2ClientConfig } from "@aws-sdk/client-ec2";
 * const config = {}; // type is EC2ClientConfig
 * const client = new EC2Client(config);
 * const input = { // ReportInstanceStatusRequest
 *   DryRun: true || false,
 *   Instances: [ // InstanceIdStringList // required
 *     "STRING_VALUE",
 *   ],
 *   Status: "ok" || "impaired", // required
 *   StartTime: new Date("TIMESTAMP"),
 *   EndTime: new Date("TIMESTAMP"),
 *   ReasonCodes: [ // ReasonCodesList // required
 *     "instance-stuck-in-state" || "unresponsive" || "not-accepting-credentials" || "password-not-available" || "performance-network" || "performance-instance-store" || "performance-ebs-volume" || "performance-other" || "other",
 *   ],
 *   Description: "STRING_VALUE",
 * };
 * const command = new ReportInstanceStatusCommand(input);
 * const response = await client.send(command);
 * // {};
 *
 * ```
 *
 * @param ReportInstanceStatusCommandInput - {@link ReportInstanceStatusCommandInput}
 * @returns {@link ReportInstanceStatusCommandOutput}
 * @see {@link ReportInstanceStatusCommandInput} for command's `input` shape.
 * @see {@link ReportInstanceStatusCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @public
 */
export declare class ReportInstanceStatusCommand extends ReportInstanceStatusCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: ReportInstanceStatusRequest;
            output: {};
        };
        sdk: {
            input: ReportInstanceStatusCommandInput;
            output: ReportInstanceStatusCommandOutput;
        };
    };
}
