import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { KMSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../KMSClient";
import { GetKeyPolicyRequest, GetKeyPolicyResponse } from "../models/models_0";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link GetKeyPolicyCommand}.
 */
export interface GetKeyPolicyCommandInput extends GetKeyPolicyRequest {
}
/**
 * @public
 *
 * The output of {@link GetKeyPolicyCommand}.
 */
export interface GetKeyPolicyCommandOutput extends GetKeyPolicyResponse, __MetadataBearer {
}
declare const GetKeyPolicyCommand_base: {
    new (input: GetKeyPolicyCommandInput): import("@smithy/smithy-client").CommandImpl<GetKeyPolicyCommandInput, GetKeyPolicyCommandOutput, KMSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: GetKeyPolicyCommandInput): import("@smithy/smithy-client").CommandImpl<GetKeyPolicyCommandInput, GetKeyPolicyCommandOutput, KMSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Gets a key policy attached to the specified KMS key.</p>
 *          <p>
 *             <b>Cross-account use</b>: No. You cannot perform this operation on a KMS key in a different Amazon Web Services account.</p>
 *          <p>
 *             <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:GetKeyPolicy</a> (key policy)</p>
 *          <p>
 *             <b>Related operations</b>: <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_PutKeyPolicy.html">PutKeyPolicy</a>
 *          </p>
 *          <p>
 *             <b>Eventual consistency</b>: The KMS API follows an eventual consistency model.
 *   For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/accessing-kms.html#programming-eventual-consistency">KMS eventual consistency</a>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { KMSClient, GetKeyPolicyCommand } from "@aws-sdk/client-kms"; // ES Modules import
 * // const { KMSClient, GetKeyPolicyCommand } = require("@aws-sdk/client-kms"); // CommonJS import
 * // import type { KMSClientConfig } from "@aws-sdk/client-kms";
 * const config = {}; // type is KMSClientConfig
 * const client = new KMSClient(config);
 * const input = { // GetKeyPolicyRequest
 *   KeyId: "STRING_VALUE", // required
 *   PolicyName: "STRING_VALUE",
 * };
 * const command = new GetKeyPolicyCommand(input);
 * const response = await client.send(command);
 * // { // GetKeyPolicyResponse
 * //   Policy: "STRING_VALUE",
 * //   PolicyName: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param GetKeyPolicyCommandInput - {@link GetKeyPolicyCommandInput}
 * @returns {@link GetKeyPolicyCommandOutput}
 * @see {@link GetKeyPolicyCommandInput} for command's `input` shape.
 * @see {@link GetKeyPolicyCommandOutput} for command's `response` shape.
 * @see {@link KMSClientResolvedConfig | config} for KMSClient's `config` shape.
 *
 * @throws {@link DependencyTimeoutException} (server fault)
 *  <p>The system timed out while trying to fulfill the request. You can retry the
 *       request.</p>
 *
 * @throws {@link InvalidArnException} (client fault)
 *  <p>The request was rejected because a specified ARN, or an ARN in a key policy, is not
 *       valid.</p>
 *
 * @throws {@link KMSInternalException} (server fault)
 *  <p>The request was rejected because an internal exception occurred. The request can be
 *       retried.</p>
 *
 * @throws {@link KMSInvalidStateException} (client fault)
 *  <p>The request was rejected because the state of the specified resource is not valid for this
 *       request.</p>
 *          <p>This exceptions means one of the following:</p>
 *          <ul>
 *             <li>
 *                <p>The key state of the KMS key is not compatible with the operation. </p>
 *                <p>To find the key state, use the <a>DescribeKey</a> operation. For more
 *           information about which key states are compatible with each KMS operation, see
 *           <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key states of KMS keys</a> in the <i>
 *                      <i>Key Management Service Developer Guide</i>
 *                   </i>.</p>
 *             </li>
 *             <li>
 *                <p>For cryptographic operations on KMS keys in custom key stores, this exception
 *           represents a general failure with many possible causes. To identify the cause, see the
 *           error message that accompanies the exception.</p>
 *             </li>
 *          </ul>
 *
 * @throws {@link NotFoundException} (client fault)
 *  <p>The request was rejected because the specified entity or resource could not be
 *       found.</p>
 *
 * @throws {@link KMSServiceException}
 * <p>Base exception class for all service exceptions from KMS service.</p>
 *
 *
 * @example To retrieve a key policy
 * ```javascript
 * // The following example retrieves the key policy for the specified KMS key.
 * const input = {
 *   KeyId: "1234abcd-12ab-34cd-56ef-1234567890ab",
 *   PolicyName: "default"
 * };
 * const command = new GetKeyPolicyCommand(input);
 * const response = await client.send(command);
 * /* response is
 * {
 *   Policy: `{
 *   "Version" : "2012-10-17",
 *   "Id" : "key-default-1",
 *   "Statement" : [ {
 *     "Sid" : "Enable IAM User Permissions",
 *     "Effect" : "Allow",
 *     "Principal" : {
 *       "AWS" : "arn:aws:iam::111122223333:root"
 *     },
 *     "Action" : "kms:*",
 *     "Resource" : "*"
 *   } ]
 * }`
 * }
 * *\/
 * ```
 *
 * @public
 */
export declare class GetKeyPolicyCommand extends GetKeyPolicyCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: GetKeyPolicyRequest;
            output: GetKeyPolicyResponse;
        };
        sdk: {
            input: GetKeyPolicyCommandInput;
            output: GetKeyPolicyCommandOutput;
        };
    };
}
